/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.view;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.internet.monitor.ui.internal.Trace;
import org.eclipse.wst.internet.monitor.ui.internal.provisional.ContentViewer;

public class Viewer {
    private IConfigurationElement element;

    public Viewer(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getLabel() {
        String label = this.element.getAttribute("label");
        if (label == null) {
            return "n/a";
        }
        return label;
    }

    public ContentViewer createViewer() {
        try {
            return (ContentViewer)this.element.createExecutableExtension("class");
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not create viewer" + this.toString(), e);
            return null;
        }
    }

    public boolean isRequestViewer() {
        return this.element.getAttribute("type").toLowerCase().indexOf("request") >= 0;
    }

    public boolean isResponseViewer() {
        return this.element.getAttribute("type").toLowerCase().indexOf("response") >= 0;
    }

    public String toString() {
        return "ContentViewer[" + this.getId() + "]";
    }
}

