/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.web.internal.WSTWebPreferences;
import org.osgi.framework.Bundle;

public class WSTWebPlugin
extends Plugin {
    private static WSTWebPlugin plugin;
    private WSTWebPreferences preferences;
    public static final String VALIDATION_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";
    public static final String[] ICON_DIRS;
    public static final String PLUGIN_ID = "org.eclipse.wst.web";

    static {
        ICON_DIRS = new String[]{"icons/full/obj16", "icons/full/ctool16", "icons/full/wizban", "icons", ""};
    }

    public WSTWebPlugin() {
        plugin = this;
    }

    public static WSTWebPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void initializeDefaultPluginPreferences() {
        this.getWSTWebPreferences().initializeDefaultPreferences();
    }

    public WSTWebPreferences getWSTWebPreferences() {
        if (this.preferences == null) {
            this.preferences = new WSTWebPreferences(this);
        }
        return this.preferences;
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return WSTWebPlugin.createStatus(severity, message, null);
    }

    public static void logError(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(WSTWebPlugin.createStatus(4, message));
    }

    public static void logError(String message, Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(WSTWebPlugin.createStatus(4, message, exception));
    }

    public static void logError(String message, CoreException exception) {
        MultiStatus status = new MultiStatus(PLUGIN_ID, 4, new IStatus[]{exception.getStatus()}, message, (Throwable)exception);
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log((IStatus)status);
    }
}

