/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.web.project.facet;

import com.ibm.icu.util.StringTokenizer;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.common.project.facet.core.JavaFacetInstallConfig;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.j2ee.project.facet.J2EEModuleFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.web.project.facet.IWebFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.project.facet.ProductManager;

public class WebFacetInstallDataModelProvider
extends J2EEModuleFacetInstallDataModelProvider
implements IWebFacetInstallDataModelProperties {
    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IWebFacetInstallDataModelProperties.CONTEXT_ROOT");
        names.add("IWebFacetInstallDataModelProperties.SOURCE_FOLDER");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            return J2EEPlugin.getDefault().getJ2EEPreferences().getString("webContent");
        }
        if (propertyName.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER")) {
            return J2EEPlugin.getDefault().getJ2EEPreferences().getString("dynWebSource");
        }
        if (propertyName.equals("IWebFacetInstallDataModelProperties.CONTEXT_ROOT")) {
            return this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").replace(' ', '_');
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.web";
        }
        if (propertyName.equals("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI")) {
            String projectName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").replace(' ', '_');
            return String.valueOf(projectName) + ".war";
        }
        if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.GENERATE_DD")) {
            IProjectFacetVersion facetVersion = (IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION");
            if (facetVersion == WebFacetUtils.WEB_25) {
                return J2EEPlugin.getDefault().getJ2EEPreferences().getBoolean("dynamic_web_generate_dd");
            }
            return Boolean.TRUE;
        }
        if (propertyName.equals("IJ2EEModuleFacetInstallDataModelProperties.OUTPUT_FOLDER")) {
            return J2EEPlugin.getDefault().getJ2EEPreferences().getString("dynWebOutput");
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR".equals(propertyName)) {
            this.model.notifyPropertyChange("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", 3);
        } else if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            this.model.notifyPropertyChange("IWebFacetInstallDataModelProperties.CONTEXT_ROOT", 4);
        } else {
            JavaFacetInstallConfig javaModel;
            if (propertyName.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
                return true;
            }
            if (propertyName.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER") && (javaModel = this.findJavaFacetInstallConfig()) != null) {
                Path sourceFolder = propertyValue == null ? null : new Path((String)propertyValue);
                javaModel.setSourceFolder((IPath)sourceFolder);
            }
        }
        return super.propertySet(propertyName, propertyValue);
    }

    private JavaFacetInstallConfig findJavaFacetInstallConfig() {
        IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
        if (fpjwc != null) {
            IFacetedProject.Action javaInstallAction = fpjwc.getProjectFacetAction(JavaFacetUtils.JAVA_FACET);
            Object config = javaInstallAction.getConfig();
            if (config instanceof JavaFacetInstallConfig) {
                return (JavaFacetInstallConfig)config;
            }
            return (JavaFacetInstallConfig)Platform.getAdapterManager().getAdapter(config, JavaFacetInstallConfig.class);
        }
        return null;
    }

    public boolean isPropertyEnabled(String propertyName) {
        return super.isPropertyEnabled(propertyName);
    }

    protected int convertFacetVersionToJ2EEVersion(IProjectFacetVersion version) {
        return J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)version.getVersionString());
    }

    public IStatus validate(String name) {
        if (name.equals("IWebFacetInstallDataModelProperties.CONTEXT_ROOT")) {
            return this.validateContextRoot(this.getStringProperty("IWebFacetInstallDataModelProperties.CONTEXT_ROOT"));
        }
        if (name.equals("IWebFacetInstallDataModelProperties.SOURCE_FOLDER")) {
            IStatus status = this.validateFolderName(this.getStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER"));
            if (status.isOK()) {
                status = WebFacetInstallDataModelProvider.validateFolderForCharacters((String)this.getStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER"));
            }
            if (status.isOK()) {
                status = this.validateSourceAndContentFolderUniqueness();
            }
            if (status.isOK()) {
                String outfolderName = this.model.getStringProperty("IJ2EEModuleFacetInstallDataModelProperties.OUTPUT_FOLDER");
                String srcfolderName = this.model.getStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER");
                status = WebFacetInstallDataModelProvider.validateSourceAndOutputFolderCase((String)srcfolderName, (String)outfolderName);
            }
            return status;
        }
        if (name.equals("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER")) {
            IStatus status = super.validate("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
            if (status.isOK()) {
                status = this.validateSourceAndContentFolderUniqueness();
            }
            if (status.isOK()) {
                String configFolder = this.model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
                String outFolder = this.model.getStringProperty("IJ2EEModuleFacetInstallDataModelProperties.OUTPUT_FOLDER");
                status = WebFacetInstallDataModelProvider.validateWebConfigAndOutputFolder(configFolder, outFolder);
            }
            return status;
        }
        if (name.equals("IJ2EEModuleFacetInstallDataModelProperties.OUTPUT_FOLDER")) {
            IStatus status = super.validate("IJ2EEModuleFacetInstallDataModelProperties.OUTPUT_FOLDER");
            if (status.isOK()) {
                String configFolder = this.model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
                String outFolder = this.model.getStringProperty("IJ2EEModuleFacetInstallDataModelProperties.OUTPUT_FOLDER");
                status = WebFacetInstallDataModelProvider.validateWebConfigAndOutputFolder(configFolder, outFolder);
            }
            if (status.isOK()) {
                String outfolderName = this.model.getStringProperty("IJ2EEModuleFacetInstallDataModelProperties.OUTPUT_FOLDER");
                String srcfolderName = this.model.getStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER");
                status = WebFacetInstallDataModelProvider.validateSourceAndOutputFolderCase((String)srcfolderName, (String)outfolderName);
            }
            return status;
        }
        return super.validate(name);
    }

    protected IStatus validateContextRoot(String contextRoot) {
        if (contextRoot == null) {
            return J2EEPlugin.newErrorStatus((String)ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Context_Root_cannot_be_empty_2, (Object[])new Object[]{contextRoot}), null);
        }
        if (contextRoot.trim().equals(contextRoot)) {
            StringTokenizer stok = new StringTokenizer(contextRoot, ".");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                int i = 0;
                while (i < token.length()) {
                    if (token.charAt(i) != '_' && token.charAt(i) != '-' && token.charAt(i) != '/' && !Character.isLetterOrDigit(token.charAt(i))) {
                        Object[] invalidChar = new Object[]{new Character(token.charAt(i)).toString()};
                        String errorStatus = ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.The_character_is_invalid_in_a_context_root, (Object[])invalidChar);
                        return J2EEPlugin.newErrorStatus((String)errorStatus, null);
                    }
                    ++i;
                }
            }
        } else {
            return J2EEPlugin.newErrorStatus((String)ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.Names_cannot_begin_or_end_with_whitespace_5, (Object[])new Object[]{contextRoot}), null);
        }
        return OK_STATUS;
    }

    protected IStatus validateSourceAndContentFolderUniqueness() {
        String srcFolder = this.getStringProperty("IWebFacetInstallDataModelProperties.SOURCE_FOLDER");
        String contentFolder = this.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        if (srcFolder != null && contentFolder != null && srcFolder.equals(contentFolder)) {
            String errorMessage = ProjectSupportResourceHandler.DYNAMIC_WEB_DISTINCT_SRC_WEBCONTENT_ERROR;
            return WTPCommonPlugin.createErrorStatus((String)errorMessage);
        }
        return OK_STATUS;
    }

    public static IStatus validateWebConfigAndOutputFolder(String rawConfigFolder, String outFolder) {
        String expectedOutFolder;
        if (ProductManager.shouldUseSingleRootStructure() && !outFolder.equals(expectedOutFolder = String.valueOf(rawConfigFolder) + "/" + "WEB-INF/classes")) {
            String message = ProjectSupportResourceHandler.getString((String)ProjectSupportResourceHandler.DYNAMIC_WEB_PERFORMANCE_VALIDATION, (Object[])new Object[]{expectedOutFolder});
            return WTPCommonPlugin.createWarningStatus((String)message);
        }
        return OK_STATUS;
    }
}

