/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.internal.deployables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.internal.deployables.JEEFlexProjDeployable;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;

public class JEEDeployableFactory
extends ProjectModuleFactoryDelegate {
    protected Map<IModule, ModuleDelegate> moduleDelegates = new HashMap<IModule, ModuleDelegate>(5);
    public static final String ID = "org.eclipse.jst.jee.server";

    protected IModule[] createModules(IProject project) {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        if (comp != null) {
            return this.createModuleDelegates(comp);
        }
        return null;
    }

    protected IModule[] createModules(ModuleCoreNature nature) {
        if (nature != null) {
            return this.createModules(nature.getProject());
        }
        return null;
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        if (module == null) {
            return null;
        }
        ModuleDelegate md = this.moduleDelegates.get(module);
        if (md == null) {
            this.createModules(module.getProject());
            md = this.moduleDelegates.get(module);
        }
        return md;
    }

    protected IModule[] createModuleDelegates(IVirtualComponent component) {
        ArrayList<IModule> projectModules;
        block6: {
            if (component == null) {
                return null;
            }
            projectModules = new ArrayList<IModule>();
            try {
                if (J2EEProjectUtilities.isJEEProject((IProject)component.getProject())) {
                    IModule module = null;
                    String type = J2EEProjectUtilities.getJ2EEProjectType((IProject)component.getProject());
                    if (type != null && !type.equals("")) {
                        String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)component.getProject());
                        module = this.createModule(component.getDeployedName(), component.getDeployedName(), type, version, component.getProject());
                        JEEFlexProjDeployable moduleDelegate = new JEEFlexProjDeployable(component.getProject(), component);
                        this.moduleDelegates.put(module, (ModuleDelegate)moduleDelegate);
                        projectModules.add(module);
                    }
                    if ("jst.ear".equals(type)) {
                        projectModules.addAll((Collection)Arrays.asList(this.createBinaryModules(component)));
                    }
                    break block6;
                }
                return null;
            }
            catch (Exception e) {
                Logger.getLogger().write((Throwable)e);
            }
        }
        return projectModules.toArray(new IModule[projectModules.size()]);
    }

    protected IModule[] createBinaryModules(IVirtualComponent component) {
        ArrayList<IModule> projectModules = new ArrayList<IModule>();
        IVirtualReference[] references = component.getReferences();
        int i = 0;
        while (i < references.length) {
            JavaEEQuickPeek qp;
            IVirtualComponent moduleComponent = references[i].getReferencedComponent();
            if (moduleComponent.isBinary() && (qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek((IVirtualComponent)moduleComponent)).getType() != -1) {
                String moduleType = null;
                String moduleVersion = null;
                switch (qp.getType()) {
                    case 3: {
                        moduleType = "jst.appclient";
                        break;
                    }
                    case 4: {
                        moduleType = "jst.web";
                        break;
                    }
                    case 0: {
                        moduleType = "jst.ejb";
                        break;
                    }
                    case 2: {
                        moduleType = "jst.connector";
                        break;
                    }
                    case 1: {
                        moduleType = "jst.ear";
                        break;
                    }
                    default: {
                        moduleType = "jst.utility";
                        moduleVersion = "1.0";
                    }
                }
                int version = qp.getVersion();
                moduleVersion = J2EEVersionUtil.convertVersionIntToString((int)version);
                IModule nestedModule = this.createModule(moduleComponent.getDeployedName(), moduleComponent.getDeployedName(), moduleType, moduleVersion, moduleComponent.getProject());
                if (nestedModule != null) {
                    J2EEFlexProjDeployable moduleDelegate = new J2EEFlexProjDeployable(moduleComponent.getProject(), moduleComponent);
                    this.moduleDelegates.put(nestedModule, (ModuleDelegate)moduleDelegate);
                    projectModules.add(nestedModule);
                    moduleDelegate.getURI(nestedModule);
                }
            }
            ++i;
        }
        return projectModules.toArray(new IModule[projectModules.size()]);
    }

    protected IPath[] getListenerPaths() {
        return new IPath[]{new Path(".project"), new Path(StructureEdit.MODULE_META_FILE_NAME), new Path(".settings/org.eclipse.wst.common.project.facet.core.xml")};
    }

    protected void clearCache(IProject project) {
        super.clearCache(project);
        ArrayList<IModule> modulesToRemove = null;
        for (IModule module : this.moduleDelegates.keySet()) {
            if (!module.getProject().equals((Object)project)) continue;
            if (modulesToRemove == null) {
                modulesToRemove = new ArrayList<IModule>();
            }
            modulesToRemove.add(module);
        }
        if (modulesToRemove != null) {
            for (IModule module : modulesToRemove) {
                this.moduleDelegates.remove(module);
            }
        }
    }
}

