/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.css.core.internal.provisional.adapters.ICSSModelAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalArranger;
import org.eclipse.wst.css.ui.internal.contentassist.CSSTemplateCompletionProcessor;
import org.eclipse.wst.html.core.internal.htmlcss.StyleAdapterFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistUtilities;

public class CSSContentAssistProcessor
implements IContentAssistProcessor {
    private int fDocumentOffset = 0;
    private char fQuote = '\u0000';
    private CSSTemplateCompletionProcessor fTemplateProcessor = null;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentPosition) {
        boolean isEmptyDocument;
        CSSProposalArranger arranger;
        IndexedRegion indexedNode;
        block25: {
            IStructuredModel cssModel;
            block29: {
                ICSSModel cssModel2;
                boolean selected;
                block28: {
                    block27: {
                        IndexedRegion keyIndexedNode;
                        IDOMNode parent;
                        block26: {
                            indexedNode = ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)(documentPosition + this.fDocumentOffset));
                            IDOMNode xNode = null;
                            parent = null;
                            arranger = null;
                            isEmptyDocument = false;
                            ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
                            boolean bl = selected = selection != null && selection.getText() != null && selection.getText().trim().length() > 0;
                            if (indexedNode instanceof IDOMNode) {
                                xNode = (IDOMNode)indexedNode;
                                parent = (IDOMNode)xNode.getParentNode();
                            }
                            if (xNode == null || !xNode.getNodeName().equalsIgnoreCase("STYLE")) break block26;
                            cssModel = this.getCSSModel(xNode);
                            if (cssModel != null) {
                                int offset = documentPosition;
                                int pos = 0;
                                keyIndexedNode = cssModel.getIndexedRegion(pos);
                                if (keyIndexedNode == null) {
                                    keyIndexedNode = (IndexedRegion)((ICSSModel)cssModel).getDocument();
                                }
                                arranger = new CSSProposalArranger(pos, (ICSSNode)keyIndexedNode, offset, '\u0000', selected);
                            }
                            break block25;
                        }
                        if (parent == null || !parent.getNodeName().equalsIgnoreCase("STYLE")) break block27;
                        cssModel = this.getCSSModel(parent);
                        if (cssModel != null) {
                            int offset = indexedNode.getStartOffset();
                            int pos = documentPosition - offset;
                            keyIndexedNode = cssModel.getIndexedRegion(pos);
                            if (keyIndexedNode == null) {
                                keyIndexedNode = (IndexedRegion)((ICSSModel)cssModel).getDocument();
                            }
                            arranger = new CSSProposalArranger(pos, (ICSSNode)keyIndexedNode, offset, '\u0000', selected);
                        }
                        break block25;
                    }
                    if (!(indexedNode instanceof IDOMNode)) break block28;
                    cssModel = this.getCSSModel((IDOMNode)indexedNode);
                    if (cssModel != null) {
                        IndexedRegion keyIndexedNode = cssModel.getIndexedRegion(documentPosition - this.fDocumentOffset);
                        if (keyIndexedNode == null) {
                            keyIndexedNode = (IndexedRegion)((ICSSModel)cssModel).getDocument();
                        }
                        if (keyIndexedNode instanceof ICSSNode) {
                            arranger = new CSSProposalArranger(documentPosition, (ICSSNode)keyIndexedNode, this.fDocumentOffset, this.fQuote, selected);
                        }
                    }
                    break block25;
                }
                if (!(indexedNode instanceof ICSSNode)) break block29;
                ICSSDocument cssdoc = ((ICSSNode)indexedNode).getOwnerDocument();
                if (cssdoc != null && (cssModel2 = cssdoc.getModel()) != null) {
                    IndexedRegion keyIndexedNode2 = cssModel2.getIndexedRegion(documentPosition - this.fDocumentOffset);
                    if (keyIndexedNode2 == null) {
                        keyIndexedNode2 = (IndexedRegion)cssModel2.getDocument();
                    }
                    if (keyIndexedNode2 instanceof ICSSNode) {
                        arranger = new CSSProposalArranger(documentPosition, (ICSSNode)keyIndexedNode2, this.fDocumentOffset, this.fQuote, selected);
                    }
                }
                break block25;
            }
            if (indexedNode != null || !this.isViewerEmpty(viewer)) break block25;
            isEmptyDocument = true;
            cssModel = null;
            try {
                cssModel = StructuredModelManager.getModelManager().getExistingModelForRead(viewer.getDocument());
                if (cssModel instanceof ICSSModel) {
                    IndexedRegion keyIndexedNode = cssModel.getIndexedRegion(documentPosition - this.fDocumentOffset);
                    if (keyIndexedNode == null) {
                        keyIndexedNode = (IndexedRegion)((ICSSModel)cssModel).getDocument();
                    }
                    if (keyIndexedNode instanceof ICSSNode) {
                        arranger = new CSSProposalArranger(documentPosition, (ICSSNode)keyIndexedNode, this.fDocumentOffset, this.fQuote);
                    }
                }
            }
            catch (Throwable keyIndexedNode) {
                Object keyIndexedNode2 = null;
                if (cssModel == null) throw keyIndexedNode;
                cssModel.releaseFromRead();
                throw keyIndexedNode;
            }
            {
                Object keyIndexedNode2 = null;
                if (cssModel == null) break block25;
            }
            cssModel.releaseFromRead();
        }
        ICompletionProposal[] proposals = new ICompletionProposal[]{};
        if (arranger == null) return proposals;
        this.fDocumentOffset = 0;
        proposals = arranger.getProposals();
        ICompletionProposal[] newfileproposals = new ICompletionProposal[]{};
        ICompletionProposal[] anyproposals = new ICompletionProposal[]{};
        if (this.getTemplateCompletionProcessor() != null) {
            if (isEmptyDocument) {
                this.getTemplateCompletionProcessor().setContextType("css_new");
                newfileproposals = this.getTemplateCompletionProcessor().computeCompletionProposals(viewer, documentPosition);
            }
            this.getTemplateCompletionProcessor().setContextType("css_all");
            anyproposals = this.getTemplateCompletionProcessor().computeCompletionProposals(viewer, documentPosition);
        }
        ICompletionProposal endTag = XMLContentAssistUtilities.computeXMLEndTagProposal((ITextViewer)viewer, (int)documentPosition, (IndexedRegion)indexedNode, (String)"STYLE", (String)"icons/full/obj16/tag-generic.gif");
        int additionalLength = newfileproposals.length + anyproposals.length;
        additionalLength = endTag != null ? ++additionalLength : additionalLength;
        if (additionalLength <= 0) return proposals;
        ICompletionProposal[] plusOnes = new ICompletionProposal[proposals.length + additionalLength];
        int appendPos = proposals.length;
        if (endTag != null) {
            System.arraycopy(proposals, 0, plusOnes, 1, proposals.length);
            plusOnes[0] = endTag;
            ++appendPos;
        } else {
            System.arraycopy(proposals, 0, plusOnes, 0, proposals.length);
        }
        int i = 0;
        while (true) {
            if (i >= newfileproposals.length) {
                appendPos += newfileproposals.length;
                break;
            }
            plusOnes[appendPos + i] = newfileproposals[i];
            ++i;
        }
        i = 0;
        while (i < anyproposals.length) {
            plusOnes[appendPos + i] = anyproposals[i];
            ++i;
        }
        return plusOnes;
    }

    private boolean isViewerEmpty(ITextViewer textViewer) {
        boolean isEmpty = false;
        String text = textViewer.getTextWidget().getText();
        if (text == null || text != null && text.trim().equals("")) {
            isEmpty = true;
        }
        return isEmpty;
    }

    private IStructuredModel getCSSModel(IDOMNode element) {
        if (element == null) {
            return null;
        }
        INodeAdapter adapter = StyleAdapterFactory.getInstance().adapt((INodeNotifier)element);
        if (adapter == null || !(adapter instanceof ICSSModelAdapter)) {
            return null;
        }
        ICSSModelAdapter modelAdapter = (ICSSModelAdapter)adapter;
        return modelAdapter.getModel();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public void setDocumentOffset(int offset) {
        this.fDocumentOffset = offset;
    }

    public void setQuoteCharOfStyleAttribute(char quote) {
        this.fQuote = quote;
    }

    private CSSTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateProcessor == null) {
            this.fTemplateProcessor = new CSSTemplateCompletionProcessor();
        }
        return this.fTemplateProcessor;
    }
}

