/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AbstractMethodCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;

public class NewMethodCompletionProposal
extends AbstractMethodCompletionProposal {
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private List fArguments;

    public NewMethodCompletionProposal(String label, IJavaScriptUnit targetCU, ASTNode invocationNode, List arguments, ITypeBinding binding, int relevance, Image image) {
        super(label, targetCU, invocationNode, binding, relevance, image);
        this.fArguments = arguments;
    }

    private int evaluateModifiers(ASTNode targetTypeDecl) {
        if (this.getSenderBinding().isAnnotation()) {
            return 0;
        }
        if (this.getSenderBinding().isInterface()) {
            FunctionDeclaration[] methodDecls = ((TypeDeclaration)targetTypeDecl).getMethods();
            if (methodDecls.length > 0) {
                return methodDecls[0].getModifiers();
            }
            return 0;
        }
        ASTNode invocationNode = this.getInvocationNode();
        if (invocationNode instanceof FunctionInvocation) {
            ASTNode node;
            int modifiers = 0;
            Expression expression = ((FunctionInvocation)invocationNode).getExpression();
            if (expression != null) {
                if (expression instanceof Name && ((Name)expression).resolveBinding().getKind() == 2) {
                    modifiers |= 8;
                }
            } else if (ASTResolving.isInStaticContext(invocationNode)) {
                modifiers |= 8;
            }
            if (targetTypeDecl.equals((Object)(node = ASTResolving.findParentType(invocationNode)))) {
                modifiers |= 2;
            } else if (node instanceof AnonymousClassDeclaration && ASTNodes.isParent(node, targetTypeDecl)) {
                modifiers |= 4;
                if (ASTResolving.isInStaticContext(node)) {
                    modifiers |= 8;
                }
            } else {
                modifiers |= 1;
            }
            return modifiers;
        }
        return 1;
    }

    protected void addNewModifiers(ASTRewrite rewrite, ASTNode targetTypeDecl, List modifiers) {
        modifiers.addAll(rewrite.getAST().newModifiers(this.evaluateModifiers(targetTypeDecl)));
        ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.getLinkedProposalModel(), rewrite, modifiers, this.getSenderBinding().isInterface());
    }

    protected boolean isConstructor() {
        ASTNode node = this.getInvocationNode();
        return node.getNodeType() != 32 && node.getNodeType() != 48;
    }

    protected SimpleName getNewName(ASTRewrite rewrite) {
        ASTNode invocationNode = this.getInvocationNode();
        String name = invocationNode instanceof FunctionInvocation ? ((FunctionInvocation)invocationNode).getName().getIdentifier() : (invocationNode instanceof SuperMethodInvocation ? ((SuperMethodInvocation)invocationNode).getName().getIdentifier() : this.getSenderBinding().getName());
        AST ast = rewrite.getAST();
        SimpleName newNameNode = ast.newSimpleName(name);
        this.addLinkedPosition(rewrite.track((ASTNode)newNameNode), false, KEY_NAME);
        ASTNode invocationName = this.getInvocationNameNode();
        if (invocationName != null && invocationName.getAST() == ast) {
            this.addLinkedPosition(rewrite.track(invocationName), true, KEY_NAME);
        }
        return newNameNode;
    }

    private ASTNode getInvocationNameNode() {
        ASTNode node = this.getInvocationNode();
        if (node instanceof FunctionInvocation) {
            return ((FunctionInvocation)node).getName();
        }
        if (node instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)node).getName();
        }
        if (node instanceof ClassInstanceCreation) {
            Type type = ((ClassInstanceCreation)node).getType();
            while (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getType();
            }
            return type;
        }
        return null;
    }

    protected Type getNewMethodType(ASTRewrite rewrite) throws CoreException {
        ITypeBinding[] bindings;
        FunctionInvocation parent;
        ASTNode node = this.getInvocationNode();
        AST ast = rewrite.getAST();
        Type newTypeNode = null;
        ITypeBinding[] otherProposals = null;
        if (node.getParent() instanceof FunctionInvocation && (parent = (FunctionInvocation)node.getParent()).getExpression() == node && (bindings = ASTResolving.getQualifierGuess(node.getRoot(), parent.getName().getIdentifier(), parent.arguments(), (IBinding)this.getSenderBinding())).length > 0) {
            newTypeNode = this.getImportRewrite().addImport(bindings[0], ast);
            otherProposals = bindings;
        }
        if (newTypeNode == null) {
            ITypeBinding binding = ASTResolving.guessBindingForReference(node);
            if (binding != null && binding.isWildcardType()) {
                binding = ASTResolving.normalizeWildcardType(binding, false, ast);
            }
            if (binding != null) {
                newTypeNode = this.getImportRewrite().addImport(binding, ast);
            } else {
                ASTNode parent2 = node.getParent();
                if (parent2 instanceof ExpressionStatement) {
                    return null;
                }
                newTypeNode = ASTResolving.guessTypeForReference(ast, node);
                if (newTypeNode == null) {
                    newTypeNode = ast.newSimpleType((Name)ast.newSimpleName("Object"));
                }
            }
        }
        this.addLinkedPosition(rewrite.track(newTypeNode), false, KEY_TYPE);
        if (otherProposals != null) {
            int i = 0;
            while (i < otherProposals.length) {
                this.addLinkedPositionProposal(KEY_TYPE, otherProposals[i]);
                ++i;
            }
        }
        return newTypeNode;
    }

    protected void addNewParameters(ASTRewrite rewrite, List takenNames, List params) throws CoreException {
        AST ast = rewrite.getAST();
        List arguments = this.fArguments;
        int i = 0;
        while (i < arguments.size()) {
            Expression elem = (Expression)arguments.get(i);
            SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
            String argTypeKey = "arg_type_" + i;
            Type type = this.evaluateParameterType(ast, elem, argTypeKey);
            param.setType(type);
            String argNameKey = "arg_name_" + i;
            String name = this.evaluateParameterName(takenNames, elem, type, argNameKey);
            param.setName(ast.newSimpleName(name));
            params.add(param);
            this.addLinkedPosition(rewrite.track((ASTNode)param.getType()), false, argTypeKey);
            this.addLinkedPosition(rewrite.track((ASTNode)param.getName()), false, argNameKey);
            ++i;
        }
    }

    private Type evaluateParameterType(AST ast, Expression elem, String key) throws CoreException {
        ITypeBinding binding = Bindings.normalizeTypeBinding(elem.resolveTypeBinding());
        if (binding != null && binding.isWildcardType()) {
            binding = ASTResolving.normalizeWildcardType(binding, true, ast);
        }
        if (binding != null) {
            ITypeBinding[] typeProposals = ASTResolving.getRelaxingTypes(ast, binding);
            int i = 0;
            while (i < typeProposals.length) {
                this.addLinkedPositionProposal(key, typeProposals[i]);
                ++i;
            }
            return this.getImportRewrite().addImport(binding, ast);
        }
        return ast.newSimpleType((Name)ast.newSimpleName("Object"));
    }

    private String evaluateParameterName(List takenNames, Expression argNode, Type type, String key) {
        IJavaScriptProject project = this.getCompilationUnit().getJavaScriptProject();
        String[] names = StubUtility.getVariableNameSuggestions(4, project, type, argNode, (Collection)takenNames);
        int i = 0;
        while (i < names.length) {
            this.addLinkedPositionProposal(key, names[i], null);
            ++i;
        }
        String favourite = names[0];
        takenNames.add(favourite);
        return favourite;
    }

    protected void addNewExceptions(ASTRewrite rewrite, List exceptions) throws CoreException {
    }

    protected void addNewTypeParameters(ASTRewrite rewrite, List takenNames, List params) throws CoreException {
    }
}

