/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.refactor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;

public class ProjectDependencyCache {
    private static ProjectDependencyCache cache;
    private final Map dependencyCache = new HashMap();
    private final Map referenceCache = new HashMap();

    public static synchronized ProjectDependencyCache getCache() {
        if (cache == null) {
            try {
                cache = new ProjectDependencyCache();
            }
            catch (CoreException ce) {
                Logger.getLogger().logError((Throwable)ce);
            }
        }
        return cache;
    }

    protected ProjectDependencyCache() throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            this.refreshDependencies(projects[i]);
            ++i;
        }
    }

    public synchronized IProject[] getDependentProjects(IProject project) {
        List dependencies = (List)this.dependencyCache.get(project);
        if (dependencies == null) {
            return new IProject[0];
        }
        return dependencies.toArray(new IProject[dependencies.size()]);
    }

    public synchronized void refreshDependencies(IProject project) throws CoreException {
        ArrayList oldRefs = (ArrayList)this.referenceCache.get(project);
        if (oldRefs == null) {
            oldRefs = new ArrayList();
        }
        IProject[] refProjects = project.getDescription().getReferencedProjects();
        ArrayList<IProject> newRefs = new ArrayList<IProject>();
        int j = 0;
        while (j < refProjects.length) {
            this.addDependency(refProjects[j], project);
            newRefs.add(refProjects[j]);
            oldRefs.remove(refProjects[j]);
            ++j;
        }
        this.referenceCache.put(project, newRefs);
        Iterator i = oldRefs.iterator();
        while (i.hasNext()) {
            this.removeDependency((IProject)i.next(), project);
        }
    }

    public synchronized void refreshDependenciesForTarget(IProject target) throws CoreException {
        IProject[] dependents = this.getDependentProjects(target);
        int i = 0;
        while (i < dependents.length) {
            this.refreshDependencies(dependents[i]);
            ++i;
        }
    }

    public synchronized void removeProject(IProject project) throws CoreException {
        this.dependencyCache.remove(project);
        List dependencies = (List)this.referenceCache.remove(project);
        if (dependencies != null) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                this.removeDependency((IProject)i.next(), project);
            }
        }
    }

    public synchronized void replaceProject(IProject originalProject, IProject newProject) throws CoreException {
        this.dependencyCache.put(newProject, this.dependencyCache.remove(originalProject));
        List dependencies = (List)this.referenceCache.remove(originalProject);
        this.referenceCache.put(newProject, dependencies);
        if (dependencies != null) {
            for (IProject ref : dependencies) {
                this.removeDependency(ref, originalProject);
                this.addDependency(ref, newProject);
            }
        }
    }

    private void removeDependency(IProject target, IProject dependent) {
        List dependentProjects = (List)this.dependencyCache.get(target);
        if (dependentProjects != null) {
            dependentProjects.remove(dependent);
        }
    }

    private void addDependency(IProject target, IProject dependent) {
        ArrayList<IProject> dependentProjects = (ArrayList<IProject>)this.dependencyCache.get(target);
        if (dependentProjects == null) {
            dependentProjects = new ArrayList<IProject>();
            this.dependencyCache.put(target, dependentProjects);
        }
        if (!dependentProjects.contains(dependent)) {
            dependentProjects.add(dependent);
        }
    }
}

