/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.navigator;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.jsdt.ui.actions.CCPActionGroup;
import org.eclipse.wst.jsdt.ui.actions.GenerateActionGroup;
import org.eclipse.wst.jsdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenViewActionGroup;

public class JavaNavigatorActionProvider
extends CommonActionProvider {
    private OpenViewActionGroup fOpenViewGroup;
    private CCPActionGroup fCCPGroup;
    private JavaSearchActionGroup fSearchGroup;
    private GenerateActionGroup fGenerateGroup;
    private boolean fInViewPart = false;

    public void fillActionBars(IActionBars actionBars) {
        if (this.fInViewPart) {
            this.fOpenViewGroup.fillActionBars(actionBars);
            this.fCCPGroup.fillActionBars(actionBars);
            this.fGenerateGroup.fillActionBars(actionBars);
            this.fSearchGroup.fillActionBars(actionBars);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.fInViewPart) {
            ISelection selection = this.getContext() != null ? this.getContext().getSelection() : null;
            boolean isEmpty = selection != null ? selection.isEmpty() : false;
            this.fOpenViewGroup.containsShowInMenu(!isEmpty);
            this.fOpenViewGroup.fillContextMenu(menu);
            this.fCCPGroup.setShowLimited(isEmpty);
            this.fCCPGroup.fillContextMenu(menu);
            this.fGenerateGroup.fillContextMenu(menu);
            this.fSearchGroup.fillContextMenu(menu);
        }
    }

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)workbenchSite.getPart();
            this.fOpenViewGroup = new OpenViewActionGroup(viewPart, (ISelectionProvider)site.getStructuredViewer());
            this.fOpenViewGroup.containsOpenPropertiesAction(false);
            this.fCCPGroup = new CCPActionGroup(viewPart);
            this.fGenerateGroup = new GenerateActionGroup(viewPart);
            this.fSearchGroup = new JavaSearchActionGroup(viewPart);
            this.fInViewPart = true;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (this.fInViewPart) {
            this.fOpenViewGroup.setContext(context);
            this.fCCPGroup.setContext(context);
            this.fGenerateGroup.setContext(context);
            this.fSearchGroup.setContext(context);
        }
    }
}

