/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.componentcore.ComponentArchiveOptions;
import org.eclipse.jst.j2ee.internal.provider.J2EEUtilityJarItemProvider;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.ui.internal.navigator.OpenJEEResourceAction;
import org.eclipse.jst.jee.ui.internal.navigator.ear.GroupEARProvider;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.BeanInterfaceNode;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.BeanNode;
import org.eclipse.jst.jee.ui.internal.navigator.ejb.GroupEJBProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.WebAppProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class JEEActionProvider
extends CommonActionProvider {
    private static final Class IRESOURCE_CLASS = IResource.class;
    private OpenJEEResourceAction openAction;

    public void init(ICommonActionExtensionSite aConfig) {
        this.openAction = new OpenJEEResourceAction();
    }

    public void setContext(ActionContext aContext) {
        if (aContext != null && aContext.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)aContext.getSelection();
            this.openAction.selectionChanged(selection);
            Object[] array = selection.toArray();
            if (this.isUtilityJars(array)) {
                J2EEUtilityJarItemProvider utilityJarItemProvider = null;
                ArrayList newSelection = new ArrayList();
                int i = 0;
                while (i < array.length) {
                    utilityJarItemProvider = (J2EEUtilityJarItemProvider)array[i];
                    newSelection.addAll(utilityJarItemProvider.getChildren(null));
                    ++i;
                }
                StructuredSelection structuredSelection = new StructuredSelection(newSelection);
            }
        }
        super.setContext(aContext);
    }

    public void fillActionBars(IActionBars theActionBars) {
        if (this.openAction.isEnabled()) {
            theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
    }

    public void fillContextMenu(IMenuManager aMenu) {
        if (this.getContext() == null || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (!this.adaptsToResource(selection.toArray())) {
            this.openAction.selectionChanged(selection);
            if (this.openAction.isEnabled()) {
                aMenu.insertAfter("group.open", (IAction)this.openAction);
            }
            this.addOpenWithMenu(aMenu);
        }
    }

    private boolean adaptsToResource(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IResource) {
                return true;
            }
            if (objects[i] instanceof IAdaptable && ((IAdaptable)objects[i]).getAdapter(IRESOURCE_CLASS) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isUtilityJars(Object[] items) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i] == null || items[i].getClass() != J2EEUtilityJarItemProvider.class) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void addOpenWithMenu(IMenuManager menu) {
        IFile file;
        ISelection selection = this.getContext().getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            return;
        }
        Object srcObject = ss.getFirstElement();
        Object resource = null;
        if (srcObject instanceof EObject) {
            resource = this.openEObject((EObject)srcObject);
        } else if (srcObject instanceof BeanInterfaceNode) {
            resource = ((BeanInterfaceNode)srcObject).get_fqn();
        } else if (srcObject instanceof BeanNode) {
            resource = ((BeanNode)srcObject).getEjbClassQualifiedName();
        } else if (srcObject instanceof WebAppProvider) {
            file = ((WebAppProvider)srcObject).getDDFile();
            if (file.isAccessible()) {
                resource = file;
            }
        } else if (srcObject instanceof GroupEJBProvider) {
            resource = this.openEObject((EObject)((GroupEJBProvider)srcObject).getEjbJar());
        } else if (srcObject instanceof GroupEARProvider && (file = ((GroupEARProvider)srcObject).getDDFile()).isAccessible()) {
            resource = file;
        }
        if (!(resource instanceof IFile)) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.OpenActionProvider_OpenWithMenu_label, "group.openWith");
        submenu.add((IContributionItem)new OpenWithMenu(page, (IAdaptable)((IFile)resource)));
        menu.appendToGroup("group.open", (IContributionItem)submenu);
    }

    private IResource openEObject(EObject _srcObject) {
        EObject ro = _srcObject;
        IFile resource = WorkbenchResourceHelper.getFile((EObject)_srcObject);
        if (resource != null) {
            return resource;
        }
        ModuleFile moduleFile = ArchiveUtil.getModuleFile((EObject)ro);
        if (moduleFile != null) {
            ArchiveOptions options = moduleFile.getOptions();
            if (options instanceof ComponentArchiveOptions) {
                ((ComponentArchiveOptions)options).getComponent();
            }
        } else {
            IArchive archive = JavaEEArchiveUtilities.findArchive((Object)ro);
            if (archive != null) {
                IVirtualComponent iVirtualComponent = JavaEEArchiveUtilities.findComponent((IArchive)archive);
            }
        }
        return null;
    }
}

