/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.WarFileDynamicClassLoader;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseLibrary;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;

public class WARFileImpl
extends ModuleFileImpl
implements WARFile {
    protected WebApp deploymentDescriptor = null;
    protected List sourceFiles;

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.WAR_FILE;
    }

    public File addCopyClass(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.add_copy_class_dir_EXC_, new Object[]{aFile.getURI()}));
        }
        return this.addCopyFileAddingPrefix(aFile, "WEB-INF/classes/");
    }

    protected File addCopyFileAddingPrefix(File aFile, String uriPrefix) throws DuplicateObjectException {
        String swizzledUri = aFile.getURI();
        if (!swizzledUri.startsWith(uriPrefix)) {
            swizzledUri = ArchiveUtil.concatUri(uriPrefix, swizzledUri, '/');
        }
        this.checkAddValid(swizzledUri);
        File copy = this.copy(aFile);
        copy.setURI(swizzledUri);
        this.getFiles().add((Object)copy);
        return copy;
    }

    public File addCopyLib(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.add_copy_lib_dir_EXC_, new Object[]{aFile.getURI()}));
        }
        return this.addCopyFileAddingPrefix(aFile, "WEB-INF/lib/");
    }

    protected RuntimeClasspathEntry createLibClasspathEntry(String libPath) {
        RuntimeClasspathEntry entry = this.createRuntimeClasspathEntry(libPath);
        entry.setWarFile(this);
        return entry;
    }

    protected List getAllFileEntriesRecursive(java.io.File aFile, List aList) {
        if (!aFile.exists()) {
            return aList;
        }
        String name = aFile.getName();
        if (name.regionMatches(true, name.length() - 4, ".jar", 0, 4)) {
            aList.add(aFile.getAbsolutePath());
        } else if (aFile.isDirectory()) {
            java.io.File[] children = aFile.listFiles();
            int i = 0;
            while (i < children.length) {
                this.getAllFileEntriesRecursive(children[i], aList);
                ++i;
            }
        }
        return aList;
    }

    public List getClasses() {
        return this.filterFilesByPrefix("WEB-INF/classes/");
    }

    public WebApp getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        WebApp dd = this.getDeploymentDescriptorGen();
        if (dd == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception e) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        return this.getDeploymentDescriptorGen();
    }

    public String getDeploymentDescriptorUri() {
        return "WEB-INF/web.xml";
    }

    public List getLibs() {
        return this.filterFilesByPrefix("WEB-INF/lib/");
    }

    public List getLibArchives() {
        return this.filterFiles("WEB-INF/lib/", new String[]{"jar", "zip"});
    }

    public List getResources() {
        String[] prefixes = new String[]{"META-INF", "WEB-INF"};
        return this.filterFilesWithoutPrefix(prefixes);
    }

    public RuntimeClasspathEntry[] getLocalRuntimeClassPath() {
        String absolutePath;
        try {
            absolutePath = this.getLoadStrategy().getBinariesPath();
        }
        catch (IOException iOException) {
            return new RuntimeClasspathEntry[0];
        }
        ArrayList<RuntimeClasspathEntry> entries = new ArrayList<RuntimeClasspathEntry>();
        if (this.getLoadStrategy().isDirectory()) {
            String classesPath = ArchiveUtil.getOSUri(absolutePath, "WEB-INF/classes/");
            entries.add(this.createRuntimeClasspathEntry(classesPath));
            this.addWebLibs(absolutePath, entries);
        }
        entries.add(this.createRuntimeClasspathEntry(absolutePath));
        return entries.toArray(new RuntimeClasspathEntry[entries.size()]);
    }

    protected RuntimeClasspathEntry[] getDependencyClassPathAtThisLevel() {
        String absolutePath = this.internalGetBinariesPath();
        if (absolutePath == null) {
            return this.emptyClasspath();
        }
        RuntimeClasspathEntry[] mfEntries = super.getDependencyClassPathAtThisLevel();
        ArrayList entries = new ArrayList();
        entries.addAll(Arrays.asList(mfEntries));
        return entries.toArray(new RuntimeClasspathEntry[entries.size()]);
    }

    protected void addWebLibs(String absolutePath, List entries) {
        java.io.File aFile = new java.io.File(ArchiveUtil.getOSUri(absolutePath, "WEB-INF/lib/"));
        List libs = this.getAllFileEntriesRecursive(aFile, new ArrayList());
        int i = 0;
        while (i < libs.size()) {
            String libPath = (String)libs.get(i);
            entries.add(this.createLibClasspathEntry(libPath));
            ++i;
        }
        this.addLooseLibsToRuntimeClasspath(entries);
    }

    protected void addLooseLibsToRuntimeClasspath(List entries) {
        LooseWARFile loose = (LooseWARFile)this.getLoadStrategy().getLooseArchive();
        if (loose == null) {
            return;
        }
        EList looseLibs = loose.getLooseLibs();
        int i = 0;
        while (i < looseLibs.size()) {
            LooseLibrary lib = (LooseLibrary)looseLibs.get(i);
            entries.add(this.createLibClasspathEntry(lib.getBinariesPath()));
            ++i;
        }
    }

    protected List calculateSourceCandidateFiles() {
        EList filesList = this.getFiles();
        Vector<File> retFiles = new Vector<File>();
        for (File file : filesList) {
            String aUri = file.getURI();
            if (!aUri.startsWith("WEB-INF") || aUri.startsWith("WEB-INF/lib/")) continue;
            retFiles.add(file);
        }
        return retFiles;
    }

    protected List getSourceCandidateFiles() {
        if (this.sourceFiles == null) {
            this.sourceFiles = this.calculateSourceCandidateFiles();
        }
        return this.sourceFiles;
    }

    protected String makeRelative(String pathString, String relToPathString) {
        if (pathString.startsWith(relToPathString)) {
            return ArchiveUtil.truncateFromFrontIgnoreCase(pathString, relToPathString);
        }
        return pathString;
    }

    public File getSourceFile(File aClassFile) {
        String classURI;
        List sourceFilesList = this.getSourceCandidateFiles();
        String convertedClassURI = classURI = aClassFile.getURI();
        if (!classURI.endsWith(".class")) {
            return null;
        }
        convertedClassURI = ArchiveUtil.classUriToJavaUri(aClassFile.getURI());
        convertedClassURI = this.makeRelative(convertedClassURI, "WEB-INF/classes/");
        int bestLength = Short.MAX_VALUE;
        File bestMatch = null;
        File file2 = null;
        String aUri = null;
        for (File file2 : sourceFilesList) {
            int excessLength;
            aUri = file2.getURI();
            if (!aUri.endsWith(convertedClassURI) || aUri.equals(classURI) || (excessLength = aUri.length() - convertedClassURI.length()) >= bestLength) continue;
            bestMatch = file2;
            bestLength = excessLength;
        }
        return bestMatch;
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isWARFile() {
        return true;
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        WebApp webApp = ((WebapplicationPackage)EPackage.Registry.INSTANCE.getEPackage("webapplication.xmi")).getWebapplicationFactory().createWebApp();
        resource.setID(webApp, "WebApp_ID");
        this.setDeploymentDescriptorGen(webApp);
        resource.getContents().add((Object)webApp);
        return webApp;
    }

    public void setDeploymentDescriptor(WebApp l) {
        this.setDeploymentDescriptorGen(l);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), l);
    }

    public WebApp getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            InternalEObject oldDeploymentDescriptor = (InternalEObject)this.deploymentDescriptor;
            this.deploymentDescriptor = (WebApp)this.eResolveProxy(oldDeploymentDescriptor);
            if (this.deploymentDescriptor != oldDeploymentDescriptor && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public WebApp basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(WebApp newDeploymentDescriptor) {
        WebApp oldDeploymentDescriptor = this.deploymentDescriptor;
        this.deploymentDescriptor = newDeploymentDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor((WebApp)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public ClassLoader createDynamicClassLoader(ClassLoader parentCl, ClassLoader extraCl) {
        return new WarFileDynamicClassLoader(this, parentCl, extraCl);
    }
}

