/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.participants;

import java.util.List;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.DTDElementDecl;
import org.eclipse.lemminx.extensions.dtd.utils.DTDUtils;
import org.eclipse.lemminx.services.extensions.IHighlightingParticipant;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class DTDHighlightingParticipant
implements IHighlightingParticipant {
    @Override
    public void findDocumentHighlights(DOMNode node, Position position, int offset, List<DocumentHighlight> highlights, CancelChecker cancelChecker) {
        DTDAttlistDecl attlistDecl;
        boolean findReferences = false;
        DTDDeclParameter parameter = null;
        DTDElementDecl elementDecl = null;
        if (node.isDTDElementDecl()) {
            elementDecl = (DTDElementDecl)node;
            if (elementDecl.isInNameParameter(offset)) {
                findReferences = true;
                parameter = elementDecl.getNameParameter();
            } else {
                parameter = elementDecl.getParameterAt(offset);
            }
        } else if (node.isDTDAttListDecl() && (attlistDecl = (DTDAttlistDecl)node).isInNameParameter(offset)) {
            parameter = attlistDecl.getNameParameter();
        }
        if (parameter == null) {
            return;
        }
        if (findReferences) {
            DTDDeclParameter originNode = parameter;
            highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(originNode), DocumentHighlightKind.Write));
            DTDUtils.searchDTDOriginElementDecls(elementDecl, (origin, target) -> highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(origin), DocumentHighlightKind.Read)), cancelChecker);
        } else {
            DTDDeclParameter targetNode = parameter;
            highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(targetNode), DocumentHighlightKind.Read));
            DTDUtils.searchDTDTargetElementDecl(parameter, true, targetName -> highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(targetName), DocumentHighlightKind.Write)));
        }
    }
}

