/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wb.core.controls.PageBook;
import org.eclipse.wb.core.editor.DesignerEditorListener;
import org.eclipse.wb.core.editor.DesignerState;
import org.eclipse.wb.core.editor.IDesignPage;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.editor.IDesignerEditor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.EditorActivatedListener;
import org.eclipse.wb.core.model.broadcast.EditorActivatedRequest;
import org.eclipse.wb.gef.core.ICommandExceptionHandler;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.editor.EditorLifeCycleListener;
import org.eclipse.wb.internal.core.editor.JavaDesignComposite;
import org.eclipse.wb.internal.core.editor.UndoManager;
import org.eclipse.wb.internal.core.editor.errors.JavaExceptionComposite;
import org.eclipse.wb.internal.core.editor.errors.JavaWarningComposite;
import org.eclipse.wb.internal.core.editor.errors.MultipleConstructorsComposite;
import org.eclipse.wb.internal.core.editor.errors.NoEntryPointComposite;
import org.eclipse.wb.internal.core.editor.errors.NotUiJavaWarningComposite;
import org.eclipse.wb.internal.core.editor.multi.DesignerEditor;
import org.eclipse.wb.internal.core.editor.structure.PartListenerAdapter;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.util.GlobalStateJava;
import org.eclipse.wb.internal.core.parser.JavaInfoParser;
import org.eclipse.wb.internal.core.utils.Debug;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.exception.MultipleConstructorsError;
import org.eclipse.wb.internal.core.utils.exception.NoEntryPointError;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public final class DesignPage
implements IDesignPage {
    private boolean m_disposed;
    private DesignerEditor m_designerEditor;
    private ICompilationUnit m_compilationUnit;
    private boolean m_showProgress = true;
    private JavaInfo m_rootObject;
    private boolean m_active;
    private UndoManager m_undoManager;
    private DesignerState m_designerState = DesignerState.Undefined;
    private final IPartListener m_partListener = new PartListenerAdapter(){

        public void partActivated(IWorkbenchPart part) {
            if (part == DesignPage.this.m_designerEditor) {
                ExecutionUtils.runLogLater((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        if (!DesignPage.this.isDisposed()) {
                            GlobalStateJava.activate((this).DesignPage.this.m_rootObject);
                            if ((this).DesignPage.this.m_active) {
                                DesignPage.this.checkDependenciesOnDesignPageActivation();
                                (this).DesignPage.this.m_undoManager.deactivate();
                                (this).DesignPage.this.m_undoManager.activate();
                            }
                        }
                    }
                });
            }
        }
    };
    private PageBook m_pageBook;
    private JavaDesignComposite m_designComposite;
    private final Map<Class<?>, Composite> m_errorCompositesMap = new HashMap();

    @Override
    public void initialize(IDesignerEditor designerEditor) {
        this.m_designerEditor = (DesignerEditor)designerEditor;
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                DesignPage.this.m_compilationUnit = DesignPage.this.m_designerEditor.getCompilationUnit();
                DesignPage.this.m_undoManager = new UndoManager(DesignPage.this, DesignPage.this.m_compilationUnit);
            }
        });
        this.m_designerEditor.getEditorSite().getPage().addPartListener(this.m_partListener);
    }

    public boolean isDisposed() {
        return this.m_disposed;
    }

    @Override
    public void dispose() {
        this.m_disposed = true;
        this.m_undoManager.deactivate();
        this.m_designerEditor.getEditorSite().getPage().removePartListener(this.m_partListener);
        this.disposeAll(true);
    }

    @Override
    public String getName() {
        return "Design";
    }

    @Override
    public Image getImage() {
        return DesignerPlugin.getImage((String)"editor_design_page.png");
    }

    @Override
    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.create((Composite)container).noMargins().noSpacing();
        this.createControl_pageBook(container);
        return container;
    }

    private void createControl_pageBook(Composite container) {
        this.m_pageBook = new PageBook(container, 0);
        GridDataFactory.create((Control)this.m_pageBook).grab().fill();
        ICommandExceptionHandler exceptionHandler = new ICommandExceptionHandler(){

            public void handleException(Throwable exception) {
                DesignPage.this.handleDesignException(exception);
            }
        };
        this.m_designComposite = new JavaDesignComposite((Composite)this.m_pageBook, 0, (IEditorPart)this.m_designerEditor, exceptionHandler);
        this.m_pageBook.showPage((Control)this.m_designComposite);
    }

    private <T extends Composite> T getErrorComposite(Class<T> compositeClass) throws Exception {
        Composite composite = this.m_errorCompositesMap.get(compositeClass);
        if (composite == null) {
            Constructor<T> constructor = compositeClass.getConstructor(Composite.class, Integer.TYPE);
            composite = (Composite)constructor.newInstance(this.m_pageBook, 0);
            this.m_errorCompositesMap.put(compositeClass, composite);
        }
        return (T)composite;
    }

    @Override
    public Control getControl() {
        return this.m_pageBook;
    }

    private void setEnabled(boolean enabled) {
        this.m_pageBook.getParent().setRedraw(enabled);
    }

    @Override
    public void setFocus() {
        this.m_designComposite.setFocus();
    }

    public JavaDesignComposite getDesignComposite() {
        return this.m_designComposite;
    }

    @Override
    public void handleActiveState(boolean activate) {
        this.m_active = activate;
        if (activate) {
            this.handleActiveState_True();
        } else {
            this.handleActiveState_False();
        }
    }

    @Override
    public void setSourceModelSynchronizationEnabled(boolean active) {
        if (active) {
            this.m_undoManager.activate();
        } else {
            this.m_undoManager.deactivate();
        }
    }

    private void handleActiveState_True() {
        if (!this.m_compilationUnit.isOpen()) {
            DesignerEditor designerEditor = this.m_designerEditor;
            this.dispose();
            this.initialize(designerEditor);
        }
        this.m_undoManager.activate();
        this.m_designComposite.onActivate();
        this.checkDependenciesOnDesignPageActivation();
    }

    private void handleActiveState_False() {
        this.m_undoManager.deactivate();
        this.m_designComposite.onDeActivate();
    }

    private void checkDependenciesOnDesignPageActivation() {
        if (this.m_rootObject != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    EditorActivatedRequest request = new EditorActivatedRequest();
                    ((EditorActivatedListener)DesignPage.this.m_rootObject.getBroadcast(EditorActivatedListener.class)).invoke(request);
                    if (request.isReparseRequested()) {
                        DesignPage.this.refreshGEF();
                    } else if (request.isRefreshRequested()) {
                        DesignPage.this.m_rootObject.refresh();
                    }
                }
            });
        }
    }

    private List<EditorLifeCycleListener> getLifeCycleListeners() {
        return ExternalFactoriesHelper.getElementsInstances(EditorLifeCycleListener.class, (String)"org.eclipse.wb.core.editorLifeCycleListeners", (String)"listener");
    }

    private boolean isLifeCycleProgressRequired() {
        for (EditorLifeCycleListener listener : this.getLifeCycleListeners()) {
            if (listener.parseWithProgress(this, this.m_compilationUnit)) continue;
            return false;
        }
        return true;
    }

    public void setShowProgress(boolean showProgress) {
        this.m_showProgress = showProgress;
    }

    private void disposeAll(final boolean force) {
        if (!this.m_pageBook.isDisposed()) {
            this.dispose_beforePresentation();
            this.m_designComposite.disposeDesign();
        }
        if (this.m_rootObject != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    DesignPage.this.m_rootObject.refresh_dispose();
                    DesignPage.this.m_rootObject.getBroadcastObject().dispose();
                    DesignPage.this.disposeContext(force);
                    GlobalStateJava.deactivate(DesignPage.this.m_rootObject);
                }
            });
            this.m_rootObject = null;
        }
    }

    private void dispose_beforePresentation() {
        if (this.m_rootObject != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    DesignPage.this.m_rootObject.getBroadcastObject().dispose_beforePresentation();
                }
            });
        }
    }

    protected void disposeContext(final boolean force) {
        for (final EditorLifeCycleListener listener : this.getLifeCycleListeners()) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    listener.disposeContext(DesignPage.this, force);
                }
            });
        }
    }

    @Override
    public void refreshGEF() {
        this.disposeContext(true);
        this.m_undoManager.refreshDesignerEditor();
        List<DesignerEditorListener> designPageListeners = List.copyOf(this.m_designerEditor.getDesignPageListeners());
        for (DesignerEditorListener listener : designPageListeners) {
            listener.reparsed();
        }
    }

    boolean internal_refreshGEF() {
        this.setEnabled(false);
        try {
            this.disposeAll(false);
            this.m_designerState = DesignerState.Parsing;
            if (this.m_showProgress && this.isLifeCycleProgressRequired()) {
                this.internal_refreshGEF_withProgress();
            } else {
                this.internal_refreshGEF((IProgressMonitor)new NullProgressMonitor());
            }
            this.m_pageBook.showPage((Control)this.m_designComposite);
            this.m_designerState = DesignerState.Successful;
            return true;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            this.showExceptionOnDesignPane(e, null);
            return false;
        }
        finally {
            this.setEnabled(true);
        }
    }

    private void internal_refreshGEF_withProgress() throws Exception {
        final Display display = Display.getCurrent();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block5: {
                    monitor.beginTask("Opening Design page.", 7);
                    try {
                        try {
                            DesignPageSite.setProgressMonitor((IProgressMonitor)monitor);
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        DesignPage.this.internal_refreshGEF(monitor);
                                    }
                                    catch (Throwable e) {
                                        ReflectionUtils.propagate((Throwable)e);
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            ReflectionUtils.propagate((Throwable)e);
                            DesignPageSite.setProgressMonitor(null);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        DesignPageSite.setProgressMonitor(null);
                        throw throwable;
                    }
                    DesignPageSite.setProgressMonitor(null);
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(DesignerPlugin.getShell()).run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.propagate((Throwable)e.getCause());
        }
        catch (Throwable e) {
            ReflectionUtils.propagate((Throwable)e);
        }
    }

    private void showExceptionOnDesignPane(Throwable e, Image screenshot) {
        this.m_designerState = DesignerState.Error;
        try {
            e = DesignerExceptionUtils.rewriteException((Throwable)e);
            Throwable designerCause = DesignerExceptionUtils.getDesignerCause((Throwable)e);
            if (e instanceof MultipleConstructorsError) {
                MultipleConstructorsComposite composite = this.getErrorComposite(MultipleConstructorsComposite.class);
                composite.setException((MultipleConstructorsError)e);
                this.m_pageBook.showPage((Control)composite);
            } else if (e instanceof NoEntryPointError) {
                NoEntryPointComposite composite = this.getErrorComposite(NoEntryPointComposite.class);
                composite.setException((NoEntryPointError)e);
                this.m_pageBook.showPage((Control)composite);
            } else if (designerCause instanceof DesignerException && ((DesignerException)designerCause).getCode() == 111) {
                NotUiJavaWarningComposite composite = this.getErrorComposite(NotUiJavaWarningComposite.class);
                composite.setException(e);
                this.m_pageBook.showPage((Control)composite);
            } else if (DesignerExceptionUtils.isWarning((Throwable)e)) {
                JavaWarningComposite composite = this.getErrorComposite(JavaWarningComposite.class);
                composite.setException(e);
                this.m_pageBook.showPage((Control)composite);
            } else {
                DesignerPlugin.log((Throwable)e);
                JavaExceptionComposite composite = this.getErrorComposite(JavaExceptionComposite.class);
                composite.setException(e, screenshot, this.m_compilationUnit, this.m_rootObject);
                this.m_pageBook.showPage((Control)composite);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_designerEditor.getMultiMode().showDesign();
    }

    /*
     * Unable to fully structure code
     */
    private void internal_refreshGEF(IProgressMonitor monitor) throws Exception {
        monitor.subTask("Initializing...");
        monitor.worked(1);
        for (EditorLifeCycleListener listener : this.getLifeCycleListeners()) {
            listener.parseStart(this);
        }
        try {
            start = System.currentTimeMillis();
            monitor.subTask("Parsing...");
            Debug.print((Object)"Parsing...");
            this.m_rootObject = JavaInfoParser.parse(this.m_compilationUnit);
            monitor.worked(1);
            Debug.println((Object)("done: " + (System.currentTimeMillis() - start)));
        }
        finally {
            ** for (listener : this.getLifeCycleListeners())
        }
lbl-1000:
        // 1 sources

        {
            listener.parseEnd(this);
            continue;
        }
lbl18:
        // 1 sources

        designPageSite = new DesignPageSite(){

            public void showSourcePosition(int position) {
                DesignPage.this.m_designerEditor.showSourcePosition(position);
            }

            public void openSourcePosition(int position) {
                DesignPage.this.m_designerEditor.showSourcePosition(position);
                DesignPage.this.m_designerEditor.getMultiMode().showSource();
            }

            public void handleException(Throwable e) {
                DesignPage.this.handleDesignException(e);
            }

            public void reparse() {
                DesignPage.this.refreshGEF();
            }
        };
        DesignPageSite.Helper.setSite((ObjectInfo)this.m_rootObject, (IDesignPageSite)designPageSite);
        this.schedule_rememberDependency();
        start = System.currentTimeMillis();
        monitor.subTask("Refreshing...");
        this.m_rootObject.refresh();
        monitor.worked(1);
        Debug.println((Object)("refresh: " + (System.currentTimeMillis() - start)));
        this.m_designComposite.refresh(this.m_rootObject, monitor);
        this.m_undoManager.setRoot(this.m_rootObject);
    }

    private void schedule_rememberDependency() {
        new Thread("WindowBuilder dependency search"){

            @Override
            public void run() {
                ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        JavaInfoUtils.rememberDependency((this).DesignPage.this.m_rootObject);
                    }
                });
            }
        }.start();
    }

    @Override
    public DesignerState getDesignerState() {
        return this.m_designerState;
    }

    public UndoManager getUndoManager() {
        return this.m_undoManager;
    }

    public boolean isActiveEditor() {
        return DesignerPlugin.getActiveEditor() == this.m_designerEditor;
    }

    private void handleDesignException(Throwable e) {
        Image screenshot;
        try {
            screenshot = DesignerExceptionUtils.makeScreenshot();
        }
        catch (Throwable ex) {
            screenshot = null;
        }
        this.disposeAll(true);
        if (EnvironmentUtils.isTestingTime()) {
            e.printStackTrace();
        }
        this.showExceptionOnDesignPane(e, screenshot);
    }
}

