/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class PageBook
extends Composite {
    private Control m_currentPage;

    public PageBook(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new PageBookLayout());
    }

    public Control getPage() {
        return this.m_currentPage;
    }

    public void showPage(Control page) {
        if (page == this.m_currentPage) {
            return;
        }
        if (page.getParent() != this) {
            return;
        }
        Control oldPage = this.m_currentPage;
        this.m_currentPage = page;
        if (page != null && !page.isDisposed()) {
            page.setVisible(true);
            this.layout(true);
        }
        if (oldPage != null && !oldPage.isDisposed()) {
            oldPage.setVisible(false);
        }
    }

    private class PageBookLayout
    extends Layout {
        private PageBookLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point result = null;
            result = PageBook.this.m_currentPage != null ? PageBook.this.m_currentPage.computeSize(wHint, hHint, flushCache) : new Point(0, 0);
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (PageBook.this.m_currentPage != null) {
                PageBook.this.m_currentPage.setBounds(composite.getClientArea());
            }
        }
    }
}

