/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.AbstractJavaProjectTest;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ComponentDescriptionIbmTest
extends SwingModelTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        EnvironmentUtils.setForcedIBM((boolean)true);
        EnvironmentUtils.setTestingTime((boolean)true);
    }

    @Test
    public void test_description_forIBM() throws Exception {
        EnvironmentUtils.setTestingTime((boolean)false);
        ContainerInfo panel = this.createDefaultProjectContents();
        ComponentDescriptionIbmTest.assertNull((Object)panel.getPropertyByTitle("testProperty"));
    }

    @Test
    public void test_descriptin_fail() throws Exception {
        block2: {
            try {
                this.createDefaultProjectContents();
                ComponentDescriptionIbmTest.fail();
            }
            catch (DesignerException e) {
                if (e.getCode() == 502) break block2;
                throw e;
            }
        }
    }

    @Test
    public void test_descriptin_nonIBM() throws Exception {
        EnvironmentUtils.setForcedIBM((boolean)false);
        ContainerInfo panel = this.createDefaultProjectContents();
        ComponentDescriptionIbmTest.assertNotNull((Object)panel.getPropertyByTitle("testProperty"));
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
        AbstractJavaProjectTest.tearDownClass();
        EnvironmentUtils.setForcedIBM((boolean)false);
        EnvironmentUtils.setTestingTime((boolean)true);
    }

    private ContainerInfo createDefaultProjectContents() throws Exception {
        this.setJavaContentSrc("test", "TestPanel", new String[]{"public class TestPanel extends JPanel {", "  public TestPanel(){", "  }", "  protected void setTestProperty(int value){", "  }", "}"}, new String[]{"<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setTestProperty(int)'>", "    <defaultValue value='7'/>", "  </property>", "</component>"});
        return this.parseContainer("// filler filler filler", "public class Test extends TestPanel {", "  public Test() {", "  }", "}");
    }
}

