/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.accessor;

import java.lang.reflect.Method;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.IAccessibleExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.MethodInvocationArgumentAccessor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MethodInvocationArgumentAccessorTest
extends SwingModelTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        MethodInvocationArgumentAccessorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setText(String text, boolean html) {", "  }", "}"));
        MethodInvocationArgumentAccessorTest.setFileContentSrc("test/MyPanel.wbp-component.xml", MethodInvocationArgumentAccessorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <methods>", "    <method name='setText'>", "      <parameter type='java.lang.String' name='text'/>", "      <parameter type='boolean' name='html'/>", "    </method>", "  </methods>", "  <method-property title='text' method='setText(java.lang.String,boolean)'/>", "</component>"));
        MethodInvocationArgumentAccessorTest.waitForAutoBuild();
    }

    @Test
    public void test_access() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExpressionAccessor accessor = this.getTestAccessor(panel, -1);
        MethodInvocationArgumentAccessorTest.assertNull((Object)accessor.getAdapter(null));
        MethodInvocationArgumentAccessorTest.assertNull((Object)accessor.getAdapter(IAccessibleExpressionAccessor.class));
        MethodInvocationArgumentAccessorTest.assertNull((Object)accessor.getAdapter(PropertyTooltipProvider.class));
    }

    @Test
    public void test_getExpression_noInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExpressionAccessor accessor = this.getTestAccessor(panel, -1);
        MethodInvocationArgumentAccessorTest.assertNull((Object)accessor.getExpression((JavaInfo)panel));
    }

    @Test
    public void test_getExpression_hasInvocation() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setText(null, false);", "  }", "}");
        ExpressionAccessor accessor = this.getTestAccessor(panel, 1);
        MethodInvocationArgumentAccessorTest.assertEquals((Object)"false", (Object)this.m_lastEditor.getSource((ASTNode)accessor.getExpression((JavaInfo)panel)));
    }

    @Test
    public void test_setExpression_replaceExisting() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setText(null, false);", "  }", "}");
        ExpressionAccessor accessor = this.getTestAccessor(panel, 1);
        accessor.setExpression((JavaInfo)panel, "true");
        this.assertEditor("public class Test extends MyPanel {", "  public Test() {", "    setText(null, true);", "  }", "}");
    }

    @Test
    public void test_setExpression_removeExisting_1() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setText('foo', false);", "  }", "}");
        ExpressionAccessor accessor = this.getTestAccessor(panel, 0);
        accessor.setExpression((JavaInfo)panel, "(String) null");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setExpression_removeExisting_2() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setText('foo', false);", "  }", "}");
        ExpressionAccessor accessor = this.getTestAccessor(panel, 0);
        accessor.setExpression((JavaInfo)panel, null);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setExpression_addNew() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        ExpressionAccessor accessor = this.getTestAccessor(panel, 1);
        accessor.setExpression((JavaInfo)panel, "true");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setText((String) null, true);", "  }", "}");
    }

    private ExpressionAccessor getTestAccessor(ContainerInfo panel, int index) throws Exception {
        Method method = ReflectionUtils.getMethodBySignature((Class)panel.getDescription().getComponentClass(), (String)"setText(java.lang.String,boolean)");
        return new MethodInvocationArgumentAccessor(method, index);
    }
}

