/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls.ui;

import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.nls.ui.FlagImagesRepository;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;

public class FlagRepositoryTest
extends DesignerTestCase {
    @Test
    public void test_sortedLocales() throws Exception {
        Object[] sortedLocales = FlagImagesRepository.getSortedLocales();
        FlagRepositoryTest.assertTrue((sortedLocales.length >= 140 ? 1 : 0) != 0);
        int index_1 = ArrayUtils.indexOf((Object[])sortedLocales, (Object)Locale.of("en"));
        int index_2 = ArrayUtils.indexOf((Object[])sortedLocales, (Object)Locale.of("ru"));
        FlagRepositoryTest.assertTrue((index_1 < index_2 ? 1 : 0) != 0);
        index_1 = ArrayUtils.indexOf((Object[])sortedLocales, (Object)Locale.of("de"));
        index_2 = ArrayUtils.indexOf((Object[])sortedLocales, (Object)Locale.of("it"));
        FlagRepositoryTest.assertTrue((index_1 < index_2 ? 1 : 0) != 0);
    }

    @Test
    public void test_getEmptyFlagImage() throws Exception {
        FlagRepositoryTest.assertNotNull((Object)FlagImagesRepository.getEmptyFlagImage());
    }

    @Test
    public void test_getFlagImage_noSuchLocale() throws Exception {
        FlagRepositoryTest.assertNull((Object)FlagImagesRepository.getFlagImage((Locale)Locale.of("noSuchLocale")));
    }

    @Test
    public void test_getFlagImage_ru() throws Exception {
        Image ruImage = FlagImagesRepository.getFlagImage((Locale)Locale.of("ru"));
        FlagRepositoryTest.assertNotNull((Object)ruImage);
        FlagRepositoryTest.assertSame((Object)FlagImagesRepository.getFlagImage((Locale)Locale.of("ru", "RU")), (Object)ruImage);
    }

    @Test
    public void test_getFlagImage_en() throws Exception {
        FlagRepositoryTest.assertSame((Object)FlagImagesRepository.getFlagImage((Locale)Locale.of("en", "US")), (Object)FlagImagesRepository.getFlagImage((Locale)Locale.of("en")));
    }

    @Test
    public void test_getFlagImage_zh() throws Exception {
        FlagRepositoryTest.assertSame((Object)FlagImagesRepository.getFlagImage((Locale)Locale.of("zh", "CN")), (Object)FlagImagesRepository.getFlagImage((Locale)Locale.of("zh")));
    }

    @Test
    public void test_getFlagImage_ar() throws Exception {
        FlagRepositoryTest.assertSame((Object)FlagImagesRepository.getFlagImage((Locale)Locale.of("ar", "AE")), (Object)FlagImagesRepository.getFlagImage((Locale)Locale.of("ar")));
    }

    @Test
    public void test_getFlagImage_YU() throws Exception {
        FlagRepositoryTest.assertNotNull((Object)FlagImagesRepository.getFlagImage((Locale)Locale.of("se", "YU")));
    }
}

