/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor;

import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.jupiter.api.Test;

public class TopSelectionEditPolicyTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_resizeBoth() throws Exception {
        ContainerInfo shell = this.openContainer("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        Rectangle bounds = shell.getBounds();
        TopSelectionEditPolicyTest.assertEquals((int)450, (int)bounds.width);
        TopSelectionEditPolicyTest.assertEquals((int)300, (int)bounds.height);
        this.canvas.beginResize(shell, 20);
        this.canvas.dragOn(50, 30).endDrag();
        bounds = shell.getBounds();
        TopSelectionEditPolicyTest.assertEquals((int)500, (int)bounds.width);
        TopSelectionEditPolicyTest.assertEquals((int)330, (int)bounds.height);
    }

    @Test
    public void test_resizeEast_toNegative() throws Exception {
        ContainerInfo shell = this.openContainer("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        Rectangle bounds = shell.getBounds();
        TopSelectionEditPolicyTest.assertEquals((int)450, (int)bounds.width);
        TopSelectionEditPolicyTest.assertEquals((int)300, (int)bounds.height);
        this.canvas.beginResize(shell, 16);
        this.canvas.dragOn(-455, 0);
        this.canvas.endDrag();
        bounds = shell.getBounds();
        Assertions.assertThat((int)bounds.width).isGreaterThan(9);
        TopSelectionEditPolicyTest.assertEquals((int)bounds.height, (int)300);
    }

    @Test
    public void test_resizeSouth_toNegative() throws Exception {
        ContainerInfo shell = this.openContainer("// filler filler filler filler filler\n// filler filler filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        Rectangle bounds = shell.getBounds();
        TopSelectionEditPolicyTest.assertEquals((int)450, (int)bounds.width);
        TopSelectionEditPolicyTest.assertEquals((int)300, (int)bounds.height);
        this.canvas.beginResize(shell, 4);
        this.canvas.dragOn(0, -305);
        this.canvas.endDrag();
        bounds = shell.getBounds();
        TopSelectionEditPolicyTest.assertEquals((int)bounds.width, (int)450);
        Assertions.assertThat((int)bounds.height).isGreaterThan(0);
    }
}

