/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.core.editor.palette.PaletteEventListener;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.rcp.model.jface.FieldEditorInfo;
import org.eclipse.wb.internal.rcp.model.jface.FieldEditorPreferencePageInfo;
import org.eclipse.wb.internal.rcp.model.jface.FieldEditorSubComponentCreationSupport;
import org.eclipse.wb.internal.rcp.model.jface.FieldEditorSubComponentVariableSupport;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.internal.swt.model.widgets.LabelInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class FieldEditorPreferencePageTest
extends RcpModelTest {
    private static final IPreferenceStore preferences = RcpToolkitDescription.INSTANCE.getPreferences();

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        preferences.setToDefault("org.eclipse.wb.rcp.preferencePage: use usual code generation style");
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_FLATimplicit() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "    addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()));", "  }", "}");
        FieldEditorPreferencePageTest.assertHierarchy("{this: org.eclipse.jface.preference.FieldEditorPreferencePage} {this} {/new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent())/ /addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()))/ /new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent())/ /addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()))/}", "  {new: org.eclipse.jface.preference.BooleanFieldEditor} {empty} {/addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()))/}", "  {new: org.eclipse.jface.preference.IntegerFieldEditor} {empty} {/addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()))/}", "    {method: getLabelControl} {subComponent} {}", "    {method: getTextControl} {subComponent} {}");
        List editors = page.getEditors();
        Assertions.assertThat((List)editors).hasSize(2);
        FieldEditorInfo editor_1 = (FieldEditorInfo)editors.get(0);
        FieldEditorInfo editor_2 = (FieldEditorInfo)editors.get(1);
        page.refresh();
        FieldEditorPreferencePageTest.assertNoErrors((JavaInfo)page);
        Rectangle bounds_1 = editor_1.getBounds();
        Rectangle bounds_2 = editor_2.getBounds();
        Assertions.assertThat((int)bounds_1.width).isGreaterThan(300);
        Assertions.assertThat((int)bounds_1.height).isGreaterThan(15);
        Assertions.assertThat((int)bounds_2.width).isGreaterThan(300);
        Assertions.assertThat((int)bounds_2.height).isGreaterThan(15);
        FieldEditorPreferencePageTest.assertFalse((boolean)bounds_1.intersects(bounds_2));
    }

    @Test
    public void test_FLATexplicit() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "    addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()));", "  }", "}");
        FieldEditorPreferencePageTest.assertHierarchy("{this: org.eclipse.jface.preference.FieldEditorPreferencePage} {this} {/new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent())/ /addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()))/ /new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent())/ /addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()))/}", "  {new: org.eclipse.jface.preference.BooleanFieldEditor} {empty} {/addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()))/}", "  {new: org.eclipse.jface.preference.IntegerFieldEditor} {empty} {/addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()))/}", "    {method: getLabelControl} {subComponent} {}", "    {method: getTextControl} {subComponent} {}");
        page.refresh();
        FieldEditorPreferencePageTest.assertNoErrors((JavaInfo)page);
    }

    @Test
    public void test_GRID() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(GRID);", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "    addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()));", "  }", "}");
        FieldEditorPreferencePageTest.assertHierarchy("{this: org.eclipse.jface.preference.FieldEditorPreferencePage} {this} {/new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent())/ /addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()))/ /new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent())/ /addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()))/}", "  {new: org.eclipse.jface.preference.BooleanFieldEditor} {empty} {/addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()))/}", "  {new: org.eclipse.jface.preference.IntegerFieldEditor} {empty} {/addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()))/}", "    {method: getLabelControl} {subComponent} {}", "    {method: getTextControl} {subComponent} {}");
        List editors = page.getEditors();
        Assertions.assertThat((List)editors).hasSize(2);
        FieldEditorInfo editor_1 = (FieldEditorInfo)editors.get(0);
        FieldEditorInfo editor_2 = (FieldEditorInfo)editors.get(1);
        page.refresh();
        FieldEditorPreferencePageTest.assertNoErrors((JavaInfo)page);
        Rectangle bounds_1 = editor_1.getBounds();
        Rectangle bounds_2 = editor_2.getBounds();
        Assertions.assertThat((int)bounds_1.width).isGreaterThanOrEqualTo(90);
        Assertions.assertThat((int)bounds_1.height).isGreaterThan(15);
        Assertions.assertThat((int)bounds_2.width).isGreaterThan(300);
        Assertions.assertThat((int)bounds_2.height).isGreaterThan(15);
        FieldEditorPreferencePageTest.assertFalse((boolean)bounds_1.intersects(bounds_2));
    }

    @Test
    public void test_complexFieldEditor_bounds() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(GRID);", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "    addField(new RadioGroupFieldEditor('id', 'New RadioGroupFieldEditor', 1, new String[][]{{'name_1', 'value_1'}, {'name_2', 'value_2'}}, getFieldEditorParent(), false));", "  }", "}");
        FieldEditorPreferencePageTest.assertNoErrors((JavaInfo)page);
        List editors = page.getEditors();
        Assertions.assertThat((List)editors).hasSize(2);
        FieldEditorInfo editor_1 = (FieldEditorInfo)editors.get(0);
        FieldEditorInfo editor_2 = (FieldEditorInfo)editors.get(1);
        page.refresh();
        FieldEditorPreferencePageTest.assertNoErrors((JavaInfo)page);
        Rectangle bounds_1 = editor_1.getBounds();
        Rectangle bounds_2 = editor_2.getBounds();
        FieldEditorPreferencePageTest.assertFalse((boolean)bounds_1.intersects(bounds_2));
    }

    @Test
    public void test_IntegerFieldEditor_properties() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  protected void createFieldEditors() {", "    addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()));", "  }", "}");
        FieldEditorInfo fieldEditor = (FieldEditorInfo)page.getEditors().get(0);
        Property rangeProperty = fieldEditor.getPropertyByTitle("validRange");
        FieldEditorPreferencePageTest.assertNotNull((Object)rangeProperty);
        Property[] subProperties = FieldEditorPreferencePageTest.getSubProperties(rangeProperty);
        FieldEditorPreferencePageTest.assertEquals((int)2, (int)subProperties.length);
        FieldEditorPreferencePageTest.assertEquals((Object)"min", (Object)subProperties[0].getTitle());
        FieldEditorPreferencePageTest.assertEquals((Object)"max", (Object)subProperties[1].getTitle());
        Property property = fieldEditor.getPropertyByTitle("textLimit");
        FieldEditorPreferencePageTest.assertEquals((Object)10, (Object)property.getValue());
    }

    @Test
    public void test_paletteTweaks_1() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  protected void createFieldEditors() {", "  }", "}");
        CategoryInfo systemCategory = new CategoryInfo("org.eclipse.wb.rcp.system");
        CategoryInfo editorsCategory = new CategoryInfo("org.eclipse.wb.rcp.fieldEditors");
        CategoryInfo otherCategory = new CategoryInfo("some.other.category");
        ArrayList categories = Lists.newArrayList((Object[])new CategoryInfo[]{systemCategory, editorsCategory, otherCategory});
        Assertions.assertThat((List)categories).hasSize(3);
        FieldEditorPreferencePageTest.assertTrue((boolean)systemCategory.isVisible());
        FieldEditorPreferencePageTest.assertTrue((boolean)editorsCategory.isVisible());
        FieldEditorPreferencePageTest.assertTrue((boolean)otherCategory.isVisible());
        ((PaletteEventListener)page.getBroadcast(PaletteEventListener.class)).categories((List)categories);
        Assertions.assertThat((List)categories).hasSize(3);
        FieldEditorPreferencePageTest.assertTrue((boolean)systemCategory.isVisible());
        FieldEditorPreferencePageTest.assertTrue((boolean)editorsCategory.isVisible());
        FieldEditorPreferencePageTest.assertFalse((boolean)otherCategory.isVisible());
    }

    @Test
    public void test_paletteTweaks_2() throws Exception {
        Object javaInfo = this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        CategoryInfo systemCategory = new CategoryInfo("org.eclipse.wb.rcp.system");
        CategoryInfo editorsCategory = new CategoryInfo("org.eclipse.wb.rcp.fieldEditors");
        CategoryInfo otherCategory = new CategoryInfo("some.other.category");
        ArrayList categories = Lists.newArrayList((Object[])new CategoryInfo[]{systemCategory, editorsCategory, otherCategory});
        Assertions.assertThat((List)categories).hasSize(3);
        FieldEditorPreferencePageTest.assertTrue((boolean)systemCategory.isVisible());
        FieldEditorPreferencePageTest.assertTrue((boolean)editorsCategory.isVisible());
        FieldEditorPreferencePageTest.assertTrue((boolean)otherCategory.isVisible());
        ((PaletteEventListener)javaInfo.getBroadcast(PaletteEventListener.class)).categories((List)categories);
        Assertions.assertThat((List)categories).hasSize(3);
        FieldEditorPreferencePageTest.assertTrue((boolean)systemCategory.isVisible());
        FieldEditorPreferencePageTest.assertFalse((boolean)editorsCategory.isVisible());
        FieldEditorPreferencePageTest.assertTrue((boolean)otherCategory.isVisible());
    }

    @Test
    public void test_CREATE_1() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "  }", "}");
        FieldEditorInfo nextEditor = (FieldEditorInfo)page.getEditors().get(0);
        FieldEditorInfo newEditor = (FieldEditorInfo)FieldEditorPreferencePageTest.createJavaInfo("org.eclipse.jface.preference.IntegerFieldEditor");
        page.command_CREATE(newEditor, nextEditor);
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    addField(new IntegerFieldEditor('id', 'New IntegerFieldEditor', getFieldEditorParent()));", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "  }", "}");
    }

    @Test
    public void test_CREATE_2() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "  }", "}");
        FieldEditorInfo newEditor = (FieldEditorInfo)FieldEditorPreferencePageTest.createJavaInfo("org.eclipse.jface.preference.IntegerFieldEditor");
        page.command_CREATE(newEditor, null);
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "    addField(new IntegerFieldEditor('id', 'New IntegerFieldEditor', getFieldEditorParent()));", "  }", "}");
    }

    @Test
    public void test_CREATE_withControlCodeStyle() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "  }", "}");
        FieldEditorInfo newEditor = (FieldEditorInfo)FieldEditorPreferencePageTest.createJavaInfo("org.eclipse.jface.preference.IntegerFieldEditor");
        preferences.setValue("org.eclipse.wb.rcp.preferencePage: use usual code generation style", true);
        page.command_CREATE(newEditor, null);
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    {", "      IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor('id', 'New IntegerFieldEditor', getFieldEditorParent());", "      addField(integerFieldEditor);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_1() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor 1', getFieldEditorParent()));", "    addField(new BooleanFieldEditor('id_2', 'Boolean editor 2', getFieldEditorParent()));", "  }", "}");
        FieldEditorInfo editor_1 = (FieldEditorInfo)page.getEditors().get(0);
        FieldEditorInfo editor_2 = (FieldEditorInfo)page.getEditors().get(1);
        page.command_MOVE(editor_2, editor_1);
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_2', 'Boolean editor 2', getFieldEditorParent()));", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor 1', getFieldEditorParent()));", "  }", "}");
    }

    @Test
    public void test_MOVE_2() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    {", "      IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor('id_1', 'Integer editor', getFieldEditorParent());", "      addField(integerFieldEditor);", "    }", "    addField(new BooleanFieldEditor('id_2', 'Boolean editor 2', getFieldEditorParent()));", "  }", "}");
        FieldEditorInfo editor_1 = (FieldEditorInfo)page.getEditors().get(0);
        page.command_MOVE(editor_1, null);
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_2', 'Boolean editor 2', getFieldEditorParent()));", "    {", "      IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor('id_1', 'Integer editor', getFieldEditorParent());", "      addField(integerFieldEditor);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_3() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "    setTitle('Some related node');", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor 1', getFieldEditorParent()));", "    addField(new BooleanFieldEditor('id_2', 'Boolean editor 2', getFieldEditorParent()));", "  }", "}");
        FieldEditorInfo editor_1 = (FieldEditorInfo)page.getEditors().get(0);
        page.command_MOVE(editor_1, null);
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "    setTitle('Some related node');", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_2', 'Boolean editor 2', getFieldEditorParent()));", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor 1', getFieldEditorParent()));", "  }", "}");
    }

    @Test
    public void test_convertToBlock() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    addField(new IntegerFieldEditor('id', 'New IntegerFieldEditor', getFieldEditorParent()));", "  }", "}");
        FieldEditorInfo editor = (FieldEditorInfo)page.getEditors().get(0);
        editor.getPropertyByTitle("textLimit").setValue((Object)5);
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    {", "      IntegerFieldEditor integerFieldEditor = new IntegerFieldEditor('id', 'New IntegerFieldEditor', getFieldEditorParent());", "      integerFieldEditor.setTextLimit(5);", "      addField(integerFieldEditor);", "    }", "  }", "}");
    }

    @Test
    public void test_copyPaste() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "    addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()));", "  }", "}");
        page.refresh();
        FieldEditorInfo fieldEditor = (FieldEditorInfo)page.getEditors().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)fieldEditor);
        FieldEditorInfo newFieldEditor = (FieldEditorInfo)memento.create((JavaInfo)page);
        page.command_CREATE(newFieldEditor, null);
        memento.apply();
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "  }", "  protected void createFieldEditors() {", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "    addField(new IntegerFieldEditor('id_2', 'Integer editor', getFieldEditorParent()));", "    addField(new BooleanFieldEditor('id_1', 'Boolean editor', getFieldEditorParent()));", "  }", "}");
    }

    @Test
    public void test_subComponents_0() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    {", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', getFieldEditorParent());", "      addField(stringFieldEditor);", "    }", "  }", "}");
        FieldEditorPreferencePageTest.assertHierarchy("{this: org.eclipse.jface.preference.FieldEditorPreferencePage} {this} {/new StringFieldEditor('id', 'String editor', getFieldEditorParent())/ /addField(stringFieldEditor)/}", "  {new: org.eclipse.jface.preference.StringFieldEditor} {local-unique: stringFieldEditor} {/new StringFieldEditor('id', 'String editor', getFieldEditorParent())/ /addField(stringFieldEditor)/}", "    {method: getLabelControl} {subComponent} {}", "    {method: getTextControl} {subComponent} {}");
        FieldEditorInfo fieldEditor = (FieldEditorInfo)page.getEditors().get(0);
        List controls = fieldEditor.getChildControls();
        Assertions.assertThat((List)controls).hasSize(2);
        FieldEditorPreferencePageTest.assertEquals((Object)"org.eclipse.swt.widgets.Label", (Object)((ControlInfo)controls.get(0)).getDescription().getComponentClass().getName());
        FieldEditorPreferencePageTest.assertEquals((Object)"org.eclipse.swt.widgets.Text", (Object)((ControlInfo)controls.get(1)).getDescription().getComponentClass().getName());
        ControlInfo labelControl = (ControlInfo)controls.get(0);
        List children = fieldEditor.getPresentation().getChildrenGraphical();
        Assertions.assertThat((List)children).isEmpty();
        FieldEditorSubComponentCreationSupport creationSupport = (FieldEditorSubComponentCreationSupport)labelControl.getCreationSupport();
        FieldEditorPreferencePageTest.assertEquals((Object)"method: getLabelControl", (Object)creationSupport.toString());
        FieldEditorPreferencePageTest.assertSame((Object)fieldEditor.getCreationSupport().getNode(), (Object)creationSupport.getNode());
        FieldEditorPreferencePageTest.assertFalse((boolean)creationSupport.canReorder());
        FieldEditorPreferencePageTest.assertFalse((boolean)creationSupport.canReparent());
        FieldEditorPreferencePageTest.assertTrue((boolean)creationSupport.canDelete());
        FieldEditorSubComponentVariableSupport variableSupport = (FieldEditorSubComponentVariableSupport)labelControl.getVariableSupport();
        FieldEditorPreferencePageTest.assertEquals((Object)"subComponent", (Object)variableSupport.toString());
        FieldEditorPreferencePageTest.assertEquals((Object)"getLabelControl()", (Object)variableSupport.getTitle());
        FieldEditorPreferencePageTest.assertEquals((Object)"stringFieldEditorLabelControl", (Object)variableSupport.getComponentName());
        variableSupport.isValidStatementForChild(AstNodeUtils.getEnclosingStatement((ASTNode)fieldEditor.getCreationSupport().getNode()));
        FieldEditorPreferencePageTest.assertEquals((Object)fieldEditor.getVariableSupport().getStatementTarget().toString(), (Object)variableSupport.getStatementTarget().toString());
        FieldEditorPreferencePageTest.assertEquals((Object)JavaInfoUtils.getTarget((JavaInfo)fieldEditor, null).toString(), (Object)variableSupport.getChildTarget().toString());
        FieldEditorPreferencePageTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)labelControl.getAssociation());
        page.refresh();
        Assertions.assertThat((int)fieldEditor.getBounds().width).isGreaterThan(300);
        Assertions.assertThat((int)fieldEditor.getBounds().height).isGreaterThan(18);
        FieldEditorPreferencePageTest.assertEquals((int)labelControl.getBounds().x, (int)0);
        Assertions.assertThat((int)labelControl.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)labelControl.getBounds().height).isGreaterThan(10);
    }

    @Test
    public void test_subComponents_1() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    {", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', getFieldEditorParent());", "      addField(stringFieldEditor);", "    }", "  }", "}");
        page.refresh();
        FieldEditorInfo fieldEditor = (FieldEditorInfo)page.getEditors().get(0);
        ControlInfo labelControl = (ControlInfo)fieldEditor.getChildControls().get(0);
        labelControl.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    {", "      Composite composite = getFieldEditorParent();", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', composite);", "      stringFieldEditor.getLabelControl(composite).setEnabled(false);", "      addField(stringFieldEditor);", "    }", "  }", "}");
        labelControl.getPropertyByTitle("toolTipText").setValue((Object)"Some tooltip");
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    {", "      Composite composite = getFieldEditorParent();", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', composite);", "      stringFieldEditor.getLabelControl(composite).setToolTipText('Some tooltip');", "      stringFieldEditor.getLabelControl(composite).setEnabled(false);", "      addField(stringFieldEditor);", "    }", "  }", "}");
    }

    @Test
    public void test_subComponents_2() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    addField(new StringFieldEditor('id', 'String editor', getFieldEditorParent()));", "  }", "}");
        page.refresh();
        FieldEditorInfo fieldEditor = (FieldEditorInfo)page.getEditors().get(0);
        ControlInfo labelControl = (ControlInfo)fieldEditor.getChildControls().get(0);
        labelControl.getPropertyByTitle("enabled").setValue((Object)false);
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    {", "      Composite composite = getFieldEditorParent();", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', composite);", "      stringFieldEditor.getLabelControl(composite).setEnabled(false);", "      addField(stringFieldEditor);", "    }", "  }", "}");
    }

    @Test
    public void test_subComponents_3() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    {", "      Composite composite = getFieldEditorParent();", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', composite);", "      stringFieldEditor.getLabelControl(composite).setToolTipText('Some tooltip');", "      stringFieldEditor.getLabelControl(composite).setEnabled(false);", "      addField(stringFieldEditor);", "    }", "  }", "}");
        FieldEditorPreferencePageTest.assertHierarchy("{this: org.eclipse.jface.preference.FieldEditorPreferencePage} {this} {/getFieldEditorParent()/ /addField(stringFieldEditor)/}", "  {new: org.eclipse.jface.preference.StringFieldEditor} {local-unique: stringFieldEditor} {/new StringFieldEditor('id', 'String editor', composite)/ /stringFieldEditor.getLabelControl(composite)/ /stringFieldEditor.getLabelControl(composite)/ /addField(stringFieldEditor)/}", "    {method: getLabelControl} {subComponent} {/stringFieldEditor.getLabelControl(composite).setToolTipText('Some tooltip')/ /stringFieldEditor.getLabelControl(composite).setEnabled(false)/}", "    {method: getTextControl} {subComponent} {}");
        page.refresh();
        FieldEditorInfo fieldEditor = (FieldEditorInfo)page.getEditors().get(0);
        LabelInfo labelControl = (LabelInfo)fieldEditor.getChildControls().get(0);
        Label labelObject = labelControl.getWidget();
        FieldEditorPreferencePageTest.assertEquals((Object)"Some tooltip", (Object)labelObject.getToolTipText());
        FieldEditorPreferencePageTest.assertEquals((Object)false, (Object)labelObject.isEnabled());
        FieldEditorPreferencePageTest.assertTrue((boolean)labelControl.canDelete());
        labelControl.delete();
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(FLAT);", "  }", "  protected void createFieldEditors() {", "    {", "      Composite composite = getFieldEditorParent();", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', composite);", "      addField(stringFieldEditor);", "    }", "  }", "}");
        Assertions.assertThat((List)fieldEditor.getChildControls()).contains((Object[])new ControlInfo[]{labelControl});
    }

    @Test
    public void test_subComponents_4() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "  }", "  protected void createFieldEditors() {", "    {", "      Composite composite = getFieldEditorParent();", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', composite);", "      stringFieldEditor.getLabelControl(composite).setEnabled(false);", "      addField(stringFieldEditor);", "    }", "  }", "}");
        page.refresh();
        FieldEditorInfo fieldEditor = (FieldEditorInfo)page.getEditors().get(0);
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)fieldEditor);
        ObjectOutputStream oos = new ObjectOutputStream(new ByteArrayOutputStream());
        oos.writeObject(memento);
        FieldEditorInfo newFieldEditor = (FieldEditorInfo)memento.create((JavaInfo)page);
        page.command_CREATE(newFieldEditor, null);
        memento.apply();
        this.assertEditor("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "  }", "  protected void createFieldEditors() {", "    {", "      Composite composite = getFieldEditorParent();", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', composite);", "      stringFieldEditor.getLabelControl(composite).setEnabled(false);", "      addField(stringFieldEditor);", "    }", "    {", "      Composite composite = getFieldEditorParent();", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', composite);", "      stringFieldEditor.getLabelControl(composite).setEnabled(false);", "      addField(stringFieldEditor);", "    }", "  }", "}");
    }

    @Test
    public void test_subComponents_5() throws Exception {
        FieldEditorPreferencePageInfo page = (FieldEditorPreferencePageInfo)this.parseJavaInfo("import org.eclipse.jface.preference.*;", "public class Test extends FieldEditorPreferencePage {", "  public Test() {", "    super(GRID);", "  }", "  protected void createFieldEditors() {", "    {", "      StringFieldEditor stringFieldEditor = new StringFieldEditor('id', 'String editor', getFieldEditorParent());", "      addField(stringFieldEditor);", "    }", "  }", "}");
        page.refresh();
        FieldEditorInfo fieldEditor = (FieldEditorInfo)page.getEditors().get(0);
        ControlInfo labelControl = (ControlInfo)fieldEditor.getChildControls().get(0);
        Assertions.assertThat((int)fieldEditor.getBounds().width).isGreaterThan(300);
        Assertions.assertThat((int)fieldEditor.getBounds().height).isGreaterThan(18);
        Assertions.assertThat((int)labelControl.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)labelControl.getBounds().height).isGreaterThan(10);
    }
}

