/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.layout.form;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplAutomatic;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class FormLayoutMoveSingleResizableTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_move_to_leading_1_2component() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(0, 20);", "        data1.right = new FormAttachment(0, 70);", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      {", "        FormData data2 = new FormData();", "        data2.left = new FormAttachment(0, 100);", "        data2.right = new FormAttachment(100, -250);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button2 = (ControlInfo)shell.getChildrenControls().get(1);
        this.moveTo(shell, button2, 90, 0);
        this.assertEditor("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(0, 20);", "        data1.right = new FormAttachment(0, 70);", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      {", "        FormData data2 = new FormData();", "        data2.left = new FormAttachment(button1, 20);", "        data2.right = new FormAttachment(100, -260);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_to_leading_2_2component() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(0, 20);", "        data1.right = new FormAttachment(0, 70);", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      {", "        FormData data2 = new FormData();", "        data2.left = new FormAttachment(0, 100);", "        data2.right = new FormAttachment(0, 150);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button1 = (ControlInfo)shell.getChildrenControls().get(0);
        this.moveTo(shell, button1, 30, 1);
        this.assertEditor("public class Test extends Shell {", "\tprivate Button button1;", "\tprivate Button button2;", "\tprivate FormData data1;", "\tpublic Test() {", "\t\tsetLayout(new FormLayout());", "\t\t{", "\t\t\tbutton1 = new Button(this, SWT.NONE);", "\t\t\t{", "\t\t\t\tdata1 = new FormData();", "\t\t\t\tbutton1.setLayoutData(data1);", "\t\t\t}", "\t\t}", "\t\t{", "\t\t\tbutton2 = new Button(this, SWT.NONE);", "\t\t\tdata1.right = new FormAttachment(button2, -20);", "\t\t\tdata1.left = new FormAttachment(button2, -70, SWT.LEFT);", "\t\t\t{", "\t\t\t\tFormData data2 = new FormData();", "\t\t\t\tdata2.left = new FormAttachment(0, 100);", "\t\t\t\tdata2.right = new FormAttachment(0, 150);", "\t\t\t\tbutton2.setLayoutData(data2);", "\t\t\t}", "\t\t}", "\t}", "}");
    }

    @Test
    public void test_move_to_leading_1() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button1;", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(0, 120);", "        data1.right = new FormAttachment(100, -70);", "        button1.setLayoutData(data1);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button1 = (ControlInfo)shell.getChildrenControls().get(0);
        this.moveTo(shell, button1, 100, 0);
        this.assertEditor("public class Test extends Shell {", "  private Button button1;", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(0, 100);", "        data1.right = new FormAttachment(100, -90);", "        button1.setLayoutData(data1);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_to_leading_2() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button1;", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(100, -120);", "        data1.right = new FormAttachment(0, 370);", "        button1.setLayoutData(data1);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button1 = (ControlInfo)shell.getChildrenControls().get(0);
        this.moveTo(shell, button1, 100, 0);
        int expectedLeft = -348;
        int expectedRight = 142;
        this.assertEditor("public class Test extends Shell {", "  private Button button1;", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(100, " + expectedLeft + ");", "        data1.right = new FormAttachment(0, " + expectedRight + ");", "        button1.setLayoutData(data1);", "      }", "    }", "  }", "}");
    }

    private FormLayoutInfoImplAutomatic<ControlInfo> getImpl(CompositeInfo shell) {
        FormLayoutInfo layout = (FormLayoutInfo)shell.getLayout();
        return (FormLayoutInfoImplAutomatic)layout.getImpl();
    }

    private void moveTo(CompositeInfo shell, ControlInfo control, int x, int direction) throws Exception {
        FormLayoutInfoImplAutomatic<ControlInfo> impl = this.getImpl(shell);
        Rectangle controlBounds = control.getModelBounds();
        impl.command_moveFreely(new Rectangle(x, 0, controlBounds.width, controlBounds.height), List.of(control), (IAbstractComponentInfo)control, direction, true);
    }

    private void prepareComponent() throws Exception {
        this.prepareComponent(75, 25);
    }

    private void prepareComponent(int width, int height) throws Exception {
        FormLayoutMoveSingleResizableTest.setFileContentSrc("test/Button.java", this.getTestSource("public class Button extends org.eclipse.swt.widgets.Button {", "  public Button(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void checkSubclass () {", "  }", "  public Point computeSize (int wHint, int hHint, boolean changed) {", "    return new Point(" + width + ", " + height + ");", "  }", "}"));
        FormLayoutMoveSingleResizableTest.waitForAutoBuild();
    }
}

