/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.layout.form;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplAutomatic;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class FormLayoutMoveSingleWithSingleSideTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_move_to_trailing_change_alignment_2component() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(0, 20);", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      {", "        FormData data2 = new FormData();", "        data2.left = new FormAttachment(0, 200);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button1 = (ControlInfo)shell.getChildrenControls().get(0);
        int x = 200 - button1.getModelBounds().width;
        this.moveTo(shell, button1, x - 30, 1);
        this.assertEditor("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  private FormData data1;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        data1 = new FormData();", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      data1.right = new FormAttachment(button2, -30);", "      {", "        FormData data2 = new FormData();", "        data2.left = new FormAttachment(0, 200);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_to_leading_change_alignment_2component() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(0, 20);", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      {", "        FormData data2 = new FormData();", "        data2.right = new FormAttachment(100, -20);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button2 = (ControlInfo)shell.getChildrenControls().get(1);
        this.moveTo(shell, button2, 110, 0);
        this.assertEditor("public class Test extends Shell {", "\tprivate Button button1;", "\tprivate Button button2;", "\tpublic Test() {", "\t\tsetLayout(new FormLayout());", "\t\t{", "\t\t\tbutton1 = new Button(this, SWT.NONE);", "\t\t\t{", "\t\t\t\tFormData data1 = new FormData();", "\t\t\t\tdata1.left = new FormAttachment(0, 20);", "\t\t\t\tbutton1.setLayoutData(data1);", "\t\t\t}", "\t\t}", "\t\t{", "\t\t\tbutton2 = new Button(this, SWT.NONE);", "\t\t\t{", "\t\t\t\tFormData data2 = new FormData();", "\t\t\t\tdata2.left = new FormAttachment(button1, 15);", "\t\t\t\tbutton2.setLayoutData(data2);", "\t\t\t}", "\t\t}", "\t}", "}");
    }

    @Test
    public void test_move_to_trailing_keep_alignment_2component() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.right = new FormAttachment(100, -320);", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      {", "        FormData data2 = new FormData();", "        data2.right = new FormAttachment(100, -20);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button2 = (ControlInfo)shell.getChildrenControls().get(1);
        int x = button2.getModelBounds().x - button1.getModelBounds().width;
        this.moveTo(shell, button1, x - 20, 1);
        this.assertEditor("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  private FormData data1;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        data1 = new FormData();", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      data1.right = new FormAttachment(button2, -20);", "      {", "        FormData data2 = new FormData();", "        data2.right = new FormAttachment(100, -20);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_to_leading_keep_alignment_2component() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(0, 20);", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      {", "        FormData data2 = new FormData();", "        data2.left = new FormAttachment(0, 200);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button2 = (ControlInfo)shell.getChildrenControls().get(1);
        this.moveTo(shell, button2, 120, 0);
        this.assertEditor("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        data1.left = new FormAttachment(0, 20);", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      {", "        FormData data2 = new FormData();", "        data2.left = new FormAttachment(button1, 25);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_to_trailing_no_constraints_2component() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        FormData data1 = new FormData();", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      {", "        FormData data2 = new FormData();", "        data2.left = new FormAttachment(0, 200);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button1 = (ControlInfo)shell.getChildrenControls().get(0);
        this.moveTo(shell, button1, 100, 1);
        this.assertEditor("public class Test extends Shell {", "  private Button button1;", "  private Button button2;", "  private FormData data1;", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      button1 = new Button(this, SWT.NONE);", "      {", "        data1 = new FormData();", "        button1.setLayoutData(data1);", "      }", "    }", "    {", "      button2 = new Button(this, SWT.NONE);", "      data1.right = new FormAttachment(button2, -25);", "      {", "        FormData data2 = new FormData();", "        data2.left = new FormAttachment(0, 200);", "        button2.setLayoutData(data2);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_to_trailing_no_constraints() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)FormLayoutMoveSingleWithSingleSideTest.getJavaInfoByName("button");
        this.moveTo(shell, button, 50, 1);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.left = new FormAttachment(0, 50);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_to_trailing_change_alignment() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.left = new FormAttachment(0, 20);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
        this.refresh();
        ControlInfo button = (ControlInfo)FormLayoutMoveSingleWithSingleSideTest.getJavaInfoByName("button");
        int shellWidth = shell.getClientArea().width;
        int x = shellWidth - button.getModelBounds().width;
        this.moveTo(shell, button, x - 30, 1);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.right = new FormAttachment(100, -30);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_to_leading_change_alignment() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.right = new FormAttachment(100, -10);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)FormLayoutMoveSingleWithSingleSideTest.getJavaInfoByName("button");
        this.moveTo(shell, button, 10, 0);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.left = new FormAttachment(0, 10);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_to_trailing_keep_alignment() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.right = new FormAttachment(100, -60);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)FormLayoutMoveSingleWithSingleSideTest.getJavaInfoByName("button");
        int shellWidth = shell.getClientArea().width;
        int x = shellWidth - button.getModelBounds().width;
        this.moveTo(shell, button, x - 10, 1);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    super(SWT.NONE);", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.right = new FormAttachment(100, -10);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_move_to_leading_keep_alignment() throws Exception {
        this.prepareComponent();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.left = new FormAttachment(0, 60);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)FormLayoutMoveSingleWithSingleSideTest.getJavaInfoByName("button");
        this.moveTo(shell, button, 10, 0);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FormLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        FormData formData = new FormData();", "        formData.left = new FormAttachment(0, 10);", "        button.setLayoutData(formData);", "      }", "    }", "  }", "}");
    }

    private FormLayoutInfoImplAutomatic<ControlInfo> getImpl(CompositeInfo shell) {
        FormLayoutInfo layout = (FormLayoutInfo)shell.getLayout();
        return (FormLayoutInfoImplAutomatic)layout.getImpl();
    }

    private void moveTo(CompositeInfo shell, ControlInfo control, int x, int direction) throws Exception {
        FormLayoutInfoImplAutomatic<ControlInfo> impl = this.getImpl(shell);
        Rectangle controlBounds = control.getModelBounds();
        impl.command_moveFreely(new Rectangle(x, 0, controlBounds.width, controlBounds.height), List.of(control), (IAbstractComponentInfo)control, direction, true);
    }

    private void prepareComponent() throws Exception {
        this.prepareComponent(75, 25);
    }

    private void prepareComponent(int width, int height) throws Exception {
        FormLayoutMoveSingleWithSingleSideTest.setFileContentSrc("test/Button.java", this.getTestSource("public class Button extends org.eclipse.swt.widgets.Button {", "  public Button(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void checkSubclass () {", "  }", "  public Point computeSize (int wHint, int hHint, boolean changed) {", "    return new Point(" + width + ", " + height + ");", "  }", "}"));
        FormLayoutMoveSingleWithSingleSideTest.waitForAutoBuild();
    }
}

