/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.UIManager;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.swing.model.property.converter.ColorConverter;
import org.eclipse.wb.internal.swing.model.property.converter.DimensionConverter;
import org.eclipse.wb.internal.swing.model.property.converter.InsetsConverter;
import org.eclipse.wb.internal.swing.model.property.converter.PointConverter;
import org.eclipse.wb.internal.swing.model.property.converter.RectangleConverter;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;

public class ConvertersTest
extends DesignerTestCase {
    @Test
    public void test_PointConverter() throws Exception {
        ExpressionConverter converter = PointConverter.INSTANCE;
        ConvertersTest.assertEquals((Object)"new java.awt.Point(1, 2)", (Object)converter.toJavaSource(null, (Object)new Point(1, 2)));
        ConvertersTest.assertEquals((Object)"(java.awt.Point) null", (Object)converter.toJavaSource(null, null));
    }

    @Test
    public void test_DimensionConverter() throws Exception {
        ExpressionConverter converter = DimensionConverter.INSTANCE;
        ConvertersTest.assertEquals((Object)"new java.awt.Dimension(1, 2)", (Object)converter.toJavaSource(null, (Object)new Dimension(1, 2)));
        ConvertersTest.assertEquals((Object)"(java.awt.Dimension) null", (Object)converter.toJavaSource(null, null));
    }

    @Test
    public void test_InsetsConverter() throws Exception {
        ExpressionConverter converter = InsetsConverter.INSTANCE;
        ConvertersTest.assertEquals((Object)"new java.awt.Insets(1, 2, 3, 4)", (Object)converter.toJavaSource(null, (Object)new Insets(1, 2, 3, 4)));
        ConvertersTest.assertEquals((Object)"(java.awt.Insets) null", (Object)converter.toJavaSource(null, null));
    }

    @Test
    public void test_RectangleConverter() throws Exception {
        ExpressionConverter converter = RectangleConverter.INSTANCE;
        ConvertersTest.assertEquals((Object)"new java.awt.Rectangle(1, 2, 3, 4)", (Object)converter.toJavaSource(null, (Object)new Rectangle(1, 2, 3, 4)));
        ConvertersTest.assertEquals((Object)"(java.awt.Rectangle) null", (Object)converter.toJavaSource(null, null));
    }

    @Test
    public void test_ColorConverter() throws Exception {
        ExpressionConverter converter = ColorConverter.INSTANCE;
        ConvertersTest.assertEquals((Object)"(java.awt.Color) null", (Object)converter.toJavaSource(null, null));
        ConvertersTest.assertEquals((Object)"java.awt.Color.RED", (Object)converter.toJavaSource(null, (Object)Color.red));
        ConvertersTest.assertEquals((Object)"java.awt.Color.RED", (Object)converter.toJavaSource(null, (Object)new Color(255, 0, 0)));
        ConvertersTest.assertEquals((Object)"new java.awt.Color(1, 2, 3, 4)", (Object)converter.toJavaSource(null, (Object)new Color(1, 2, 3, 4)));
        class SystemColorValue
        extends Expectations.KeyValue<SystemColor> {
            public SystemColorValue(String _key, SystemColor _value) {
                super(_key, _value);
            }
        }
        ConvertersTest.assertEquals((Object)Expectations.get("java.awt.SystemColor.textHighlight", new Expectations.StrValue("kosta-home", "java.awt.SystemColor.textInactiveText"), new Expectations.StrValue("scheglov-win", "java.awt.SystemColor.textHighlight")), (Object)converter.toJavaSource(null, (Object)Expectations.get(SystemColor.textHighlight, new SystemColorValue("kosta-home", SystemColor.textInactiveText), new SystemColorValue("scheglov-win", SystemColor.textHighlight))));
        EventQueue.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        ConvertersTest.assertEquals((Object)"javax.swing.UIManager.getColor(\"Button.darkShadow\")", (Object)converter.toJavaSource(null, (Object)UIManager.getColor("Button.darkShadow")));
    }
}

