/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.property.editor.models.spinner.SpinnerModelPropertyEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JSpinnerTest
extends SwingModelTest {
    private static TimeZone TIME_ZONE;
    private static Locale LOCALE;

    @BeforeAll
    public static void setUpAll() {
        TIME_ZONE = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone(ZoneId.of("UTC")));
        LOCALE = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
    }

    @AfterAll
    public static void tearDownAll() {
        TimeZone.setDefault(TIME_ZONE);
        Locale.setDefault(LOCALE);
    }

    @Test
    public void test_setEditor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JSpinner spinner = new JSpinner();", "    spinner.setEditor(new JSpinner.NumberEditor(spinner, '#'));", "    add(spinner);", "  }", "}");
        panel.refresh();
        JSpinnerTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_numberModel_Integer() throws Exception {
        String source = "new SpinnerNumberModel(15, 10, 20, 1)";
        String expectedText = "Integer, 15, 10, 20, 1";
        String expectedTooltip = "type=Integer value=15 start=10 end=20 step=1";
        this.assertEditorTextTooltip(source, expectedText, expectedTooltip);
    }

    @Test
    public void test_numberModel_Double() throws Exception {
        String source = "new SpinnerNumberModel(15.0, 10.2, 20.0, 1.2)";
        String expectedText = "Double, 15.0, 10.2, 20.0, 1.2";
        String expectedTooltip = "type=Double value=15.0 start=10.2 end=20.0 step=1.2";
        this.assertEditorTextTooltip(source, expectedText, expectedTooltip);
    }

    @Test
    public void test_numberModel_null() throws Exception {
        String source = "new SpinnerNumberModel(15, 0, null, 1)";
        String expectedText = "Integer, 15, 0, null, 1";
        String expectedTooltip = "type=Integer value=15 start=0 end=null step=1";
        this.assertEditorTextTooltip(source, expectedText, expectedTooltip);
    }

    @Test
    public void test_listModel() throws Exception {
        String source = "new SpinnerListModel(new Object[]{\"aaa\", \"bbb\", \"ccc\"})";
        String expectedText = "aaa, bbb, ccc";
        String expectedTooltip = "aaa\nbbb\nccc";
        this.assertEditorTextTooltip(source, expectedText, expectedTooltip);
    }

    @Test
    public void test_dateModel_getDateStep() throws Exception {
        Field[] declaredFields;
        Field[] fieldArray = declaredFields = Calendar.class.getDeclaredFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                String expectedName = field.getName();
                if (expectedName.equals("DATE")) {
                    expectedName = "DAY_OF_MONTH";
                }
                if (expectedName.equals("ZONE_OFFSET")) break;
                String actualName = (String)ReflectionUtils.invokeMethod2(SpinnerModelPropertyEditor.class, (String)"getDateStep", Integer.TYPE, (Object)field.getInt(null));
                JSpinnerTest.assertEquals((Object)expectedName, (Object)actualName);
            }
            ++n2;
        }
        JSpinnerTest.assertNull((Object)ReflectionUtils.invokeMethod2(SpinnerModelPropertyEditor.class, (String)"getDateStep", Integer.TYPE, (Object)-559038737));
    }

    @Test
    public void test_dateModel() throws Exception {
        String source = "new SpinnerDateModel(new java.util.Date(0), null, null, java.util.Calendar.SECOND)";
        String expectedText = "01.01.1970 00:00:00, null, null, SECOND";
        String expectedTooltip = "value=01.01.1970 00:00:00\nstart=null\nend=null\nstep=SECOND";
        this.assertEditorTextTooltip(source, expectedText, expectedTooltip);
    }

    private void assertEditorTextTooltip(String modelSource, String expectedText, String expectedTooltip) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JSpinner spinner = new JSpinner();", "    spinner.setModel(" + modelSource + ");", "    add(spinner);", "  }", "}");
        panel.refresh();
        ComponentInfo spinner = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property modelProperty = spinner.getPropertyByTitle("model");
        PropertyEditor modelEditor = modelProperty.getEditor();
        String text = (String)ReflectionUtils.invokeMethod2((Object)modelEditor, (String)"getText", Property.class, (Object)modelProperty);
        JSpinnerTest.assertEquals((Object)expectedText, (Object)text);
        String tooltip = JSpinnerTest.getPropertyTooltipText((IAdaptable)modelEditor, modelProperty);
        JSpinnerTest.assertEquals((Object)expectedTooltip, (Object)tooltip);
        PropertyTooltipProvider provider = (PropertyTooltipProvider)modelEditor.getAdapter(PropertyTooltipProvider.class);
        JSpinnerTest.assertSame((Object)1, (Object)provider.getTooltipPosition());
    }

    @Test
    public void test_editor_noModel() throws Exception {
        ContainerInfo spinner = this.parseContainer("// filler filler filler\npublic class Test extends JSpinner {\n\tpublic Test() {\n\t}\n}");
        spinner.refresh();
        Property modelProperty = spinner.getPropertyByTitle("model");
        PropertyEditor modelEditor = modelProperty.getEditor();
        JSpinnerTest.assertEquals((Object)"Integer, 0, null, null, 1", (Object)JSpinnerTest.getPropertyText(modelProperty));
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("model").bot();
            JSpinnerTest.assertFalse((boolean)shell.cTabItem("List").isActive());
            JSpinnerTest.assertTrue((boolean)shell.cTabItem("Number").isActive());
            JSpinnerTest.assertFalse((boolean)shell.cTabItem("Date").isActive());
        }));
    }

    @Test
    public void test_editor_numberModel() throws Exception {
        ContainerInfo spinner = this.parseContainer("// filler filler filler\npublic class Test extends JSpinner {\n\tpublic Test() {\n\t\tsetModel(new SpinnerNumberModel(5, 0, 10, 2));\n\t}\n}");
        spinner.refresh();
        Property modelProperty = spinner.getPropertyByTitle("model");
        PropertyEditor modelEditor = modelProperty.getEditor();
        JSpinnerTest.assertEquals((Object)"Integer, 5, 0, 10, 2", (Object)JSpinnerTest.getPropertyText(modelProperty));
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("model").bot();
            JSpinnerTest.assertFalse((boolean)shell.cTabItem("List").isActive());
            JSpinnerTest.assertTrue((boolean)shell.cTabItem("Number").isActive());
            JSpinnerTest.assertFalse((boolean)shell.cTabItem("Date").isActive());
            JSpinnerTest.assertEquals((Object)"Integer", (Object)shell.comboBox().getText(), (String)"Number type");
            JSpinnerTest.assertEquals((Object)"5", (Object)shell.spinner(0).getText(), (String)"Initial Value");
            JSpinnerTest.assertEquals((Object)"0", (Object)shell.spinner(1).getText(), (String)"Minimum");
            JSpinnerTest.assertEquals((Object)"10", (Object)shell.spinner(2).getText(), (String)"Maximum");
            JSpinnerTest.assertEquals((Object)"2", (Object)shell.spinner(3).getText(), (String)"Step Size");
        }));
    }

    @Test
    public void test_editor_listModel() throws Exception {
        ContainerInfo spinner = this.parseContainer("// filler filler filler\npublic class Test extends JSpinner {\n\tpublic Test() {\n\t\tsetModel(new SpinnerListModel(new String[] {\"a\", \"b\", \"c\", \"d\", \"e\"}));\n\t}\n}");
        spinner.refresh();
        Property modelProperty = spinner.getPropertyByTitle("model");
        PropertyEditor modelEditor = modelProperty.getEditor();
        JSpinnerTest.assertEquals((Object)"a, b, c, d, e", (Object)JSpinnerTest.getPropertyText(modelProperty));
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("model").bot();
            JSpinnerTest.assertTrue((boolean)shell.cTabItem("List").isActive());
            JSpinnerTest.assertFalse((boolean)shell.cTabItem("Number").isActive());
            JSpinnerTest.assertFalse((boolean)shell.cTabItem("Date").isActive());
            JSpinnerTest.assertEquals((Object)"a\nb\nc\nd\ne", (Object)shell.text().getText(), (String)"Items");
        }));
    }

    @Test
    public void test_editor_dateModel() throws Exception {
        ContainerInfo spinner = this.parseContainer("import java.util.Calendar;\nimport java.util.Date;\n// filler filler filler\npublic class Test extends JSpinner {\n\tpublic Test() {\n\t\tsetModel(new SpinnerDateModel(new Date(1757800800000L), new Date(1757714400000L), new Date(1757887200000L), Calendar.DAY_OF_YEAR));\n\t}\n}");
        spinner.refresh();
        Property modelProperty = spinner.getPropertyByTitle("model");
        PropertyEditor modelEditor = modelProperty.getEditor();
        JSpinnerTest.assertEquals((Object)"13.09.2025 22:00:00, 12.09.2025 22:00:00, 14.09.2025 22:00:00, DAY_OF_YEAR", (Object)JSpinnerTest.getPropertyText(modelProperty));
        new UiContext().executeAndCheck((FailableRunnable<Exception>)((FailableRunnable)() -> {
            boolean bl = modelEditor.activate(null, modelProperty, null);
        }), (FailableConsumer<SWTBot, Exception>)((FailableConsumer)bot -> {
            SWTBot shell = bot.shell("model").bot();
            JSpinnerTest.assertFalse((boolean)shell.cTabItem("List").isActive());
            JSpinnerTest.assertFalse((boolean)shell.cTabItem("Number").isActive());
            JSpinnerTest.assertTrue((boolean)shell.cTabItem("Date").isActive());
            JSpinnerTest.assertEquals((Object)"Sep 13, 2025, 10:00:00\u202fPM", (Object)shell.text(0).getText(), (String)"Initial value");
            JSpinnerTest.assertEquals((Object)"Sep 12, 2025, 10:00:00\u202fPM", (Object)shell.text(1).getText(), (String)"Start");
            JSpinnerTest.assertEquals((Object)"Sep 14, 2025, 10:00:00\u202fPM", (Object)shell.text(2).getText(), (String)"End");
        }));
    }
}

