/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component.menu;

import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.ImplicitFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.VoidInvocationVariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo;
import org.eclipse.wb.internal.swing.model.bean.ActionInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuBarInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuItemInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuSeparatorCreationSupport;
import org.eclipse.wb.internal.swing.model.component.menu.JPopupMenuSeparatorInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.junit.jupiter.api.Test;

public class JMenuTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_renderEmpty() throws Exception {
        this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "    }", "  }", "}");
        this.refresh();
        JMenuInfo menuInfo = (JMenuInfo)JMenuTest.getJavaInfoByName("menu");
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        JMenuTest.assertTrue((menuObject.getBounds().width > 100 ? 1 : 0) != 0);
        JMenuTest.assertTrue((menuObject.getBounds().height > 15 ? 1 : 0) != 0);
    }

    @Test
    public void test_disposeImages() throws Exception {
        this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "    }", "  }", "}");
        this.refresh();
        JMenuInfo menuInfo = (JMenuInfo)JMenuTest.getJavaInfoByName("menu");
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        Image asItem = menuInfo.getImage();
        JMenuTest.assertFalse((boolean)asItem.isDisposed());
        JMenuTest.assertNotNull((Object)menuObject.getImageDescriptor());
        this.disposeLastModel();
        JMenuTest.assertTrue((boolean)asItem.isDisposed());
        JMenuTest.assertNull((Object)menuObject.getImageDescriptor());
    }

    @Test
    public void test_onContainer() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JMenu menu = new JMenu('Menu');", "      add(menu);", "    }", "  }", "}");
        this.refresh();
        JMenuInfo menu = (JMenuInfo)JMenuTest.getJavaInfoByName("menu");
        Rectangle bounds = menu.getBounds();
        JMenuTest.assertEquals((Object)new Rectangle(0, 0, 450, 300), (Object)bounds);
    }

    @Test
    public void test_deepHierarchy() throws Exception {
        this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    JMenu menu_1 = new JMenu('A');", "    JMenu menu_2 = new JMenu('B');", "    JMenu menu_3 = new JMenu('C');", "    setJMenuBar(menuBar);", "    menuBar.add(menu_1);", "    menu_1.add(menu_2);", "    menu_2.add(menu_3);", "  }", "}");
        this.refresh();
        JMenuInfo menu_1 = (JMenuInfo)JMenuTest.getJavaInfoByName("menu_1");
        JMenuInfo menu_2 = (JMenuInfo)JMenuTest.getJavaInfoByName("menu_2");
        JMenuInfo menu_3 = (JMenuInfo)JMenuTest.getJavaInfoByName("menu_3");
        IMenuInfo menuObject_1 = MenuObjectInfoUtils.getMenuInfo((Object)menu_1);
        IMenuInfo menuObject_2 = MenuObjectInfoUtils.getMenuInfo((Object)menu_2);
        IMenuInfo menuObject_3 = MenuObjectInfoUtils.getMenuInfo((Object)menu_3);
        JMenuTest.assertNotNull((Object)menu_1.getBounds());
        JMenuTest.assertNotNull((Object)menu_2.getBounds());
        JMenuTest.assertNotNull((Object)menu_3.getBounds());
        JMenuTest.assertNotNull((Object)menuObject_1.getBounds());
        JMenuTest.assertNotNull((Object)menuObject_2.getBounds());
        JMenuTest.assertNotNull((Object)menuObject_3.getBounds());
    }

    @Test
    public void test_IMenuItemInfo_IMenuInfo() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem item_1 = new JMenuItem('Item 1');", "        menu.add(item_1);", "      }", "      {", "        JMenuItem item_2 = new JMenuItem('Item 2');", "        menu.add(item_2);", "      }", "    }", "  }", "}");
        frameInfo.refresh();
        JMenuInfo menuInfo = (JMenuInfo)JMenuTest.getJavaInfoByName("menu");
        JMenuItemInfo itemInfo_1 = (JMenuItemInfo)JMenuTest.getJavaInfoByName("item_1");
        JMenuItemInfo itemInfo_2 = (JMenuItemInfo)JMenuTest.getJavaInfoByName("item_2");
        JMenuTest.assertNull((Object)menuInfo.getAdapter(List.class));
        IMenuItemInfo itemObject = MenuObjectInfoUtils.getMenuItemInfo((Object)menuInfo);
        JMenuTest.assertSame((Object)menuInfo, (Object)itemObject.getModel());
        JMenuTest.assertNull((Object)itemObject.getImageDescriptor());
        JMenuTest.assertEquals((Object)menuInfo.getBounds(), (Object)itemObject.getBounds());
        JMenuTest.assertSame((Object)MenuObjectInfoUtils.getMenuInfo((Object)menuInfo), (Object)itemObject.getMenu());
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        JMenuTest.assertSame((Object)menuObject, (Object)menuObject.getModel());
        JMenuTest.assertNotNull((Object)menuObject.getImageDescriptor());
        JMenuTest.assertTrue((menuObject.getBounds().width > 50 ? 1 : 0) != 0);
        JMenuTest.assertTrue((menuObject.getBounds().height > 30 ? 1 : 0) != 0);
        JMenuTest.assertFalse((boolean)menuObject.isHorizontal());
        List items = menuObject.getItems();
        JMenuTest.assertSame((Object)itemInfo_1, (Object)((IMenuItemInfo)items.get(0)).getModel());
        JMenuTest.assertSame((Object)itemInfo_2, (Object)((IMenuItemInfo)items.get(1)).getModel());
        JMenuTest.assertSame((Object)itemObject.getPolicy(), (Object)menuObject.getPolicy());
    }

    @Test
    public void test_IMenuInfo_withSeparator() throws Exception {
        ContainerInfo frameInfo = this.parseContainer(JMenuTest.getDoubleQuotes(new String[]{"public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem item_1 = new JMenuItem('Item 1');", "        menu.add(item_1);", "      }", "      {", "        JSeparator separator = new JSeparator();", "        menu.add(separator);", "      }", "    }", "  }", "}"}));
        frameInfo.refresh();
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menuInfo = (JMenuInfo)menuBarInfo.getChildrenMenus().get(0);
        JMenuItemInfo itemInfo_1 = (JMenuItemInfo)menuInfo.getChildrenComponents().get(0);
        ComponentInfo separatorInfo = (ComponentInfo)menuInfo.getChildrenComponents().get(1);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        JMenuTest.assertSame((Object)menuObject, (Object)menuObject.getModel());
        JMenuTest.assertNotNull((Object)menuObject.getImageDescriptor());
        Rectangle bounds = menuObject.getBounds();
        Assertions.assertThat((bounds.width > 50 ? 1 : 0) != 0);
        Assertions.assertThat((bounds.height > 30 ? 1 : 0) != 0);
        JMenuTest.assertFalse((boolean)menuObject.isHorizontal());
        List items = menuObject.getItems();
        Assertions.assertThat((List)items).hasSize(2);
        IMenuItemInfo itemObject = (IMenuItemInfo)items.get(0);
        JMenuTest.assertSame((Object)itemInfo_1, (Object)itemObject.getModel());
        Rectangle bounds2 = itemObject.getBounds();
        Assertions.assertThat((int)bounds2.x).isLessThan(5);
        Assertions.assertThat((int)bounds2.y).isLessThan(5);
        Assertions.assertThat((int)bounds2.width).isGreaterThan(50);
        Assertions.assertThat((int)bounds2.height).isGreaterThan(18);
        itemObject = (IMenuItemInfo)items.get(1);
        JMenuTest.assertSame((Object)separatorInfo, (Object)itemObject.getModel());
        bounds2 = itemObject.getBounds();
        Assertions.assertThat((int)bounds2.x).isGreaterThanOrEqualTo(0).isLessThan(5);
        Assertions.assertThat((int)bounds2.width).isGreaterThan(50);
        Assertions.assertThat((int)bounds2.height).isGreaterThan(0).isLessThan(5);
    }

    @Test
    public void test_IMenuInfo_CREATE_noObject() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "    }", "  }", "}");
        frameInfo.refresh();
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menuInfo = (JMenuInfo)menuBarInfo.getChildrenMenus().get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JMenuTest.assertEquals((int)0, (int)menuObject.getItems().size());
        Object newObject = JMenuTest.createJavaInfo("java.lang.Object");
        JMenuTest.assertFalse((boolean)policy.validateCreate(newObject));
        Object newPopup = JMenuTest.createJavaInfo("javax.swing.JPopupMenu");
        JMenuTest.assertFalse((boolean)policy.validateCreate(newPopup));
    }

    @Test
    public void test_IMenuInfo_CREATE() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "    }", "  }", "}");
        frameInfo.refresh();
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menuInfo = (JMenuInfo)menuBarInfo.getChildrenMenus().get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JMenuTest.assertEquals((int)0, (int)menuObject.getItems().size());
        JMenuItemInfo newItemInfo = (JMenuItemInfo)JMenuTest.createComponent(JMenuItem.class);
        JMenuTest.assertTrue((boolean)policy.validateCreate((Object)newItemInfo));
        policy.commandCreate((Object)newItemInfo, null);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem menuItem = new JMenuItem('New menu item');", "        menu.add(menuItem);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_CREATE_component() throws Exception {
        this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "    }", "  }", "}");
        this.refresh();
        JMenuInfo menuInfo = (JMenuInfo)JMenuTest.getJavaInfoByName("menu");
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JMenuTest.assertEquals((int)0, (int)menuObject.getItems().size());
        ComponentInfo newComponent = JMenuTest.createJButton();
        JMenuTest.assertTrue((boolean)policy.validateCreate((Object)newComponent));
        policy.commandCreate((Object)newComponent, null);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JButton button = new JButton();", "        menu.add(button);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_MOVE() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem item_1 = new JMenuItem('Item 1');", "        menu.add(item_1);", "      }", "      {", "        JMenuItem item_2 = new JMenuItem('Item 2');", "        menu.add(item_2);", "      }", "    }", "  }", "}");
        frameInfo.refresh();
        JMenuInfo menuInfo = (JMenuInfo)JMenuTest.getJavaInfoByName("menu");
        JMenuItemInfo itemInfo_1 = (JMenuItemInfo)JMenuTest.getJavaInfoByName("item_1");
        JMenuItemInfo itemInfo_2 = (JMenuItemInfo)JMenuTest.getJavaInfoByName("item_2");
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JMenuTest.assertFalse((boolean)policy.validateMove((Object)frameInfo));
        IMenuItemInfo menuItemObject = MenuObjectInfoUtils.getMenuItemInfo((Object)menuInfo);
        Object menuItemObject_model = menuItemObject.getToolkitModel();
        JMenuTest.assertSame((Object)menuInfo, (Object)menuItemObject_model);
        JMenuTest.assertFalse((boolean)policy.validateMove(menuItemObject_model));
        JMenuTest.assertTrue((boolean)policy.validateMove((Object)itemInfo_2));
        policy.commandMove((Object)itemInfo_2, (Object)itemInfo_1);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem item_2 = new JMenuItem('Item 2');", "        menu.add(item_2);", "      }", "      {", "        JMenuItem item_1 = new JMenuItem('Item 1');", "        menu.add(item_1);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_PASTE() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem existingItem = new JMenuItem('Some item');", "        menu.add(existingItem);", "      }", "    }", "  }", "}");
        frameInfo.refresh();
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menuInfo = (JMenuInfo)menuBarInfo.getChildrenMenus().get(0);
        JMenuItemInfo existingItemInfo = (JMenuItemInfo)menuInfo.getChildrenItems().get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)existingItemInfo);
        List<JavaInfoMemento> mementos = List.of(memento);
        JMenuTest.assertTrue((boolean)policy.validatePaste(mementos));
        policy.commandPaste(mementos, null);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem existingItem = new JMenuItem('Some item');", "        menu.add(existingItem);", "      }", "      {", "        JMenuItem existingItem = new JMenuItem('Some item');", "        menu.add(existingItem);", "      }", "    }", "  }", "}");
    }

    private void createExternalAction() throws Exception {
        JMenuTest.setFileContentSrc("test/ExternalAction.java", this.getTestSource("public class ExternalAction extends AbstractAction {", "  public ExternalAction() {", "    putValue(NAME, 'My name');", "    putValue(SHORT_DESCRIPTION, 'My short description');", "  }", "  public void actionPerformed(ActionEvent e) {", "  }", "}"));
        JMenuTest.waitForAutoBuild();
    }

    @Test
    public void test_addAction_parse() throws Exception {
        this.createExternalAction();
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem menuItem = menu.add(action);", "      }", "    }", "  }", "}");
        frameInfo.refresh();
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menuInfo = (JMenuInfo)menuBarInfo.getChildrenMenus().get(0);
        JMenuItemInfo itemInfo = (JMenuItemInfo)menuInfo.getChildrenItems().get(0);
        ImplicitFactoryCreationSupport creationSupport = (ImplicitFactoryCreationSupport)itemInfo.getCreationSupport();
        JMenuTest.assertEquals((Object)"menu.add(action)", (Object)this.m_lastEditor.getSource(creationSupport.getNode()));
        JMenuTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)itemInfo.getVariableSupport());
        JMenuTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)itemInfo.getAssociation());
    }

    @Test
    public void test_IMenuInfo_CREATE_existingAction() throws Exception {
        this.createExternalAction();
        String[] lines = new String[]{"public class Test extends JFrame {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "    }", "  }", "}"};
        ContainerInfo frameInfo = this.parseContainer(lines);
        frameInfo.refresh();
        ActionInfo action = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)frameInfo).get(0);
        this.test_IMenuInfo_CREATE_forAction(frameInfo, action, new String[]{"public class Test extends JFrame {", "  private ExternalAction action = new ExternalAction();", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem menuItem = menu.add(action);", "      }", "    }", "  }", "}"});
    }

    @Test
    public void test_IMenuInfo_CREATE_newAction() throws Exception {
        this.createExternalAction();
        String[] lines = new String[]{"public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "    }", "  }", "}"};
        ContainerInfo frameInfo = this.parseContainer(lines);
        frameInfo.refresh();
        ActionInfo action = (ActionInfo)JMenuTest.createJavaInfo("test.ExternalAction");
        this.test_IMenuInfo_CREATE_forAction(frameInfo, action, new String[]{"public class Test extends JFrame {", "  private final ExternalAction externalAction = new ExternalAction();", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem menuItem = menu.add(externalAction);", "      }", "    }", "  }", "}"});
    }

    @Test
    public void test_IMenuInfo_CREATE_newAction_lazy() throws Exception {
        this.createExternalAction();
        String[] lines1 = new String[]{"public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu();", "      menuBar.add(menu);", "    }", "  }", "}"};
        ContainerInfo frameInfo = this.parseContainer(lines1);
        frameInfo.refresh();
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        ActionInfo action = (ActionInfo)JMenuTest.createJavaInfo("test.ExternalAction");
        JMenuItemInfo newItem = this.test_IMenuInfo_CREATE_forAction0(frameInfo, action, new String[]{"public class Test extends JFrame {", "  private ExternalAction externalAction;", "  private JMenuItem menuItem;", "  private JMenu menu;", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      menu = new JMenu();", "      menuBar.add(menu);", "      getMenuItem();", "    }", "  }", "  private ExternalAction getExternalAction() {", "    if (externalAction == null) {", "      externalAction = new ExternalAction();", "    }", "    return externalAction;", "  }", "  private JMenuItem getMenuItem() {", "    if (menuItem == null) {", "      menuItem = menu.add(getExternalAction());", "    }", "    return menuItem;", "  }", "}"});
        JMenuTest.assertTrue((boolean)newItem.canDelete());
        newItem.delete();
        String[] lines = new String[]{"public class Test extends JFrame {", "  private ExternalAction externalAction;", "  private JMenu menu;", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      menu = new JMenu();", "      menuBar.add(menu);", "    }", "  }", "  private ExternalAction getExternalAction() {", "    if (externalAction == null) {", "      externalAction = new ExternalAction();", "    }", "    return externalAction;", "  }", "}"};
        this.assertEditor(lines);
    }

    @Test
    public void test_IMenuInfo_CREATE_newAction_lazy2() throws Exception {
        this.createExternalAction();
        String[] lines1 = new String[]{"public class Test extends JFrame {", "  private JMenu menu;", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    menuBar.add(getMenu());", "  }", "  private JMenu getMenu() {", "    if (menu == null) {", "      menu = new JMenu();", "    }", "    return menu;", "  }", "}"};
        ContainerInfo frameInfo = this.parseContainer(lines1);
        frameInfo.refresh();
        SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
        ActionInfo action = (ActionInfo)JMenuTest.createJavaInfo("test.ExternalAction");
        JMenuItemInfo newItem = this.test_IMenuInfo_CREATE_forAction0(frameInfo, action, new String[]{"public class Test extends JFrame {", "  private JMenu menu;", "  private ExternalAction externalAction;", "  private JMenuItem menuItem;", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    menuBar.add(getMenu());", "  }", "  private JMenu getMenu() {", "    if (menu == null) {", "      menu = new JMenu();", "      getMenuItem();", "    }", "    return menu;", "  }", "  private ExternalAction getExternalAction() {", "    if (externalAction == null) {", "      externalAction = new ExternalAction();", "    }", "    return externalAction;", "  }", "  private JMenuItem getMenuItem() {", "    if (menuItem == null) {", "      menuItem = getMenu().add(getExternalAction());", "    }", "    return menuItem;", "  }", "}"});
        JMenuTest.assertTrue((boolean)newItem.canDelete());
        newItem.delete();
        String[] lines = new String[]{"public class Test extends JFrame {", "  private JMenu menu;", "  private ExternalAction externalAction;", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    menuBar.add(getMenu());", "  }", "  private JMenu getMenu() {", "    if (menu == null) {", "      menu = new JMenu();", "    }", "    return menu;", "  }", "  private ExternalAction getExternalAction() {", "    if (externalAction == null) {", "      externalAction = new ExternalAction();", "    }", "    return externalAction;", "  }", "}"};
        this.assertEditor(lines);
    }

    @Test
    public void test_IMenuInfo_CREATE_newAction_lazy3() throws Exception {
        this.createExternalAction();
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  private JMenu menu;", "  private final ExternalAction externalAction = new ExternalAction();", "  private JMenuItem menuItem;", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    menuBar.add(getMenu());", "  }", "  private JMenu getMenu() {", "    if (menu == null) {", "      menu = new JMenu('Menu');", "      getMenuItem();", "    }", "    return menu;", "  }", "  private JMenuItem getMenuItem() {", "    if (menuItem == null) {", "      menuItem = getMenu().add(externalAction);", "    }", "    return menuItem;", "  }", "}");
        JMenuTest.assertHierarchy("{this: javax.swing.JFrame} {this} {/setJMenuBar(menuBar)/}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {new: javax.swing.JMenuBar} {local-unique: menuBar} {/new JMenuBar()/ /setJMenuBar(menuBar)/ /menuBar.add(getMenu())/}", "    {new: javax.swing.JMenu} {lazy: menu getMenu()} {/new JMenu('Menu')/ /getMenu().add(externalAction)/ /menu/ /menuBar.add(getMenu())/}", "      {implicit-factory} {lazy: menuItem getMenuItem()} {/getMenu().add(externalAction)/ /menuItem/ /getMenuItem()/}", "  {org.eclipse.wb.internal.swing.model.bean.ActionContainerInfo}", "    {new: test.ExternalAction} {field-initializer: externalAction} {/new ExternalAction()/ /getMenu().add(externalAction)/}");
        frameInfo.refresh();
        JavaInfo menuBar = (JavaInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        JavaInfo menu = (JavaInfo)menuBar.getChildrenJava().get(0);
        JMenuItemInfo item = (JMenuItemInfo)menu.getChildrenJava().get(0);
        JMenuTest.assertTrue((boolean)item.canDelete());
        item.delete();
        this.assertEditor("public class Test extends JFrame {", "  private JMenu menu;", "  private final ExternalAction externalAction = new ExternalAction();", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    menuBar.add(getMenu());", "  }", "  private JMenu getMenu() {", "    if (menu == null) {", "      menu = new JMenu('Menu');", "    }", "    return menu;", "  }", "}");
    }

    private void test_IMenuInfo_CREATE_forAction(ContainerInfo frameInfo, ActionInfo action, String[] expectedLines) throws Exception {
        JMenuItemInfo itemInfo = this.test_IMenuInfo_CREATE_forAction0(frameInfo, action, expectedLines);
        JMenuTest.assertInstanceOf(ImplicitFactoryCreationSupport.class, (Object)itemInfo.getCreationSupport());
        JMenuTest.assertInstanceOf(LocalUniqueVariableSupport.class, (Object)itemInfo.getVariableSupport());
        JMenuTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)itemInfo.getAssociation());
        IMenuItemInfo itemObject = MenuObjectInfoUtils.getMenuItemInfo((Object)itemInfo);
        JMenuTest.assertTrue((boolean)itemObject.canMove());
        JMenuTest.assertFalse((boolean)itemObject.canReparent());
    }

    private JMenuItemInfo test_IMenuInfo_CREATE_forAction0(ContainerInfo frameInfo, ActionInfo action, String[] expectedLines) throws Exception {
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menuInfo = (JMenuInfo)menuBarInfo.getChildrenMenus().get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JMenuTest.assertEquals((int)0, (int)menuObject.getItems().size());
        JMenuTest.assertTrue((boolean)policy.validateCreate((Object)action));
        policy.commandCreate((Object)action, null);
        this.assertEditor(expectedLines);
        return (JMenuItemInfo)menuInfo.getChildrenItems().get(0);
    }

    @Test
    public void test_separatorParse_addSeparator() throws Exception {
        this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      menu.addSeparator();", "    }", "  }", "}");
        JMenuTest.assertHierarchy("{this: javax.swing.JFrame} {this} {/setJMenuBar(menuBar)/}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {new: javax.swing.JMenuBar} {local-unique: menuBar} {/new JMenuBar()/ /setJMenuBar(menuBar)/ /menuBar.add(menu)/}", "    {new: javax.swing.JMenu} {local-unique: menu} {/new JMenu('Menu')/ /menuBar.add(menu)/ /menu.addSeparator()/}", "      {void} {void} {/menu.addSeparator()/}");
        this.refresh();
        JMenuInfo menu = (JMenuInfo)JMenuTest.getJavaInfoByName("menu");
        JPopupMenuSeparatorInfo separator = (JPopupMenuSeparatorInfo)menu.getChildren(JPopupMenuSeparatorInfo.class).get(0);
        JMenuTest.assertInstanceOf(JPopupMenu.Separator.class, (Object)separator.getObject());
        VariableSupport variable = separator.getVariableSupport();
        JMenuTest.assertInstanceOf(VoidInvocationVariableSupport.class, (Object)variable);
        JMenuSeparatorCreationSupport creation = (JMenuSeparatorCreationSupport)separator.getCreationSupport();
        JMenuTest.assertEquals((Object)"void", (Object)creation.toString());
        JMenuTest.assertSame((Object)((InvocationVoidAssociation)separator.getAssociation()).getInvocation(), (Object)creation.getNode());
        JMenuTest.assertTrue((boolean)creation.canReorder());
        JMenuTest.assertFalse((boolean)creation.canReparent());
        JMenuTest.assertTrue((boolean)creation.canDelete());
        JMenuTest.assertInstanceOf(InvocationVoidAssociation.class, (Object)separator.getAssociation());
    }

    @Test
    public void test_separatorParse_newSeparator() throws Exception {
        this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JPopupMenu.Separator separator = new JPopupMenu.Separator();", "        menu.add(separator);", "      }", "    }", "  }", "}");
        JMenuTest.assertHierarchy("{this: javax.swing.JFrame} {this} {/setJMenuBar(menuBar)/}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {new: javax.swing.JMenuBar} {local-unique: menuBar} {/new JMenuBar()/ /setJMenuBar(menuBar)/ /menuBar.add(menu)/}", "    {new: javax.swing.JMenu} {local-unique: menu} {/new JMenu('Menu')/ /menuBar.add(menu)/ /menu.add(separator)/}", "      {new: javax.swing.JPopupMenu$Separator} {local-unique: separator} {/new JPopupMenu.Separator()/ /menu.add(separator)/}");
        this.refresh();
    }

    @Test
    public void test_separator_CREATE() throws Exception {
        this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "    }", "  }", "}");
        this.refresh();
        JMenuInfo menuInfo = (JMenuInfo)JMenuTest.getJavaInfoByName("menu");
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JMenuSeparatorCreationSupport creationSupport = new JMenuSeparatorCreationSupport((JavaInfo)menuInfo);
        JPopupMenuSeparatorInfo separator = (JPopupMenuSeparatorInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, JPopupMenu.Separator.class, (CreationSupport)creationSupport);
        JMenuTest.assertTrue((boolean)policy.validateCreate((Object)separator));
        policy.commandCreate((Object)separator, null);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      menu.addSeparator();", "    }", "  }", "}");
    }

    @Test
    public void test_visualInheritance() throws Exception {
        this.createModelType("test", "MyFrame.java", this.getTestSource("public class MyFrame extends JFrame {", "  private final JMenuBar m_menuBar = new JMenuBar();", "  private final JMenu m_menu = new JMenu();", "  private final JMenuItem m_menuItem = new JMenuItem();", "  public MyFrame() {", "    setJMenuBar(m_menuBar);", "    m_menuBar.add(m_menu);", "    m_menu.add(m_menuItem);", "  }", "  public JMenuBar getMyMenuBar() {", "    return m_menuBar;", "  }", "  public JMenu getMyMenu() {", "    return m_menu;", "  }", "  public JMenuItem getMyMenuItem() {", "    return m_menuItem;", "  }", "}"));
        JMenuTest.waitForAutoBuild();
        this.parseContainer("// filler filler filler", "public class Test extends MyFrame {", "  public Test() {", "  }", "}");
        JMenuTest.assertHierarchy("{this: test.MyFrame} {this} {}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {method: public javax.swing.JMenuBar test.MyFrame.getMyMenuBar()} {property} {}", "    {method: public javax.swing.JMenu test.MyFrame.getMyMenu()} {property} {}", "      {method: public javax.swing.JMenuItem test.MyFrame.getMyMenuItem()} {property} {}");
    }
}

