/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class LayoutLayoutDataCompatibilityTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_compatible() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData());", "    }", "  }", "}");
        LayoutLayoutDataCompatibilityTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new GridLayout())/ /new Button(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.GridLayout} {empty} {/setLayout(new GridLayout())/}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(this, SWT.NONE)/ /button.setLayoutData(new GridData())/}", "    {new: org.eclipse.swt.layout.GridData} {empty} {/button.setLayoutData(new GridData())/}");
        shell.refresh();
        LayoutLayoutDataCompatibilityTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_noData() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        LayoutLayoutDataCompatibilityTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/setLayout(new FillLayout())/ /new Button(this, SWT.NONE)/}", "  {new: org.eclipse.swt.layout.FillLayout} {empty} {/setLayout(new FillLayout())/}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(this, SWT.NONE)/}");
        shell.refresh();
        LayoutLayoutDataCompatibilityTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_notCompatible() throws Exception {
        try {
            this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new RowData());", "    }", "  }", "}");
            LayoutLayoutDataCompatibilityTest.fail();
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            LayoutLayoutDataCompatibilityTest.assertEquals((int)2003, (int)de.getCode());
        }
    }

    @Test
    public void test_FillLayout_generatedFillData() throws Exception {
        LayoutLayoutDataCompatibilityTest.setFileContentSrc("test/MyShell.java", this.getTestSource("public class MyShell extends Shell {", "  public MyShell() {", "    setLayout(new FillLayout());", "  }", "  protected void setDoComputeSize(boolean b) {", "    computeSize(-1, -1); // force FillData assignment", "  }", "  protected void checkSubclass() {", "  }", "}"));
        LayoutLayoutDataCompatibilityTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends MyShell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "    setDoComputeSize(true);", "  }", "}");
        LayoutLayoutDataCompatibilityTest.assertHierarchy("{this: test.MyShell} {this} {/new Button(this, SWT.NONE)/ /setDoComputeSize(true)/}", "  {implicit-layout: org.eclipse.swt.layout.FillLayout} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Button} {local-unique: button} {/new Button(this, SWT.NONE)/}");
        shell.refresh();
        LayoutLayoutDataCompatibilityTest.assertNoErrors((JavaInfo)shell);
    }
}

