#-
# Copyright (c) 2015 Oleksandr Tymoshenko <gonzo@freebsd.org>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $FreeBSD: stable/11/sys/arm/arm/hdmi_if.m 296064 2016-02-25 20:17:18Z jmcneill $
#

#include <sys/bus.h>
#include <dev/videomode/videomode.h>
#include <dev/videomode/edidvar.h>

INTERFACE hdmi;

HEADER {
	#include <sys/eventhandler.h>

	typedef void (*hdmi_event_hook)(void *, device_t, int);
	EVENTHANDLER_DECLARE(hdmi_event, hdmi_event_hook);

	#define HDMI_EVENT_CONNECTED	0
}

#
# Get EDID info
#
METHOD int get_edid {
	device_t dev;
	uint8_t **edid;
	uint32_t *edid_length;
};

#
# Set videomode
#
METHOD int set_videomode {
	device_t dev;
	const struct videomode *videomode;
};

#
# Enable/disable output
#
METHOD int enable {
	device_t dev;
	int onoff;
};
