/*	$NetBSD: ptrace.S,v 1.7 2003/08/07 16:42:04 agc Exp $ */

/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)ptrace.s	5.1 (Berkeley) 4/23/90
 */

#include <machine/asm.h>
__FBSDID("$FreeBSD: stable/6/lib/libc/arm/sys/ptrace.S 137464 2004-11-09 16:49:14Z cognet $");
#include "SYS.h"

ENTRY(ptrace)
#ifdef _REENTRANT
	stmfd	sp!, {r0-r3, lr}
	sub	sp, sp, #4	/* align stack */
	bl	PIC_SYM(_C_LABEL(__errno), PLT)
	add	sp, sp, #4	/* unalign stack */
	mov	r1, #0x00000000
	str	r1, [r0]
	ldmfd	sp!, {r0-r3, lr}
#else
	stmfd	sp!, {r0, r1}
#ifdef PIC
	/* Setup the GOT */
	ldr	r0, .Lgot
	add	r0, pc, r0
.L1:
	ldr	r1, .Lerrno
	ldr	r1, [r0, r1]
#else
	ldr	r1, .Lerrno
#endif /* PIC */
	mov	r0, #0x00000000
	str	r0, [r1]
	ldmfd	sp!, {r0, r1}
#endif /* _REENTRANT */

	SYSTRAP(ptrace)
	bcs	PIC_SYM(CERROR, PLT)
	RET

#ifndef _REENTRANT
#ifdef PIC
	.align	0
.Lgot:
	.word	_C_LABEL(_GLOBAL_OFFSET_TABLE_) + (. - (.L1+4))
#endif /* PIC */

.Lerrno:
	.word	PIC_SYM(_C_LABEL(errno), GOT)
#endif /* !_REENTRANT */
