/*
 * nghttp3
 *
 * Copyright (c) 2019 nghttp3 contributors
 * Copyright (c) 2013 nghttp2 contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "nghttp3_qpack_huffman.h"

/* Generated by mkhufftbl.py */

const nghttp3_qpack_huffman_sym huffman_sym_table[] = {
  {13, 0xffc00000u}, {23, 0xffffb000u}, {28, 0xfffffe20u}, {28, 0xfffffe30u},
  {28, 0xfffffe40u}, {28, 0xfffffe50u}, {28, 0xfffffe60u}, {28, 0xfffffe70u},
  {28, 0xfffffe80u}, {24, 0xffffea00u}, {30, 0xfffffff0u}, {28, 0xfffffe90u},
  {28, 0xfffffea0u}, {30, 0xfffffff4u}, {28, 0xfffffeb0u}, {28, 0xfffffec0u},
  {28, 0xfffffed0u}, {28, 0xfffffee0u}, {28, 0xfffffef0u}, {28, 0xffffff00u},
  {28, 0xffffff10u}, {28, 0xffffff20u}, {30, 0xfffffff8u}, {28, 0xffffff30u},
  {28, 0xffffff40u}, {28, 0xffffff50u}, {28, 0xffffff60u}, {28, 0xffffff70u},
  {28, 0xffffff80u}, {28, 0xffffff90u}, {28, 0xffffffa0u}, {28, 0xffffffb0u},
  {6, 0x50000000u},  {10, 0xfe000000u}, {10, 0xfe400000u}, {12, 0xffa00000u},
  {13, 0xffc80000u}, {6, 0x54000000u},  {8, 0xf8000000u},  {11, 0xff400000u},
  {10, 0xfe800000u}, {10, 0xfec00000u}, {8, 0xf9000000u},  {11, 0xff600000u},
  {8, 0xfa000000u},  {6, 0x58000000u},  {6, 0x5c000000u},  {6, 0x60000000u},
  {5, 0x0u},         {5, 0x8000000u},   {5, 0x10000000u},  {6, 0x64000000u},
  {6, 0x68000000u},  {6, 0x6c000000u},  {6, 0x70000000u},  {6, 0x74000000u},
  {6, 0x78000000u},  {6, 0x7c000000u},  {7, 0xb8000000u},  {8, 0xfb000000u},
  {15, 0xfff80000u}, {6, 0x80000000u},  {12, 0xffb00000u}, {10, 0xff000000u},
  {13, 0xffd00000u}, {6, 0x84000000u},  {7, 0xba000000u},  {7, 0xbc000000u},
  {7, 0xbe000000u},  {7, 0xc0000000u},  {7, 0xc2000000u},  {7, 0xc4000000u},
  {7, 0xc6000000u},  {7, 0xc8000000u},  {7, 0xca000000u},  {7, 0xcc000000u},
  {7, 0xce000000u},  {7, 0xd0000000u},  {7, 0xd2000000u},  {7, 0xd4000000u},
  {7, 0xd6000000u},  {7, 0xd8000000u},  {7, 0xda000000u},  {7, 0xdc000000u},
  {7, 0xde000000u},  {7, 0xe0000000u},  {7, 0xe2000000u},  {7, 0xe4000000u},
  {8, 0xfc000000u},  {7, 0xe6000000u},  {8, 0xfd000000u},  {13, 0xffd80000u},
  {19, 0xfffe0000u}, {13, 0xffe00000u}, {14, 0xfff00000u}, {6, 0x88000000u},
  {15, 0xfffa0000u}, {5, 0x18000000u},  {6, 0x8c000000u},  {5, 0x20000000u},
  {6, 0x90000000u},  {5, 0x28000000u},  {6, 0x94000000u},  {6, 0x98000000u},
  {6, 0x9c000000u},  {5, 0x30000000u},  {7, 0xe8000000u},  {7, 0xea000000u},
  {6, 0xa0000000u},  {6, 0xa4000000u},  {6, 0xa8000000u},  {5, 0x38000000u},
  {6, 0xac000000u},  {7, 0xec000000u},  {6, 0xb0000000u},  {5, 0x40000000u},
  {5, 0x48000000u},  {6, 0xb4000000u},  {7, 0xee000000u},  {7, 0xf0000000u},
  {7, 0xf2000000u},  {7, 0xf4000000u},  {7, 0xf6000000u},  {15, 0xfffc0000u},
  {11, 0xff800000u}, {14, 0xfff40000u}, {13, 0xffe80000u}, {28, 0xffffffc0u},
  {20, 0xfffe6000u}, {22, 0xffff4800u}, {20, 0xfffe7000u}, {20, 0xfffe8000u},
  {22, 0xffff4c00u}, {22, 0xffff5000u}, {22, 0xffff5400u}, {23, 0xffffb200u},
  {22, 0xffff5800u}, {23, 0xffffb400u}, {23, 0xffffb600u}, {23, 0xffffb800u},
  {23, 0xffffba00u}, {23, 0xffffbc00u}, {24, 0xffffeb00u}, {23, 0xffffbe00u},
  {24, 0xffffec00u}, {24, 0xffffed00u}, {22, 0xffff5c00u}, {23, 0xffffc000u},
  {24, 0xffffee00u}, {23, 0xffffc200u}, {23, 0xffffc400u}, {23, 0xffffc600u},
  {23, 0xffffc800u}, {21, 0xfffee000u}, {22, 0xffff6000u}, {23, 0xffffca00u},
  {22, 0xffff6400u}, {23, 0xffffcc00u}, {23, 0xffffce00u}, {24, 0xffffef00u},
  {22, 0xffff6800u}, {21, 0xfffee800u}, {20, 0xfffe9000u}, {22, 0xffff6c00u},
  {22, 0xffff7000u}, {23, 0xffffd000u}, {23, 0xffffd200u}, {21, 0xfffef000u},
  {23, 0xffffd400u}, {22, 0xffff7400u}, {22, 0xffff7800u}, {24, 0xfffff000u},
  {21, 0xfffef800u}, {22, 0xffff7c00u}, {23, 0xffffd600u}, {23, 0xffffd800u},
  {21, 0xffff0000u}, {21, 0xffff0800u}, {22, 0xffff8000u}, {21, 0xffff1000u},
  {23, 0xffffda00u}, {22, 0xffff8400u}, {23, 0xffffdc00u}, {23, 0xffffde00u},
  {20, 0xfffea000u}, {22, 0xffff8800u}, {22, 0xffff8c00u}, {22, 0xffff9000u},
  {23, 0xffffe000u}, {22, 0xffff9400u}, {22, 0xffff9800u}, {23, 0xffffe200u},
  {26, 0xfffff800u}, {26, 0xfffff840u}, {20, 0xfffeb000u}, {19, 0xfffe2000u},
  {22, 0xffff9c00u}, {23, 0xffffe400u}, {22, 0xffffa000u}, {25, 0xfffff600u},
  {26, 0xfffff880u}, {26, 0xfffff8c0u}, {26, 0xfffff900u}, {27, 0xfffffbc0u},
  {27, 0xfffffbe0u}, {26, 0xfffff940u}, {24, 0xfffff100u}, {25, 0xfffff680u},
  {19, 0xfffe4000u}, {21, 0xffff1800u}, {26, 0xfffff980u}, {27, 0xfffffc00u},
  {27, 0xfffffc20u}, {26, 0xfffff9c0u}, {27, 0xfffffc40u}, {24, 0xfffff200u},
  {21, 0xffff2000u}, {21, 0xffff2800u}, {26, 0xfffffa00u}, {26, 0xfffffa40u},
  {28, 0xffffffd0u}, {27, 0xfffffc60u}, {27, 0xfffffc80u}, {27, 0xfffffca0u},
  {20, 0xfffec000u}, {24, 0xfffff300u}, {20, 0xfffed000u}, {21, 0xffff3000u},
  {22, 0xffffa400u}, {21, 0xffff3800u}, {21, 0xffff4000u}, {23, 0xffffe600u},
  {22, 0xffffa800u}, {22, 0xffffac00u}, {25, 0xfffff700u}, {25, 0xfffff780u},
  {24, 0xfffff400u}, {24, 0xfffff500u}, {26, 0xfffffa80u}, {23, 0xffffe800u},
  {26, 0xfffffac0u}, {27, 0xfffffcc0u}, {26, 0xfffffb00u}, {26, 0xfffffb40u},
  {27, 0xfffffce0u}, {27, 0xfffffd00u}, {27, 0xfffffd20u}, {27, 0xfffffd40u},
  {27, 0xfffffd60u}, {28, 0xffffffe0u}, {27, 0xfffffd80u}, {27, 0xfffffda0u},
  {27, 0xfffffdc0u}, {27, 0xfffffde0u}, {27, 0xfffffe00u}, {26, 0xfffffb80u},
  {30, 0xfffffffcu}};

const nghttp3_qpack_huffman_decode_node qpack_huffman_decode_table[][16] = {
  /* 0 */
  {
    {0x04, 0, 0},
    {0x05, 0, 0},
    {0x07, 0, 0},
    {0x08, 0, 0},
    {0x0b, 0, 0},
    {0x0c, 0, 0},
    {0x10, 0, 0},
    {0x13, 0, 0},
    {0x19, 0, 0},
    {0x1c, 0, 0},
    {0x20, 0, 0},
    {0x23, 0, 0},
    {0x2a, 0, 0},
    {0x31, 0, 0},
    {0x39, 0, 0},
    {0x40, 1, 0},
  },
  /* 1 */
  {
    {0x00, 3, 48},
    {0x00, 3, 49},
    {0x00, 3, 50},
    {0x00, 3, 97},
    {0x00, 3, 99},
    {0x00, 3, 101},
    {0x00, 3, 105},
    {0x00, 3, 111},
    {0x00, 3, 115},
    {0x00, 3, 116},
    {0x0d, 0, 0},
    {0x0e, 0, 0},
    {0x11, 0, 0},
    {0x12, 0, 0},
    {0x14, 0, 0},
    {0x15, 0, 0},
  },
  /* 2 */
  {
    {0x01, 2, 48},
    {0x16, 3, 48},
    {0x01, 2, 49},
    {0x16, 3, 49},
    {0x01, 2, 50},
    {0x16, 3, 50},
    {0x01, 2, 97},
    {0x16, 3, 97},
    {0x01, 2, 99},
    {0x16, 3, 99},
    {0x01, 2, 101},
    {0x16, 3, 101},
    {0x01, 2, 105},
    {0x16, 3, 105},
    {0x01, 2, 111},
    {0x16, 3, 111},
  },
  /* 3 */
  {
    {0x02, 2, 48},
    {0x09, 2, 48},
    {0x17, 2, 48},
    {0x28, 3, 48},
    {0x02, 2, 49},
    {0x09, 2, 49},
    {0x17, 2, 49},
    {0x28, 3, 49},
    {0x02, 2, 50},
    {0x09, 2, 50},
    {0x17, 2, 50},
    {0x28, 3, 50},
    {0x02, 2, 97},
    {0x09, 2, 97},
    {0x17, 2, 97},
    {0x28, 3, 97},
  },
  /* 4 */
  {
    {0x03, 2, 48},
    {0x06, 2, 48},
    {0x0a, 2, 48},
    {0x0f, 2, 48},
    {0x18, 2, 48},
    {0x1f, 2, 48},
    {0x29, 2, 48},
    {0x38, 3, 48},
    {0x03, 2, 49},
    {0x06, 2, 49},
    {0x0a, 2, 49},
    {0x0f, 2, 49},
    {0x18, 2, 49},
    {0x1f, 2, 49},
    {0x29, 2, 49},
    {0x38, 3, 49},
  },
  /* 5 */
  {
    {0x03, 2, 50},
    {0x06, 2, 50},
    {0x0a, 2, 50},
    {0x0f, 2, 50},
    {0x18, 2, 50},
    {0x1f, 2, 50},
    {0x29, 2, 50},
    {0x38, 3, 50},
    {0x03, 2, 97},
    {0x06, 2, 97},
    {0x0a, 2, 97},
    {0x0f, 2, 97},
    {0x18, 2, 97},
    {0x1f, 2, 97},
    {0x29, 2, 97},
    {0x38, 3, 97},
  },
  /* 6 */
  {
    {0x02, 2, 99},
    {0x09, 2, 99},
    {0x17, 2, 99},
    {0x28, 3, 99},
    {0x02, 2, 101},
    {0x09, 2, 101},
    {0x17, 2, 101},
    {0x28, 3, 101},
    {0x02, 2, 105},
    {0x09, 2, 105},
    {0x17, 2, 105},
    {0x28, 3, 105},
    {0x02, 2, 111},
    {0x09, 2, 111},
    {0x17, 2, 111},
    {0x28, 3, 111},
  },
  /* 7 */
  {
    {0x03, 2, 99},
    {0x06, 2, 99},
    {0x0a, 2, 99},
    {0x0f, 2, 99},
    {0x18, 2, 99},
    {0x1f, 2, 99},
    {0x29, 2, 99},
    {0x38, 3, 99},
    {0x03, 2, 101},
    {0x06, 2, 101},
    {0x0a, 2, 101},
    {0x0f, 2, 101},
    {0x18, 2, 101},
    {0x1f, 2, 101},
    {0x29, 2, 101},
    {0x38, 3, 101},
  },
  /* 8 */
  {
    {0x03, 2, 105},
    {0x06, 2, 105},
    {0x0a, 2, 105},
    {0x0f, 2, 105},
    {0x18, 2, 105},
    {0x1f, 2, 105},
    {0x29, 2, 105},
    {0x38, 3, 105},
    {0x03, 2, 111},
    {0x06, 2, 111},
    {0x0a, 2, 111},
    {0x0f, 2, 111},
    {0x18, 2, 111},
    {0x1f, 2, 111},
    {0x29, 2, 111},
    {0x38, 3, 111},
  },
  /* 9 */
  {
    {0x01, 2, 115},
    {0x16, 3, 115},
    {0x01, 2, 116},
    {0x16, 3, 116},
    {0x00, 3, 32},
    {0x00, 3, 37},
    {0x00, 3, 45},
    {0x00, 3, 46},
    {0x00, 3, 47},
    {0x00, 3, 51},
    {0x00, 3, 52},
    {0x00, 3, 53},
    {0x00, 3, 54},
    {0x00, 3, 55},
    {0x00, 3, 56},
    {0x00, 3, 57},
  },
  /* 10 */
  {
    {0x02, 2, 115},
    {0x09, 2, 115},
    {0x17, 2, 115},
    {0x28, 3, 115},
    {0x02, 2, 116},
    {0x09, 2, 116},
    {0x17, 2, 116},
    {0x28, 3, 116},
    {0x01, 2, 32},
    {0x16, 3, 32},
    {0x01, 2, 37},
    {0x16, 3, 37},
    {0x01, 2, 45},
    {0x16, 3, 45},
    {0x01, 2, 46},
    {0x16, 3, 46},
  },
  /* 11 */
  {
    {0x03, 2, 115},
    {0x06, 2, 115},
    {0x0a, 2, 115},
    {0x0f, 2, 115},
    {0x18, 2, 115},
    {0x1f, 2, 115},
    {0x29, 2, 115},
    {0x38, 3, 115},
    {0x03, 2, 116},
    {0x06, 2, 116},
    {0x0a, 2, 116},
    {0x0f, 2, 116},
    {0x18, 2, 116},
    {0x1f, 2, 116},
    {0x29, 2, 116},
    {0x38, 3, 116},
  },
  /* 12 */
  {
    {0x02, 2, 32},
    {0x09, 2, 32},
    {0x17, 2, 32},
    {0x28, 3, 32},
    {0x02, 2, 37},
    {0x09, 2, 37},
    {0x17, 2, 37},
    {0x28, 3, 37},
    {0x02, 2, 45},
    {0x09, 2, 45},
    {0x17, 2, 45},
    {0x28, 3, 45},
    {0x02, 2, 46},
    {0x09, 2, 46},
    {0x17, 2, 46},
    {0x28, 3, 46},
  },
  /* 13 */
  {
    {0x03, 2, 32},
    {0x06, 2, 32},
    {0x0a, 2, 32},
    {0x0f, 2, 32},
    {0x18, 2, 32},
    {0x1f, 2, 32},
    {0x29, 2, 32},
    {0x38, 3, 32},
    {0x03, 2, 37},
    {0x06, 2, 37},
    {0x0a, 2, 37},
    {0x0f, 2, 37},
    {0x18, 2, 37},
    {0x1f, 2, 37},
    {0x29, 2, 37},
    {0x38, 3, 37},
  },
  /* 14 */
  {
    {0x03, 2, 45},
    {0x06, 2, 45},
    {0x0a, 2, 45},
    {0x0f, 2, 45},
    {0x18, 2, 45},
    {0x1f, 2, 45},
    {0x29, 2, 45},
    {0x38, 3, 45},
    {0x03, 2, 46},
    {0x06, 2, 46},
    {0x0a, 2, 46},
    {0x0f, 2, 46},
    {0x18, 2, 46},
    {0x1f, 2, 46},
    {0x29, 2, 46},
    {0x38, 3, 46},
  },
  /* 15 */
  {
    {0x01, 2, 47},
    {0x16, 3, 47},
    {0x01, 2, 51},
    {0x16, 3, 51},
    {0x01, 2, 52},
    {0x16, 3, 52},
    {0x01, 2, 53},
    {0x16, 3, 53},
    {0x01, 2, 54},
    {0x16, 3, 54},
    {0x01, 2, 55},
    {0x16, 3, 55},
    {0x01, 2, 56},
    {0x16, 3, 56},
    {0x01, 2, 57},
    {0x16, 3, 57},
  },
  /* 16 */
  {
    {0x02, 2, 47},
    {0x09, 2, 47},
    {0x17, 2, 47},
    {0x28, 3, 47},
    {0x02, 2, 51},
    {0x09, 2, 51},
    {0x17, 2, 51},
    {0x28, 3, 51},
    {0x02, 2, 52},
    {0x09, 2, 52},
    {0x17, 2, 52},
    {0x28, 3, 52},
    {0x02, 2, 53},
    {0x09, 2, 53},
    {0x17, 2, 53},
    {0x28, 3, 53},
  },
  /* 17 */
  {
    {0x03, 2, 47},
    {0x06, 2, 47},
    {0x0a, 2, 47},
    {0x0f, 2, 47},
    {0x18, 2, 47},
    {0x1f, 2, 47},
    {0x29, 2, 47},
    {0x38, 3, 47},
    {0x03, 2, 51},
    {0x06, 2, 51},
    {0x0a, 2, 51},
    {0x0f, 2, 51},
    {0x18, 2, 51},
    {0x1f, 2, 51},
    {0x29, 2, 51},
    {0x38, 3, 51},
  },
  /* 18 */
  {
    {0x03, 2, 52},
    {0x06, 2, 52},
    {0x0a, 2, 52},
    {0x0f, 2, 52},
    {0x18, 2, 52},
    {0x1f, 2, 52},
    {0x29, 2, 52},
    {0x38, 3, 52},
    {0x03, 2, 53},
    {0x06, 2, 53},
    {0x0a, 2, 53},
    {0x0f, 2, 53},
    {0x18, 2, 53},
    {0x1f, 2, 53},
    {0x29, 2, 53},
    {0x38, 3, 53},
  },
  /* 19 */
  {
    {0x02, 2, 54},
    {0x09, 2, 54},
    {0x17, 2, 54},
    {0x28, 3, 54},
    {0x02, 2, 55},
    {0x09, 2, 55},
    {0x17, 2, 55},
    {0x28, 3, 55},
    {0x02, 2, 56},
    {0x09, 2, 56},
    {0x17, 2, 56},
    {0x28, 3, 56},
    {0x02, 2, 57},
    {0x09, 2, 57},
    {0x17, 2, 57},
    {0x28, 3, 57},
  },
  /* 20 */
  {
    {0x03, 2, 54},
    {0x06, 2, 54},
    {0x0a, 2, 54},
    {0x0f, 2, 54},
    {0x18, 2, 54},
    {0x1f, 2, 54},
    {0x29, 2, 54},
    {0x38, 3, 54},
    {0x03, 2, 55},
    {0x06, 2, 55},
    {0x0a, 2, 55},
    {0x0f, 2, 55},
    {0x18, 2, 55},
    {0x1f, 2, 55},
    {0x29, 2, 55},
    {0x38, 3, 55},
  },
  /* 21 */
  {
    {0x03, 2, 56},
    {0x06, 2, 56},
    {0x0a, 2, 56},
    {0x0f, 2, 56},
    {0x18, 2, 56},
    {0x1f, 2, 56},
    {0x29, 2, 56},
    {0x38, 3, 56},
    {0x03, 2, 57},
    {0x06, 2, 57},
    {0x0a, 2, 57},
    {0x0f, 2, 57},
    {0x18, 2, 57},
    {0x1f, 2, 57},
    {0x29, 2, 57},
    {0x38, 3, 57},
  },
  /* 22 */
  {
    {0x1a, 0, 0},
    {0x1b, 0, 0},
    {0x1d, 0, 0},
    {0x1e, 0, 0},
    {0x21, 0, 0},
    {0x22, 0, 0},
    {0x24, 0, 0},
    {0x25, 0, 0},
    {0x2b, 0, 0},
    {0x2e, 0, 0},
    {0x32, 0, 0},
    {0x35, 0, 0},
    {0x3a, 0, 0},
    {0x3d, 0, 0},
    {0x41, 0, 0},
    {0x44, 1, 0},
  },
  /* 23 */
  {
    {0x00, 3, 61},
    {0x00, 3, 65},
    {0x00, 3, 95},
    {0x00, 3, 98},
    {0x00, 3, 100},
    {0x00, 3, 102},
    {0x00, 3, 103},
    {0x00, 3, 104},
    {0x00, 3, 108},
    {0x00, 3, 109},
    {0x00, 3, 110},
    {0x00, 3, 112},
    {0x00, 3, 114},
    {0x00, 3, 117},
    {0x26, 0, 0},
    {0x27, 0, 0},
  },
  /* 24 */
  {
    {0x01, 2, 61},
    {0x16, 3, 61},
    {0x01, 2, 65},
    {0x16, 3, 65},
    {0x01, 2, 95},
    {0x16, 3, 95},
    {0x01, 2, 98},
    {0x16, 3, 98},
    {0x01, 2, 100},
    {0x16, 3, 100},
    {0x01, 2, 102},
    {0x16, 3, 102},
    {0x01, 2, 103},
    {0x16, 3, 103},
    {0x01, 2, 104},
    {0x16, 3, 104},
  },
  /* 25 */
  {
    {0x02, 2, 61},
    {0x09, 2, 61},
    {0x17, 2, 61},
    {0x28, 3, 61},
    {0x02, 2, 65},
    {0x09, 2, 65},
    {0x17, 2, 65},
    {0x28, 3, 65},
    {0x02, 2, 95},
    {0x09, 2, 95},
    {0x17, 2, 95},
    {0x28, 3, 95},
    {0x02, 2, 98},
    {0x09, 2, 98},
    {0x17, 2, 98},
    {0x28, 3, 98},
  },
  /* 26 */
  {
    {0x03, 2, 61},
    {0x06, 2, 61},
    {0x0a, 2, 61},
    {0x0f, 2, 61},
    {0x18, 2, 61},
    {0x1f, 2, 61},
    {0x29, 2, 61},
    {0x38, 3, 61},
    {0x03, 2, 65},
    {0x06, 2, 65},
    {0x0a, 2, 65},
    {0x0f, 2, 65},
    {0x18, 2, 65},
    {0x1f, 2, 65},
    {0x29, 2, 65},
    {0x38, 3, 65},
  },
  /* 27 */
  {
    {0x03, 2, 95},
    {0x06, 2, 95},
    {0x0a, 2, 95},
    {0x0f, 2, 95},
    {0x18, 2, 95},
    {0x1f, 2, 95},
    {0x29, 2, 95},
    {0x38, 3, 95},
    {0x03, 2, 98},
    {0x06, 2, 98},
    {0x0a, 2, 98},
    {0x0f, 2, 98},
    {0x18, 2, 98},
    {0x1f, 2, 98},
    {0x29, 2, 98},
    {0x38, 3, 98},
  },
  /* 28 */
  {
    {0x02, 2, 100},
    {0x09, 2, 100},
    {0x17, 2, 100},
    {0x28, 3, 100},
    {0x02, 2, 102},
    {0x09, 2, 102},
    {0x17, 2, 102},
    {0x28, 3, 102},
    {0x02, 2, 103},
    {0x09, 2, 103},
    {0x17, 2, 103},
    {0x28, 3, 103},
    {0x02, 2, 104},
    {0x09, 2, 104},
    {0x17, 2, 104},
    {0x28, 3, 104},
  },
  /* 29 */
  {
    {0x03, 2, 100},
    {0x06, 2, 100},
    {0x0a, 2, 100},
    {0x0f, 2, 100},
    {0x18, 2, 100},
    {0x1f, 2, 100},
    {0x29, 2, 100},
    {0x38, 3, 100},
    {0x03, 2, 102},
    {0x06, 2, 102},
    {0x0a, 2, 102},
    {0x0f, 2, 102},
    {0x18, 2, 102},
    {0x1f, 2, 102},
    {0x29, 2, 102},
    {0x38, 3, 102},
  },
  /* 30 */
  {
    {0x03, 2, 103},
    {0x06, 2, 103},
    {0x0a, 2, 103},
    {0x0f, 2, 103},
    {0x18, 2, 103},
    {0x1f, 2, 103},
    {0x29, 2, 103},
    {0x38, 3, 103},
    {0x03, 2, 104},
    {0x06, 2, 104},
    {0x0a, 2, 104},
    {0x0f, 2, 104},
    {0x18, 2, 104},
    {0x1f, 2, 104},
    {0x29, 2, 104},
    {0x38, 3, 104},
  },
  /* 31 */
  {
    {0x01, 2, 108},
    {0x16, 3, 108},
    {0x01, 2, 109},
    {0x16, 3, 109},
    {0x01, 2, 110},
    {0x16, 3, 110},
    {0x01, 2, 112},
    {0x16, 3, 112},
    {0x01, 2, 114},
    {0x16, 3, 114},
    {0x01, 2, 117},
    {0x16, 3, 117},
    {0x00, 3, 58},
    {0x00, 3, 66},
    {0x00, 3, 67},
    {0x00, 3, 68},
  },
  /* 32 */
  {
    {0x02, 2, 108},
    {0x09, 2, 108},
    {0x17, 2, 108},
    {0x28, 3, 108},
    {0x02, 2, 109},
    {0x09, 2, 109},
    {0x17, 2, 109},
    {0x28, 3, 109},
    {0x02, 2, 110},
    {0x09, 2, 110},
    {0x17, 2, 110},
    {0x28, 3, 110},
    {0x02, 2, 112},
    {0x09, 2, 112},
    {0x17, 2, 112},
    {0x28, 3, 112},
  },
  /* 33 */
  {
    {0x03, 2, 108},
    {0x06, 2, 108},
    {0x0a, 2, 108},
    {0x0f, 2, 108},
    {0x18, 2, 108},
    {0x1f, 2, 108},
    {0x29, 2, 108},
    {0x38, 3, 108},
    {0x03, 2, 109},
    {0x06, 2, 109},
    {0x0a, 2, 109},
    {0x0f, 2, 109},
    {0x18, 2, 109},
    {0x1f, 2, 109},
    {0x29, 2, 109},
    {0x38, 3, 109},
  },
  /* 34 */
  {
    {0x03, 2, 110},
    {0x06, 2, 110},
    {0x0a, 2, 110},
    {0x0f, 2, 110},
    {0x18, 2, 110},
    {0x1f, 2, 110},
    {0x29, 2, 110},
    {0x38, 3, 110},
    {0x03, 2, 112},
    {0x06, 2, 112},
    {0x0a, 2, 112},
    {0x0f, 2, 112},
    {0x18, 2, 112},
    {0x1f, 2, 112},
    {0x29, 2, 112},
    {0x38, 3, 112},
  },
  /* 35 */
  {
    {0x02, 2, 114},
    {0x09, 2, 114},
    {0x17, 2, 114},
    {0x28, 3, 114},
    {0x02, 2, 117},
    {0x09, 2, 117},
    {0x17, 2, 117},
    {0x28, 3, 117},
    {0x01, 2, 58},
    {0x16, 3, 58},
    {0x01, 2, 66},
    {0x16, 3, 66},
    {0x01, 2, 67},
    {0x16, 3, 67},
    {0x01, 2, 68},
    {0x16, 3, 68},
  },
  /* 36 */
  {
    {0x03, 2, 114},
    {0x06, 2, 114},
    {0x0a, 2, 114},
    {0x0f, 2, 114},
    {0x18, 2, 114},
    {0x1f, 2, 114},
    {0x29, 2, 114},
    {0x38, 3, 114},
    {0x03, 2, 117},
    {0x06, 2, 117},
    {0x0a, 2, 117},
    {0x0f, 2, 117},
    {0x18, 2, 117},
    {0x1f, 2, 117},
    {0x29, 2, 117},
    {0x38, 3, 117},
  },
  /* 37 */
  {
    {0x02, 2, 58},
    {0x09, 2, 58},
    {0x17, 2, 58},
    {0x28, 3, 58},
    {0x02, 2, 66},
    {0x09, 2, 66},
    {0x17, 2, 66},
    {0x28, 3, 66},
    {0x02, 2, 67},
    {0x09, 2, 67},
    {0x17, 2, 67},
    {0x28, 3, 67},
    {0x02, 2, 68},
    {0x09, 2, 68},
    {0x17, 2, 68},
    {0x28, 3, 68},
  },
  /* 38 */
  {
    {0x03, 2, 58},
    {0x06, 2, 58},
    {0x0a, 2, 58},
    {0x0f, 2, 58},
    {0x18, 2, 58},
    {0x1f, 2, 58},
    {0x29, 2, 58},
    {0x38, 3, 58},
    {0x03, 2, 66},
    {0x06, 2, 66},
    {0x0a, 2, 66},
    {0x0f, 2, 66},
    {0x18, 2, 66},
    {0x1f, 2, 66},
    {0x29, 2, 66},
    {0x38, 3, 66},
  },
  /* 39 */
  {
    {0x03, 2, 67},
    {0x06, 2, 67},
    {0x0a, 2, 67},
    {0x0f, 2, 67},
    {0x18, 2, 67},
    {0x1f, 2, 67},
    {0x29, 2, 67},
    {0x38, 3, 67},
    {0x03, 2, 68},
    {0x06, 2, 68},
    {0x0a, 2, 68},
    {0x0f, 2, 68},
    {0x18, 2, 68},
    {0x1f, 2, 68},
    {0x29, 2, 68},
    {0x38, 3, 68},
  },
  /* 40 */
  {
    {0x2c, 0, 0},
    {0x2d, 0, 0},
    {0x2f, 0, 0},
    {0x30, 0, 0},
    {0x33, 0, 0},
    {0x34, 0, 0},
    {0x36, 0, 0},
    {0x37, 0, 0},
    {0x3b, 0, 0},
    {0x3c, 0, 0},
    {0x3e, 0, 0},
    {0x3f, 0, 0},
    {0x42, 0, 0},
    {0x43, 0, 0},
    {0x45, 0, 0},
    {0x48, 1, 0},
  },
  /* 41 */
  {
    {0x00, 3, 69},
    {0x00, 3, 70},
    {0x00, 3, 71},
    {0x00, 3, 72},
    {0x00, 3, 73},
    {0x00, 3, 74},
    {0x00, 3, 75},
    {0x00, 3, 76},
    {0x00, 3, 77},
    {0x00, 3, 78},
    {0x00, 3, 79},
    {0x00, 3, 80},
    {0x00, 3, 81},
    {0x00, 3, 82},
    {0x00, 3, 83},
    {0x00, 3, 84},
  },
  /* 42 */
  {
    {0x01, 2, 69},
    {0x16, 3, 69},
    {0x01, 2, 70},
    {0x16, 3, 70},
    {0x01, 2, 71},
    {0x16, 3, 71},
    {0x01, 2, 72},
    {0x16, 3, 72},
    {0x01, 2, 73},
    {0x16, 3, 73},
    {0x01, 2, 74},
    {0x16, 3, 74},
    {0x01, 2, 75},
    {0x16, 3, 75},
    {0x01, 2, 76},
    {0x16, 3, 76},
  },
  /* 43 */
  {
    {0x02, 2, 69},
    {0x09, 2, 69},
    {0x17, 2, 69},
    {0x28, 3, 69},
    {0x02, 2, 70},
    {0x09, 2, 70},
    {0x17, 2, 70},
    {0x28, 3, 70},
    {0x02, 2, 71},
    {0x09, 2, 71},
    {0x17, 2, 71},
    {0x28, 3, 71},
    {0x02, 2, 72},
    {0x09, 2, 72},
    {0x17, 2, 72},
    {0x28, 3, 72},
  },
  /* 44 */
  {
    {0x03, 2, 69},
    {0x06, 2, 69},
    {0x0a, 2, 69},
    {0x0f, 2, 69},
    {0x18, 2, 69},
    {0x1f, 2, 69},
    {0x29, 2, 69},
    {0x38, 3, 69},
    {0x03, 2, 70},
    {0x06, 2, 70},
    {0x0a, 2, 70},
    {0x0f, 2, 70},
    {0x18, 2, 70},
    {0x1f, 2, 70},
    {0x29, 2, 70},
    {0x38, 3, 70},
  },
  /* 45 */
  {
    {0x03, 2, 71},
    {0x06, 2, 71},
    {0x0a, 2, 71},
    {0x0f, 2, 71},
    {0x18, 2, 71},
    {0x1f, 2, 71},
    {0x29, 2, 71},
    {0x38, 3, 71},
    {0x03, 2, 72},
    {0x06, 2, 72},
    {0x0a, 2, 72},
    {0x0f, 2, 72},
    {0x18, 2, 72},
    {0x1f, 2, 72},
    {0x29, 2, 72},
    {0x38, 3, 72},
  },
  /* 46 */
  {
    {0x02, 2, 73},
    {0x09, 2, 73},
    {0x17, 2, 73},
    {0x28, 3, 73},
    {0x02, 2, 74},
    {0x09, 2, 74},
    {0x17, 2, 74},
    {0x28, 3, 74},
    {0x02, 2, 75},
    {0x09, 2, 75},
    {0x17, 2, 75},
    {0x28, 3, 75},
    {0x02, 2, 76},
    {0x09, 2, 76},
    {0x17, 2, 76},
    {0x28, 3, 76},
  },
  /* 47 */
  {
    {0x03, 2, 73},
    {0x06, 2, 73},
    {0x0a, 2, 73},
    {0x0f, 2, 73},
    {0x18, 2, 73},
    {0x1f, 2, 73},
    {0x29, 2, 73},
    {0x38, 3, 73},
    {0x03, 2, 74},
    {0x06, 2, 74},
    {0x0a, 2, 74},
    {0x0f, 2, 74},
    {0x18, 2, 74},
    {0x1f, 2, 74},
    {0x29, 2, 74},
    {0x38, 3, 74},
  },
  /* 48 */
  {
    {0x03, 2, 75},
    {0x06, 2, 75},
    {0x0a, 2, 75},
    {0x0f, 2, 75},
    {0x18, 2, 75},
    {0x1f, 2, 75},
    {0x29, 2, 75},
    {0x38, 3, 75},
    {0x03, 2, 76},
    {0x06, 2, 76},
    {0x0a, 2, 76},
    {0x0f, 2, 76},
    {0x18, 2, 76},
    {0x1f, 2, 76},
    {0x29, 2, 76},
    {0x38, 3, 76},
  },
  /* 49 */
  {
    {0x01, 2, 77},
    {0x16, 3, 77},
    {0x01, 2, 78},
    {0x16, 3, 78},
    {0x01, 2, 79},
    {0x16, 3, 79},
    {0x01, 2, 80},
    {0x16, 3, 80},
    {0x01, 2, 81},
    {0x16, 3, 81},
    {0x01, 2, 82},
    {0x16, 3, 82},
    {0x01, 2, 83},
    {0x16, 3, 83},
    {0x01, 2, 84},
    {0x16, 3, 84},
  },
  /* 50 */
  {
    {0x02, 2, 77},
    {0x09, 2, 77},
    {0x17, 2, 77},
    {0x28, 3, 77},
    {0x02, 2, 78},
    {0x09, 2, 78},
    {0x17, 2, 78},
    {0x28, 3, 78},
    {0x02, 2, 79},
    {0x09, 2, 79},
    {0x17, 2, 79},
    {0x28, 3, 79},
    {0x02, 2, 80},
    {0x09, 2, 80},
    {0x17, 2, 80},
    {0x28, 3, 80},
  },
  /* 51 */
  {
    {0x03, 2, 77},
    {0x06, 2, 77},
    {0x0a, 2, 77},
    {0x0f, 2, 77},
    {0x18, 2, 77},
    {0x1f, 2, 77},
    {0x29, 2, 77},
    {0x38, 3, 77},
    {0x03, 2, 78},
    {0x06, 2, 78},
    {0x0a, 2, 78},
    {0x0f, 2, 78},
    {0x18, 2, 78},
    {0x1f, 2, 78},
    {0x29, 2, 78},
    {0x38, 3, 78},
  },
  /* 52 */
  {
    {0x03, 2, 79},
    {0x06, 2, 79},
    {0x0a, 2, 79},
    {0x0f, 2, 79},
    {0x18, 2, 79},
    {0x1f, 2, 79},
    {0x29, 2, 79},
    {0x38, 3, 79},
    {0x03, 2, 80},
    {0x06, 2, 80},
    {0x0a, 2, 80},
    {0x0f, 2, 80},
    {0x18, 2, 80},
    {0x1f, 2, 80},
    {0x29, 2, 80},
    {0x38, 3, 80},
  },
  /* 53 */
  {
    {0x02, 2, 81},
    {0x09, 2, 81},
    {0x17, 2, 81},
    {0x28, 3, 81},
    {0x02, 2, 82},
    {0x09, 2, 82},
    {0x17, 2, 82},
    {0x28, 3, 82},
    {0x02, 2, 83},
    {0x09, 2, 83},
    {0x17, 2, 83},
    {0x28, 3, 83},
    {0x02, 2, 84},
    {0x09, 2, 84},
    {0x17, 2, 84},
    {0x28, 3, 84},
  },
  /* 54 */
  {
    {0x03, 2, 81},
    {0x06, 2, 81},
    {0x0a, 2, 81},
    {0x0f, 2, 81},
    {0x18, 2, 81},
    {0x1f, 2, 81},
    {0x29, 2, 81},
    {0x38, 3, 81},
    {0x03, 2, 82},
    {0x06, 2, 82},
    {0x0a, 2, 82},
    {0x0f, 2, 82},
    {0x18, 2, 82},
    {0x1f, 2, 82},
    {0x29, 2, 82},
    {0x38, 3, 82},
  },
  /* 55 */
  {
    {0x03, 2, 83},
    {0x06, 2, 83},
    {0x0a, 2, 83},
    {0x0f, 2, 83},
    {0x18, 2, 83},
    {0x1f, 2, 83},
    {0x29, 2, 83},
    {0x38, 3, 83},
    {0x03, 2, 84},
    {0x06, 2, 84},
    {0x0a, 2, 84},
    {0x0f, 2, 84},
    {0x18, 2, 84},
    {0x1f, 2, 84},
    {0x29, 2, 84},
    {0x38, 3, 84},
  },
  /* 56 */
  {
    {0x00, 3, 85},
    {0x00, 3, 86},
    {0x00, 3, 87},
    {0x00, 3, 89},
    {0x00, 3, 106},
    {0x00, 3, 107},
    {0x00, 3, 113},
    {0x00, 3, 118},
    {0x00, 3, 119},
    {0x00, 3, 120},
    {0x00, 3, 121},
    {0x00, 3, 122},
    {0x46, 0, 0},
    {0x47, 0, 0},
    {0x49, 0, 0},
    {0x4a, 1, 0},
  },
  /* 57 */
  {
    {0x01, 2, 85},
    {0x16, 3, 85},
    {0x01, 2, 86},
    {0x16, 3, 86},
    {0x01, 2, 87},
    {0x16, 3, 87},
    {0x01, 2, 89},
    {0x16, 3, 89},
    {0x01, 2, 106},
    {0x16, 3, 106},
    {0x01, 2, 107},
    {0x16, 3, 107},
    {0x01, 2, 113},
    {0x16, 3, 113},
    {0x01, 2, 118},
    {0x16, 3, 118},
  },
  /* 58 */
  {
    {0x02, 2, 85},
    {0x09, 2, 85},
    {0x17, 2, 85},
    {0x28, 3, 85},
    {0x02, 2, 86},
    {0x09, 2, 86},
    {0x17, 2, 86},
    {0x28, 3, 86},
    {0x02, 2, 87},
    {0x09, 2, 87},
    {0x17, 2, 87},
    {0x28, 3, 87},
    {0x02, 2, 89},
    {0x09, 2, 89},
    {0x17, 2, 89},
    {0x28, 3, 89},
  },
  /* 59 */
  {
    {0x03, 2, 85},
    {0x06, 2, 85},
    {0x0a, 2, 85},
    {0x0f, 2, 85},
    {0x18, 2, 85},
    {0x1f, 2, 85},
    {0x29, 2, 85},
    {0x38, 3, 85},
    {0x03, 2, 86},
    {0x06, 2, 86},
    {0x0a, 2, 86},
    {0x0f, 2, 86},
    {0x18, 2, 86},
    {0x1f, 2, 86},
    {0x29, 2, 86},
    {0x38, 3, 86},
  },
  /* 60 */
  {
    {0x03, 2, 87},
    {0x06, 2, 87},
    {0x0a, 2, 87},
    {0x0f, 2, 87},
    {0x18, 2, 87},
    {0x1f, 2, 87},
    {0x29, 2, 87},
    {0x38, 3, 87},
    {0x03, 2, 89},
    {0x06, 2, 89},
    {0x0a, 2, 89},
    {0x0f, 2, 89},
    {0x18, 2, 89},
    {0x1f, 2, 89},
    {0x29, 2, 89},
    {0x38, 3, 89},
  },
  /* 61 */
  {
    {0x02, 2, 106},
    {0x09, 2, 106},
    {0x17, 2, 106},
    {0x28, 3, 106},
    {0x02, 2, 107},
    {0x09, 2, 107},
    {0x17, 2, 107},
    {0x28, 3, 107},
    {0x02, 2, 113},
    {0x09, 2, 113},
    {0x17, 2, 113},
    {0x28, 3, 113},
    {0x02, 2, 118},
    {0x09, 2, 118},
    {0x17, 2, 118},
    {0x28, 3, 118},
  },
  /* 62 */
  {
    {0x03, 2, 106},
    {0x06, 2, 106},
    {0x0a, 2, 106},
    {0x0f, 2, 106},
    {0x18, 2, 106},
    {0x1f, 2, 106},
    {0x29, 2, 106},
    {0x38, 3, 106},
    {0x03, 2, 107},
    {0x06, 2, 107},
    {0x0a, 2, 107},
    {0x0f, 2, 107},
    {0x18, 2, 107},
    {0x1f, 2, 107},
    {0x29, 2, 107},
    {0x38, 3, 107},
  },
  /* 63 */
  {
    {0x03, 2, 113},
    {0x06, 2, 113},
    {0x0a, 2, 113},
    {0x0f, 2, 113},
    {0x18, 2, 113},
    {0x1f, 2, 113},
    {0x29, 2, 113},
    {0x38, 3, 113},
    {0x03, 2, 118},
    {0x06, 2, 118},
    {0x0a, 2, 118},
    {0x0f, 2, 118},
    {0x18, 2, 118},
    {0x1f, 2, 118},
    {0x29, 2, 118},
    {0x38, 3, 118},
  },
  /* 64 */
  {
    {0x01, 2, 119},
    {0x16, 3, 119},
    {0x01, 2, 120},
    {0x16, 3, 120},
    {0x01, 2, 121},
    {0x16, 3, 121},
    {0x01, 2, 122},
    {0x16, 3, 122},
    {0x00, 3, 38},
    {0x00, 3, 42},
    {0x00, 3, 44},
    {0x00, 3, 59},
    {0x00, 3, 88},
    {0x00, 3, 90},
    {0x4b, 0, 0},
    {0x4e, 0, 0},
  },
  /* 65 */
  {
    {0x02, 2, 119},
    {0x09, 2, 119},
    {0x17, 2, 119},
    {0x28, 3, 119},
    {0x02, 2, 120},
    {0x09, 2, 120},
    {0x17, 2, 120},
    {0x28, 3, 120},
    {0x02, 2, 121},
    {0x09, 2, 121},
    {0x17, 2, 121},
    {0x28, 3, 121},
    {0x02, 2, 122},
    {0x09, 2, 122},
    {0x17, 2, 122},
    {0x28, 3, 122},
  },
  /* 66 */
  {
    {0x03, 2, 119},
    {0x06, 2, 119},
    {0x0a, 2, 119},
    {0x0f, 2, 119},
    {0x18, 2, 119},
    {0x1f, 2, 119},
    {0x29, 2, 119},
    {0x38, 3, 119},
    {0x03, 2, 120},
    {0x06, 2, 120},
    {0x0a, 2, 120},
    {0x0f, 2, 120},
    {0x18, 2, 120},
    {0x1f, 2, 120},
    {0x29, 2, 120},
    {0x38, 3, 120},
  },
  /* 67 */
  {
    {0x03, 2, 121},
    {0x06, 2, 121},
    {0x0a, 2, 121},
    {0x0f, 2, 121},
    {0x18, 2, 121},
    {0x1f, 2, 121},
    {0x29, 2, 121},
    {0x38, 3, 121},
    {0x03, 2, 122},
    {0x06, 2, 122},
    {0x0a, 2, 122},
    {0x0f, 2, 122},
    {0x18, 2, 122},
    {0x1f, 2, 122},
    {0x29, 2, 122},
    {0x38, 3, 122},
  },
  /* 68 */
  {
    {0x01, 2, 38},
    {0x16, 3, 38},
    {0x01, 2, 42},
    {0x16, 3, 42},
    {0x01, 2, 44},
    {0x16, 3, 44},
    {0x01, 2, 59},
    {0x16, 3, 59},
    {0x01, 2, 88},
    {0x16, 3, 88},
    {0x01, 2, 90},
    {0x16, 3, 90},
    {0x4c, 0, 0},
    {0x4d, 0, 0},
    {0x4f, 0, 0},
    {0x51, 0, 0},
  },
  /* 69 */
  {
    {0x02, 2, 38},
    {0x09, 2, 38},
    {0x17, 2, 38},
    {0x28, 3, 38},
    {0x02, 2, 42},
    {0x09, 2, 42},
    {0x17, 2, 42},
    {0x28, 3, 42},
    {0x02, 2, 44},
    {0x09, 2, 44},
    {0x17, 2, 44},
    {0x28, 3, 44},
    {0x02, 2, 59},
    {0x09, 2, 59},
    {0x17, 2, 59},
    {0x28, 3, 59},
  },
  /* 70 */
  {
    {0x03, 2, 38},
    {0x06, 2, 38},
    {0x0a, 2, 38},
    {0x0f, 2, 38},
    {0x18, 2, 38},
    {0x1f, 2, 38},
    {0x29, 2, 38},
    {0x38, 3, 38},
    {0x03, 2, 42},
    {0x06, 2, 42},
    {0x0a, 2, 42},
    {0x0f, 2, 42},
    {0x18, 2, 42},
    {0x1f, 2, 42},
    {0x29, 2, 42},
    {0x38, 3, 42},
  },
  /* 71 */
  {
    {0x03, 2, 44},
    {0x06, 2, 44},
    {0x0a, 2, 44},
    {0x0f, 2, 44},
    {0x18, 2, 44},
    {0x1f, 2, 44},
    {0x29, 2, 44},
    {0x38, 3, 44},
    {0x03, 2, 59},
    {0x06, 2, 59},
    {0x0a, 2, 59},
    {0x0f, 2, 59},
    {0x18, 2, 59},
    {0x1f, 2, 59},
    {0x29, 2, 59},
    {0x38, 3, 59},
  },
  /* 72 */
  {
    {0x02, 2, 88},
    {0x09, 2, 88},
    {0x17, 2, 88},
    {0x28, 3, 88},
    {0x02, 2, 90},
    {0x09, 2, 90},
    {0x17, 2, 90},
    {0x28, 3, 90},
    {0x00, 3, 33},
    {0x00, 3, 34},
    {0x00, 3, 40},
    {0x00, 3, 41},
    {0x00, 3, 63},
    {0x50, 0, 0},
    {0x52, 0, 0},
    {0x54, 0, 0},
  },
  /* 73 */
  {
    {0x03, 2, 88},
    {0x06, 2, 88},
    {0x0a, 2, 88},
    {0x0f, 2, 88},
    {0x18, 2, 88},
    {0x1f, 2, 88},
    {0x29, 2, 88},
    {0x38, 3, 88},
    {0x03, 2, 90},
    {0x06, 2, 90},
    {0x0a, 2, 90},
    {0x0f, 2, 90},
    {0x18, 2, 90},
    {0x1f, 2, 90},
    {0x29, 2, 90},
    {0x38, 3, 90},
  },
  /* 74 */
  {
    {0x01, 2, 33},
    {0x16, 3, 33},
    {0x01, 2, 34},
    {0x16, 3, 34},
    {0x01, 2, 40},
    {0x16, 3, 40},
    {0x01, 2, 41},
    {0x16, 3, 41},
    {0x01, 2, 63},
    {0x16, 3, 63},
    {0x00, 3, 39},
    {0x00, 3, 43},
    {0x00, 3, 124},
    {0x53, 0, 0},
    {0x55, 0, 0},
    {0x58, 0, 0},
  },
  /* 75 */
  {
    {0x02, 2, 33},
    {0x09, 2, 33},
    {0x17, 2, 33},
    {0x28, 3, 33},
    {0x02, 2, 34},
    {0x09, 2, 34},
    {0x17, 2, 34},
    {0x28, 3, 34},
    {0x02, 2, 40},
    {0x09, 2, 40},
    {0x17, 2, 40},
    {0x28, 3, 40},
    {0x02, 2, 41},
    {0x09, 2, 41},
    {0x17, 2, 41},
    {0x28, 3, 41},
  },
  /* 76 */
  {
    {0x03, 2, 33},
    {0x06, 2, 33},
    {0x0a, 2, 33},
    {0x0f, 2, 33},
    {0x18, 2, 33},
    {0x1f, 2, 33},
    {0x29, 2, 33},
    {0x38, 3, 33},
    {0x03, 2, 34},
    {0x06, 2, 34},
    {0x0a, 2, 34},
    {0x0f, 2, 34},
    {0x18, 2, 34},
    {0x1f, 2, 34},
    {0x29, 2, 34},
    {0x38, 3, 34},
  },
  /* 77 */
  {
    {0x03, 2, 40},
    {0x06, 2, 40},
    {0x0a, 2, 40},
    {0x0f, 2, 40},
    {0x18, 2, 40},
    {0x1f, 2, 40},
    {0x29, 2, 40},
    {0x38, 3, 40},
    {0x03, 2, 41},
    {0x06, 2, 41},
    {0x0a, 2, 41},
    {0x0f, 2, 41},
    {0x18, 2, 41},
    {0x1f, 2, 41},
    {0x29, 2, 41},
    {0x38, 3, 41},
  },
  /* 78 */
  {
    {0x02, 2, 63},
    {0x09, 2, 63},
    {0x17, 2, 63},
    {0x28, 3, 63},
    {0x01, 2, 39},
    {0x16, 3, 39},
    {0x01, 2, 43},
    {0x16, 3, 43},
    {0x01, 2, 124},
    {0x16, 3, 124},
    {0x00, 3, 35},
    {0x00, 3, 62},
    {0x56, 0, 0},
    {0x57, 0, 0},
    {0x59, 0, 0},
    {0x5a, 0, 0},
  },
  /* 79 */
  {
    {0x03, 2, 63},
    {0x06, 2, 63},
    {0x0a, 2, 63},
    {0x0f, 2, 63},
    {0x18, 2, 63},
    {0x1f, 2, 63},
    {0x29, 2, 63},
    {0x38, 3, 63},
    {0x02, 2, 39},
    {0x09, 2, 39},
    {0x17, 2, 39},
    {0x28, 3, 39},
    {0x02, 2, 43},
    {0x09, 2, 43},
    {0x17, 2, 43},
    {0x28, 3, 43},
  },
  /* 80 */
  {
    {0x03, 2, 39},
    {0x06, 2, 39},
    {0x0a, 2, 39},
    {0x0f, 2, 39},
    {0x18, 2, 39},
    {0x1f, 2, 39},
    {0x29, 2, 39},
    {0x38, 3, 39},
    {0x03, 2, 43},
    {0x06, 2, 43},
    {0x0a, 2, 43},
    {0x0f, 2, 43},
    {0x18, 2, 43},
    {0x1f, 2, 43},
    {0x29, 2, 43},
    {0x38, 3, 43},
  },
  /* 81 */
  {
    {0x02, 2, 124},
    {0x09, 2, 124},
    {0x17, 2, 124},
    {0x28, 3, 124},
    {0x01, 2, 35},
    {0x16, 3, 35},
    {0x01, 2, 62},
    {0x16, 3, 62},
    {0x00, 3, 0},
    {0x00, 3, 36},
    {0x00, 3, 64},
    {0x00, 3, 91},
    {0x00, 3, 93},
    {0x00, 3, 126},
    {0x5b, 0, 0},
    {0x5c, 0, 0},
  },
  /* 82 */
  {
    {0x03, 2, 124},
    {0x06, 2, 124},
    {0x0a, 2, 124},
    {0x0f, 2, 124},
    {0x18, 2, 124},
    {0x1f, 2, 124},
    {0x29, 2, 124},
    {0x38, 3, 124},
    {0x02, 2, 35},
    {0x09, 2, 35},
    {0x17, 2, 35},
    {0x28, 3, 35},
    {0x02, 2, 62},
    {0x09, 2, 62},
    {0x17, 2, 62},
    {0x28, 3, 62},
  },
  /* 83 */
  {
    {0x03, 2, 35},
    {0x06, 2, 35},
    {0x0a, 2, 35},
    {0x0f, 2, 35},
    {0x18, 2, 35},
    {0x1f, 2, 35},
    {0x29, 2, 35},
    {0x38, 3, 35},
    {0x03, 2, 62},
    {0x06, 2, 62},
    {0x0a, 2, 62},
    {0x0f, 2, 62},
    {0x18, 2, 62},
    {0x1f, 2, 62},
    {0x29, 2, 62},
    {0x38, 3, 62},
  },
  /* 84 */
  {
    {0x01, 2, 0},
    {0x16, 3, 0},
    {0x01, 2, 36},
    {0x16, 3, 36},
    {0x01, 2, 64},
    {0x16, 3, 64},
    {0x01, 2, 91},
    {0x16, 3, 91},
    {0x01, 2, 93},
    {0x16, 3, 93},
    {0x01, 2, 126},
    {0x16, 3, 126},
    {0x00, 3, 94},
    {0x00, 3, 125},
    {0x5d, 0, 0},
    {0x5e, 0, 0},
  },
  /* 85 */
  {
    {0x02, 2, 0},
    {0x09, 2, 0},
    {0x17, 2, 0},
    {0x28, 3, 0},
    {0x02, 2, 36},
    {0x09, 2, 36},
    {0x17, 2, 36},
    {0x28, 3, 36},
    {0x02, 2, 64},
    {0x09, 2, 64},
    {0x17, 2, 64},
    {0x28, 3, 64},
    {0x02, 2, 91},
    {0x09, 2, 91},
    {0x17, 2, 91},
    {0x28, 3, 91},
  },
  /* 86 */
  {
    {0x03, 2, 0},
    {0x06, 2, 0},
    {0x0a, 2, 0},
    {0x0f, 2, 0},
    {0x18, 2, 0},
    {0x1f, 2, 0},
    {0x29, 2, 0},
    {0x38, 3, 0},
    {0x03, 2, 36},
    {0x06, 2, 36},
    {0x0a, 2, 36},
    {0x0f, 2, 36},
    {0x18, 2, 36},
    {0x1f, 2, 36},
    {0x29, 2, 36},
    {0x38, 3, 36},
  },
  /* 87 */
  {
    {0x03, 2, 64},
    {0x06, 2, 64},
    {0x0a, 2, 64},
    {0x0f, 2, 64},
    {0x18, 2, 64},
    {0x1f, 2, 64},
    {0x29, 2, 64},
    {0x38, 3, 64},
    {0x03, 2, 91},
    {0x06, 2, 91},
    {0x0a, 2, 91},
    {0x0f, 2, 91},
    {0x18, 2, 91},
    {0x1f, 2, 91},
    {0x29, 2, 91},
    {0x38, 3, 91},
  },
  /* 88 */
  {
    {0x02, 2, 93},
    {0x09, 2, 93},
    {0x17, 2, 93},
    {0x28, 3, 93},
    {0x02, 2, 126},
    {0x09, 2, 126},
    {0x17, 2, 126},
    {0x28, 3, 126},
    {0x01, 2, 94},
    {0x16, 3, 94},
    {0x01, 2, 125},
    {0x16, 3, 125},
    {0x00, 3, 60},
    {0x00, 3, 96},
    {0x00, 3, 123},
    {0x5f, 0, 0},
  },
  /* 89 */
  {
    {0x03, 2, 93},
    {0x06, 2, 93},
    {0x0a, 2, 93},
    {0x0f, 2, 93},
    {0x18, 2, 93},
    {0x1f, 2, 93},
    {0x29, 2, 93},
    {0x38, 3, 93},
    {0x03, 2, 126},
    {0x06, 2, 126},
    {0x0a, 2, 126},
    {0x0f, 2, 126},
    {0x18, 2, 126},
    {0x1f, 2, 126},
    {0x29, 2, 126},
    {0x38, 3, 126},
  },
  /* 90 */
  {
    {0x02, 2, 94},
    {0x09, 2, 94},
    {0x17, 2, 94},
    {0x28, 3, 94},
    {0x02, 2, 125},
    {0x09, 2, 125},
    {0x17, 2, 125},
    {0x28, 3, 125},
    {0x01, 2, 60},
    {0x16, 3, 60},
    {0x01, 2, 96},
    {0x16, 3, 96},
    {0x01, 2, 123},
    {0x16, 3, 123},
    {0x60, 0, 0},
    {0x6e, 0, 0},
  },
  /* 91 */
  {
    {0x03, 2, 94},
    {0x06, 2, 94},
    {0x0a, 2, 94},
    {0x0f, 2, 94},
    {0x18, 2, 94},
    {0x1f, 2, 94},
    {0x29, 2, 94},
    {0x38, 3, 94},
    {0x03, 2, 125},
    {0x06, 2, 125},
    {0x0a, 2, 125},
    {0x0f, 2, 125},
    {0x18, 2, 125},
    {0x1f, 2, 125},
    {0x29, 2, 125},
    {0x38, 3, 125},
  },
  /* 92 */
  {
    {0x02, 2, 60},
    {0x09, 2, 60},
    {0x17, 2, 60},
    {0x28, 3, 60},
    {0x02, 2, 96},
    {0x09, 2, 96},
    {0x17, 2, 96},
    {0x28, 3, 96},
    {0x02, 2, 123},
    {0x09, 2, 123},
    {0x17, 2, 123},
    {0x28, 3, 123},
    {0x61, 0, 0},
    {0x65, 0, 0},
    {0x6f, 0, 0},
    {0x85, 0, 0},
  },
  /* 93 */
  {
    {0x03, 2, 60},
    {0x06, 2, 60},
    {0x0a, 2, 60},
    {0x0f, 2, 60},
    {0x18, 2, 60},
    {0x1f, 2, 60},
    {0x29, 2, 60},
    {0x38, 3, 60},
    {0x03, 2, 96},
    {0x06, 2, 96},
    {0x0a, 2, 96},
    {0x0f, 2, 96},
    {0x18, 2, 96},
    {0x1f, 2, 96},
    {0x29, 2, 96},
    {0x38, 3, 96},
  },
  /* 94 */
  {
    {0x03, 2, 123},
    {0x06, 2, 123},
    {0x0a, 2, 123},
    {0x0f, 2, 123},
    {0x18, 2, 123},
    {0x1f, 2, 123},
    {0x29, 2, 123},
    {0x38, 3, 123},
    {0x62, 0, 0},
    {0x63, 0, 0},
    {0x66, 0, 0},
    {0x69, 0, 0},
    {0x70, 0, 0},
    {0x77, 0, 0},
    {0x86, 0, 0},
    {0x99, 0, 0},
  },
  /* 95 */
  {
    {0x00, 3, 92},
    {0x00, 3, 195},
    {0x00, 3, 208},
    {0x64, 0, 0},
    {0x67, 0, 0},
    {0x68, 0, 0},
    {0x6a, 0, 0},
    {0x6b, 0, 0},
    {0x71, 0, 0},
    {0x74, 0, 0},
    {0x78, 0, 0},
    {0x7e, 0, 0},
    {0x87, 0, 0},
    {0x8e, 0, 0},
    {0x9a, 0, 0},
    {0xa9, 0, 0},
  },
  /* 96 */
  {
    {0x01, 2, 92},
    {0x16, 3, 92},
    {0x01, 2, 195},
    {0x16, 3, 195},
    {0x01, 2, 208},
    {0x16, 3, 208},
    {0x00, 3, 128},
    {0x00, 3, 130},
    {0x00, 3, 131},
    {0x00, 3, 162},
    {0x00, 3, 184},
    {0x00, 3, 194},
    {0x00, 3, 224},
    {0x00, 3, 226},
    {0x6c, 0, 0},
    {0x6d, 0, 0},
  },
  /* 97 */
  {
    {0x02, 2, 92},
    {0x09, 2, 92},
    {0x17, 2, 92},
    {0x28, 3, 92},
    {0x02, 2, 195},
    {0x09, 2, 195},
    {0x17, 2, 195},
    {0x28, 3, 195},
    {0x02, 2, 208},
    {0x09, 2, 208},
    {0x17, 2, 208},
    {0x28, 3, 208},
    {0x01, 2, 128},
    {0x16, 3, 128},
    {0x01, 2, 130},
    {0x16, 3, 130},
  },
  /* 98 */
  {
    {0x03, 2, 92},
    {0x06, 2, 92},
    {0x0a, 2, 92},
    {0x0f, 2, 92},
    {0x18, 2, 92},
    {0x1f, 2, 92},
    {0x29, 2, 92},
    {0x38, 3, 92},
    {0x03, 2, 195},
    {0x06, 2, 195},
    {0x0a, 2, 195},
    {0x0f, 2, 195},
    {0x18, 2, 195},
    {0x1f, 2, 195},
    {0x29, 2, 195},
    {0x38, 3, 195},
  },
  /* 99 */
  {
    {0x03, 2, 208},
    {0x06, 2, 208},
    {0x0a, 2, 208},
    {0x0f, 2, 208},
    {0x18, 2, 208},
    {0x1f, 2, 208},
    {0x29, 2, 208},
    {0x38, 3, 208},
    {0x02, 2, 128},
    {0x09, 2, 128},
    {0x17, 2, 128},
    {0x28, 3, 128},
    {0x02, 2, 130},
    {0x09, 2, 130},
    {0x17, 2, 130},
    {0x28, 3, 130},
  },
  /* 100 */
  {
    {0x03, 2, 128},
    {0x06, 2, 128},
    {0x0a, 2, 128},
    {0x0f, 2, 128},
    {0x18, 2, 128},
    {0x1f, 2, 128},
    {0x29, 2, 128},
    {0x38, 3, 128},
    {0x03, 2, 130},
    {0x06, 2, 130},
    {0x0a, 2, 130},
    {0x0f, 2, 130},
    {0x18, 2, 130},
    {0x1f, 2, 130},
    {0x29, 2, 130},
    {0x38, 3, 130},
  },
  /* 101 */
  {
    {0x01, 2, 131},
    {0x16, 3, 131},
    {0x01, 2, 162},
    {0x16, 3, 162},
    {0x01, 2, 184},
    {0x16, 3, 184},
    {0x01, 2, 194},
    {0x16, 3, 194},
    {0x01, 2, 224},
    {0x16, 3, 224},
    {0x01, 2, 226},
    {0x16, 3, 226},
    {0x00, 3, 153},
    {0x00, 3, 161},
    {0x00, 3, 167},
    {0x00, 3, 172},
  },
  /* 102 */
  {
    {0x02, 2, 131},
    {0x09, 2, 131},
    {0x17, 2, 131},
    {0x28, 3, 131},
    {0x02, 2, 162},
    {0x09, 2, 162},
    {0x17, 2, 162},
    {0x28, 3, 162},
    {0x02, 2, 184},
    {0x09, 2, 184},
    {0x17, 2, 184},
    {0x28, 3, 184},
    {0x02, 2, 194},
    {0x09, 2, 194},
    {0x17, 2, 194},
    {0x28, 3, 194},
  },
  /* 103 */
  {
    {0x03, 2, 131},
    {0x06, 2, 131},
    {0x0a, 2, 131},
    {0x0f, 2, 131},
    {0x18, 2, 131},
    {0x1f, 2, 131},
    {0x29, 2, 131},
    {0x38, 3, 131},
    {0x03, 2, 162},
    {0x06, 2, 162},
    {0x0a, 2, 162},
    {0x0f, 2, 162},
    {0x18, 2, 162},
    {0x1f, 2, 162},
    {0x29, 2, 162},
    {0x38, 3, 162},
  },
  /* 104 */
  {
    {0x03, 2, 184},
    {0x06, 2, 184},
    {0x0a, 2, 184},
    {0x0f, 2, 184},
    {0x18, 2, 184},
    {0x1f, 2, 184},
    {0x29, 2, 184},
    {0x38, 3, 184},
    {0x03, 2, 194},
    {0x06, 2, 194},
    {0x0a, 2, 194},
    {0x0f, 2, 194},
    {0x18, 2, 194},
    {0x1f, 2, 194},
    {0x29, 2, 194},
    {0x38, 3, 194},
  },
  /* 105 */
  {
    {0x02, 2, 224},
    {0x09, 2, 224},
    {0x17, 2, 224},
    {0x28, 3, 224},
    {0x02, 2, 226},
    {0x09, 2, 226},
    {0x17, 2, 226},
    {0x28, 3, 226},
    {0x01, 2, 153},
    {0x16, 3, 153},
    {0x01, 2, 161},
    {0x16, 3, 161},
    {0x01, 2, 167},
    {0x16, 3, 167},
    {0x01, 2, 172},
    {0x16, 3, 172},
  },
  /* 106 */
  {
    {0x03, 2, 224},
    {0x06, 2, 224},
    {0x0a, 2, 224},
    {0x0f, 2, 224},
    {0x18, 2, 224},
    {0x1f, 2, 224},
    {0x29, 2, 224},
    {0x38, 3, 224},
    {0x03, 2, 226},
    {0x06, 2, 226},
    {0x0a, 2, 226},
    {0x0f, 2, 226},
    {0x18, 2, 226},
    {0x1f, 2, 226},
    {0x29, 2, 226},
    {0x38, 3, 226},
  },
  /* 107 */
  {
    {0x02, 2, 153},
    {0x09, 2, 153},
    {0x17, 2, 153},
    {0x28, 3, 153},
    {0x02, 2, 161},
    {0x09, 2, 161},
    {0x17, 2, 161},
    {0x28, 3, 161},
    {0x02, 2, 167},
    {0x09, 2, 167},
    {0x17, 2, 167},
    {0x28, 3, 167},
    {0x02, 2, 172},
    {0x09, 2, 172},
    {0x17, 2, 172},
    {0x28, 3, 172},
  },
  /* 108 */
  {
    {0x03, 2, 153},
    {0x06, 2, 153},
    {0x0a, 2, 153},
    {0x0f, 2, 153},
    {0x18, 2, 153},
    {0x1f, 2, 153},
    {0x29, 2, 153},
    {0x38, 3, 153},
    {0x03, 2, 161},
    {0x06, 2, 161},
    {0x0a, 2, 161},
    {0x0f, 2, 161},
    {0x18, 2, 161},
    {0x1f, 2, 161},
    {0x29, 2, 161},
    {0x38, 3, 161},
  },
  /* 109 */
  {
    {0x03, 2, 167},
    {0x06, 2, 167},
    {0x0a, 2, 167},
    {0x0f, 2, 167},
    {0x18, 2, 167},
    {0x1f, 2, 167},
    {0x29, 2, 167},
    {0x38, 3, 167},
    {0x03, 2, 172},
    {0x06, 2, 172},
    {0x0a, 2, 172},
    {0x0f, 2, 172},
    {0x18, 2, 172},
    {0x1f, 2, 172},
    {0x29, 2, 172},
    {0x38, 3, 172},
  },
  /* 110 */
  {
    {0x72, 0, 0},
    {0x73, 0, 0},
    {0x75, 0, 0},
    {0x76, 0, 0},
    {0x79, 0, 0},
    {0x7b, 0, 0},
    {0x7f, 0, 0},
    {0x82, 0, 0},
    {0x88, 0, 0},
    {0x8b, 0, 0},
    {0x8f, 0, 0},
    {0x92, 0, 0},
    {0x9b, 0, 0},
    {0xa2, 0, 0},
    {0xaa, 0, 0},
    {0xb4, 0, 0},
  },
  /* 111 */
  {
    {0x00, 3, 176},
    {0x00, 3, 177},
    {0x00, 3, 179},
    {0x00, 3, 209},
    {0x00, 3, 216},
    {0x00, 3, 217},
    {0x00, 3, 227},
    {0x00, 3, 229},
    {0x00, 3, 230},
    {0x7a, 0, 0},
    {0x7c, 0, 0},
    {0x7d, 0, 0},
    {0x80, 0, 0},
    {0x81, 0, 0},
    {0x83, 0, 0},
    {0x84, 0, 0},
  },
  /* 112 */
  {
    {0x01, 2, 176},
    {0x16, 3, 176},
    {0x01, 2, 177},
    {0x16, 3, 177},
    {0x01, 2, 179},
    {0x16, 3, 179},
    {0x01, 2, 209},
    {0x16, 3, 209},
    {0x01, 2, 216},
    {0x16, 3, 216},
    {0x01, 2, 217},
    {0x16, 3, 217},
    {0x01, 2, 227},
    {0x16, 3, 227},
    {0x01, 2, 229},
    {0x16, 3, 229},
  },
  /* 113 */
  {
    {0x02, 2, 176},
    {0x09, 2, 176},
    {0x17, 2, 176},
    {0x28, 3, 176},
    {0x02, 2, 177},
    {0x09, 2, 177},
    {0x17, 2, 177},
    {0x28, 3, 177},
    {0x02, 2, 179},
    {0x09, 2, 179},
    {0x17, 2, 179},
    {0x28, 3, 179},
    {0x02, 2, 209},
    {0x09, 2, 209},
    {0x17, 2, 209},
    {0x28, 3, 209},
  },
  /* 114 */
  {
    {0x03, 2, 176},
    {0x06, 2, 176},
    {0x0a, 2, 176},
    {0x0f, 2, 176},
    {0x18, 2, 176},
    {0x1f, 2, 176},
    {0x29, 2, 176},
    {0x38, 3, 176},
    {0x03, 2, 177},
    {0x06, 2, 177},
    {0x0a, 2, 177},
    {0x0f, 2, 177},
    {0x18, 2, 177},
    {0x1f, 2, 177},
    {0x29, 2, 177},
    {0x38, 3, 177},
  },
  /* 115 */
  {
    {0x03, 2, 179},
    {0x06, 2, 179},
    {0x0a, 2, 179},
    {0x0f, 2, 179},
    {0x18, 2, 179},
    {0x1f, 2, 179},
    {0x29, 2, 179},
    {0x38, 3, 179},
    {0x03, 2, 209},
    {0x06, 2, 209},
    {0x0a, 2, 209},
    {0x0f, 2, 209},
    {0x18, 2, 209},
    {0x1f, 2, 209},
    {0x29, 2, 209},
    {0x38, 3, 209},
  },
  /* 116 */
  {
    {0x02, 2, 216},
    {0x09, 2, 216},
    {0x17, 2, 216},
    {0x28, 3, 216},
    {0x02, 2, 217},
    {0x09, 2, 217},
    {0x17, 2, 217},
    {0x28, 3, 217},
    {0x02, 2, 227},
    {0x09, 2, 227},
    {0x17, 2, 227},
    {0x28, 3, 227},
    {0x02, 2, 229},
    {0x09, 2, 229},
    {0x17, 2, 229},
    {0x28, 3, 229},
  },
  /* 117 */
  {
    {0x03, 2, 216},
    {0x06, 2, 216},
    {0x0a, 2, 216},
    {0x0f, 2, 216},
    {0x18, 2, 216},
    {0x1f, 2, 216},
    {0x29, 2, 216},
    {0x38, 3, 216},
    {0x03, 2, 217},
    {0x06, 2, 217},
    {0x0a, 2, 217},
    {0x0f, 2, 217},
    {0x18, 2, 217},
    {0x1f, 2, 217},
    {0x29, 2, 217},
    {0x38, 3, 217},
  },
  /* 118 */
  {
    {0x03, 2, 227},
    {0x06, 2, 227},
    {0x0a, 2, 227},
    {0x0f, 2, 227},
    {0x18, 2, 227},
    {0x1f, 2, 227},
    {0x29, 2, 227},
    {0x38, 3, 227},
    {0x03, 2, 229},
    {0x06, 2, 229},
    {0x0a, 2, 229},
    {0x0f, 2, 229},
    {0x18, 2, 229},
    {0x1f, 2, 229},
    {0x29, 2, 229},
    {0x38, 3, 229},
  },
  /* 119 */
  {
    {0x01, 2, 230},
    {0x16, 3, 230},
    {0x00, 3, 129},
    {0x00, 3, 132},
    {0x00, 3, 133},
    {0x00, 3, 134},
    {0x00, 3, 136},
    {0x00, 3, 146},
    {0x00, 3, 154},
    {0x00, 3, 156},
    {0x00, 3, 160},
    {0x00, 3, 163},
    {0x00, 3, 164},
    {0x00, 3, 169},
    {0x00, 3, 170},
    {0x00, 3, 173},
  },
  /* 120 */
  {
    {0x02, 2, 230},
    {0x09, 2, 230},
    {0x17, 2, 230},
    {0x28, 3, 230},
    {0x01, 2, 129},
    {0x16, 3, 129},
    {0x01, 2, 132},
    {0x16, 3, 132},
    {0x01, 2, 133},
    {0x16, 3, 133},
    {0x01, 2, 134},
    {0x16, 3, 134},
    {0x01, 2, 136},
    {0x16, 3, 136},
    {0x01, 2, 146},
    {0x16, 3, 146},
  },
  /* 121 */
  {
    {0x03, 2, 230},
    {0x06, 2, 230},
    {0x0a, 2, 230},
    {0x0f, 2, 230},
    {0x18, 2, 230},
    {0x1f, 2, 230},
    {0x29, 2, 230},
    {0x38, 3, 230},
    {0x02, 2, 129},
    {0x09, 2, 129},
    {0x17, 2, 129},
    {0x28, 3, 129},
    {0x02, 2, 132},
    {0x09, 2, 132},
    {0x17, 2, 132},
    {0x28, 3, 132},
  },
  /* 122 */
  {
    {0x03, 2, 129},
    {0x06, 2, 129},
    {0x0a, 2, 129},
    {0x0f, 2, 129},
    {0x18, 2, 129},
    {0x1f, 2, 129},
    {0x29, 2, 129},
    {0x38, 3, 129},
    {0x03, 2, 132},
    {0x06, 2, 132},
    {0x0a, 2, 132},
    {0x0f, 2, 132},
    {0x18, 2, 132},
    {0x1f, 2, 132},
    {0x29, 2, 132},
    {0x38, 3, 132},
  },
  /* 123 */
  {
    {0x02, 2, 133},
    {0x09, 2, 133},
    {0x17, 2, 133},
    {0x28, 3, 133},
    {0x02, 2, 134},
    {0x09, 2, 134},
    {0x17, 2, 134},
    {0x28, 3, 134},
    {0x02, 2, 136},
    {0x09, 2, 136},
    {0x17, 2, 136},
    {0x28, 3, 136},
    {0x02, 2, 146},
    {0x09, 2, 146},
    {0x17, 2, 146},
    {0x28, 3, 146},
  },
  /* 124 */
  {
    {0x03, 2, 133},
    {0x06, 2, 133},
    {0x0a, 2, 133},
    {0x0f, 2, 133},
    {0x18, 2, 133},
    {0x1f, 2, 133},
    {0x29, 2, 133},
    {0x38, 3, 133},
    {0x03, 2, 134},
    {0x06, 2, 134},
    {0x0a, 2, 134},
    {0x0f, 2, 134},
    {0x18, 2, 134},
    {0x1f, 2, 134},
    {0x29, 2, 134},
    {0x38, 3, 134},
  },
  /* 125 */
  {
    {0x03, 2, 136},
    {0x06, 2, 136},
    {0x0a, 2, 136},
    {0x0f, 2, 136},
    {0x18, 2, 136},
    {0x1f, 2, 136},
    {0x29, 2, 136},
    {0x38, 3, 136},
    {0x03, 2, 146},
    {0x06, 2, 146},
    {0x0a, 2, 146},
    {0x0f, 2, 146},
    {0x18, 2, 146},
    {0x1f, 2, 146},
    {0x29, 2, 146},
    {0x38, 3, 146},
  },
  /* 126 */
  {
    {0x01, 2, 154},
    {0x16, 3, 154},
    {0x01, 2, 156},
    {0x16, 3, 156},
    {0x01, 2, 160},
    {0x16, 3, 160},
    {0x01, 2, 163},
    {0x16, 3, 163},
    {0x01, 2, 164},
    {0x16, 3, 164},
    {0x01, 2, 169},
    {0x16, 3, 169},
    {0x01, 2, 170},
    {0x16, 3, 170},
    {0x01, 2, 173},
    {0x16, 3, 173},
  },
  /* 127 */
  {
    {0x02, 2, 154},
    {0x09, 2, 154},
    {0x17, 2, 154},
    {0x28, 3, 154},
    {0x02, 2, 156},
    {0x09, 2, 156},
    {0x17, 2, 156},
    {0x28, 3, 156},
    {0x02, 2, 160},
    {0x09, 2, 160},
    {0x17, 2, 160},
    {0x28, 3, 160},
    {0x02, 2, 163},
    {0x09, 2, 163},
    {0x17, 2, 163},
    {0x28, 3, 163},
  },
  /* 128 */
  {
    {0x03, 2, 154},
    {0x06, 2, 154},
    {0x0a, 2, 154},
    {0x0f, 2, 154},
    {0x18, 2, 154},
    {0x1f, 2, 154},
    {0x29, 2, 154},
    {0x38, 3, 154},
    {0x03, 2, 156},
    {0x06, 2, 156},
    {0x0a, 2, 156},
    {0x0f, 2, 156},
    {0x18, 2, 156},
    {0x1f, 2, 156},
    {0x29, 2, 156},
    {0x38, 3, 156},
  },
  /* 129 */
  {
    {0x03, 2, 160},
    {0x06, 2, 160},
    {0x0a, 2, 160},
    {0x0f, 2, 160},
    {0x18, 2, 160},
    {0x1f, 2, 160},
    {0x29, 2, 160},
    {0x38, 3, 160},
    {0x03, 2, 163},
    {0x06, 2, 163},
    {0x0a, 2, 163},
    {0x0f, 2, 163},
    {0x18, 2, 163},
    {0x1f, 2, 163},
    {0x29, 2, 163},
    {0x38, 3, 163},
  },
  /* 130 */
  {
    {0x02, 2, 164},
    {0x09, 2, 164},
    {0x17, 2, 164},
    {0x28, 3, 164},
    {0x02, 2, 169},
    {0x09, 2, 169},
    {0x17, 2, 169},
    {0x28, 3, 169},
    {0x02, 2, 170},
    {0x09, 2, 170},
    {0x17, 2, 170},
    {0x28, 3, 170},
    {0x02, 2, 173},
    {0x09, 2, 173},
    {0x17, 2, 173},
    {0x28, 3, 173},
  },
  /* 131 */
  {
    {0x03, 2, 164},
    {0x06, 2, 164},
    {0x0a, 2, 164},
    {0x0f, 2, 164},
    {0x18, 2, 164},
    {0x1f, 2, 164},
    {0x29, 2, 164},
    {0x38, 3, 164},
    {0x03, 2, 169},
    {0x06, 2, 169},
    {0x0a, 2, 169},
    {0x0f, 2, 169},
    {0x18, 2, 169},
    {0x1f, 2, 169},
    {0x29, 2, 169},
    {0x38, 3, 169},
  },
  /* 132 */
  {
    {0x03, 2, 170},
    {0x06, 2, 170},
    {0x0a, 2, 170},
    {0x0f, 2, 170},
    {0x18, 2, 170},
    {0x1f, 2, 170},
    {0x29, 2, 170},
    {0x38, 3, 170},
    {0x03, 2, 173},
    {0x06, 2, 173},
    {0x0a, 2, 173},
    {0x0f, 2, 173},
    {0x18, 2, 173},
    {0x1f, 2, 173},
    {0x29, 2, 173},
    {0x38, 3, 173},
  },
  /* 133 */
  {
    {0x89, 0, 0},
    {0x8a, 0, 0},
    {0x8c, 0, 0},
    {0x8d, 0, 0},
    {0x90, 0, 0},
    {0x91, 0, 0},
    {0x93, 0, 0},
    {0x96, 0, 0},
    {0x9c, 0, 0},
    {0x9f, 0, 0},
    {0xa3, 0, 0},
    {0xa6, 0, 0},
    {0xab, 0, 0},
    {0xae, 0, 0},
    {0xb5, 0, 0},
    {0xbe, 0, 0},
  },
  /* 134 */
  {
    {0x00, 3, 178},
    {0x00, 3, 181},
    {0x00, 3, 185},
    {0x00, 3, 186},
    {0x00, 3, 187},
    {0x00, 3, 189},
    {0x00, 3, 190},
    {0x00, 3, 196},
    {0x00, 3, 198},
    {0x00, 3, 228},
    {0x00, 3, 232},
    {0x00, 3, 233},
    {0x94, 0, 0},
    {0x95, 0, 0},
    {0x97, 0, 0},
    {0x98, 0, 0},
  },
  /* 135 */
  {
    {0x01, 2, 178},
    {0x16, 3, 178},
    {0x01, 2, 181},
    {0x16, 3, 181},
    {0x01, 2, 185},
    {0x16, 3, 185},
    {0x01, 2, 186},
    {0x16, 3, 186},
    {0x01, 2, 187},
    {0x16, 3, 187},
    {0x01, 2, 189},
    {0x16, 3, 189},
    {0x01, 2, 190},
    {0x16, 3, 190},
    {0x01, 2, 196},
    {0x16, 3, 196},
  },
  /* 136 */
  {
    {0x02, 2, 178},
    {0x09, 2, 178},
    {0x17, 2, 178},
    {0x28, 3, 178},
    {0x02, 2, 181},
    {0x09, 2, 181},
    {0x17, 2, 181},
    {0x28, 3, 181},
    {0x02, 2, 185},
    {0x09, 2, 185},
    {0x17, 2, 185},
    {0x28, 3, 185},
    {0x02, 2, 186},
    {0x09, 2, 186},
    {0x17, 2, 186},
    {0x28, 3, 186},
  },
  /* 137 */
  {
    {0x03, 2, 178},
    {0x06, 2, 178},
    {0x0a, 2, 178},
    {0x0f, 2, 178},
    {0x18, 2, 178},
    {0x1f, 2, 178},
    {0x29, 2, 178},
    {0x38, 3, 178},
    {0x03, 2, 181},
    {0x06, 2, 181},
    {0x0a, 2, 181},
    {0x0f, 2, 181},
    {0x18, 2, 181},
    {0x1f, 2, 181},
    {0x29, 2, 181},
    {0x38, 3, 181},
  },
  /* 138 */
  {
    {0x03, 2, 185},
    {0x06, 2, 185},
    {0x0a, 2, 185},
    {0x0f, 2, 185},
    {0x18, 2, 185},
    {0x1f, 2, 185},
    {0x29, 2, 185},
    {0x38, 3, 185},
    {0x03, 2, 186},
    {0x06, 2, 186},
    {0x0a, 2, 186},
    {0x0f, 2, 186},
    {0x18, 2, 186},
    {0x1f, 2, 186},
    {0x29, 2, 186},
    {0x38, 3, 186},
  },
  /* 139 */
  {
    {0x02, 2, 187},
    {0x09, 2, 187},
    {0x17, 2, 187},
    {0x28, 3, 187},
    {0x02, 2, 189},
    {0x09, 2, 189},
    {0x17, 2, 189},
    {0x28, 3, 189},
    {0x02, 2, 190},
    {0x09, 2, 190},
    {0x17, 2, 190},
    {0x28, 3, 190},
    {0x02, 2, 196},
    {0x09, 2, 196},
    {0x17, 2, 196},
    {0x28, 3, 196},
  },
  /* 140 */
  {
    {0x03, 2, 187},
    {0x06, 2, 187},
    {0x0a, 2, 187},
    {0x0f, 2, 187},
    {0x18, 2, 187},
    {0x1f, 2, 187},
    {0x29, 2, 187},
    {0x38, 3, 187},
    {0x03, 2, 189},
    {0x06, 2, 189},
    {0x0a, 2, 189},
    {0x0f, 2, 189},
    {0x18, 2, 189},
    {0x1f, 2, 189},
    {0x29, 2, 189},
    {0x38, 3, 189},
  },
  /* 141 */
  {
    {0x03, 2, 190},
    {0x06, 2, 190},
    {0x0a, 2, 190},
    {0x0f, 2, 190},
    {0x18, 2, 190},
    {0x1f, 2, 190},
    {0x29, 2, 190},
    {0x38, 3, 190},
    {0x03, 2, 196},
    {0x06, 2, 196},
    {0x0a, 2, 196},
    {0x0f, 2, 196},
    {0x18, 2, 196},
    {0x1f, 2, 196},
    {0x29, 2, 196},
    {0x38, 3, 196},
  },
  /* 142 */
  {
    {0x01, 2, 198},
    {0x16, 3, 198},
    {0x01, 2, 228},
    {0x16, 3, 228},
    {0x01, 2, 232},
    {0x16, 3, 232},
    {0x01, 2, 233},
    {0x16, 3, 233},
    {0x00, 3, 1},
    {0x00, 3, 135},
    {0x00, 3, 137},
    {0x00, 3, 138},
    {0x00, 3, 139},
    {0x00, 3, 140},
    {0x00, 3, 141},
    {0x00, 3, 143},
  },
  /* 143 */
  {
    {0x02, 2, 198},
    {0x09, 2, 198},
    {0x17, 2, 198},
    {0x28, 3, 198},
    {0x02, 2, 228},
    {0x09, 2, 228},
    {0x17, 2, 228},
    {0x28, 3, 228},
    {0x02, 2, 232},
    {0x09, 2, 232},
    {0x17, 2, 232},
    {0x28, 3, 232},
    {0x02, 2, 233},
    {0x09, 2, 233},
    {0x17, 2, 233},
    {0x28, 3, 233},
  },
  /* 144 */
  {
    {0x03, 2, 198},
    {0x06, 2, 198},
    {0x0a, 2, 198},
    {0x0f, 2, 198},
    {0x18, 2, 198},
    {0x1f, 2, 198},
    {0x29, 2, 198},
    {0x38, 3, 198},
    {0x03, 2, 228},
    {0x06, 2, 228},
    {0x0a, 2, 228},
    {0x0f, 2, 228},
    {0x18, 2, 228},
    {0x1f, 2, 228},
    {0x29, 2, 228},
    {0x38, 3, 228},
  },
  /* 145 */
  {
    {0x03, 2, 232},
    {0x06, 2, 232},
    {0x0a, 2, 232},
    {0x0f, 2, 232},
    {0x18, 2, 232},
    {0x1f, 2, 232},
    {0x29, 2, 232},
    {0x38, 3, 232},
    {0x03, 2, 233},
    {0x06, 2, 233},
    {0x0a, 2, 233},
    {0x0f, 2, 233},
    {0x18, 2, 233},
    {0x1f, 2, 233},
    {0x29, 2, 233},
    {0x38, 3, 233},
  },
  /* 146 */
  {
    {0x01, 2, 1},
    {0x16, 3, 1},
    {0x01, 2, 135},
    {0x16, 3, 135},
    {0x01, 2, 137},
    {0x16, 3, 137},
    {0x01, 2, 138},
    {0x16, 3, 138},
    {0x01, 2, 139},
    {0x16, 3, 139},
    {0x01, 2, 140},
    {0x16, 3, 140},
    {0x01, 2, 141},
    {0x16, 3, 141},
    {0x01, 2, 143},
    {0x16, 3, 143},
  },
  /* 147 */
  {
    {0x02, 2, 1},
    {0x09, 2, 1},
    {0x17, 2, 1},
    {0x28, 3, 1},
    {0x02, 2, 135},
    {0x09, 2, 135},
    {0x17, 2, 135},
    {0x28, 3, 135},
    {0x02, 2, 137},
    {0x09, 2, 137},
    {0x17, 2, 137},
    {0x28, 3, 137},
    {0x02, 2, 138},
    {0x09, 2, 138},
    {0x17, 2, 138},
    {0x28, 3, 138},
  },
  /* 148 */
  {
    {0x03, 2, 1},
    {0x06, 2, 1},
    {0x0a, 2, 1},
    {0x0f, 2, 1},
    {0x18, 2, 1},
    {0x1f, 2, 1},
    {0x29, 2, 1},
    {0x38, 3, 1},
    {0x03, 2, 135},
    {0x06, 2, 135},
    {0x0a, 2, 135},
    {0x0f, 2, 135},
    {0x18, 2, 135},
    {0x1f, 2, 135},
    {0x29, 2, 135},
    {0x38, 3, 135},
  },
  /* 149 */
  {
    {0x03, 2, 137},
    {0x06, 2, 137},
    {0x0a, 2, 137},
    {0x0f, 2, 137},
    {0x18, 2, 137},
    {0x1f, 2, 137},
    {0x29, 2, 137},
    {0x38, 3, 137},
    {0x03, 2, 138},
    {0x06, 2, 138},
    {0x0a, 2, 138},
    {0x0f, 2, 138},
    {0x18, 2, 138},
    {0x1f, 2, 138},
    {0x29, 2, 138},
    {0x38, 3, 138},
  },
  /* 150 */
  {
    {0x02, 2, 139},
    {0x09, 2, 139},
    {0x17, 2, 139},
    {0x28, 3, 139},
    {0x02, 2, 140},
    {0x09, 2, 140},
    {0x17, 2, 140},
    {0x28, 3, 140},
    {0x02, 2, 141},
    {0x09, 2, 141},
    {0x17, 2, 141},
    {0x28, 3, 141},
    {0x02, 2, 143},
    {0x09, 2, 143},
    {0x17, 2, 143},
    {0x28, 3, 143},
  },
  /* 151 */
  {
    {0x03, 2, 139},
    {0x06, 2, 139},
    {0x0a, 2, 139},
    {0x0f, 2, 139},
    {0x18, 2, 139},
    {0x1f, 2, 139},
    {0x29, 2, 139},
    {0x38, 3, 139},
    {0x03, 2, 140},
    {0x06, 2, 140},
    {0x0a, 2, 140},
    {0x0f, 2, 140},
    {0x18, 2, 140},
    {0x1f, 2, 140},
    {0x29, 2, 140},
    {0x38, 3, 140},
  },
  /* 152 */
  {
    {0x03, 2, 141},
    {0x06, 2, 141},
    {0x0a, 2, 141},
    {0x0f, 2, 141},
    {0x18, 2, 141},
    {0x1f, 2, 141},
    {0x29, 2, 141},
    {0x38, 3, 141},
    {0x03, 2, 143},
    {0x06, 2, 143},
    {0x0a, 2, 143},
    {0x0f, 2, 143},
    {0x18, 2, 143},
    {0x1f, 2, 143},
    {0x29, 2, 143},
    {0x38, 3, 143},
  },
  /* 153 */
  {
    {0x9d, 0, 0},
    {0x9e, 0, 0},
    {0xa0, 0, 0},
    {0xa1, 0, 0},
    {0xa4, 0, 0},
    {0xa5, 0, 0},
    {0xa7, 0, 0},
    {0xa8, 0, 0},
    {0xac, 0, 0},
    {0xad, 0, 0},
    {0xaf, 0, 0},
    {0xb1, 0, 0},
    {0xb6, 0, 0},
    {0xb9, 0, 0},
    {0xbf, 0, 0},
    {0xcf, 0, 0},
  },
  /* 154 */
  {
    {0x00, 3, 147},
    {0x00, 3, 149},
    {0x00, 3, 150},
    {0x00, 3, 151},
    {0x00, 3, 152},
    {0x00, 3, 155},
    {0x00, 3, 157},
    {0x00, 3, 158},
    {0x00, 3, 165},
    {0x00, 3, 166},
    {0x00, 3, 168},
    {0x00, 3, 174},
    {0x00, 3, 175},
    {0x00, 3, 180},
    {0x00, 3, 182},
    {0x00, 3, 183},
  },
  /* 155 */
  {
    {0x01, 2, 147},
    {0x16, 3, 147},
    {0x01, 2, 149},
    {0x16, 3, 149},
    {0x01, 2, 150},
    {0x16, 3, 150},
    {0x01, 2, 151},
    {0x16, 3, 151},
    {0x01, 2, 152},
    {0x16, 3, 152},
    {0x01, 2, 155},
    {0x16, 3, 155},
    {0x01, 2, 157},
    {0x16, 3, 157},
    {0x01, 2, 158},
    {0x16, 3, 158},
  },
  /* 156 */
  {
    {0x02, 2, 147},
    {0x09, 2, 147},
    {0x17, 2, 147},
    {0x28, 3, 147},
    {0x02, 2, 149},
    {0x09, 2, 149},
    {0x17, 2, 149},
    {0x28, 3, 149},
    {0x02, 2, 150},
    {0x09, 2, 150},
    {0x17, 2, 150},
    {0x28, 3, 150},
    {0x02, 2, 151},
    {0x09, 2, 151},
    {0x17, 2, 151},
    {0x28, 3, 151},
  },
  /* 157 */
  {
    {0x03, 2, 147},
    {0x06, 2, 147},
    {0x0a, 2, 147},
    {0x0f, 2, 147},
    {0x18, 2, 147},
    {0x1f, 2, 147},
    {0x29, 2, 147},
    {0x38, 3, 147},
    {0x03, 2, 149},
    {0x06, 2, 149},
    {0x0a, 2, 149},
    {0x0f, 2, 149},
    {0x18, 2, 149},
    {0x1f, 2, 149},
    {0x29, 2, 149},
    {0x38, 3, 149},
  },
  /* 158 */
  {
    {0x03, 2, 150},
    {0x06, 2, 150},
    {0x0a, 2, 150},
    {0x0f, 2, 150},
    {0x18, 2, 150},
    {0x1f, 2, 150},
    {0x29, 2, 150},
    {0x38, 3, 150},
    {0x03, 2, 151},
    {0x06, 2, 151},
    {0x0a, 2, 151},
    {0x0f, 2, 151},
    {0x18, 2, 151},
    {0x1f, 2, 151},
    {0x29, 2, 151},
    {0x38, 3, 151},
  },
  /* 159 */
  {
    {0x02, 2, 152},
    {0x09, 2, 152},
    {0x17, 2, 152},
    {0x28, 3, 152},
    {0x02, 2, 155},
    {0x09, 2, 155},
    {0x17, 2, 155},
    {0x28, 3, 155},
    {0x02, 2, 157},
    {0x09, 2, 157},
    {0x17, 2, 157},
    {0x28, 3, 157},
    {0x02, 2, 158},
    {0x09, 2, 158},
    {0x17, 2, 158},
    {0x28, 3, 158},
  },
  /* 160 */
  {
    {0x03, 2, 152},
    {0x06, 2, 152},
    {0x0a, 2, 152},
    {0x0f, 2, 152},
    {0x18, 2, 152},
    {0x1f, 2, 152},
    {0x29, 2, 152},
    {0x38, 3, 152},
    {0x03, 2, 155},
    {0x06, 2, 155},
    {0x0a, 2, 155},
    {0x0f, 2, 155},
    {0x18, 2, 155},
    {0x1f, 2, 155},
    {0x29, 2, 155},
    {0x38, 3, 155},
  },
  /* 161 */
  {
    {0x03, 2, 157},
    {0x06, 2, 157},
    {0x0a, 2, 157},
    {0x0f, 2, 157},
    {0x18, 2, 157},
    {0x1f, 2, 157},
    {0x29, 2, 157},
    {0x38, 3, 157},
    {0x03, 2, 158},
    {0x06, 2, 158},
    {0x0a, 2, 158},
    {0x0f, 2, 158},
    {0x18, 2, 158},
    {0x1f, 2, 158},
    {0x29, 2, 158},
    {0x38, 3, 158},
  },
  /* 162 */
  {
    {0x01, 2, 165},
    {0x16, 3, 165},
    {0x01, 2, 166},
    {0x16, 3, 166},
    {0x01, 2, 168},
    {0x16, 3, 168},
    {0x01, 2, 174},
    {0x16, 3, 174},
    {0x01, 2, 175},
    {0x16, 3, 175},
    {0x01, 2, 180},
    {0x16, 3, 180},
    {0x01, 2, 182},
    {0x16, 3, 182},
    {0x01, 2, 183},
    {0x16, 3, 183},
  },
  /* 163 */
  {
    {0x02, 2, 165},
    {0x09, 2, 165},
    {0x17, 2, 165},
    {0x28, 3, 165},
    {0x02, 2, 166},
    {0x09, 2, 166},
    {0x17, 2, 166},
    {0x28, 3, 166},
    {0x02, 2, 168},
    {0x09, 2, 168},
    {0x17, 2, 168},
    {0x28, 3, 168},
    {0x02, 2, 174},
    {0x09, 2, 174},
    {0x17, 2, 174},
    {0x28, 3, 174},
  },
  /* 164 */
  {
    {0x03, 2, 165},
    {0x06, 2, 165},
    {0x0a, 2, 165},
    {0x0f, 2, 165},
    {0x18, 2, 165},
    {0x1f, 2, 165},
    {0x29, 2, 165},
    {0x38, 3, 165},
    {0x03, 2, 166},
    {0x06, 2, 166},
    {0x0a, 2, 166},
    {0x0f, 2, 166},
    {0x18, 2, 166},
    {0x1f, 2, 166},
    {0x29, 2, 166},
    {0x38, 3, 166},
  },
  /* 165 */
  {
    {0x03, 2, 168},
    {0x06, 2, 168},
    {0x0a, 2, 168},
    {0x0f, 2, 168},
    {0x18, 2, 168},
    {0x1f, 2, 168},
    {0x29, 2, 168},
    {0x38, 3, 168},
    {0x03, 2, 174},
    {0x06, 2, 174},
    {0x0a, 2, 174},
    {0x0f, 2, 174},
    {0x18, 2, 174},
    {0x1f, 2, 174},
    {0x29, 2, 174},
    {0x38, 3, 174},
  },
  /* 166 */
  {
    {0x02, 2, 175},
    {0x09, 2, 175},
    {0x17, 2, 175},
    {0x28, 3, 175},
    {0x02, 2, 180},
    {0x09, 2, 180},
    {0x17, 2, 180},
    {0x28, 3, 180},
    {0x02, 2, 182},
    {0x09, 2, 182},
    {0x17, 2, 182},
    {0x28, 3, 182},
    {0x02, 2, 183},
    {0x09, 2, 183},
    {0x17, 2, 183},
    {0x28, 3, 183},
  },
  /* 167 */
  {
    {0x03, 2, 175},
    {0x06, 2, 175},
    {0x0a, 2, 175},
    {0x0f, 2, 175},
    {0x18, 2, 175},
    {0x1f, 2, 175},
    {0x29, 2, 175},
    {0x38, 3, 175},
    {0x03, 2, 180},
    {0x06, 2, 180},
    {0x0a, 2, 180},
    {0x0f, 2, 180},
    {0x18, 2, 180},
    {0x1f, 2, 180},
    {0x29, 2, 180},
    {0x38, 3, 180},
  },
  /* 168 */
  {
    {0x03, 2, 182},
    {0x06, 2, 182},
    {0x0a, 2, 182},
    {0x0f, 2, 182},
    {0x18, 2, 182},
    {0x1f, 2, 182},
    {0x29, 2, 182},
    {0x38, 3, 182},
    {0x03, 2, 183},
    {0x06, 2, 183},
    {0x0a, 2, 183},
    {0x0f, 2, 183},
    {0x18, 2, 183},
    {0x1f, 2, 183},
    {0x29, 2, 183},
    {0x38, 3, 183},
  },
  /* 169 */
  {
    {0x00, 3, 188},
    {0x00, 3, 191},
    {0x00, 3, 197},
    {0x00, 3, 231},
    {0x00, 3, 239},
    {0xb0, 0, 0},
    {0xb2, 0, 0},
    {0xb3, 0, 0},
    {0xb7, 0, 0},
    {0xb8, 0, 0},
    {0xba, 0, 0},
    {0xbb, 0, 0},
    {0xc0, 0, 0},
    {0xc7, 0, 0},
    {0xd0, 0, 0},
    {0xdf, 0, 0},
  },
  /* 170 */
  {
    {0x01, 2, 188},
    {0x16, 3, 188},
    {0x01, 2, 191},
    {0x16, 3, 191},
    {0x01, 2, 197},
    {0x16, 3, 197},
    {0x01, 2, 231},
    {0x16, 3, 231},
    {0x01, 2, 239},
    {0x16, 3, 239},
    {0x00, 3, 9},
    {0x00, 3, 142},
    {0x00, 3, 144},
    {0x00, 3, 145},
    {0x00, 3, 148},
    {0x00, 3, 159},
  },
  /* 171 */
  {
    {0x02, 2, 188},
    {0x09, 2, 188},
    {0x17, 2, 188},
    {0x28, 3, 188},
    {0x02, 2, 191},
    {0x09, 2, 191},
    {0x17, 2, 191},
    {0x28, 3, 191},
    {0x02, 2, 197},
    {0x09, 2, 197},
    {0x17, 2, 197},
    {0x28, 3, 197},
    {0x02, 2, 231},
    {0x09, 2, 231},
    {0x17, 2, 231},
    {0x28, 3, 231},
  },
  /* 172 */
  {
    {0x03, 2, 188},
    {0x06, 2, 188},
    {0x0a, 2, 188},
    {0x0f, 2, 188},
    {0x18, 2, 188},
    {0x1f, 2, 188},
    {0x29, 2, 188},
    {0x38, 3, 188},
    {0x03, 2, 191},
    {0x06, 2, 191},
    {0x0a, 2, 191},
    {0x0f, 2, 191},
    {0x18, 2, 191},
    {0x1f, 2, 191},
    {0x29, 2, 191},
    {0x38, 3, 191},
  },
  /* 173 */
  {
    {0x03, 2, 197},
    {0x06, 2, 197},
    {0x0a, 2, 197},
    {0x0f, 2, 197},
    {0x18, 2, 197},
    {0x1f, 2, 197},
    {0x29, 2, 197},
    {0x38, 3, 197},
    {0x03, 2, 231},
    {0x06, 2, 231},
    {0x0a, 2, 231},
    {0x0f, 2, 231},
    {0x18, 2, 231},
    {0x1f, 2, 231},
    {0x29, 2, 231},
    {0x38, 3, 231},
  },
  /* 174 */
  {
    {0x02, 2, 239},
    {0x09, 2, 239},
    {0x17, 2, 239},
    {0x28, 3, 239},
    {0x01, 2, 9},
    {0x16, 3, 9},
    {0x01, 2, 142},
    {0x16, 3, 142},
    {0x01, 2, 144},
    {0x16, 3, 144},
    {0x01, 2, 145},
    {0x16, 3, 145},
    {0x01, 2, 148},
    {0x16, 3, 148},
    {0x01, 2, 159},
    {0x16, 3, 159},
  },
  /* 175 */
  {
    {0x03, 2, 239},
    {0x06, 2, 239},
    {0x0a, 2, 239},
    {0x0f, 2, 239},
    {0x18, 2, 239},
    {0x1f, 2, 239},
    {0x29, 2, 239},
    {0x38, 3, 239},
    {0x02, 2, 9},
    {0x09, 2, 9},
    {0x17, 2, 9},
    {0x28, 3, 9},
    {0x02, 2, 142},
    {0x09, 2, 142},
    {0x17, 2, 142},
    {0x28, 3, 142},
  },
  /* 176 */
  {
    {0x03, 2, 9},
    {0x06, 2, 9},
    {0x0a, 2, 9},
    {0x0f, 2, 9},
    {0x18, 2, 9},
    {0x1f, 2, 9},
    {0x29, 2, 9},
    {0x38, 3, 9},
    {0x03, 2, 142},
    {0x06, 2, 142},
    {0x0a, 2, 142},
    {0x0f, 2, 142},
    {0x18, 2, 142},
    {0x1f, 2, 142},
    {0x29, 2, 142},
    {0x38, 3, 142},
  },
  /* 177 */
  {
    {0x02, 2, 144},
    {0x09, 2, 144},
    {0x17, 2, 144},
    {0x28, 3, 144},
    {0x02, 2, 145},
    {0x09, 2, 145},
    {0x17, 2, 145},
    {0x28, 3, 145},
    {0x02, 2, 148},
    {0x09, 2, 148},
    {0x17, 2, 148},
    {0x28, 3, 148},
    {0x02, 2, 159},
    {0x09, 2, 159},
    {0x17, 2, 159},
    {0x28, 3, 159},
  },
  /* 178 */
  {
    {0x03, 2, 144},
    {0x06, 2, 144},
    {0x0a, 2, 144},
    {0x0f, 2, 144},
    {0x18, 2, 144},
    {0x1f, 2, 144},
    {0x29, 2, 144},
    {0x38, 3, 144},
    {0x03, 2, 145},
    {0x06, 2, 145},
    {0x0a, 2, 145},
    {0x0f, 2, 145},
    {0x18, 2, 145},
    {0x1f, 2, 145},
    {0x29, 2, 145},
    {0x38, 3, 145},
  },
  /* 179 */
  {
    {0x03, 2, 148},
    {0x06, 2, 148},
    {0x0a, 2, 148},
    {0x0f, 2, 148},
    {0x18, 2, 148},
    {0x1f, 2, 148},
    {0x29, 2, 148},
    {0x38, 3, 148},
    {0x03, 2, 159},
    {0x06, 2, 159},
    {0x0a, 2, 159},
    {0x0f, 2, 159},
    {0x18, 2, 159},
    {0x1f, 2, 159},
    {0x29, 2, 159},
    {0x38, 3, 159},
  },
  /* 180 */
  {
    {0x00, 3, 171},
    {0x00, 3, 206},
    {0x00, 3, 215},
    {0x00, 3, 225},
    {0x00, 3, 236},
    {0x00, 3, 237},
    {0xbc, 0, 0},
    {0xbd, 0, 0},
    {0xc1, 0, 0},
    {0xc4, 0, 0},
    {0xc8, 0, 0},
    {0xcb, 0, 0},
    {0xd1, 0, 0},
    {0xd8, 0, 0},
    {0xe0, 0, 0},
    {0xee, 0, 0},
  },
  /* 181 */
  {
    {0x01, 2, 171},
    {0x16, 3, 171},
    {0x01, 2, 206},
    {0x16, 3, 206},
    {0x01, 2, 215},
    {0x16, 3, 215},
    {0x01, 2, 225},
    {0x16, 3, 225},
    {0x01, 2, 236},
    {0x16, 3, 236},
    {0x01, 2, 237},
    {0x16, 3, 237},
    {0x00, 3, 199},
    {0x00, 3, 207},
    {0x00, 3, 234},
    {0x00, 3, 235},
  },
  /* 182 */
  {
    {0x02, 2, 171},
    {0x09, 2, 171},
    {0x17, 2, 171},
    {0x28, 3, 171},
    {0x02, 2, 206},
    {0x09, 2, 206},
    {0x17, 2, 206},
    {0x28, 3, 206},
    {0x02, 2, 215},
    {0x09, 2, 215},
    {0x17, 2, 215},
    {0x28, 3, 215},
    {0x02, 2, 225},
    {0x09, 2, 225},
    {0x17, 2, 225},
    {0x28, 3, 225},
  },
  /* 183 */
  {
    {0x03, 2, 171},
    {0x06, 2, 171},
    {0x0a, 2, 171},
    {0x0f, 2, 171},
    {0x18, 2, 171},
    {0x1f, 2, 171},
    {0x29, 2, 171},
    {0x38, 3, 171},
    {0x03, 2, 206},
    {0x06, 2, 206},
    {0x0a, 2, 206},
    {0x0f, 2, 206},
    {0x18, 2, 206},
    {0x1f, 2, 206},
    {0x29, 2, 206},
    {0x38, 3, 206},
  },
  /* 184 */
  {
    {0x03, 2, 215},
    {0x06, 2, 215},
    {0x0a, 2, 215},
    {0x0f, 2, 215},
    {0x18, 2, 215},
    {0x1f, 2, 215},
    {0x29, 2, 215},
    {0x38, 3, 215},
    {0x03, 2, 225},
    {0x06, 2, 225},
    {0x0a, 2, 225},
    {0x0f, 2, 225},
    {0x18, 2, 225},
    {0x1f, 2, 225},
    {0x29, 2, 225},
    {0x38, 3, 225},
  },
  /* 185 */
  {
    {0x02, 2, 236},
    {0x09, 2, 236},
    {0x17, 2, 236},
    {0x28, 3, 236},
    {0x02, 2, 237},
    {0x09, 2, 237},
    {0x17, 2, 237},
    {0x28, 3, 237},
    {0x01, 2, 199},
    {0x16, 3, 199},
    {0x01, 2, 207},
    {0x16, 3, 207},
    {0x01, 2, 234},
    {0x16, 3, 234},
    {0x01, 2, 235},
    {0x16, 3, 235},
  },
  /* 186 */
  {
    {0x03, 2, 236},
    {0x06, 2, 236},
    {0x0a, 2, 236},
    {0x0f, 2, 236},
    {0x18, 2, 236},
    {0x1f, 2, 236},
    {0x29, 2, 236},
    {0x38, 3, 236},
    {0x03, 2, 237},
    {0x06, 2, 237},
    {0x0a, 2, 237},
    {0x0f, 2, 237},
    {0x18, 2, 237},
    {0x1f, 2, 237},
    {0x29, 2, 237},
    {0x38, 3, 237},
  },
  /* 187 */
  {
    {0x02, 2, 199},
    {0x09, 2, 199},
    {0x17, 2, 199},
    {0x28, 3, 199},
    {0x02, 2, 207},
    {0x09, 2, 207},
    {0x17, 2, 207},
    {0x28, 3, 207},
    {0x02, 2, 234},
    {0x09, 2, 234},
    {0x17, 2, 234},
    {0x28, 3, 234},
    {0x02, 2, 235},
    {0x09, 2, 235},
    {0x17, 2, 235},
    {0x28, 3, 235},
  },
  /* 188 */
  {
    {0x03, 2, 199},
    {0x06, 2, 199},
    {0x0a, 2, 199},
    {0x0f, 2, 199},
    {0x18, 2, 199},
    {0x1f, 2, 199},
    {0x29, 2, 199},
    {0x38, 3, 199},
    {0x03, 2, 207},
    {0x06, 2, 207},
    {0x0a, 2, 207},
    {0x0f, 2, 207},
    {0x18, 2, 207},
    {0x1f, 2, 207},
    {0x29, 2, 207},
    {0x38, 3, 207},
  },
  /* 189 */
  {
    {0x03, 2, 234},
    {0x06, 2, 234},
    {0x0a, 2, 234},
    {0x0f, 2, 234},
    {0x18, 2, 234},
    {0x1f, 2, 234},
    {0x29, 2, 234},
    {0x38, 3, 234},
    {0x03, 2, 235},
    {0x06, 2, 235},
    {0x0a, 2, 235},
    {0x0f, 2, 235},
    {0x18, 2, 235},
    {0x1f, 2, 235},
    {0x29, 2, 235},
    {0x38, 3, 235},
  },
  /* 190 */
  {
    {0xc2, 0, 0},
    {0xc3, 0, 0},
    {0xc5, 0, 0},
    {0xc6, 0, 0},
    {0xc9, 0, 0},
    {0xca, 0, 0},
    {0xcc, 0, 0},
    {0xcd, 0, 0},
    {0xd2, 0, 0},
    {0xd5, 0, 0},
    {0xd9, 0, 0},
    {0xdc, 0, 0},
    {0xe1, 0, 0},
    {0xe7, 0, 0},
    {0xef, 0, 0},
    {0xf6, 0, 0},
  },
  /* 191 */
  {
    {0x00, 3, 192},
    {0x00, 3, 193},
    {0x00, 3, 200},
    {0x00, 3, 201},
    {0x00, 3, 202},
    {0x00, 3, 205},
    {0x00, 3, 210},
    {0x00, 3, 213},
    {0x00, 3, 218},
    {0x00, 3, 219},
    {0x00, 3, 238},
    {0x00, 3, 240},
    {0x00, 3, 242},
    {0x00, 3, 243},
    {0x00, 3, 255},
    {0xce, 0, 0},
  },
  /* 192 */
  {
    {0x01, 2, 192},
    {0x16, 3, 192},
    {0x01, 2, 193},
    {0x16, 3, 193},
    {0x01, 2, 200},
    {0x16, 3, 200},
    {0x01, 2, 201},
    {0x16, 3, 201},
    {0x01, 2, 202},
    {0x16, 3, 202},
    {0x01, 2, 205},
    {0x16, 3, 205},
    {0x01, 2, 210},
    {0x16, 3, 210},
    {0x01, 2, 213},
    {0x16, 3, 213},
  },
  /* 193 */
  {
    {0x02, 2, 192},
    {0x09, 2, 192},
    {0x17, 2, 192},
    {0x28, 3, 192},
    {0x02, 2, 193},
    {0x09, 2, 193},
    {0x17, 2, 193},
    {0x28, 3, 193},
    {0x02, 2, 200},
    {0x09, 2, 200},
    {0x17, 2, 200},
    {0x28, 3, 200},
    {0x02, 2, 201},
    {0x09, 2, 201},
    {0x17, 2, 201},
    {0x28, 3, 201},
  },
  /* 194 */
  {
    {0x03, 2, 192},
    {0x06, 2, 192},
    {0x0a, 2, 192},
    {0x0f, 2, 192},
    {0x18, 2, 192},
    {0x1f, 2, 192},
    {0x29, 2, 192},
    {0x38, 3, 192},
    {0x03, 2, 193},
    {0x06, 2, 193},
    {0x0a, 2, 193},
    {0x0f, 2, 193},
    {0x18, 2, 193},
    {0x1f, 2, 193},
    {0x29, 2, 193},
    {0x38, 3, 193},
  },
  /* 195 */
  {
    {0x03, 2, 200},
    {0x06, 2, 200},
    {0x0a, 2, 200},
    {0x0f, 2, 200},
    {0x18, 2, 200},
    {0x1f, 2, 200},
    {0x29, 2, 200},
    {0x38, 3, 200},
    {0x03, 2, 201},
    {0x06, 2, 201},
    {0x0a, 2, 201},
    {0x0f, 2, 201},
    {0x18, 2, 201},
    {0x1f, 2, 201},
    {0x29, 2, 201},
    {0x38, 3, 201},
  },
  /* 196 */
  {
    {0x02, 2, 202},
    {0x09, 2, 202},
    {0x17, 2, 202},
    {0x28, 3, 202},
    {0x02, 2, 205},
    {0x09, 2, 205},
    {0x17, 2, 205},
    {0x28, 3, 205},
    {0x02, 2, 210},
    {0x09, 2, 210},
    {0x17, 2, 210},
    {0x28, 3, 210},
    {0x02, 2, 213},
    {0x09, 2, 213},
    {0x17, 2, 213},
    {0x28, 3, 213},
  },
  /* 197 */
  {
    {0x03, 2, 202},
    {0x06, 2, 202},
    {0x0a, 2, 202},
    {0x0f, 2, 202},
    {0x18, 2, 202},
    {0x1f, 2, 202},
    {0x29, 2, 202},
    {0x38, 3, 202},
    {0x03, 2, 205},
    {0x06, 2, 205},
    {0x0a, 2, 205},
    {0x0f, 2, 205},
    {0x18, 2, 205},
    {0x1f, 2, 205},
    {0x29, 2, 205},
    {0x38, 3, 205},
  },
  /* 198 */
  {
    {0x03, 2, 210},
    {0x06, 2, 210},
    {0x0a, 2, 210},
    {0x0f, 2, 210},
    {0x18, 2, 210},
    {0x1f, 2, 210},
    {0x29, 2, 210},
    {0x38, 3, 210},
    {0x03, 2, 213},
    {0x06, 2, 213},
    {0x0a, 2, 213},
    {0x0f, 2, 213},
    {0x18, 2, 213},
    {0x1f, 2, 213},
    {0x29, 2, 213},
    {0x38, 3, 213},
  },
  /* 199 */
  {
    {0x01, 2, 218},
    {0x16, 3, 218},
    {0x01, 2, 219},
    {0x16, 3, 219},
    {0x01, 2, 238},
    {0x16, 3, 238},
    {0x01, 2, 240},
    {0x16, 3, 240},
    {0x01, 2, 242},
    {0x16, 3, 242},
    {0x01, 2, 243},
    {0x16, 3, 243},
    {0x01, 2, 255},
    {0x16, 3, 255},
    {0x00, 3, 203},
    {0x00, 3, 204},
  },
  /* 200 */
  {
    {0x02, 2, 218},
    {0x09, 2, 218},
    {0x17, 2, 218},
    {0x28, 3, 218},
    {0x02, 2, 219},
    {0x09, 2, 219},
    {0x17, 2, 219},
    {0x28, 3, 219},
    {0x02, 2, 238},
    {0x09, 2, 238},
    {0x17, 2, 238},
    {0x28, 3, 238},
    {0x02, 2, 240},
    {0x09, 2, 240},
    {0x17, 2, 240},
    {0x28, 3, 240},
  },
  /* 201 */
  {
    {0x03, 2, 218},
    {0x06, 2, 218},
    {0x0a, 2, 218},
    {0x0f, 2, 218},
    {0x18, 2, 218},
    {0x1f, 2, 218},
    {0x29, 2, 218},
    {0x38, 3, 218},
    {0x03, 2, 219},
    {0x06, 2, 219},
    {0x0a, 2, 219},
    {0x0f, 2, 219},
    {0x18, 2, 219},
    {0x1f, 2, 219},
    {0x29, 2, 219},
    {0x38, 3, 219},
  },
  /* 202 */
  {
    {0x03, 2, 238},
    {0x06, 2, 238},
    {0x0a, 2, 238},
    {0x0f, 2, 238},
    {0x18, 2, 238},
    {0x1f, 2, 238},
    {0x29, 2, 238},
    {0x38, 3, 238},
    {0x03, 2, 240},
    {0x06, 2, 240},
    {0x0a, 2, 240},
    {0x0f, 2, 240},
    {0x18, 2, 240},
    {0x1f, 2, 240},
    {0x29, 2, 240},
    {0x38, 3, 240},
  },
  /* 203 */
  {
    {0x02, 2, 242},
    {0x09, 2, 242},
    {0x17, 2, 242},
    {0x28, 3, 242},
    {0x02, 2, 243},
    {0x09, 2, 243},
    {0x17, 2, 243},
    {0x28, 3, 243},
    {0x02, 2, 255},
    {0x09, 2, 255},
    {0x17, 2, 255},
    {0x28, 3, 255},
    {0x01, 2, 203},
    {0x16, 3, 203},
    {0x01, 2, 204},
    {0x16, 3, 204},
  },
  /* 204 */
  {
    {0x03, 2, 242},
    {0x06, 2, 242},
    {0x0a, 2, 242},
    {0x0f, 2, 242},
    {0x18, 2, 242},
    {0x1f, 2, 242},
    {0x29, 2, 242},
    {0x38, 3, 242},
    {0x03, 2, 243},
    {0x06, 2, 243},
    {0x0a, 2, 243},
    {0x0f, 2, 243},
    {0x18, 2, 243},
    {0x1f, 2, 243},
    {0x29, 2, 243},
    {0x38, 3, 243},
  },
  /* 205 */
  {
    {0x03, 2, 255},
    {0x06, 2, 255},
    {0x0a, 2, 255},
    {0x0f, 2, 255},
    {0x18, 2, 255},
    {0x1f, 2, 255},
    {0x29, 2, 255},
    {0x38, 3, 255},
    {0x02, 2, 203},
    {0x09, 2, 203},
    {0x17, 2, 203},
    {0x28, 3, 203},
    {0x02, 2, 204},
    {0x09, 2, 204},
    {0x17, 2, 204},
    {0x28, 3, 204},
  },
  /* 206 */
  {
    {0x03, 2, 203},
    {0x06, 2, 203},
    {0x0a, 2, 203},
    {0x0f, 2, 203},
    {0x18, 2, 203},
    {0x1f, 2, 203},
    {0x29, 2, 203},
    {0x38, 3, 203},
    {0x03, 2, 204},
    {0x06, 2, 204},
    {0x0a, 2, 204},
    {0x0f, 2, 204},
    {0x18, 2, 204},
    {0x1f, 2, 204},
    {0x29, 2, 204},
    {0x38, 3, 204},
  },
  /* 207 */
  {
    {0xd3, 0, 0},
    {0xd4, 0, 0},
    {0xd6, 0, 0},
    {0xd7, 0, 0},
    {0xda, 0, 0},
    {0xdb, 0, 0},
    {0xdd, 0, 0},
    {0xde, 0, 0},
    {0xe2, 0, 0},
    {0xe4, 0, 0},
    {0xe8, 0, 0},
    {0xeb, 0, 0},
    {0xf0, 0, 0},
    {0xf3, 0, 0},
    {0xf7, 0, 0},
    {0xfa, 0, 0},
  },
  /* 208 */
  {
    {0x00, 3, 211},
    {0x00, 3, 212},
    {0x00, 3, 214},
    {0x00, 3, 221},
    {0x00, 3, 222},
    {0x00, 3, 223},
    {0x00, 3, 241},
    {0x00, 3, 244},
    {0x00, 3, 245},
    {0x00, 3, 246},
    {0x00, 3, 247},
    {0x00, 3, 248},
    {0x00, 3, 250},
    {0x00, 3, 251},
    {0x00, 3, 252},
    {0x00, 3, 253},
  },
  /* 209 */
  {
    {0x01, 2, 211},
    {0x16, 3, 211},
    {0x01, 2, 212},
    {0x16, 3, 212},
    {0x01, 2, 214},
    {0x16, 3, 214},
    {0x01, 2, 221},
    {0x16, 3, 221},
    {0x01, 2, 222},
    {0x16, 3, 222},
    {0x01, 2, 223},
    {0x16, 3, 223},
    {0x01, 2, 241},
    {0x16, 3, 241},
    {0x01, 2, 244},
    {0x16, 3, 244},
  },
  /* 210 */
  {
    {0x02, 2, 211},
    {0x09, 2, 211},
    {0x17, 2, 211},
    {0x28, 3, 211},
    {0x02, 2, 212},
    {0x09, 2, 212},
    {0x17, 2, 212},
    {0x28, 3, 212},
    {0x02, 2, 214},
    {0x09, 2, 214},
    {0x17, 2, 214},
    {0x28, 3, 214},
    {0x02, 2, 221},
    {0x09, 2, 221},
    {0x17, 2, 221},
    {0x28, 3, 221},
  },
  /* 211 */
  {
    {0x03, 2, 211},
    {0x06, 2, 211},
    {0x0a, 2, 211},
    {0x0f, 2, 211},
    {0x18, 2, 211},
    {0x1f, 2, 211},
    {0x29, 2, 211},
    {0x38, 3, 211},
    {0x03, 2, 212},
    {0x06, 2, 212},
    {0x0a, 2, 212},
    {0x0f, 2, 212},
    {0x18, 2, 212},
    {0x1f, 2, 212},
    {0x29, 2, 212},
    {0x38, 3, 212},
  },
  /* 212 */
  {
    {0x03, 2, 214},
    {0x06, 2, 214},
    {0x0a, 2, 214},
    {0x0f, 2, 214},
    {0x18, 2, 214},
    {0x1f, 2, 214},
    {0x29, 2, 214},
    {0x38, 3, 214},
    {0x03, 2, 221},
    {0x06, 2, 221},
    {0x0a, 2, 221},
    {0x0f, 2, 221},
    {0x18, 2, 221},
    {0x1f, 2, 221},
    {0x29, 2, 221},
    {0x38, 3, 221},
  },
  /* 213 */
  {
    {0x02, 2, 222},
    {0x09, 2, 222},
    {0x17, 2, 222},
    {0x28, 3, 222},
    {0x02, 2, 223},
    {0x09, 2, 223},
    {0x17, 2, 223},
    {0x28, 3, 223},
    {0x02, 2, 241},
    {0x09, 2, 241},
    {0x17, 2, 241},
    {0x28, 3, 241},
    {0x02, 2, 244},
    {0x09, 2, 244},
    {0x17, 2, 244},
    {0x28, 3, 244},
  },
  /* 214 */
  {
    {0x03, 2, 222},
    {0x06, 2, 222},
    {0x0a, 2, 222},
    {0x0f, 2, 222},
    {0x18, 2, 222},
    {0x1f, 2, 222},
    {0x29, 2, 222},
    {0x38, 3, 222},
    {0x03, 2, 223},
    {0x06, 2, 223},
    {0x0a, 2, 223},
    {0x0f, 2, 223},
    {0x18, 2, 223},
    {0x1f, 2, 223},
    {0x29, 2, 223},
    {0x38, 3, 223},
  },
  /* 215 */
  {
    {0x03, 2, 241},
    {0x06, 2, 241},
    {0x0a, 2, 241},
    {0x0f, 2, 241},
    {0x18, 2, 241},
    {0x1f, 2, 241},
    {0x29, 2, 241},
    {0x38, 3, 241},
    {0x03, 2, 244},
    {0x06, 2, 244},
    {0x0a, 2, 244},
    {0x0f, 2, 244},
    {0x18, 2, 244},
    {0x1f, 2, 244},
    {0x29, 2, 244},
    {0x38, 3, 244},
  },
  /* 216 */
  {
    {0x01, 2, 245},
    {0x16, 3, 245},
    {0x01, 2, 246},
    {0x16, 3, 246},
    {0x01, 2, 247},
    {0x16, 3, 247},
    {0x01, 2, 248},
    {0x16, 3, 248},
    {0x01, 2, 250},
    {0x16, 3, 250},
    {0x01, 2, 251},
    {0x16, 3, 251},
    {0x01, 2, 252},
    {0x16, 3, 252},
    {0x01, 2, 253},
    {0x16, 3, 253},
  },
  /* 217 */
  {
    {0x02, 2, 245},
    {0x09, 2, 245},
    {0x17, 2, 245},
    {0x28, 3, 245},
    {0x02, 2, 246},
    {0x09, 2, 246},
    {0x17, 2, 246},
    {0x28, 3, 246},
    {0x02, 2, 247},
    {0x09, 2, 247},
    {0x17, 2, 247},
    {0x28, 3, 247},
    {0x02, 2, 248},
    {0x09, 2, 248},
    {0x17, 2, 248},
    {0x28, 3, 248},
  },
  /* 218 */
  {
    {0x03, 2, 245},
    {0x06, 2, 245},
    {0x0a, 2, 245},
    {0x0f, 2, 245},
    {0x18, 2, 245},
    {0x1f, 2, 245},
    {0x29, 2, 245},
    {0x38, 3, 245},
    {0x03, 2, 246},
    {0x06, 2, 246},
    {0x0a, 2, 246},
    {0x0f, 2, 246},
    {0x18, 2, 246},
    {0x1f, 2, 246},
    {0x29, 2, 246},
    {0x38, 3, 246},
  },
  /* 219 */
  {
    {0x03, 2, 247},
    {0x06, 2, 247},
    {0x0a, 2, 247},
    {0x0f, 2, 247},
    {0x18, 2, 247},
    {0x1f, 2, 247},
    {0x29, 2, 247},
    {0x38, 3, 247},
    {0x03, 2, 248},
    {0x06, 2, 248},
    {0x0a, 2, 248},
    {0x0f, 2, 248},
    {0x18, 2, 248},
    {0x1f, 2, 248},
    {0x29, 2, 248},
    {0x38, 3, 248},
  },
  /* 220 */
  {
    {0x02, 2, 250},
    {0x09, 2, 250},
    {0x17, 2, 250},
    {0x28, 3, 250},
    {0x02, 2, 251},
    {0x09, 2, 251},
    {0x17, 2, 251},
    {0x28, 3, 251},
    {0x02, 2, 252},
    {0x09, 2, 252},
    {0x17, 2, 252},
    {0x28, 3, 252},
    {0x02, 2, 253},
    {0x09, 2, 253},
    {0x17, 2, 253},
    {0x28, 3, 253},
  },
  /* 221 */
  {
    {0x03, 2, 250},
    {0x06, 2, 250},
    {0x0a, 2, 250},
    {0x0f, 2, 250},
    {0x18, 2, 250},
    {0x1f, 2, 250},
    {0x29, 2, 250},
    {0x38, 3, 250},
    {0x03, 2, 251},
    {0x06, 2, 251},
    {0x0a, 2, 251},
    {0x0f, 2, 251},
    {0x18, 2, 251},
    {0x1f, 2, 251},
    {0x29, 2, 251},
    {0x38, 3, 251},
  },
  /* 222 */
  {
    {0x03, 2, 252},
    {0x06, 2, 252},
    {0x0a, 2, 252},
    {0x0f, 2, 252},
    {0x18, 2, 252},
    {0x1f, 2, 252},
    {0x29, 2, 252},
    {0x38, 3, 252},
    {0x03, 2, 253},
    {0x06, 2, 253},
    {0x0a, 2, 253},
    {0x0f, 2, 253},
    {0x18, 2, 253},
    {0x1f, 2, 253},
    {0x29, 2, 253},
    {0x38, 3, 253},
  },
  /* 223 */
  {
    {0x00, 3, 254},
    {0xe3, 0, 0},
    {0xe5, 0, 0},
    {0xe6, 0, 0},
    {0xe9, 0, 0},
    {0xea, 0, 0},
    {0xec, 0, 0},
    {0xed, 0, 0},
    {0xf1, 0, 0},
    {0xf2, 0, 0},
    {0xf4, 0, 0},
    {0xf5, 0, 0},
    {0xf8, 0, 0},
    {0xf9, 0, 0},
    {0xfb, 0, 0},
    {0xfc, 0, 0},
  },
  /* 224 */
  {
    {0x01, 2, 254},
    {0x16, 3, 254},
    {0x00, 3, 2},
    {0x00, 3, 3},
    {0x00, 3, 4},
    {0x00, 3, 5},
    {0x00, 3, 6},
    {0x00, 3, 7},
    {0x00, 3, 8},
    {0x00, 3, 11},
    {0x00, 3, 12},
    {0x00, 3, 14},
    {0x00, 3, 15},
    {0x00, 3, 16},
    {0x00, 3, 17},
    {0x00, 3, 18},
  },
  /* 225 */
  {
    {0x02, 2, 254},
    {0x09, 2, 254},
    {0x17, 2, 254},
    {0x28, 3, 254},
    {0x01, 2, 2},
    {0x16, 3, 2},
    {0x01, 2, 3},
    {0x16, 3, 3},
    {0x01, 2, 4},
    {0x16, 3, 4},
    {0x01, 2, 5},
    {0x16, 3, 5},
    {0x01, 2, 6},
    {0x16, 3, 6},
    {0x01, 2, 7},
    {0x16, 3, 7},
  },
  /* 226 */
  {
    {0x03, 2, 254},
    {0x06, 2, 254},
    {0x0a, 2, 254},
    {0x0f, 2, 254},
    {0x18, 2, 254},
    {0x1f, 2, 254},
    {0x29, 2, 254},
    {0x38, 3, 254},
    {0x02, 2, 2},
    {0x09, 2, 2},
    {0x17, 2, 2},
    {0x28, 3, 2},
    {0x02, 2, 3},
    {0x09, 2, 3},
    {0x17, 2, 3},
    {0x28, 3, 3},
  },
  /* 227 */
  {
    {0x03, 2, 2},
    {0x06, 2, 2},
    {0x0a, 2, 2},
    {0x0f, 2, 2},
    {0x18, 2, 2},
    {0x1f, 2, 2},
    {0x29, 2, 2},
    {0x38, 3, 2},
    {0x03, 2, 3},
    {0x06, 2, 3},
    {0x0a, 2, 3},
    {0x0f, 2, 3},
    {0x18, 2, 3},
    {0x1f, 2, 3},
    {0x29, 2, 3},
    {0x38, 3, 3},
  },
  /* 228 */
  {
    {0x02, 2, 4},
    {0x09, 2, 4},
    {0x17, 2, 4},
    {0x28, 3, 4},
    {0x02, 2, 5},
    {0x09, 2, 5},
    {0x17, 2, 5},
    {0x28, 3, 5},
    {0x02, 2, 6},
    {0x09, 2, 6},
    {0x17, 2, 6},
    {0x28, 3, 6},
    {0x02, 2, 7},
    {0x09, 2, 7},
    {0x17, 2, 7},
    {0x28, 3, 7},
  },
  /* 229 */
  {
    {0x03, 2, 4},
    {0x06, 2, 4},
    {0x0a, 2, 4},
    {0x0f, 2, 4},
    {0x18, 2, 4},
    {0x1f, 2, 4},
    {0x29, 2, 4},
    {0x38, 3, 4},
    {0x03, 2, 5},
    {0x06, 2, 5},
    {0x0a, 2, 5},
    {0x0f, 2, 5},
    {0x18, 2, 5},
    {0x1f, 2, 5},
    {0x29, 2, 5},
    {0x38, 3, 5},
  },
  /* 230 */
  {
    {0x03, 2, 6},
    {0x06, 2, 6},
    {0x0a, 2, 6},
    {0x0f, 2, 6},
    {0x18, 2, 6},
    {0x1f, 2, 6},
    {0x29, 2, 6},
    {0x38, 3, 6},
    {0x03, 2, 7},
    {0x06, 2, 7},
    {0x0a, 2, 7},
    {0x0f, 2, 7},
    {0x18, 2, 7},
    {0x1f, 2, 7},
    {0x29, 2, 7},
    {0x38, 3, 7},
  },
  /* 231 */
  {
    {0x01, 2, 8},
    {0x16, 3, 8},
    {0x01, 2, 11},
    {0x16, 3, 11},
    {0x01, 2, 12},
    {0x16, 3, 12},
    {0x01, 2, 14},
    {0x16, 3, 14},
    {0x01, 2, 15},
    {0x16, 3, 15},
    {0x01, 2, 16},
    {0x16, 3, 16},
    {0x01, 2, 17},
    {0x16, 3, 17},
    {0x01, 2, 18},
    {0x16, 3, 18},
  },
  /* 232 */
  {
    {0x02, 2, 8},
    {0x09, 2, 8},
    {0x17, 2, 8},
    {0x28, 3, 8},
    {0x02, 2, 11},
    {0x09, 2, 11},
    {0x17, 2, 11},
    {0x28, 3, 11},
    {0x02, 2, 12},
    {0x09, 2, 12},
    {0x17, 2, 12},
    {0x28, 3, 12},
    {0x02, 2, 14},
    {0x09, 2, 14},
    {0x17, 2, 14},
    {0x28, 3, 14},
  },
  /* 233 */
  {
    {0x03, 2, 8},
    {0x06, 2, 8},
    {0x0a, 2, 8},
    {0x0f, 2, 8},
    {0x18, 2, 8},
    {0x1f, 2, 8},
    {0x29, 2, 8},
    {0x38, 3, 8},
    {0x03, 2, 11},
    {0x06, 2, 11},
    {0x0a, 2, 11},
    {0x0f, 2, 11},
    {0x18, 2, 11},
    {0x1f, 2, 11},
    {0x29, 2, 11},
    {0x38, 3, 11},
  },
  /* 234 */
  {
    {0x03, 2, 12},
    {0x06, 2, 12},
    {0x0a, 2, 12},
    {0x0f, 2, 12},
    {0x18, 2, 12},
    {0x1f, 2, 12},
    {0x29, 2, 12},
    {0x38, 3, 12},
    {0x03, 2, 14},
    {0x06, 2, 14},
    {0x0a, 2, 14},
    {0x0f, 2, 14},
    {0x18, 2, 14},
    {0x1f, 2, 14},
    {0x29, 2, 14},
    {0x38, 3, 14},
  },
  /* 235 */
  {
    {0x02, 2, 15},
    {0x09, 2, 15},
    {0x17, 2, 15},
    {0x28, 3, 15},
    {0x02, 2, 16},
    {0x09, 2, 16},
    {0x17, 2, 16},
    {0x28, 3, 16},
    {0x02, 2, 17},
    {0x09, 2, 17},
    {0x17, 2, 17},
    {0x28, 3, 17},
    {0x02, 2, 18},
    {0x09, 2, 18},
    {0x17, 2, 18},
    {0x28, 3, 18},
  },
  /* 236 */
  {
    {0x03, 2, 15},
    {0x06, 2, 15},
    {0x0a, 2, 15},
    {0x0f, 2, 15},
    {0x18, 2, 15},
    {0x1f, 2, 15},
    {0x29, 2, 15},
    {0x38, 3, 15},
    {0x03, 2, 16},
    {0x06, 2, 16},
    {0x0a, 2, 16},
    {0x0f, 2, 16},
    {0x18, 2, 16},
    {0x1f, 2, 16},
    {0x29, 2, 16},
    {0x38, 3, 16},
  },
  /* 237 */
  {
    {0x03, 2, 17},
    {0x06, 2, 17},
    {0x0a, 2, 17},
    {0x0f, 2, 17},
    {0x18, 2, 17},
    {0x1f, 2, 17},
    {0x29, 2, 17},
    {0x38, 3, 17},
    {0x03, 2, 18},
    {0x06, 2, 18},
    {0x0a, 2, 18},
    {0x0f, 2, 18},
    {0x18, 2, 18},
    {0x1f, 2, 18},
    {0x29, 2, 18},
    {0x38, 3, 18},
  },
  /* 238 */
  {
    {0x00, 3, 19},
    {0x00, 3, 20},
    {0x00, 3, 21},
    {0x00, 3, 23},
    {0x00, 3, 24},
    {0x00, 3, 25},
    {0x00, 3, 26},
    {0x00, 3, 27},
    {0x00, 3, 28},
    {0x00, 3, 29},
    {0x00, 3, 30},
    {0x00, 3, 31},
    {0x00, 3, 127},
    {0x00, 3, 220},
    {0x00, 3, 249},
    {0xfd, 0, 0},
  },
  /* 239 */
  {
    {0x01, 2, 19},
    {0x16, 3, 19},
    {0x01, 2, 20},
    {0x16, 3, 20},
    {0x01, 2, 21},
    {0x16, 3, 21},
    {0x01, 2, 23},
    {0x16, 3, 23},
    {0x01, 2, 24},
    {0x16, 3, 24},
    {0x01, 2, 25},
    {0x16, 3, 25},
    {0x01, 2, 26},
    {0x16, 3, 26},
    {0x01, 2, 27},
    {0x16, 3, 27},
  },
  /* 240 */
  {
    {0x02, 2, 19},
    {0x09, 2, 19},
    {0x17, 2, 19},
    {0x28, 3, 19},
    {0x02, 2, 20},
    {0x09, 2, 20},
    {0x17, 2, 20},
    {0x28, 3, 20},
    {0x02, 2, 21},
    {0x09, 2, 21},
    {0x17, 2, 21},
    {0x28, 3, 21},
    {0x02, 2, 23},
    {0x09, 2, 23},
    {0x17, 2, 23},
    {0x28, 3, 23},
  },
  /* 241 */
  {
    {0x03, 2, 19},
    {0x06, 2, 19},
    {0x0a, 2, 19},
    {0x0f, 2, 19},
    {0x18, 2, 19},
    {0x1f, 2, 19},
    {0x29, 2, 19},
    {0x38, 3, 19},
    {0x03, 2, 20},
    {0x06, 2, 20},
    {0x0a, 2, 20},
    {0x0f, 2, 20},
    {0x18, 2, 20},
    {0x1f, 2, 20},
    {0x29, 2, 20},
    {0x38, 3, 20},
  },
  /* 242 */
  {
    {0x03, 2, 21},
    {0x06, 2, 21},
    {0x0a, 2, 21},
    {0x0f, 2, 21},
    {0x18, 2, 21},
    {0x1f, 2, 21},
    {0x29, 2, 21},
    {0x38, 3, 21},
    {0x03, 2, 23},
    {0x06, 2, 23},
    {0x0a, 2, 23},
    {0x0f, 2, 23},
    {0x18, 2, 23},
    {0x1f, 2, 23},
    {0x29, 2, 23},
    {0x38, 3, 23},
  },
  /* 243 */
  {
    {0x02, 2, 24},
    {0x09, 2, 24},
    {0x17, 2, 24},
    {0x28, 3, 24},
    {0x02, 2, 25},
    {0x09, 2, 25},
    {0x17, 2, 25},
    {0x28, 3, 25},
    {0x02, 2, 26},
    {0x09, 2, 26},
    {0x17, 2, 26},
    {0x28, 3, 26},
    {0x02, 2, 27},
    {0x09, 2, 27},
    {0x17, 2, 27},
    {0x28, 3, 27},
  },
  /* 244 */
  {
    {0x03, 2, 24},
    {0x06, 2, 24},
    {0x0a, 2, 24},
    {0x0f, 2, 24},
    {0x18, 2, 24},
    {0x1f, 2, 24},
    {0x29, 2, 24},
    {0x38, 3, 24},
    {0x03, 2, 25},
    {0x06, 2, 25},
    {0x0a, 2, 25},
    {0x0f, 2, 25},
    {0x18, 2, 25},
    {0x1f, 2, 25},
    {0x29, 2, 25},
    {0x38, 3, 25},
  },
  /* 245 */
  {
    {0x03, 2, 26},
    {0x06, 2, 26},
    {0x0a, 2, 26},
    {0x0f, 2, 26},
    {0x18, 2, 26},
    {0x1f, 2, 26},
    {0x29, 2, 26},
    {0x38, 3, 26},
    {0x03, 2, 27},
    {0x06, 2, 27},
    {0x0a, 2, 27},
    {0x0f, 2, 27},
    {0x18, 2, 27},
    {0x1f, 2, 27},
    {0x29, 2, 27},
    {0x38, 3, 27},
  },
  /* 246 */
  {
    {0x01, 2, 28},
    {0x16, 3, 28},
    {0x01, 2, 29},
    {0x16, 3, 29},
    {0x01, 2, 30},
    {0x16, 3, 30},
    {0x01, 2, 31},
    {0x16, 3, 31},
    {0x01, 2, 127},
    {0x16, 3, 127},
    {0x01, 2, 220},
    {0x16, 3, 220},
    {0x01, 2, 249},
    {0x16, 3, 249},
    {0xfe, 0, 0},
    {0xff, 0, 0},
  },
  /* 247 */
  {
    {0x02, 2, 28},
    {0x09, 2, 28},
    {0x17, 2, 28},
    {0x28, 3, 28},
    {0x02, 2, 29},
    {0x09, 2, 29},
    {0x17, 2, 29},
    {0x28, 3, 29},
    {0x02, 2, 30},
    {0x09, 2, 30},
    {0x17, 2, 30},
    {0x28, 3, 30},
    {0x02, 2, 31},
    {0x09, 2, 31},
    {0x17, 2, 31},
    {0x28, 3, 31},
  },
  /* 248 */
  {
    {0x03, 2, 28},
    {0x06, 2, 28},
    {0x0a, 2, 28},
    {0x0f, 2, 28},
    {0x18, 2, 28},
    {0x1f, 2, 28},
    {0x29, 2, 28},
    {0x38, 3, 28},
    {0x03, 2, 29},
    {0x06, 2, 29},
    {0x0a, 2, 29},
    {0x0f, 2, 29},
    {0x18, 2, 29},
    {0x1f, 2, 29},
    {0x29, 2, 29},
    {0x38, 3, 29},
  },
  /* 249 */
  {
    {0x03, 2, 30},
    {0x06, 2, 30},
    {0x0a, 2, 30},
    {0x0f, 2, 30},
    {0x18, 2, 30},
    {0x1f, 2, 30},
    {0x29, 2, 30},
    {0x38, 3, 30},
    {0x03, 2, 31},
    {0x06, 2, 31},
    {0x0a, 2, 31},
    {0x0f, 2, 31},
    {0x18, 2, 31},
    {0x1f, 2, 31},
    {0x29, 2, 31},
    {0x38, 3, 31},
  },
  /* 250 */
  {
    {0x02, 2, 127},
    {0x09, 2, 127},
    {0x17, 2, 127},
    {0x28, 3, 127},
    {0x02, 2, 220},
    {0x09, 2, 220},
    {0x17, 2, 220},
    {0x28, 3, 220},
    {0x02, 2, 249},
    {0x09, 2, 249},
    {0x17, 2, 249},
    {0x28, 3, 249},
    {0x00, 3, 10},
    {0x00, 3, 13},
    {0x00, 3, 22},
    {0x100, 0, 0},
  },
  /* 251 */
  {
    {0x03, 2, 127},
    {0x06, 2, 127},
    {0x0a, 2, 127},
    {0x0f, 2, 127},
    {0x18, 2, 127},
    {0x1f, 2, 127},
    {0x29, 2, 127},
    {0x38, 3, 127},
    {0x03, 2, 220},
    {0x06, 2, 220},
    {0x0a, 2, 220},
    {0x0f, 2, 220},
    {0x18, 2, 220},
    {0x1f, 2, 220},
    {0x29, 2, 220},
    {0x38, 3, 220},
  },
  /* 252 */
  {
    {0x03, 2, 249},
    {0x06, 2, 249},
    {0x0a, 2, 249},
    {0x0f, 2, 249},
    {0x18, 2, 249},
    {0x1f, 2, 249},
    {0x29, 2, 249},
    {0x38, 3, 249},
    {0x01, 2, 10},
    {0x16, 3, 10},
    {0x01, 2, 13},
    {0x16, 3, 13},
    {0x01, 2, 22},
    {0x16, 3, 22},
    {0x100, 0, 0},
    {0x100, 0, 0},
  },
  /* 253 */
  {
    {0x02, 2, 10},
    {0x09, 2, 10},
    {0x17, 2, 10},
    {0x28, 3, 10},
    {0x02, 2, 13},
    {0x09, 2, 13},
    {0x17, 2, 13},
    {0x28, 3, 13},
    {0x02, 2, 22},
    {0x09, 2, 22},
    {0x17, 2, 22},
    {0x28, 3, 22},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
  },
  /* 254 */
  {
    {0x03, 2, 10},
    {0x06, 2, 10},
    {0x0a, 2, 10},
    {0x0f, 2, 10},
    {0x18, 2, 10},
    {0x1f, 2, 10},
    {0x29, 2, 10},
    {0x38, 3, 10},
    {0x03, 2, 13},
    {0x06, 2, 13},
    {0x0a, 2, 13},
    {0x0f, 2, 13},
    {0x18, 2, 13},
    {0x1f, 2, 13},
    {0x29, 2, 13},
    {0x38, 3, 13},
  },
  /* 255 */
  {
    {0x03, 2, 22},
    {0x06, 2, 22},
    {0x0a, 2, 22},
    {0x0f, 2, 22},
    {0x18, 2, 22},
    {0x1f, 2, 22},
    {0x29, 2, 22},
    {0x38, 3, 22},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
  },
  /* 256 */
  {
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
    {0x100, 0, 0},
  },
};
