/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ast extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "árabe";
        final String metaValue_hy = "armeniu";
        final String metaValue_ban = "balinés";
        final String metaValue_bn = "bengalín";
        final String metaValue_ka = "xeorxanu";
        final String metaValue_got = "góticu";
        final String metaValue_el = "griegu";
        final String metaValue_he = "hebréu";
        final String metaValue_jv = "xavanés";
        final String metaValue_ja = "xaponés";
        final String metaValue_km = "ḥemer";
        final String metaValue_kn = "canarés";
        final String metaValue_ko = "coreanu";
        final String metaValue_kpe = "kpelle";
        final String metaValue_lo = "laosianu";
        final String metaValue_la = "llatín";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birmanu";
        final String metaValue_nqo = "n’ko";
        final String metaValue_or = "oriya";
        final String metaValue_phn = "feniciu";
        final String metaValue_saz = "saurashtra";
        final String metaValue_si = "cingalés";
        final String metaValue_su = "sondanés";
        final String metaValue_syr = "siriacu";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_th = "tailandés";
        final String metaValue_bo = "tibetanu";
        final String metaValue_uga = "ugaríticu";
        final String metaValue_vai = "vai";
        final String metaValue_peo = "persa antiguu";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "Mundu" },
            { "002", "África" },
            { "003", "Norteamérica" },
            { "005", "América del Sur" },
            { "009", "Oceanía" },
            { "011", "África Occidental" },
            { "013", "América Central" },
            { "014", "África Oriental" },
            { "015", "África del Norte" },
            { "017", "África Central" },
            { "018", "África del Sur" },
            { "019", "América" },
            { "021", "América del Norte" },
            { "029", "Caribe" },
            { "030", "Asia Oriental" },
            { "034", "Asia del Sur" },
            { "035", "Sureste Asiáticu" },
            { "039", "Europa del Sur" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Rexón de Micronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia Central" },
            { "145", "Asia Occidental" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "154", "Europa del Norte" },
            { "155", "Europa Occidental" },
            { "419", "América Llatina" },
            { "AC", "Islla Ascensión" },
            { "AD", "Andorra" },
            { "AE", "Emiratos Árabes Xuníos" },
            { "AF", "Afganistán" },
            { "AG", "Antigua y Barbuda" },
            { "AI", "Anguila" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "L’Antártida" },
            { "AR", "Arxentina" },
            { "AS", "Samoa Americana" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Islles Aland" },
            { "AZ", "Azerbaixán" },
            { "BA", "Bosnia y Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladex" },
            { "BE", "Bélxica" },
            { "BF", "Burkina Fasu" },
            { "BG", "Bulgaria" },
            { "BH", "Baḥréin" },
            { "BI", "Burundi" },
            { "BJ", "Benín" },
            { "BL", "San Bartolomé" },
            { "BM", "Les Bermudes" },
            { "BN", "Brunéi" },
            { "BO", "Bolivia" },
            { "BQ", "Caribe neerlandés" },
            { "BR", "Brasil" },
            { "BS", "Les Bahames" },
            { "BT", "Bután" },
            { "BV", "Islla Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Bielorrusia" },
            { "BZ", "Belize" },
            { "CA", "Canadá" },
            { "CC", "Islles Cocos (Keeling)" },
            { "CD", "Congu - Kinxasa" },
            { "CF", "República Centroafricana" },
            { "CG", "Congu - Brazzaville" },
            { "CH", "Suiza" },
            { "CI", "Costa de Marfil" },
            { "CK", "Islles Cook" },
            { "CL", "Chile" },
            { "CM", "Camerún" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Islla Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cabu Verde" },
            { "CW", "Curaçao" },
            { "CX", "Islla Christmas" },
            { "CY", "Xipre" },
            { "CZ", "Chequia" },
            { "DE", "Alemaña" },
            { "DG", "Diego Garcia" },
            { "DJ", "Xibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "República Dominicana" },
            { "DZ", "Arxelia" },
            { "EA", "Ceuta y Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Exiptu" },
            { "EH", "Sáḥara Occidental" },
            { "ER", "Eritrea" },
            { "ES", "España" },
            { "ET", "Etiopía" },
            { "EU", "Xunión Europea" },
            { "EZ", "Eurozona" },
            { "FI", "Finlandia" },
            { "FJ", "Islles Fixi" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "FO", "Islles Feroe" },
            { "FR", "Francia" },
            { "GA", "Gabón" },
            { "GB", "Reinu Xuníu" },
            { "GD", "Granada" },
            { "GE", "Xeorxa" },
            { "GF", "Guyana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Xibraltar" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Ecuatorial" },
            { "GR", "Grecia" },
            { "GS", "Islles Xeorxa del Sur y Sandwich del Sur" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bisáu" },
            { "GY", "Guyana" },
            { "HK", "ARE China de Ḥong Kong" },
            { "HM", "Islles Heard y McDonald" },
            { "HN", "Hondures" },
            { "HR", "Croacia" },
            { "HT", "Haití" },
            { "HU", "Hungría" },
            { "IC", "Islles Canaries" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Islla de Man" },
            { "IN", "India" },
            { "IQ", "Iraq" },
            { "IR", "Irán" },
            { "IS", "Islandia" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Xamaica" },
            { "JO", "Xordania" },
            { "JP", "Xapón" },
            { "KE", "Kenia" },
            { "KG", "Kirguistán" },
            { "KH", "Camboya" },
            { "KI", "Kiribati" },
            { "KM", "Les Comores" },
            { "KN", "Saint Kitts y Nevis" },
            { "KP", "Corea del Norte" },
            { "KR", "Corea del Sur" },
            { "KW", "Kuwait" },
            { "KY", "Islles Caimán" },
            { "KZ", "Kazakstán" },
            { "LA", "Laos" },
            { "LB", "Líbanu" },
            { "LC", "Santa Llucía" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesothu" },
            { "LT", "Lituania" },
            { "LU", "Luxemburgu" },
            { "LV", "Letonia" },
            { "LY", "Libia" },
            { "MA", "Marruecos" },
            { "MC", "Mónacu" },
            { "MD", "Moldavia" },
            { "ME", "Montenegru" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Islles Marshall" },
            { "ML", "Malí" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "MO", "ARE China de Macáu" },
            { "MP", "Islles Marianes del Norte" },
            { "MQ", "La Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauriciu" },
            { "MV", "Les Maldives" },
            { "MW", "Malaui" },
            { "MX", "Méxicu" },
            { "MY", "Malasia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "Nueva Caledonia" },
            { "NE", "El Níxer" },
            { "NF", "Islla Norfolk" },
            { "NG", "Nixeria" },
            { "NI", "Nicaragua" },
            { "NL", "Países Baxos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nueva Zelanda" },
            { "OM", "Omán" },
            { "PA", "Panamá" },
            { "PE", "Perú" },
            { "PF", "Polinesia Francesa" },
            { "PG", "Papúa Nueva Guinea" },
            { "PH", "Filipines" },
            { "PK", "Paquistán" },
            { "PL", "Polonia" },
            { "PM", "Saint Pierre y Miquelon" },
            { "PN", "Islles Pitcairn" },
            { "PR", "Puertu Ricu" },
            { "PS", "Territorios Palestinos" },
            { "PT", "Portugal" },
            { "PW", "Paláu" },
            { "PY", "Paraguái" },
            { "QA", "Qatar" },
            { "QO", "Oceanía esterior" },
            { "RE", "Reunión" },
            { "RO", "Rumanía" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudita" },
            { "SB", "Islles Salomón" },
            { "SC", "Les Seixeles" },
            { "SD", "Sudán" },
            { "SE", "Suecia" },
            { "SG", "Singapur" },
            { "SH", "Santa Helena" },
            { "SI", "Eslovenia" },
            { "SJ", "Svalbard ya Islla Jan Mayen" },
            { "SK", "Eslovaquia" },
            { "SL", "Sierra Lleona" },
            { "SM", "San Marín" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sudán del Sur" },
            { "ST", "Santu Tomé y Príncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "SZ", "Suazilandia" },
            { "TA", "Tristán da Cunha" },
            { "TC", "Islles Turques y Caicos" },
            { "TD", "Chad" },
            { "TF", "Tierres Australes Franceses" },
            { "TG", "Togu" },
            { "TH", "Tailandia" },
            { "TJ", "Taxiquistán" },
            { "TK", "Tokeláu" },
            { "TL", "Timor Oriental" },
            { "TM", "Turkmenistán" },
            { "TN", "Tunicia" },
            { "TO", "Tonga" },
            { "TR", "Turquía" },
            { "TT", "Trinidá y Tobagu" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwán" },
            { "TZ", "Tanzania" },
            { "UA", "Ucraína" },
            { "UG", "Uganda" },
            { "UM", "Islles Perifériques Menores de los EE.XX." },
            { "UN", "Naciones Xuníes" },
            { "US", "Estaos Xuníos" },
            { "UY", "Uruguái" },
            { "UZ", "Uzbequistán" },
            { "VA", "Ciudá del Vaticanu" },
            { "VC", "San Vicente y Granadines" },
            { "VE", "Venezuela" },
            { "VG", "Islles Vírxenes Britániques" },
            { "VI", "Islles Vírxenes Americanes" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis y Futuna" },
            { "WS", "Samoa" },
            { "XK", "Kosovu" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sudáfrica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabue" },
            { "ZZ", "Rexón desconocida" },
            { "aa", "afar" },
            { "ab", "abkhazianu" },
            { "ae", "avestanín" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amháricu" },
            { "an", "aragonés" },
            { "ar", metaValue_ar },
            { "as", "asamés" },
            { "av", "aváricu" },
            { "ay", "aymara" },
            { "az", "azerbaixanu" },
            { "ba", "bashkir" },
            { "be", "bielorrusu" },
            { "bg", "búlgaru" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretón" },
            { "bs", "bosniu" },
            { "ca", "catalán" },
            { "ce", "chechenu" },
            { "ch", "chamorro" },
            { "co", "corsu" },
            { "cr", "cree" },
            { "cs", "checu" },
            { "cu", "eslávicu eclesiásticu" },
            { "cv", "chuvash" },
            { "cy", "galés" },
            { "da", "danés" },
            { "de", "alemán" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "inglés" },
            { "eo", "esperanto" },
            { "es", "español" },
            { "et", "estoniu" },
            { "eu", "vascu" },
            { "fa", "persa" },
            { "ff", "fulah" },
            { "fi", "finlandés" },
            { "fj", "fixanu" },
            { "fo", "feroés" },
            { "fr", "francés" },
            { "fy", "frisón occidental" },
            { "ga", "irlandés" },
            { "gd", "gaélicu escocés" },
            { "gl", "gallegu" },
            { "gn", "guaraní" },
            { "gu", "guyaratí" },
            { "gv", "manés" },
            { "ha", "ḥausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "haitianu" },
            { "hu", "húngaru" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesiu" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi de Sichuán" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandés" },
            { "it", "italianu" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazaquistanín" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "cachemirés" },
            { "ku", "curdu" },
            { "kv", "komi" },
            { "kw", "córnicu" },
            { "ky", "kirguistanín" },
            { "la", metaValue_la },
            { "lb", "luxemburgués" },
            { "lg", "ganda" },
            { "li", "limburgués" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituanu" },
            { "lu", "luba-katanga" },
            { "lv", "letón" },
            { "mg", "malgaxe" },
            { "mh", "marshallés" },
            { "mi", "maorí" },
            { "mk", "macedoniu" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malayu" },
            { "mt", "maltés" },
            { "my", metaValue_my },
            { "na", "nauru" },
            { "nb", "noruegu Bokmål" },
            { "nd", "ndebele del norte" },
            { "ne", "nepalés" },
            { "ng", "ndonga" },
            { "nl", "neerlandés" },
            { "nn", "noruegu Nynorsk" },
            { "no", "noruegu" },
            { "nr", "ndebele del sur" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitanu" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "oséticu" },
            { "pa", "punyabí" },
            { "pi", "pali" },
            { "pl", "polacu" },
            { "ps", "pashtu" },
            { "pt", "portugués" },
            { "qu", "quechua" },
            { "rm", "romanche" },
            { "rn", "rundi" },
            { "ro", "rumanu" },
            { "ru", "rusu" },
            { "rw", "kinyarwanda" },
            { "sa", "sánscritu" },
            { "sc", "sardu" },
            { "sd", "sindhi" },
            { "se", "sami del norte" },
            { "sg", "sango" },
            { "sh", "serbo-croata" },
            { "si", metaValue_si },
            { "sk", "eslovacu" },
            { "sl", "eslovenu" },
            { "sm", "samoanu" },
            { "sn", "shona" },
            { "so", "somalín" },
            { "sq", "albanu" },
            { "sr", "serbiu" },
            { "ss", "swati" },
            { "st", "sotho del sur" },
            { "su", metaValue_su },
            { "sv", "suecu" },
            { "sw", "suaḥili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "taxiquistanín" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "tk", "turcomanu" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonganu" },
            { "tr", "turcu" },
            { "ts", "tsonga" },
            { "tt", "tártaru" },
            { "tw", "twi" },
            { "ty", "tahitianu" },
            { "ug", "uigur" },
            { "uk", "ucraín" },
            { "ur", "urdu" },
            { "uz", "uzbequistanín" },
            { "ve", "venda" },
            { "vi", "vietnamín" },
            { "vo", "volapük" },
            { "wa", "valón" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "chinu" },
            { "zu", "zulú" },
            { "ace", "achinés" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "aeb", "árabe de Túnez" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "akk", "acadianu" },
            { "akz", "alabama" },
            { "ale", "aleut" },
            { "aln", "gheg d’Albania" },
            { "alt", "altai del sur" },
            { "ang", "inglés antiguu" },
            { "anp", "angika" },
            { "arc", "araméu" },
            { "arn", "mapuche" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "árabe d’Arxelia" },
            { "arw", "arawak" },
            { "ary", "árabe de Marruecos" },
            { "arz", "árabe d’Exiptu" },
            { "asa", "asu" },
            { "ase", "llingua de signos americana" },
            { "ast", "asturianu" },
            { "avk", "kotava" },
            { "awa", "awadhi" },
            { "bal", "baluchi" },
            { "ban", metaValue_ban },
            { "bar", "bávaru" },
            { "bas", "basaa" },
            { "bax", "bamun" },
            { "bbc", "batak toba" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bew", "betawi" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bfq", "badaga" },
            { "bgn", "balochi occidental" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bjn", "banjar" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "bpy", "bishnupriya" },
            { "bqi", "bakhtiari" },
            { "bra", "braj" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriat" },
            { "bug", "buginés" },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "caribe" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ceb", "cebuanu" },
            { "cgg", "chiga" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuukés" },
            { "chm", "mari" },
            { "chn", "xíriga chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyanu" },
            { "chr", "cheroqui" },
            { "chy", "cheyenne" },
            { "ckb", "kurdu central" },
            { "cop", "cópticu" },
            { "cps", "capiznon" },
            { "crh", "turcu de Crimea" },
            { "crs", "francés criollu seselwa" },
            { "csb", "kashubianu" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "baxu sorbiu" },
            { "dtp", "dusun central" },
            { "dua", "duala" },
            { "dum", "neerlandés mediu" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "dzg", "dazaga" },
            { "ebu", "embú" },
            { "efi", "efik" },
            { "egl", "emilianu" },
            { "egy", "exipciu antiguu" },
            { "eka", "ekajuk" },
            { "elx", "elamita" },
            { "enm", "inglés mediu" },
            { "esu", "yupik central" },
            { "ewo", "ewondo" },
            { "ext", "estremeñu" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipín" },
            { "fit", "finlandés de Tornedalen" },
            { "fon", "fon" },
            { "frc", "francés cajun" },
            { "frm", "francés mediu" },
            { "fro", "francés antiguu" },
            { "frp", "arpitanu" },
            { "frr", "frisón del norte" },
            { "frs", "frisón oriental" },
            { "fur", "friulianu" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gan", "chinu gan" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gbz", "dari zoroastrianu" },
            { "gez", "geez" },
            { "gil", "gilbertés" },
            { "glk", "gilaki" },
            { "gmh", "altualemán mediu" },
            { "goh", "altualemán antiguu" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "griegu antiguu" },
            { "gsw", "alemán de Suiza" },
            { "guc", "wayuu" },
            { "gur", "frafra" },
            { "guz", "gusii" },
            { "gwi", "gwichʼin" },
            { "hai", "haida" },
            { "hak", "chinu hakka" },
            { "haw", "hawaianu" },
            { "hif", "hindi de Fiji" },
            { "hil", "hiligaynon" },
            { "hit", "hitita" },
            { "hmn", "hmong" },
            { "hsb", "altu sorbiu" },
            { "hsn", "chinu xiang" },
            { "hup", "hupa" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ilo", "iloko" },
            { "inh", "ingush" },
            { "izh", "ingrianu" },
            { "jam", "inglés criollu xamaicanu" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "xudeo-persa" },
            { "jrb", "xudeo-árabe" },
            { "jut", "jutlandés" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabileñu" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardianu" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "cabuverdianu" },
            { "ken", "kenyang" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotanés" },
            { "khq", "koyra chiini" },
            { "khw", "khowar" },
            { "kiu", "kirmanjki" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permyak" },
            { "kok", "konkani" },
            { "kos", "kosraeanu" },
            { "kpe", metaValue_kpe },
            { "krc", "karachay-balkar" },
            { "kri", "krio" },
            { "krj", "kinaray-a" },
            { "krl", "karelianu" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "colonianu" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghianu" },
            { "lfn", "lingua franca nova" },
            { "lij", "ligurianu" },
            { "liv", "livonianu" },
            { "lkt", "lakota" },
            { "lmo", "lombardu" },
            { "lol", "mongo" },
            { "loz", "lozi" },
            { "lrc", "luri del norte" },
            { "ltg", "latgalianu" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "lzh", "chinu lliterariu" },
            { "lzz", "laz" },
            { "mad", "madurés" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "mas", "masái" },
            { "mde", "maba" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mga", "írlandés mediu" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "manchú" },
            { "mni", "manipuri" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mrj", "mari occidental" },
            { "mua", "mundang" },
            { "mul", "múltiples llingües" },
            { "mus", "creek" },
            { "mwl", "mirandés" },
            { "mwr", "marwari" },
            { "mwv", "mentawai" },
            { "mye", "myene" },
            { "myv", "erzya" },
            { "mzn", "mazanderani" },
            { "nan", "chinu min nan" },
            { "nap", "napolitanu" },
            { "naq", "nama" },
            { "nds", "baxu alemán" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niueanu" },
            { "njo", "ao naga" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "non", "noruegu antiguu" },
            { "nov", "novial" },
            { "nqo", metaValue_nqo },
            { "nso", "sotho del norte" },
            { "nus", "nuer" },
            { "nwc", "newari clásicu" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "osa", "osage" },
            { "ota", "turcu otomanu" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauanu" },
            { "pcd", "pícaru" },
            { "pcm", "nixerianu simplificáu" },
            { "pdc", "alemán de Pennsylvania" },
            { "pdt", "plautdietsch" },
            { "peo", metaValue_peo },
            { "pfl", "alemán palatinu" },
            { "phn", metaValue_phn },
            { "pms", "piamontés" },
            { "pnt", "pónticu" },
            { "pon", "pohnpeianu" },
            { "prg", "prusianu" },
            { "pro", "provenzal antiguu" },
            { "quc", "kʼicheʼ" },
            { "qug", "quichua del altiplanu de Chimborazo" },
            { "raj", "rajasthanín" },
            { "rap", "rapanui" },
            { "rar", "rarotonganu" },
            { "rgn", "romañol" },
            { "rif", "rifianu" },
            { "rof", "rombo" },
            { "rom", "romaní" },
            { "rtm", "rotumanu" },
            { "rue", "rusyn" },
            { "rug", "roviana" },
            { "rup", "aromanianu" },
            { "rwk", "rwa" },
            { "sad", "sandavés" },
            { "sah", "sakha" },
            { "sam", "araméu samaritanu" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "saz", metaValue_saz },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sicilianu" },
            { "sco", "scots" },
            { "sdc", "sardu sassarés" },
            { "sdh", "kurdu del sur" },
            { "see", "séneca" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "selkup" },
            { "ses", "koyraboro senni" },
            { "sga", "irlandés antiguu" },
            { "sgs", "samogitianu" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "árabe chadianu" },
            { "sid", "sidamo" },
            { "sli", "baxu silesianu" },
            { "sly", "selayarés" },
            { "sma", "sami del sur" },
            { "smj", "lule sami" },
            { "smn", "inari sami" },
            { "sms", "skolt sami" },
            { "snk", "soninke" },
            { "sog", "sogdianu" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", metaValue_ssy },
            { "stq", "frisón de Saterland" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeriu" },
            { "swb", "comorianu" },
            { "syc", "siriacu clásicu" },
            { "syr", metaValue_syr },
            { "szl", "silesianu" },
            { "tcy", "tulu" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "terena" },
            { "tet", "tetum" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tkr", "tsakhur" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tly", "talixín" },
            { "tmh", "tamashek" },
            { "tog", "tonga nyasa" },
            { "tpi", "tok pisin" },
            { "tru", "turoyo" },
            { "trv", "taroko" },
            { "tsd", "tsakoniu" },
            { "tsi", "tsimshian" },
            { "ttt", "tati musulmán" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinianu" },
            { "tzm", "tamazight del Atles central" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "llingua desconocida" },
            { "vai", metaValue_vai },
            { "vec", "venecianu" },
            { "vep", "vepsiu" },
            { "vls", "flamencu occidental" },
            { "vmf", "franconianu del Main" },
            { "vot", "vóticu" },
            { "vro", "voro" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaytta" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "chinu wu" },
            { "xal", "calmuco" },
            { "xmf", "mingrelianu" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "yapés" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "cantonés" },
            { "zap", "zapoteca" },
            { "zbl", "simbólicu Bliss" },
            { "zea", "zeelandés" },
            { "zen", "zenaga" },
            { "zgh", "tamazight estándar de Marruecos" },
            { "zun", "zuni" },
            { "zxx", "ensin conteníu llingüísticu" },
            { "zza", "zaza" },
            { "Adlm", "adlm" },
            { "Afak", "afaka" },
            { "Aghb", "cáucaso-albanés" },
            { "Ahom", "ahom" },
            { "Arab", metaValue_ar },
            { "Armi", "aramaicu imperial" },
            { "Armn", metaValue_hy },
            { "Avst", "avésticu" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamum" },
            { "Bass", "bassa vah" },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "bhks" },
            { "Blis", "símbolos de Bliss" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", "lontara" },
            { "Buhd", "buhid" },
            { "Cakm", "chakma" },
            { "Cans", "silábicu unificáu de los nativos canadienses" },
            { "Cari", "cariu" },
            { "Cham", "cham" },
            { "Cher", "cheroki" },
            { "Cirt", "cirth" },
            { "Copt", "coptu" },
            { "Cprt", "xipriota" },
            { "Cyrl", "cirílicu" },
            { "Cyrs", "eslavónicu cirílicu eclesiásticu antiguu" },
            { "Deva", "devanagari" },
            { "Dsrt", "alfabetu Deseret" },
            { "Dupl", "taquigrafía Duployé" },
            { "Egyd", "demóticu exipcianu" },
            { "Egyh", "hieráticu exipcianu" },
            { "Egyp", "xeroglíficos exipcianos" },
            { "Elba", "elbasan" },
            { "Ethi", "etíope" },
            { "Geok", "khutsuri xeorxanu" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolíticu" },
            { "Goth", metaValue_got },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", "guyarati" },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunó’o" },
            { "Hans", "simplificáu" },
            { "Hant", "tradicional" },
            { "Hatr", "hatranu" },
            { "Hebr", metaValue_he },
            { "Hira", "ḥiragana" },
            { "Hluw", "xeroglíficos anatolios" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "silabarios xaponeses" },
            { "Hung", "húngaru antiguu" },
            { "Inds", "indus" },
            { "Ital", "itálicu antiguu" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "jurchen" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithi" },
            { "Lana", "lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "fraktur llatín" },
            { "Latg", "gaélicu llatín" },
            { "Latn", metaValue_la },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "llinial A" },
            { "Linb", "llinial B" },
            { "Lisu", "alfabetu de Fraser" },
            { "Loma", "loma" },
            { "Lyci", "liciu" },
            { "Lydi", "lidiu" },
            { "Mahj", "mahajani" },
            { "Mand", "mandéu" },
            { "Mani", "maniquéu" },
            { "Marc", "marc" },
            { "Maya", "xeroglíficos mayes" },
            { "Mend", metaValue_men },
            { "Merc", "meroíticu en cursiva" },
            { "Mero", "meroíticu" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Moon", "tipos Moon" },
            { "Mroo", "mro" },
            { "Mtei", "meitei mayek" },
            { "Mult", "multani" },
            { "Mymr", metaValue_my },
            { "Narb", "árabe del norte antiguu" },
            { "Nbat", "nabatéu" },
            { "Newa", "newa" },
            { "Nkgb", "geba del naxi" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "nüshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", metaValue_or },
            { "Osge", "osge" },
            { "Osma", "osmanya" },
            { "Palm", "palmirenu" },
            { "Pauc", "pau cin hau" },
            { "Perm", "pérmicu antiguu" },
            { "Phag", "escritura ‘Phags-pa" },
            { "Phli", "pahlavi d’inscripciones" },
            { "Phlp", "pahlavi de salteriu" },
            { "Phlv", "pahlavi de llibros" },
            { "Phnx", metaValue_phn },
            { "Plrd", "fonéticu de Pollard" },
            { "Prti", "partu d’inscripciones" },
            { "Rjng", "rejang" },
            { "Roro", "rongorongo" },
            { "Runr", "runes" },
            { "Samr", "samaritanu" },
            { "Sara", "sarati" },
            { "Sarb", "árabe del sur antiguu" },
            { "Saur", metaValue_saz },
            { "Sgnw", "escritura de signos" },
            { "Shaw", "shavianu" },
            { "Shrd", "sharada" },
            { "Sidd", "siddham" },
            { "Sind", "khudabadi" },
            { "Sinh", metaValue_si },
            { "Sora", "sora sompeng" },
            { "Sund", metaValue_su },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "siriacu estrangelo" },
            { "Syrj", "siriacu occidental" },
            { "Syrn", "siriacu oriental" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takri" },
            { "Tale", "tai le" },
            { "Talu", "tai lue nuevu" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Telu", metaValue_te },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "fala visible" },
            { "Wara", "varang kshiti" },
            { "Wole", "woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "cuneiforme sumeriu acadiu" },
            { "Yiii", "yi" },
            { "Zinh", "heredáu" },
            { "Zmth", "escritura matemática" },
            { "Zsye", "emoji" },
            { "Zsym", "símbolos" },
            { "Zxxx", "non escritu" },
            { "Zyyy", "común" },
            { "Zzzz", "escritura desconocida" },
            { "de_AT", "alemán d’Austria" },
            { "de_CH", "altualemán de Suiza" },
            { "en_AU", "inglés d’Australia" },
            { "en_CA", "inglés de Canadá" },
            { "en_GB", "inglés de Gran Bretaña" },
            { "en_US", "inglés d’Estaos Xuníos" },
            { "es_ES", "español européu" },
            { "es_MX", "español de Méxicu" },
            { "fr_CA", "francés de Canadá" },
            { "fr_CH", "francés de Suiza" },
            { "nl_BE", "flamencu" },
            { "pt_BR", "portugués del Brasil" },
            { "pt_PT", "portugués européu" },
            { "ro_MD", "moldavu" },
            { "sw_CD", "suaḥili del Congu" },
            { "%%1901", "ortografía alemana tradicional" },
            { "%%1994", "ortografía resiana estandarizada" },
            { "%%1996", "ortografía alemana de 1996" },
            { "ar_001", "árabe estándar modernu" },
            { "es_419", "español d’América Llatina" },
            { "key.ca", "calendariu" },
            { "key.cf", "formatu monetariu" },
            { "key.co", "orde de clasificación" },
            { "key.cu", "moneda" },
            { "key.hc", "ciclu horariu (12 o 24)" },
            { "key.lb", "estilu de saltu de llinia" },
            { "key.ms", "sistema de midida" },
            { "key.nu", "númberos" },
            { "nds_NL", "baxu saxón" },
            { "%%ALUKU", "dialectu aluku" },
            { "%%BARLA", "grupu dialectal barlavento del cabuverdianu" },
            { "%%BISKE", "dialectu San Giorgio/Bila" },
            { "%%BOONT", "boontling" },
            { "%%KKCOR", "ortografía común" },
            { "%%KSCOR", "ortografía estándar" },
            { "%%LIPAW", "el dialectu lipovaz del resianu" },
            { "%%NEDIS", "dialectu natisone" },
            { "%%NJIVA", "dialectu gniva/njiva" },
            { "%%NULIK", "volapük modernu" },
            { "%%OSOJS", "dialectu oseacco/osojane" },
            { "%%POSIX", "ordenador" },
            { "%%RIGIK", "volapük clásicu" },
            { "%%ROZAJ", "resianu" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "dialectu stolvizza/solbica" },
            { "%%SOTAV", "grupu dialectal sotavento del cabuverdianu" },
            { "%%UCCOR", "ortografía unificada" },
            { "zh_Hans", "chinu simplificáu" },
            { "zh_Hant", "chinu tradicional" },
            { "%%AO1990", "alcuerdu ortográficu de 1990 pa la llingua portuguesa" },
            { "%%DAJNKO", "alfabetu dajnko" },
            { "%%EKAVSK", "serbiu con pronunciación ekaviana" },
            { "%%FONIPA", "fonética IPA" },
            { "%%FONUPA", "fonética UPA" },
            { "%%NDYUKA", "dialectu ndyuka" },
            { "%%PAMAKA", "dialectu pamaka" },
            { "%%PINYIN", "romanización pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "ortografía taraskievica" },
            { "%%UCRCOR", "ortografía unificada revisada" },
            { "%%UNIFON", "alfabetu fonéticu Unifon" },
            { "%%ABL1943", "formulación ortográfica de 1943" },
            { "%%ALALC97", "romanizacion ALA-LC, edicion de 1997" },
            { "%%AREVELA", "armeniu oriental" },
            { "%%AREVMDA", "armeniu occidental" },
            { "%%BALANKA", "dialectu balanka del anii" },
            { "%%BOHORIC", "alfabetu bohorič" },
            { "%%EMODENG", "inglés modernu primitivu" },
            { "%%HEPBURN", "romanización de Hepburn" },
            { "%%METELKO", "alfabetu metelko" },
            { "%%MONOTON", "monotónicu" },
            { "%%POLYTON", "politónicu" },
            { "%%REVISED", "ortografía revisada" },
            { "%%1606NICT", "últimu francés mediu fasta 1606" },
            { "%%1694ACAD", "francés modernu primitivu" },
            { "%%1959ACAD", "académicu" },
            { "%%BAKU1926", "alfabetu turcu llatino unificáu" },
            { "%%COLB1945", "convención ortográfica brasilanu-portuguesa de 1945" },
            { "%%IJEKAVSK", "serbiu con pronunciación Ijekaviana" },
            { "%%OXENDICT", "ortografía del diccionariu d’inglés d’Oxford" },
            { "%%SCOTLAND", "inglés estándar escocés" },
            { "%%VALENCIA", "valencianu" },
            { "%%WADEGILE", "romanización de Wade-Giles" },
            { "type.ca.roc", "calendariu de la República de China" },
            { "type.co.eor", "regles d’ordenamientu europees" },
            { "type.hc.h11", "sistema de 12 hores (0–11)" },
            { "type.hc.h12", "sistema de 12 hores (1–12)" },
            { "type.hc.h23", "sistema de 24 hores (0–23)" },
            { "type.hc.h24", "sistema de 24 hores (1–24)" },
            { "type.nu.ahom", "númberos ahom" },
            { "type.nu.arab", "númberos arábico-índicos" },
            { "type.nu.armn", "númberos armenios" },
            { "type.nu.bali", "númberos balineses" },
            { "type.nu.beng", "númberos bengalinos" },
            { "type.nu.brah", "númberos brahmi" },
            { "type.nu.cakm", "númberos chakma" },
            { "type.nu.cham", "númberos cham" },
            { "type.nu.cyrl", "númberos cirílicos" },
            { "type.nu.deva", "númberos devanagari" },
            { "type.nu.ethi", "númberos etíopes" },
            { "type.nu.geor", "númberos xeorxanos" },
            { "type.nu.grek", "númberos griegos" },
            { "type.nu.gujr", "númberos gujarati" },
            { "type.nu.guru", "númberos gurmukhi" },
            { "type.nu.hans", "númberos chinos simplificaos" },
            { "type.nu.hant", "númberos chinos tradicionales" },
            { "type.nu.hebr", "númberos hebreos" },
            { "type.nu.hmng", "númberos Pahawh Hmong" },
            { "type.nu.java", "númberos xavanesos" },
            { "type.nu.jpan", "númberos xaponeses" },
            { "type.nu.kali", "númberos Kayah Li" },
            { "type.nu.khmr", "numberación khmer" },
            { "type.nu.knda", "numberación kannada" },
            { "type.nu.lana", "numberación Tai Tham Hora" },
            { "type.nu.laoo", "númberos laosianos" },
            { "type.nu.latn", "númberos occidentales" },
            { "type.nu.lepc", "númberos lepcha" },
            { "type.nu.limb", "númberos limbu" },
            { "type.nu.mlym", "númberos malayalam" },
            { "type.nu.modi", "númberos modi" },
            { "type.nu.mong", "númberos mongoles" },
            { "type.nu.mroo", "númberos mro" },
            { "type.nu.mtei", "númberos Meetei Mayek" },
            { "type.nu.mymr", "númberos de Myanmar" },
            { "type.nu.nkoo", "númberos N’Ko" },
            { "type.nu.olck", "númberos Ol Chiki" },
            { "type.nu.orya", "númberos odia" },
            { "type.nu.osma", "númberos osmanya" },
            { "type.nu.saur", "númberos saurashtra" },
            { "type.nu.shrd", "númberos sharada" },
            { "type.nu.sind", "númberos Khudawadi" },
            { "type.nu.sinh", "númberos Lith cingaleses" },
            { "type.nu.sora", "númberos Sora Sompeng" },
            { "type.nu.sund", "númberos sondaneses" },
            { "type.nu.takr", "númberos takri" },
            { "type.nu.talu", "numberación Tai Lue nueva" },
            { "type.nu.taml", "númberos tamil tradicionales" },
            { "type.nu.telu", "númberos telugu" },
            { "type.nu.thai", "númberos tailandeses" },
            { "type.nu.tibt", "númberos tibetanos" },
            { "type.nu.tirh", "númberos tirhuta" },
            { "type.nu.vaii", "númberos vai" },
            { "type.nu.wara", "númberos Warang Citi" },
            { "type.ca.dangi", "calendariu dangi" },
            { "type.co.ducet", "orde de clasificación Unicode predetermináu" },
            { "type.co.emoji", "orde de clasificación Emoji" },
            { "type.lb.loose", "saltu de llinia relaxáu" },
            { "type.nu.roman", "númberos romanos" },
            { "type.ca.coptic", "calendariu coptu" },
            { "type.ca.hebrew", "calendariu hebréu" },
            { "type.ca.indian", "calendariu nacional indiu" },
            { "type.co.compat", "orde de clasificación anterior, por compatibilidá" },
            { "type.co.pinyin", "orde de clasificación pinyin" },
            { "type.co.search", "gueta xeneral" },
            { "type.co.stroke", "orde de clasificación pol trazu" },
            { "type.co.unihan", "orde de clasificación por radical y trazu" },
            { "type.co.zhuyin", "orde de clasificación zhuyin" },
            { "type.lb.normal", "saltu de llinia normal" },
            { "type.lb.strict", "saltu de llinia estrictu" },
            { "type.ms.metric", "sistema métricu" },
            { "type.ca.chinese", "calendariu chinu" },
            { "type.ca.iso8601", "calendariu ISO-8601" },
            { "type.ca.persian", "calendariu persa" },
            { "type.cf.account", "formatu monetariu contable" },
            { "type.nu.arabext", "númberos arábico-índicos estendíos" },
            { "type.nu.armnlow", "númberos armenios en minúscules" },
            { "type.nu.greklow", "númberos griegos en minúscules" },
            { "type.nu.hanidec", "númberos decimales chinos" },
            { "type.nu.hansfin", "númberos chinos financieros simplificaos" },
            { "type.nu.hantfin", "númberos chinos financieros tradicionales" },
            { "type.nu.jpanfin", "númberos financieros xaponeses" },
            { "type.nu.mathdbl", "númberos matemáticos con trazu doble" },
            { "type.nu.tamldec", "númberos tamil" },
            { "type.ca.buddhist", "calendariu budista" },
            { "type.ca.ethiopic", "calendariu etíope" },
            { "type.ca.japanese", "calendariu xaponés" },
            { "type.cf.standard", "formatu monetariu estándar" },
            { "type.co.searchjl", "gueta por consonante Hangul d’aniciu" },
            { "type.co.standard", "orde de clasificación estándar" },
            { "type.ms.uksystem", "sistema de midida imperial" },
            { "type.ms.ussystem", "sistema de midida d’EE.XX." },
            { "type.nu.fullwide", "númberos n’anchu completu" },
            { "type.nu.lanatham", "numberación Tai Tham Tham" },
            { "type.nu.mathbold", "númberos matemáticos en negrina" },
            { "type.nu.mathmono", "númberos matemáticos monoespaciaos" },
            { "type.nu.mathsanb", "númberos matemáticos Sans-Serif en negrina" },
            { "type.nu.mathsans", "númberos matemáticos Sans-Serif" },
            { "type.nu.mymrshan", "númberos Shan de Myanmar" },
            { "type.nu.mymrtlng", "númberos Tai Laing de Myanmar" },
            { "type.nu.romanlow", "númberos romanos en minúscules" },
            { "type.ca.gregorian", "calendariu gregorianu" },
            { "type.co.phonebook", "orde de clasificación de llista telefónica" },
            { "type.co.dictionary", "orde de clasificación de diccionariu" },
            { "type.co.traditional", "orde de clasificación tradicional" },
            { "type.ca.ethiopic-amete-alem", "calendariu etíope Amete Alem" },
        };
        return data;
    }
}
