#ifndef ACCESS_H
#define ACCESS_H

/*
 * Copyright (C) 1999 Accessible Linux Group (Rishi Dubey, Aaron Klish,
 *                                            Kristian Rickert, Shane Smith)
 * Copyright (C) 2000-2002 Daniel Linder / UIUC DRES
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *   USA
 *
 */

#include <iostream.h>
#include <math.h>

inline char* onoroff(int val)
{
  if(val)
    return "Enabled";
  else return "Disabled";
}
  
class Access {
 public:
  Access();
  ~Access();

  int QueryServer();
  int FlushNewSettings();
  void ShowDiagnostics();

  // AccessX Timeout Functions

  int GetAccessXTOState();
  void SetAccessXTOState(int state);

  unsigned short GetAccessXDelay();
  void SetAccessXDelay(unsigned short delay);

  // MouseKeys Functions

  int GetMouseKeysState();
  void SetMouseKeysState(int state);

  unsigned short GetMouseKeysDelay();
  void SetMouseKeysDelay(unsigned short delay);

  unsigned short GetMouseKeysInterval();
  void SetMouseKeysInterval(unsigned short interval);

  unsigned short GetMouseKeysTimeToMax();
  void SetMouseKeysTimeToMax(unsigned short timetomax);

  unsigned short GetMouseKeysMaxSpeed();
  void SetMouseKeysMaxSpeed(unsigned short maxspeed);

  short GetMouseKeysCurve();
  void SetMouseKeysCurve(short curve);

  // SlowKeys Functions

  int GetSlowKeysState();
  void SetSlowKeysState(int state);

  unsigned short GetSlowKeysDelay();
  void SetSlowKeysDelay(unsigned short delay);

  // StickyKeys Functions

  int GetStickyKeysState();
  void SetStickyKeysState(int state);

  int GetStickyKeysLatchToLockState();
  void SetStickyKeysLatchToLockState(int state);

  int GetStickyKeysTwoKeyDisableState();
  void SetStickyKeysTwoKeyDisableState(int state);

  // BounceKeys Functions

  int GetBounceKeysState();
  void SetBounceKeysState(int state);

  unsigned short GetBounceKeysDelay();
  void SetBounceKeysDelay(unsigned short delay);

  // RepeatKeys Functions

  int GetRepeatKeysState();
  void SetRepeatKeysState(int state);

  unsigned short GetRepeatKeysDelay();
  void SetRepeatKeysDelay(unsigned short delay);

  unsigned short GetRepeatKeysInterval();
  void SetRepeatKeysInterval(unsigned short interval);

private:

  // General Data

  unsigned  long   enabled_ctrls;      // Mask for all AccessX Features
  unsigned  short  accessx_delay;      // AccessX Timeout Value

  // MouseKeys Parameters

  unsigned  short  mk_delay;
  unsigned  short  mk_interval;
  unsigned  short  mk_time_to_max;
  unsigned  short  mk_max_speed;
            short  mk_curve;

  // SlowKeys Parameters

  unsigned  short  slow_keys_delay;

  // StickyKeys Parameters

  unsigned  long   enabled_sticky_key_options;

  // BounceKeys Parameters

  unsigned  short  debounce_delay;

  // RepeatKeys Parameters

  unsigned  short  repeat_delay;
  unsigned  short  repeat_interval;

};

#endif

