/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequestAdditionalModelResponseFieldPathsListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailStreamConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.InferenceConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.Message;
import software.amazon.awssdk.services.bedrockruntime.model.MessagesCopier;
import software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.SystemContentBlocksCopier;
import software.amazon.awssdk.services.bedrockruntime.model.ToolConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConverseStreamRequest
extends BedrockRuntimeRequest
implements ToCopyableBuilder<Builder, ConverseStreamRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(ConverseStreamRequest.getter(ConverseStreamRequest::modelId)).setter(ConverseStreamRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelId").build()}).build();
    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messages").getter(ConverseStreamRequest.getter(ConverseStreamRequest::messages)).setter(ConverseStreamRequest.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SystemContentBlock>> SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("system").getter(ConverseStreamRequest.getter(ConverseStreamRequest::system)).setter(ConverseStreamRequest.setter(Builder::system)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("system").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SystemContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InferenceConfiguration> INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfig").getter(ConverseStreamRequest.getter(ConverseStreamRequest::inferenceConfig)).setter(ConverseStreamRequest.setter(Builder::inferenceConfig)).constructor(InferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()}).build();
    private static final SdkField<ToolConfiguration> TOOL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolConfig").getter(ConverseStreamRequest.getter(ConverseStreamRequest::toolConfig)).setter(ConverseStreamRequest.setter(Builder::toolConfig)).constructor(ToolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolConfig").build()}).build();
    private static final SdkField<GuardrailStreamConfiguration> GUARDRAIL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfig").getter(ConverseStreamRequest.getter(ConverseStreamRequest::guardrailConfig)).setter(ConverseStreamRequest.setter(Builder::guardrailConfig)).constructor(GuardrailStreamConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfig").build()}).build();
    private static final SdkField<Document> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("additionalModelRequestFields").getter(ConverseStreamRequest.getter(ConverseStreamRequest::additionalModelRequestFields)).setter(ConverseStreamRequest.setter(Builder::additionalModelRequestFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_MODEL_RESPONSE_FIELD_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("additionalModelResponseFieldPaths").getter(ConverseStreamRequest.getter(ConverseStreamRequest::additionalModelResponseFieldPaths)).setter(ConverseStreamRequest.setter(Builder::additionalModelResponseFieldPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelResponseFieldPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MESSAGES_FIELD, SYSTEM_FIELD, INFERENCE_CONFIG_FIELD, TOOL_CONFIG_FIELD, GUARDRAIL_CONFIG_FIELD, ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, ADDITIONAL_MODEL_RESPONSE_FIELD_PATHS_FIELD));
    private final String modelId;
    private final List<Message> messages;
    private final List<SystemContentBlock> system;
    private final InferenceConfiguration inferenceConfig;
    private final ToolConfiguration toolConfig;
    private final GuardrailStreamConfiguration guardrailConfig;
    private final Document additionalModelRequestFields;
    private final List<String> additionalModelResponseFieldPaths;

    private ConverseStreamRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.messages = builder.messages;
        this.system = builder.system;
        this.inferenceConfig = builder.inferenceConfig;
        this.toolConfig = builder.toolConfig;
        this.guardrailConfig = builder.guardrailConfig;
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.additionalModelResponseFieldPaths = builder.additionalModelResponseFieldPaths;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public final List<Message> messages() {
        return this.messages;
    }

    public final boolean hasSystem() {
        return this.system != null && !(this.system instanceof SdkAutoConstructList);
    }

    public final List<SystemContentBlock> system() {
        return this.system;
    }

    public final InferenceConfiguration inferenceConfig() {
        return this.inferenceConfig;
    }

    public final ToolConfiguration toolConfig() {
        return this.toolConfig;
    }

    public final GuardrailStreamConfiguration guardrailConfig() {
        return this.guardrailConfig;
    }

    public final Document additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public final boolean hasAdditionalModelResponseFieldPaths() {
        return this.additionalModelResponseFieldPaths != null && !(this.additionalModelResponseFieldPaths instanceof SdkAutoConstructList);
    }

    public final List<String> additionalModelResponseFieldPaths() {
        return this.additionalModelResponseFieldPaths;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystem() ? this.system() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalModelRequestFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalModelResponseFieldPaths() ? this.additionalModelResponseFieldPaths() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseStreamRequest)) {
            return false;
        }
        ConverseStreamRequest other = (ConverseStreamRequest)((Object)obj);
        return Objects.equals(this.modelId(), other.modelId()) && this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && this.hasSystem() == other.hasSystem() && Objects.equals(this.system(), other.system()) && Objects.equals(this.inferenceConfig(), other.inferenceConfig()) && Objects.equals(this.toolConfig(), other.toolConfig()) && Objects.equals(this.guardrailConfig(), other.guardrailConfig()) && Objects.equals(this.additionalModelRequestFields(), other.additionalModelRequestFields()) && this.hasAdditionalModelResponseFieldPaths() == other.hasAdditionalModelResponseFieldPaths() && Objects.equals(this.additionalModelResponseFieldPaths(), other.additionalModelResponseFieldPaths());
    }

    public final String toString() {
        return ToString.builder((String)"ConverseStreamRequest").add("ModelId", (Object)this.modelId()).add("Messages", this.hasMessages() ? this.messages() : null).add("System", this.hasSystem() ? this.system() : null).add("InferenceConfig", (Object)this.inferenceConfig()).add("ToolConfig", (Object)this.toolConfig()).add("GuardrailConfig", (Object)this.guardrailConfig()).add("AdditionalModelRequestFields", (Object)this.additionalModelRequestFields()).add("AdditionalModelResponseFieldPaths", this.hasAdditionalModelResponseFieldPaths() ? this.additionalModelResponseFieldPaths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "system": {
                return Optional.ofNullable(clazz.cast(this.system()));
            }
            case "inferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfig()));
            }
            case "toolConfig": {
                return Optional.ofNullable(clazz.cast(this.toolConfig()));
            }
            case "guardrailConfig": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfig()));
            }
            case "additionalModelRequestFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelRequestFields()));
            }
            case "additionalModelResponseFieldPaths": {
                return Optional.ofNullable(clazz.cast(this.additionalModelResponseFieldPaths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConverseStreamRequest, T> g) {
        return obj -> g.apply((ConverseStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRuntimeRequest.BuilderImpl
    implements Builder {
        private String modelId;
        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();
        private List<SystemContentBlock> system = DefaultSdkAutoConstructList.getInstance();
        private InferenceConfiguration inferenceConfig;
        private ToolConfiguration toolConfig;
        private GuardrailStreamConfiguration guardrailConfig;
        private Document additionalModelRequestFields;
        private List<String> additionalModelResponseFieldPaths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConverseStreamRequest model) {
            super(model);
            this.modelId(model.modelId);
            this.messages(model.messages);
            this.system(model.system);
            this.inferenceConfig(model.inferenceConfig);
            this.toolConfig(model.toolConfig);
            this.guardrailConfig(model.guardrailConfig);
            this.additionalModelRequestFields(model.additionalModelRequestFields);
            this.additionalModelResponseFieldPaths(model.additionalModelResponseFieldPaths);
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SystemContentBlock.Builder> getSystem() {
            List<SystemContentBlock.Builder> result = SystemContentBlocksCopier.copyToBuilder(this.system);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystem(Collection<SystemContentBlock.BuilderImpl> system) {
            this.system = SystemContentBlocksCopier.copyFromBuilder(system);
        }

        @Override
        public final Builder system(Collection<SystemContentBlock> system) {
            this.system = SystemContentBlocksCopier.copy(system);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(SystemContentBlock ... system) {
            this.system(Arrays.asList(system));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder system(Consumer<SystemContentBlock.Builder> ... system) {
            this.system(Stream.of(system).map(c -> (SystemContentBlock)((SystemContentBlock.Builder)SystemContentBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InferenceConfiguration.Builder getInferenceConfig() {
            return this.inferenceConfig != null ? this.inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(InferenceConfiguration.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(InferenceConfiguration inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final ToolConfiguration.Builder getToolConfig() {
            return this.toolConfig != null ? this.toolConfig.toBuilder() : null;
        }

        public final void setToolConfig(ToolConfiguration.BuilderImpl toolConfig) {
            this.toolConfig = toolConfig != null ? toolConfig.build() : null;
        }

        @Override
        public final Builder toolConfig(ToolConfiguration toolConfig) {
            this.toolConfig = toolConfig;
            return this;
        }

        public final GuardrailStreamConfiguration.Builder getGuardrailConfig() {
            return this.guardrailConfig != null ? this.guardrailConfig.toBuilder() : null;
        }

        public final void setGuardrailConfig(GuardrailStreamConfiguration.BuilderImpl guardrailConfig) {
            this.guardrailConfig = guardrailConfig != null ? guardrailConfig.build() : null;
        }

        @Override
        public final Builder guardrailConfig(GuardrailStreamConfiguration guardrailConfig) {
            this.guardrailConfig = guardrailConfig;
            return this;
        }

        public final Document getAdditionalModelRequestFields() {
            return this.additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
        }

        @Override
        public final Builder additionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
            return this;
        }

        public final Collection<String> getAdditionalModelResponseFieldPaths() {
            if (this.additionalModelResponseFieldPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalModelResponseFieldPaths;
        }

        public final void setAdditionalModelResponseFieldPaths(Collection<String> additionalModelResponseFieldPaths) {
            this.additionalModelResponseFieldPaths = ConverseStreamRequestAdditionalModelResponseFieldPathsListCopier.copy(additionalModelResponseFieldPaths);
        }

        @Override
        public final Builder additionalModelResponseFieldPaths(Collection<String> additionalModelResponseFieldPaths) {
            this.additionalModelResponseFieldPaths = ConverseStreamRequestAdditionalModelResponseFieldPathsListCopier.copy(additionalModelResponseFieldPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalModelResponseFieldPaths(String ... additionalModelResponseFieldPaths) {
            this.additionalModelResponseFieldPaths(Arrays.asList(additionalModelResponseFieldPaths));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConverseStreamRequest build() {
            return new ConverseStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConverseStreamRequest> {
        public Builder modelId(String var1);

        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);

        public Builder messages(Consumer<Message.Builder> ... var1);

        public Builder system(Collection<SystemContentBlock> var1);

        public Builder system(SystemContentBlock ... var1);

        public Builder system(Consumer<SystemContentBlock.Builder> ... var1);

        public Builder inferenceConfig(InferenceConfiguration var1);

        default public Builder inferenceConfig(Consumer<InferenceConfiguration.Builder> inferenceConfig) {
            return this.inferenceConfig((InferenceConfiguration)((InferenceConfiguration.Builder)InferenceConfiguration.builder().applyMutation(inferenceConfig)).build());
        }

        public Builder toolConfig(ToolConfiguration var1);

        default public Builder toolConfig(Consumer<ToolConfiguration.Builder> toolConfig) {
            return this.toolConfig((ToolConfiguration)((ToolConfiguration.Builder)ToolConfiguration.builder().applyMutation(toolConfig)).build());
        }

        public Builder guardrailConfig(GuardrailStreamConfiguration var1);

        default public Builder guardrailConfig(Consumer<GuardrailStreamConfiguration.Builder> guardrailConfig) {
            return this.guardrailConfig((GuardrailStreamConfiguration)((GuardrailStreamConfiguration.Builder)GuardrailStreamConfiguration.builder().applyMutation(guardrailConfig)).build());
        }

        public Builder additionalModelRequestFields(Document var1);

        public Builder additionalModelResponseFieldPaths(Collection<String> var1);

        public Builder additionalModelResponseFieldPaths(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

