/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.get.MultiGetShardRequest;
import org.elasticsearch.action.get.MultiGetShardResponse;
import org.elasticsearch.action.get.TransportShardMultiGetAction;
import org.elasticsearch.action.get.TransportShardMultiGetFomTranslogAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportMultiGetAction
extends HandledTransportAction<MultiGetRequest, MultiGetResponse> {
    public static final String NAME = "indices:data/read/mget";
    public static final ActionType<MultiGetResponse> TYPE = new ActionType("indices:data/read/mget");
    private final ClusterService clusterService;
    private final NodeClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportMultiGetAction(TransportService transportService, ClusterService clusterService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver resolver, IndicesService indicesService) {
        super(NAME, transportService, actionFilters, MultiGetRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.client = client;
        this.indexNameExpressionResolver = resolver;
        new TransportShardMultiGetFomTranslogAction(transportService, indicesService, actionFilters);
    }

    @Override
    protected void doExecute(Task task, MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        AtomicArray<MultiGetItemResponse> responses = new AtomicArray<MultiGetItemResponse>(request.items.size());
        HashMap<ShardId, MultiGetShardRequest> shardRequests = new HashMap<ShardId, MultiGetShardRequest>();
        Tuple lastResolvedIndex = Tuple.tuple(null, null);
        for (int i = 0; i < request.items.size(); ++i) {
            ShardId shardId;
            MultiGetRequest.Item item = request.items.get(i);
            try {
                String concreteSingleIndex;
                if (item.index().equals(lastResolvedIndex.v1())) {
                    concreteSingleIndex = (String)lastResolvedIndex.v2();
                } else {
                    concreteSingleIndex = this.indexNameExpressionResolver.concreteSingleIndex(clusterState, item).getName();
                    lastResolvedIndex = Tuple.tuple((Object)item.index(), (Object)concreteSingleIndex);
                }
                item.routing(clusterState.metadata().resolveIndexRouting(item.routing(), item.index()));
                shardId = OperationRouting.shardId(clusterState, concreteSingleIndex, item.id(), item.routing());
            }
            catch (RoutingMissingException e) {
                responses.set(i, TransportMultiGetAction.newItemFailure(e.getIndex().getName(), e.getId(), e));
                continue;
            }
            catch (Exception e) {
                responses.set(i, TransportMultiGetAction.newItemFailure(item.index(), item.id(), e));
                continue;
            }
            MultiGetShardRequest shardRequest = (MultiGetShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                shardRequest = new MultiGetShardRequest(request, shardId.getIndexName(), shardId.getId());
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, item);
        }
        if (shardRequests.isEmpty()) {
            listener.onResponse(new MultiGetResponse(responses.toArray((MultiGetItemResponse[])new MultiGetItemResponse[responses.length()])));
        }
        this.executeShardAction(listener, responses, shardRequests);
    }

    protected void executeShardAction(ActionListener<MultiGetResponse> listener, final AtomicArray<MultiGetItemResponse> responses, Map<ShardId, MultiGetShardRequest> shardRequests) {
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiGetShardRequest shardRequest : shardRequests.values()) {
            this.client.executeLocally(TransportShardMultiGetAction.TYPE, shardRequest, new DelegatingActionListener<MultiGetShardResponse, MultiGetResponse>(this, listener){

                @Override
                public void onResponse(MultiGetShardResponse response) {
                    for (int i = 0; i < response.locations.size(); ++i) {
                        MultiGetItemResponse itemResponse = new MultiGetItemResponse(response.responses.get(i), response.failures.get(i));
                        responses.set(response.locations.get(i), itemResponse);
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    for (int i = 0; i < shardRequest.locations.size(); ++i) {
                        MultiGetRequest.Item item = shardRequest.items.get(i);
                        responses.set(shardRequest.locations.get(i), TransportMultiGetAction.newItemFailure(shardRequest.index(), item.id(), e));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    this.delegate.onResponse(new MultiGetResponse(responses.toArray(new MultiGetItemResponse[responses.length()])));
                }
            });
        }
    }

    private static MultiGetItemResponse newItemFailure(String index, String id, Exception exception) {
        return new MultiGetItemResponse(null, new MultiGetResponse.Failure(index, id, exception));
    }
}

