/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.BatchSummary;
import org.elasticsearch.cluster.service.ClusterStateUpdateStats;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class MasterService
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(MasterService.class);
    public static final Setting<TimeValue> MASTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING = Setting.positiveTimeSetting("cluster.service.slow_master_task_logging_threshold", TimeValue.timeValueSeconds((long)10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> MASTER_SERVICE_STARVATION_LOGGING_THRESHOLD_SETTING = Setting.positiveTimeSetting("cluster.service.master_service_starvation_logging_threshold", TimeValue.timeValueMinutes((long)5L), Setting.Property.NodeScope);
    public static final String MASTER_UPDATE_THREAD_NAME = "masterService#updateTask";
    public static final String STATE_UPDATE_ACTION_NAME = "publish_cluster_state_update";
    private final ClusterStateTaskExecutor<ClusterStateUpdateTask> unbatchedExecutor;
    private ClusterStatePublisher clusterStatePublisher;
    private Supplier<ClusterState> clusterStateSupplier;
    private final String nodeName;
    private volatile TimeValue slowTaskLoggingThreshold;
    private final TimeValue starvationLoggingThreshold;
    protected final ThreadPool threadPool;
    private final TaskManager taskManager;
    private final ThreadContext.StoredContext clusterStateUpdateContext;
    private volatile ExecutorService threadPoolExecutor;
    private final AtomicInteger totalQueueSize = new AtomicInteger();
    private volatile Batch currentlyExecutingBatch;
    private final Map<Priority, PerPriorityQueue> queuesByPriority;
    private final LongSupplier insertionIndexSupplier = new AtomicLong()::incrementAndGet;
    private final ClusterStateUpdateStatsTracker clusterStateUpdateStatsTracker = new ClusterStateUpdateStatsTracker();
    private final StarvationWatcher starvationWatcher = new StarvationWatcher();
    static final String TEST_ONLY_EXECUTOR_MAY_CHANGE_VERSION_NUMBER_TRANSIENT_NAME = "test_only_executor_may_change_version_number";
    private final Runnable queuesProcessor = new AbstractRunnable(){

        @Override
        public void doRun() {
            assert (MasterService.this.threadPool.getThreadContext().isSystemContext());
            assert (MasterService.this.totalQueueSize.get() > 0);
            assert (MasterService.this.currentlyExecutingBatch == null);
            ActionListener.run(new ActionListener<Void>(){

                @Override
                public void onResponse(Void unused) {
                    this.onCompletion();
                }

                @Override
                public void onFailure(Exception e) {
                    logger.error("unexpected exception executing queue entry", (Throwable)e);
                    assert (false) : e;
                    this.onCompletion();
                }

                public String toString() {
                    return "master service batch completion listener";
                }
            }, batchCompletionListener -> {
                Batch nextBatch = MasterService.this.takeNextBatch();
                assert (MasterService.this.currentlyExecutingBatch == nextBatch);
                if (MasterService.this.lifecycle.started()) {
                    nextBatch.run((ActionListener<Void>)batchCompletionListener);
                } else {
                    nextBatch.onRejection(new FailedToCommitClusterStateException("node closed", (Throwable)MasterService.this.getRejectionException(), new Object[0]));
                    batchCompletionListener.onResponse(null);
                }
            });
        }

        @Override
        public void onFailure(Exception e) {
            logger.error("unexpected exception executing queue entry", (Throwable)e);
            assert (false) : e;
            this.onCompletion();
        }

        private void onCompletion() {
            MasterService.this.currentlyExecutingBatch = null;
            if (MasterService.this.totalQueueSize.decrementAndGet() > 0) {
                MasterService.this.starvationWatcher.onNonemptyQueue();
                MasterService.this.forkQueueProcessor();
            } else {
                MasterService.this.starvationWatcher.onEmptyQueue();
            }
        }

        @Override
        public void onRejection(Exception e) {
            EsRejectedExecutionException esre;
            assert (e instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e).isExecutorShutdown()) : e;
            MasterService.this.drainQueueOnRejection(new FailedToCommitClusterStateException("node closed", (Throwable)e, new Object[0]));
        }

        public String toString() {
            return "master service queue processor";
        }
    };
    static final int MAX_TASK_DESCRIPTION_CHARS = 8192;

    public MasterService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, TaskManager taskManager) {
        this.nodeName = Objects.requireNonNull(Node.NODE_NAME_SETTING.get(settings));
        this.slowTaskLoggingThreshold = MASTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MASTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD_SETTING, this::setSlowTaskLoggingThreshold);
        this.starvationLoggingThreshold = MASTER_SERVICE_STARVATION_LOGGING_THRESHOLD_SETTING.get(settings);
        this.threadPool = threadPool;
        this.taskManager = taskManager;
        this.clusterStateUpdateContext = MasterService.getClusterStateUpdateContext(threadPool.getThreadContext());
        EnumMap<Priority, PerPriorityQueue> queuesByPriorityBuilder = new EnumMap<Priority, PerPriorityQueue>(Priority.class);
        for (Priority priority : Priority.values()) {
            queuesByPriorityBuilder.put(priority, new PerPriorityQueue(priority));
        }
        this.queuesByPriority = Collections.unmodifiableMap(queuesByPriorityBuilder);
        this.unbatchedExecutor = new UnbatchedExecutor();
    }

    private static ThreadContext.StoredContext getClusterStateUpdateContext(ThreadContext threadContext) {
        try (ThreadContext.StoredContext ignored = threadContext.newStoredContext();){
            assert (threadContext.isDefaultContext()) : "must only create MasterService in a clean ThreadContext";
            threadContext.markAsSystemContext();
            ThreadContext.StoredContext storedContext = threadContext.newStoredContext();
            return storedContext;
        }
    }

    private void setSlowTaskLoggingThreshold(TimeValue slowTaskLoggingThreshold) {
        this.slowTaskLoggingThreshold = slowTaskLoggingThreshold;
    }

    public synchronized void setClusterStatePublisher(ClusterStatePublisher publisher) {
        this.clusterStatePublisher = publisher;
    }

    public synchronized void setClusterStateSupplier(Supplier<ClusterState> clusterStateSupplier) {
        this.clusterStateSupplier = clusterStateSupplier;
    }

    @Override
    protected synchronized void doStart() {
        Objects.requireNonNull(this.clusterStatePublisher, "please set a cluster state publisher before starting");
        Objects.requireNonNull(this.clusterStateSupplier, "please set a cluster state supplier before starting");
        this.threadPoolExecutor = this.createThreadPoolExecutor();
    }

    protected ExecutorService createThreadPoolExecutor() {
        return EsExecutors.newScaling(this.nodeName + "/masterService#updateTask", 0, 1, 60L, TimeUnit.SECONDS, true, EsExecutors.daemonThreadFactory(this.nodeName, MASTER_UPDATE_THREAD_NAME), this.threadPool.getThreadContext());
    }

    public ClusterStateUpdateStats getClusterStateUpdateStats() {
        return this.clusterStateUpdateStatsTracker.getStatistics();
    }

    @Override
    protected synchronized void doStop() {
        ThreadPool.terminate(this.threadPoolExecutor, 10L, TimeUnit.SECONDS);
    }

    @Override
    protected synchronized void doClose() {
    }

    ClusterState state() {
        return this.clusterStateSupplier.get();
    }

    public static boolean isMasterUpdateThread() {
        return Thread.currentThread().getName().contains("[masterService#updateTask]");
    }

    public static boolean assertMasterUpdateOrTestThread() {
        return ThreadPool.assertCurrentThreadPool(MASTER_UPDATE_THREAD_NAME);
    }

    public static boolean assertNotMasterUpdateThread(String reason) {
        assert (!MasterService.isMasterUpdateThread()) : "Expected current thread [" + String.valueOf(Thread.currentThread()) + "] to not be the master service thread. Reason: [" + reason + "]";
        return true;
    }

    private <T extends ClusterStateTaskListener> void executeAndPublishBatch(ClusterStateTaskExecutor<T> executor, List<ExecutionResult<T>> executionResults, BatchSummary summary, ActionListener<Void> listener) {
        if (!this.lifecycle.started()) {
            logger.debug("processing [{}]: ignoring, master service not started", (Object)summary);
            listener.onResponse(null);
            return;
        }
        logger.debug("executing cluster state update for [{}]", (Object)summary);
        ClusterState previousClusterState = this.state();
        if (!previousClusterState.nodes().isLocalNodeElectedMaster() && executor.runOnlyOnMaster()) {
            logger.debug("failing [{}]: local node is no longer master", (Object)summary);
            for (ExecutionResult<T> executionResult : executionResults) {
                executionResult.onBatchFailure(new NotMasterException("no longer master"));
                executionResult.notifyFailure();
            }
            listener.onResponse(null);
            return;
        }
        long computationStartTime = this.threadPool.rawRelativeTimeInMillis();
        ClusterState newClusterState = this.patchVersions(previousClusterState, MasterService.executeTasks(previousClusterState, executionResults, executor, summary, this.threadPool.getThreadContext()));
        TimeValue computationTime = this.getTimeSince(computationStartTime);
        this.logExecutionTime(computationTime, "compute cluster state update", summary);
        if (previousClusterState == newClusterState) {
            long notificationStartTime = this.threadPool.rawRelativeTimeInMillis();
            for (ExecutionResult<T> executionResult : executionResults) {
                ContextPreservingAckListener contextPreservingAckListener = executionResult.getContextPreservingAckListener();
                if (contextPreservingAckListener != null) {
                    contextPreservingAckListener.onAckSuccess();
                }
                executionResult.onClusterStateUnchanged(newClusterState);
            }
            TimeValue executionTime = this.getTimeSince(notificationStartTime);
            this.logExecutionTime(executionTime, "notify listeners on unchanged cluster state", summary);
            this.clusterStateUpdateStatsTracker.onUnchangedClusterState(computationTime.millis(), executionTime.millis());
            listener.onResponse(null);
        } else {
            long publicationStartTime = this.threadPool.rawRelativeTimeInMillis();
            try (ThreadContext.StoredContext ignored = this.threadPool.getThreadContext().newTraceContext();){
                final long newClusterStateVersion = newClusterState.getVersion();
                Task task = this.taskManager.register("master", STATE_UPDATE_ACTION_NAME, new TaskAwareRequest(){

                    @Override
                    public void setParentTask(TaskId taskId) {
                    }

                    @Override
                    public void setRequestId(long requestId) {
                    }

                    @Override
                    public TaskId getParentTask() {
                        return TaskId.EMPTY_TASK_ID;
                    }

                    @Override
                    public String getDescription() {
                        return "publication of cluster state [" + newClusterStateVersion + "]";
                    }
                });
                ActionListener.run(new DelegatingActionListener<Void, Void>(this, ActionListener.runAfter(listener, () -> this.taskManager.unregister(task)).delegateResponse((l, e) -> {
                    assert (this.publicationMayFail()) : e;
                    this.handleException(summary, publicationStartTime, newClusterState, (Exception)e);
                    l.onResponse(null);
                })){

                    @Override
                    public void onResponse(Void response) {
                        this.delegate.onResponse(response);
                    }

                    @Override
                    public String toString() {
                        return "listener for publication of cluster state [" + newClusterStateVersion + "]";
                    }
                }, l -> this.publishClusterStateUpdate(executor, summary, previousClusterState, executionResults, newClusterState, computationTime, publicationStartTime, task, (ActionListener<Void>)l));
            }
        }
    }

    private <T extends ClusterStateTaskListener> void publishClusterStateUpdate(final ClusterStateTaskExecutor<T> executor, final BatchSummary summary, ClusterState previousClusterState, final List<ExecutionResult<T>> executionResults, final ClusterState newClusterState, TimeValue computationTime, final long publicationStartTime, Task task, final ActionListener<Void> listener) {
        String nodesDeltaSummary;
        if (logger.isTraceEnabled()) {
            logger.trace("cluster state updated, source [{}]\n{}", (Object)summary, (Object)newClusterState);
        } else {
            logger.debug("cluster state updated, version [{}], source [{}]", (Object)newClusterState.version(), (Object)summary);
        }
        final ClusterStatePublicationEvent clusterStatePublicationEvent = new ClusterStatePublicationEvent(summary, previousClusterState, newClusterState, task, computationTime.millis(), publicationStartTime);
        DiscoveryNodes.Delta nodesDelta = newClusterState.nodes().delta(previousClusterState.nodes());
        if (nodesDelta.hasChanges() && logger.isInfoEnabled() && (nodesDeltaSummary = nodesDelta.shortSummary()).length() > 0) {
            logger.info("{}, term: {}, version: {}, delta: {}", (Object)summary, (Object)newClusterState.term(), (Object)newClusterState.version(), (Object)nodesDeltaSummary);
        }
        logger.debug("publishing cluster state version [{}]", (Object)newClusterState.version());
        newClusterState.initializeAsync(this.threadPool.generic());
        this.publish(clusterStatePublicationEvent, new CompositeTaskAckListener(executionResults.stream().map(ExecutionResult::getContextPreservingAckListener).filter(Objects::nonNull).map(contextPreservingAckListener -> new TaskAckListener((ContextPreservingAckListener)contextPreservingAckListener, newClusterState.version(), newClusterState.nodes(), this.threadPool)).toList()), ActionListener.runAfter(new ActionListener<Void>(){

            @Override
            public void onResponse(Void unused) {
                long notificationStartTime = MasterService.this.threadPool.rawRelativeTimeInMillis();
                for (ExecutionResult executionResult : executionResults) {
                    executionResult.onPublishSuccess(newClusterState);
                }
                try {
                    executor.clusterStatePublished(newClusterState);
                }
                catch (Exception e) {
                    logger.error(() -> Strings.format((String)"exception thrown while notifying executor of new cluster state publication [%s]", (Object[])new Object[]{summary}), (Throwable)e);
                }
                TimeValue executionTime = MasterService.this.getTimeSince(notificationStartTime);
                MasterService.this.logExecutionTime(executionTime, "notify listeners on successful publication of cluster state (version: " + newClusterState.version() + ", uuid: " + newClusterState.stateUUID() + ")", summary);
                MasterService.this.clusterStateUpdateStatsTracker.onPublicationSuccess(MasterService.this.threadPool.rawRelativeTimeInMillis(), clusterStatePublicationEvent, executionTime.millis());
            }

            @Override
            public void onFailure(Exception exception) {
                if (exception instanceof FailedToCommitClusterStateException) {
                    FailedToCommitClusterStateException failedToCommitClusterStateException = (FailedToCommitClusterStateException)exception;
                    long notificationStartTime = MasterService.this.threadPool.rawRelativeTimeInMillis();
                    long version = newClusterState.version();
                    logger.warn(() -> Strings.format((String)"failing [%s]: failed to commit cluster state version [%s]", (Object[])new Object[]{summary, version}), (Throwable)exception);
                    for (ExecutionResult executionResult : executionResults) {
                        executionResult.onPublishFailure(failedToCommitClusterStateException);
                    }
                    long notificationMillis = MasterService.this.threadPool.rawRelativeTimeInMillis() - notificationStartTime;
                    MasterService.this.clusterStateUpdateStatsTracker.onPublicationFailure(MasterService.this.threadPool.rawRelativeTimeInMillis(), clusterStatePublicationEvent, notificationMillis);
                } else if (exception instanceof EsRejectedExecutionException) {
                    EsRejectedExecutionException esRejectedExecutionException = (EsRejectedExecutionException)exception;
                    assert (esRejectedExecutionException.isExecutorShutdown());
                    MasterService.this.clusterStateUpdateStatsTracker.onPublicationFailure(MasterService.this.threadPool.rawRelativeTimeInMillis(), clusterStatePublicationEvent, 0L);
                    long version = newClusterState.version();
                    logger.debug(() -> Strings.format((String)"shut down during publication of cluster state version [%s]: [%s]", (Object[])new Object[]{version, summary}), (Throwable)exception);
                } else {
                    assert (MasterService.this.publicationMayFail()) : exception;
                    MasterService.this.clusterStateUpdateStatsTracker.onPublicationFailure(MasterService.this.threadPool.rawRelativeTimeInMillis(), clusterStatePublicationEvent, 0L);
                    MasterService.this.handleException(summary, publicationStartTime, newClusterState, exception);
                }
            }

            public String toString() {
                return org.elasticsearch.common.Strings.format("publication completion listener for version [%d]", clusterStatePublicationEvent.getNewState().version());
            }
        }, new Runnable(){

            @Override
            public void run() {
                listener.onResponse(null);
            }

            public String toString() {
                return String.valueOf(listener) + "/onResponse";
            }
        }));
    }

    protected boolean publicationMayFail() {
        return false;
    }

    private TimeValue getTimeSince(long startTimeMillis) {
        return TimeValue.timeValueMillis((long)Math.max(0L, this.threadPool.rawRelativeTimeInMillis() - startTimeMillis));
    }

    protected void publish(ClusterStatePublicationEvent clusterStatePublicationEvent, ClusterStatePublisher.AckListener ackListener, ActionListener<Void> publicationListener) {
        this.clusterStatePublisher.publish(clusterStatePublicationEvent, new ThreadedActionListener<Void>(this.threadPoolExecutor, new ContextPreservingActionListener<Void>(this.threadPool.getThreadContext().newRestorableContext(false), publicationListener)), ackListener);
    }

    private void handleException(BatchSummary summary, long startTimeMillis, ClusterState newClusterState, Exception e) {
        logger.warn(() -> Strings.format((String)"took [%s] and then failed to publish updated cluster state (version: %s, uuid: %s) for [%s]:\n%s", (Object[])new Object[]{this.getTimeSince(startTimeMillis), newClusterState.version(), newClusterState.stateUUID(), summary, newClusterState}), (Throwable)e);
    }

    private ClusterState patchVersions(ClusterState previousClusterState, ClusterState newClusterState) {
        if (previousClusterState != newClusterState) {
            ClusterState.Builder builder = this.incrementVersion(newClusterState);
            if (previousClusterState.metadata() != newClusterState.metadata()) {
                builder.metadata(newClusterState.metadata().withIncrementedVersion());
            }
            Metadata previousMetadata = newClusterState.metadata();
            newClusterState = builder.build();
            assert (previousMetadata.sameIndicesLookup(newClusterState.metadata()));
        }
        return newClusterState;
    }

    public ClusterState.Builder incrementVersion(ClusterState clusterState) {
        return ClusterState.builder(clusterState).incrementVersion();
    }

    private static boolean versionNumbersPreserved(ClusterState oldState, ClusterState newState) {
        if (oldState.nodes().getMasterNodeId() == null && newState.nodes().getMasterNodeId() != null) {
            return true;
        }
        if (oldState.version() != newState.version()) {
            return false;
        }
        return oldState.metadata().version() == newState.metadata().version();
    }

    @Deprecated
    public void submitUnbatchedStateUpdateTask(String source, ClusterStateUpdateTask updateTask) {
        this.createTaskQueue("unbatched", updateTask.priority(), this.unbatchedExecutor).submitTask(source, updateTask, updateTask.timeout());
    }

    public List<PendingClusterTask> pendingTasks() {
        long currentTimeMillis = this.threadPool.relativeTimeInMillis();
        return this.allBatchesStream().flatMap(e -> e.getPending(currentTimeMillis)).toList();
    }

    public int numberOfPendingTasks() {
        return this.allBatchesStream().mapToInt(Batch::getPendingCount).sum();
    }

    public TimeValue getMaxTaskWaitTime() {
        long oldestTaskTimeMillis = this.allBatchesStream().mapToLong(Batch::getCreationTimeMillis).min().orElse(Long.MAX_VALUE);
        if (oldestTaskTimeMillis == Long.MAX_VALUE) {
            return TimeValue.ZERO;
        }
        return TimeValue.timeValueMillis((long)(this.threadPool.relativeTimeInMillis() - oldestTaskTimeMillis));
    }

    private Stream<Batch> allBatchesStream() {
        return Stream.concat(Stream.ofNullable(this.currentlyExecutingBatch), this.queuesByPriority.values().stream().filter(Objects::nonNull).flatMap(q -> q.queue.stream()));
    }

    private void logExecutionTime(TimeValue executionTime, String activity, BatchSummary summary) {
        if (executionTime.getMillis() > this.slowTaskLoggingThreshold.getMillis()) {
            logger.warn("took [{}/{}ms] to {} for [{}], which exceeds the warn threshold of [{}]", (Object)executionTime, (Object)executionTime.getMillis(), (Object)activity, (Object)summary, (Object)this.slowTaskLoggingThreshold);
        } else {
            logger.debug("took [{}] to {} for [{}]", (Object)executionTime, (Object)activity, (Object)summary);
        }
    }

    private static <T extends ClusterStateTaskListener> ClusterState executeTasks(ClusterState previousClusterState, List<ExecutionResult<T>> executionResults, ClusterStateTaskExecutor<T> executor, BatchSummary summary, ThreadContext threadContext) {
        ClusterState resultingState = MasterService.innerExecuteTasks(previousClusterState, executionResults, executor, summary, threadContext);
        if (previousClusterState != resultingState && previousClusterState.nodes().isLocalNodeElectedMaster() && !resultingState.nodes().isLocalNodeElectedMaster()) {
            throw new AssertionError((Object)"update task submitted to MasterService cannot remove master");
        }
        assert (MasterService.assertAllTasksComplete(executor, executionResults));
        return resultingState;
    }

    private static <T extends ClusterStateTaskListener> boolean assertAllTasksComplete(ClusterStateTaskExecutor<T> executor, List<ExecutionResult<T>> executionResults) {
        List<ExecutionResult> incompleteTaskContexts = executionResults.stream().filter(ExecutionResult::incomplete).toList();
        assert (incompleteTaskContexts.isEmpty()) : "cluster state task executors must mark all tasks as successful or failed, but [" + String.valueOf(executor) + "] left the following tasks incomplete: " + String.valueOf(incompleteTaskContexts);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static <T extends ClusterStateTaskListener> ClusterState innerExecuteTasks(ClusterState previousClusterState, List<ExecutionResult<T>> executionResults, ClusterStateTaskExecutor<T> executor, BatchSummary summary, ThreadContext threadContext) {
        try (ThreadContext.StoredContext ignored = threadContext.newStoredContext();){
            ClusterState clusterState;
            block16: {
                try {
                    ClusterState updatedState = executor.execute(new ClusterStateTaskExecutor.BatchExecutionContext<T>(previousClusterState, executionResults, threadContext::newStoredContext));
                    if (!MasterService.versionNumbersPreserved(previousClusterState, updatedState)) {
                        IllegalStateException exception = new IllegalStateException("cluster state update executor did not preserve version numbers: [" + summary.toString() + "]");
                        assert (threadContext.getTransient(TEST_ONLY_EXECUTOR_MAY_CHANGE_VERSION_NUMBER_TRANSIENT_NAME) != null) : exception;
                        throw exception;
                    }
                    clusterState = updatedState;
                    if ($assertionsDisabled || threadContext.getResponseHeaders().isEmpty()) break block16;
                }
                catch (Exception e) {
                    ClusterState clusterState2;
                    block18: {
                        block17: {
                            logger.trace(() -> Strings.format((String)"failed to execute cluster state update (on version: [%s], uuid: [%s]) for [%s]\n%s%s%s", (Object[])new Object[]{previousClusterState.version(), previousClusterState.stateUUID(), summary, previousClusterState.nodes(), previousClusterState.routingTable(), previousClusterState.getRoutingNodes()}), (Throwable)e);
                            for (ExecutionResult<T> executionResult : executionResults) {
                                executionResult.onBatchFailure(e);
                            }
                            clusterState2 = previousClusterState;
                            if ($assertionsDisabled || threadContext.getResponseHeaders().isEmpty()) break block17;
                            throw new AssertionError((Object)("Batched task executors must marshal response headers to the appropriate task context (e.g. using TaskContext#captureResponseHeaders) or suppress them (e.g. using BatchExecutionContext#dropHeadersContext) and must not leak them to the master service, but executor [" + String.valueOf(executor) + "] leaked the following headers: " + String.valueOf(threadContext.getResponseHeaders())));
                        }
                        if (ignored == null) break block18;
                        ignored.close();
                    }
                    return clusterState2;
                    {
                        catch (Throwable throwable) {
                            assert (threadContext.getResponseHeaders().isEmpty()) : "Batched task executors must marshal response headers to the appropriate task context (e.g. using TaskContext#captureResponseHeaders) or suppress them (e.g. using BatchExecutionContext#dropHeadersContext) and must not leak them to the master service, but executor [" + String.valueOf(executor) + "] leaked the following headers: " + String.valueOf(threadContext.getResponseHeaders());
                            throw throwable;
                        }
                    }
                }
                throw new AssertionError((Object)("Batched task executors must marshal response headers to the appropriate task context (e.g. using TaskContext#captureResponseHeaders) or suppress them (e.g. using BatchExecutionContext#dropHeadersContext) and must not leak them to the master service, but executor [" + String.valueOf(executor) + "] leaked the following headers: " + String.valueOf(threadContext.getResponseHeaders())));
            }
            return clusterState;
        }
    }

    public static boolean isPublishFailureException(Exception e) {
        return e instanceof NotMasterException || e instanceof FailedToCommitClusterStateException;
    }

    private Batch takeNextBatch() {
        assert (this.totalQueueSize.get() > 0);
        assert (this.currentlyExecutingBatch == null);
        for (PerPriorityQueue queue : this.queuesByPriority.values()) {
            Batch batch = queue.queue.poll();
            if (batch == null) continue;
            this.currentlyExecutingBatch = batch;
            return batch;
        }
        logger.error("queue processor found no items");
        assert (false) : "queue processor found no items";
        throw new IllegalStateException("queue processor found no items");
    }

    private void forkQueueProcessor() {
        if (!this.lifecycle.started()) {
            this.drainQueueOnRejection(new FailedToCommitClusterStateException("node closed", (Throwable)this.getRejectionException(), new Object[0]));
            return;
        }
        assert (this.totalQueueSize.get() > 0);
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignored = threadContext.newStoredContext();){
            this.clusterStateUpdateContext.restore();
            this.threadPoolExecutor.execute(this.queuesProcessor);
        }
    }

    private EsRejectedExecutionException getRejectionException() {
        assert (!this.lifecycle.started());
        return new EsRejectedExecutionException("master service is in state [" + String.valueOf((Object)this.lifecycleState()) + "]", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainQueueOnRejection(FailedToCommitClusterStateException e) {
        assert (this.totalQueueSize.get() > 0);
        do {
            assert (this.currentlyExecutingBatch == null);
            Batch nextBatch = this.takeNextBatch();
            assert (this.currentlyExecutingBatch == nextBatch);
            try {
                nextBatch.onRejection(e);
            }
            catch (Exception e2) {
                e2.addSuppressed(e);
                logger.error(() -> Strings.format((String)"exception failing batch on rejection [%s]", (Object[])new Object[]{nextBatch}), (Throwable)e2);
                assert (false) : e2;
            }
            finally {
                this.currentlyExecutingBatch = null;
            }
        } while (this.totalQueueSize.decrementAndGet() > 0);
    }

    public <T extends ClusterStateTaskListener> MasterServiceTaskQueue<T> createTaskQueue(String name, Priority priority, ClusterStateTaskExecutor<T> executor) {
        return new BatchingTaskQueue(name, this::executeAndPublishBatch, this.insertionIndexSupplier, this.queuesByPriority.get((Object)priority), executor, this.threadPool);
    }

    static String getTimeoutTaskDescription(String source, Object task, TimeValue timeout) {
        return org.elasticsearch.common.Strings.format("master service timeout handler for [%s][%s] after [%s]", source, task, timeout);
    }

    private static class ClusterStateUpdateStatsTracker {
        private long unchangedTaskCount;
        private long publicationSuccessCount;
        private long publicationFailureCount;
        private long unchangedComputationElapsedMillis;
        private long unchangedNotificationElapsedMillis;
        private long successfulComputationElapsedMillis;
        private long successfulPublicationElapsedMillis;
        private long successfulContextConstructionElapsedMillis;
        private long successfulCommitElapsedMillis;
        private long successfulCompletionElapsedMillis;
        private long successfulMasterApplyElapsedMillis;
        private long successfulNotificationElapsedMillis;
        private long failedComputationElapsedMillis;
        private long failedPublicationElapsedMillis;
        private long failedContextConstructionElapsedMillis;
        private long failedCommitElapsedMillis;
        private long failedCompletionElapsedMillis;
        private long failedMasterApplyElapsedMillis;
        private long failedNotificationElapsedMillis;

        private ClusterStateUpdateStatsTracker() {
        }

        synchronized void onUnchangedClusterState(long computationElapsedMillis, long notificationElapsedMillis) {
            ++this.unchangedTaskCount;
            this.unchangedComputationElapsedMillis += computationElapsedMillis;
            this.unchangedNotificationElapsedMillis += notificationElapsedMillis;
        }

        synchronized void onPublicationSuccess(long currentTimeMillis, ClusterStatePublicationEvent clusterStatePublicationEvent, long notificationElapsedMillis) {
            ++this.publicationSuccessCount;
            this.successfulComputationElapsedMillis += clusterStatePublicationEvent.getComputationTimeMillis();
            this.successfulPublicationElapsedMillis += currentTimeMillis - clusterStatePublicationEvent.getPublicationStartTimeMillis();
            this.successfulContextConstructionElapsedMillis += clusterStatePublicationEvent.getPublicationContextConstructionElapsedMillis();
            this.successfulCommitElapsedMillis += clusterStatePublicationEvent.getPublicationCommitElapsedMillis();
            this.successfulCompletionElapsedMillis += clusterStatePublicationEvent.getPublicationCompletionElapsedMillis();
            this.successfulMasterApplyElapsedMillis += clusterStatePublicationEvent.getMasterApplyElapsedMillis();
            this.successfulNotificationElapsedMillis += notificationElapsedMillis;
        }

        synchronized void onPublicationFailure(long currentTimeMillis, ClusterStatePublicationEvent clusterStatePublicationEvent, long notificationMillis) {
            ++this.publicationFailureCount;
            this.failedComputationElapsedMillis += clusterStatePublicationEvent.getComputationTimeMillis();
            this.failedPublicationElapsedMillis += currentTimeMillis - clusterStatePublicationEvent.getPublicationStartTimeMillis();
            this.failedContextConstructionElapsedMillis += clusterStatePublicationEvent.maybeGetPublicationContextConstructionElapsedMillis();
            this.failedCommitElapsedMillis += clusterStatePublicationEvent.maybeGetPublicationCommitElapsedMillis();
            this.failedCompletionElapsedMillis += clusterStatePublicationEvent.maybeGetPublicationCompletionElapsedMillis();
            this.failedMasterApplyElapsedMillis += clusterStatePublicationEvent.maybeGetMasterApplyElapsedMillis();
            this.failedNotificationElapsedMillis += notificationMillis;
        }

        synchronized ClusterStateUpdateStats getStatistics() {
            return new ClusterStateUpdateStats(this.unchangedTaskCount, this.publicationSuccessCount, this.publicationFailureCount, this.unchangedComputationElapsedMillis, this.unchangedNotificationElapsedMillis, this.successfulComputationElapsedMillis, this.successfulPublicationElapsedMillis, this.successfulContextConstructionElapsedMillis, this.successfulCommitElapsedMillis, this.successfulCompletionElapsedMillis, this.successfulMasterApplyElapsedMillis, this.successfulNotificationElapsedMillis, this.failedComputationElapsedMillis, this.failedPublicationElapsedMillis, this.failedContextConstructionElapsedMillis, this.failedCommitElapsedMillis, this.failedCompletionElapsedMillis, this.failedMasterApplyElapsedMillis, this.failedNotificationElapsedMillis);
        }
    }

    private class StarvationWatcher {
        private long lastLogMillis;
        private long nonemptySinceMillis;
        private boolean isEmpty = true;

        private StarvationWatcher() {
        }

        synchronized void onEmptyQueue() {
            this.isEmpty = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onNonemptyQueue() {
            long nonemptyDurationMillis;
            long nowMillis = MasterService.this.threadPool.relativeTimeInMillis();
            StarvationWatcher starvationWatcher = this;
            synchronized (starvationWatcher) {
                if (this.isEmpty) {
                    this.isEmpty = false;
                    this.nonemptySinceMillis = nowMillis;
                    this.lastLogMillis = nowMillis;
                    return;
                }
                if (nowMillis - this.lastLogMillis < MasterService.this.starvationLoggingThreshold.millis()) {
                    return;
                }
                this.lastLogMillis = nowMillis;
                nonemptyDurationMillis = nowMillis - this.nonemptySinceMillis;
            }
            TimeValue maxTaskWaitTime = MasterService.this.getMaxTaskWaitTime();
            logger.warn("pending task queue has been nonempty for [{}/{}ms] which is longer than the warn threshold of [{}ms]; there are currently [{}] pending tasks, the oldest of which has age [{}/{}ms]", (Object)TimeValue.timeValueMillis((long)nonemptyDurationMillis), (Object)nonemptyDurationMillis, (Object)MasterService.this.starvationLoggingThreshold.millis(), (Object)MasterService.this.numberOfPendingTasks(), (Object)maxTaskWaitTime, (Object)maxTaskWaitTime.millis());
        }
    }

    private class PerPriorityQueue {
        private final ConcurrentLinkedQueue<Batch> queue = new ConcurrentLinkedQueue();
        private final Priority priority;

        PerPriorityQueue(Priority priority) {
            this.priority = priority;
        }

        void execute(Batch runner) {
            this.queue.add(runner);
            if (MasterService.this.totalQueueSize.getAndIncrement() == 0) {
                MasterService.this.starvationWatcher.onEmptyQueue();
                MasterService.this.forkQueueProcessor();
            }
        }

        Priority priority() {
            return this.priority;
        }
    }

    private static class UnbatchedExecutor
    implements ClusterStateTaskExecutor<ClusterStateUpdateTask> {
        private UnbatchedExecutor() {
        }

        @Override
        @SuppressForbidden(reason="consuming published cluster state for legacy reasons")
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<ClusterStateUpdateTask> batchExecutionContext) throws Exception {
            ClusterState newState;
            assert (batchExecutionContext.taskContexts().size() == 1) : "this only supports a single task but received " + String.valueOf(batchExecutionContext.taskContexts());
            ClusterStateTaskExecutor.TaskContext<ClusterStateUpdateTask> taskContext = batchExecutionContext.taskContexts().get(0);
            ClusterStateUpdateTask task = taskContext.getTask();
            try (Releasable ignored = taskContext.captureResponseHeaders();){
                newState = task.execute(batchExecutionContext.initialState());
            }
            Consumer<ClusterState> publishListener = publishedState -> task.clusterStateProcessed(batchExecutionContext.initialState(), (ClusterState)publishedState);
            if (task instanceof ClusterStateAckListener) {
                ClusterStateAckListener ackListener = (ClusterStateAckListener)((Object)task);
                taskContext.success(publishListener, ackListener);
            } else {
                taskContext.success(publishListener);
            }
            return newState;
        }

        @Override
        public String describeTasks(List<ClusterStateUpdateTask> tasks) {
            return "";
        }
    }

    private static class ExecutionResult<T extends ClusterStateTaskListener>
    implements ClusterStateTaskExecutor.TaskContext<T> {
        private final String source;
        private final T task;
        private final ThreadContext threadContext;
        private final Supplier<ThreadContext.StoredContext> threadContextSupplier;
        @Nullable
        Consumer<ClusterState> publishedStateConsumer;
        @Nullable
        Runnable onPublicationSuccess;
        @Nullable
        ClusterStateAckListener clusterStateAckListener;
        @Nullable
        Exception failure;
        @Nullable
        Map<String, List<String>> responseHeaders;

        ExecutionResult(String source, T task, ThreadContext threadContext, Supplier<ThreadContext.StoredContext> threadContextSupplier) {
            this.source = source;
            this.task = task;
            this.threadContext = threadContext;
            this.threadContextSupplier = threadContextSupplier;
        }

        public String getSource() {
            return this.source;
        }

        @Override
        public T getTask() {
            return this.task;
        }

        private boolean incomplete() {
            assert (MasterService.assertMasterUpdateOrTestThread());
            return this.publishedStateConsumer == null && this.onPublicationSuccess == null && this.failure == null;
        }

        @Override
        public void success(Runnable onPublicationSuccess) {
            assert (!(this.getTask() instanceof ClusterStateAckListener)) : "tasks that implement ClusterStateAckListener must explicitly supply themselves as the ack listener";
            assert (this.incomplete());
            this.onPublicationSuccess = Objects.requireNonNull(onPublicationSuccess);
        }

        @Override
        public void success(Consumer<ClusterState> publishListener) {
            assert (!(this.getTask() instanceof ClusterStateAckListener)) : "tasks that implement ClusterStateAckListener must explicitly supply themselves as the ack listener";
            assert (this.incomplete());
            this.publishedStateConsumer = Objects.requireNonNull(publishListener);
        }

        @Override
        public void success(Runnable onPublicationSuccess, ClusterStateAckListener clusterStateAckListener) {
            assert (this.getTask() == clusterStateAckListener || !(this.getTask() instanceof ClusterStateAckListener)) : "tasks that implement ClusterStateAckListener must not supply a separate clusterStateAckListener";
            assert (this.incomplete());
            this.onPublicationSuccess = Objects.requireNonNull(onPublicationSuccess);
            this.clusterStateAckListener = Objects.requireNonNull(clusterStateAckListener);
        }

        @Override
        public void success(Consumer<ClusterState> publishListener, ClusterStateAckListener clusterStateAckListener) {
            assert (this.getTask() == clusterStateAckListener || !(this.getTask() instanceof ClusterStateAckListener)) : "tasks that implement ClusterStateAckListener must not supply a separate clusterStateAckListener";
            assert (this.incomplete());
            this.publishedStateConsumer = Objects.requireNonNull(publishListener);
            this.clusterStateAckListener = Objects.requireNonNull(clusterStateAckListener);
        }

        @Override
        public void onFailure(Exception failure) {
            assert (this.incomplete());
            this.failure = Objects.requireNonNull(failure);
        }

        @Override
        public Releasable captureResponseHeaders() {
            ThreadContext.StoredContext storedContext = this.threadContext.newStoredContext();
            return Releasables.wrap((Releasable[])new Releasable[]{() -> {
                Map<String, List<String>> newResponseHeaders = this.threadContext.getResponseHeaders();
                if (newResponseHeaders.isEmpty()) {
                    return;
                }
                if (this.responseHeaders == null) {
                    this.responseHeaders = new HashMap<String, List<String>>(newResponseHeaders);
                } else {
                    for (Map.Entry<String, List<String>> newResponseHeader : newResponseHeaders.entrySet()) {
                        this.responseHeaders.compute(newResponseHeader.getKey(), (ignored, oldValue) -> {
                            if (oldValue == null) {
                                return (List)newResponseHeader.getValue();
                            }
                            return CollectionUtils.concatLists(oldValue, (Collection)newResponseHeader.getValue());
                        });
                    }
                }
            }, storedContext});
        }

        private void restoreResponseHeaders() {
            if (this.responseHeaders != null) {
                for (Map.Entry<String, List<String>> responseHeader : this.responseHeaders.entrySet()) {
                    for (String value : responseHeader.getValue()) {
                        this.threadContext.addResponseHeader(responseHeader.getKey(), value);
                    }
                }
            }
        }

        void onBatchFailure(Exception failure) {
            this.failure = Objects.requireNonNull(failure);
            this.publishedStateConsumer = null;
            this.clusterStateAckListener = null;
        }

        void onPublishSuccess(ClusterState newClusterState) {
            if (this.publishedStateConsumer == null && this.onPublicationSuccess == null) {
                this.notifyFailure();
                return;
            }
            try (ThreadContext.StoredContext ignored = this.threadContextSupplier.get();){
                this.restoreResponseHeaders();
                if (this.onPublicationSuccess == null) {
                    this.publishedStateConsumer.accept(newClusterState);
                } else {
                    this.onPublicationSuccess.run();
                }
            }
            catch (Exception e) {
                logger.error("exception thrown by listener while notifying of new cluster state", (Throwable)e);
            }
        }

        void onClusterStateUnchanged(ClusterState clusterState) {
            if (this.publishedStateConsumer == null && this.onPublicationSuccess == null) {
                this.notifyFailure();
                return;
            }
            try (ThreadContext.StoredContext ignored = this.threadContextSupplier.get();){
                this.restoreResponseHeaders();
                if (this.onPublicationSuccess == null) {
                    this.publishedStateConsumer.accept(clusterState);
                } else {
                    this.onPublicationSuccess.run();
                }
            }
            catch (Exception e) {
                logger.error("exception thrown by listener while notifying of unchanged cluster state", (Throwable)e);
            }
        }

        void onPublishFailure(FailedToCommitClusterStateException e) {
            if (this.publishedStateConsumer == null && this.onPublicationSuccess == null) {
                assert (this.failure != null);
                Exception taskFailure = this.failure;
                this.failure = new FailedToCommitClusterStateException(e.getMessage(), (Throwable)e, new Object[0]);
                this.failure.addSuppressed(taskFailure);
                this.notifyFailure();
                return;
            }
            try (ThreadContext.StoredContext ignored = this.threadContextSupplier.get();){
                this.restoreResponseHeaders();
                this.getTask().onFailure(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.error("exception thrown by listener notifying of failure", (Throwable)inner);
            }
        }

        void notifyFailure() {
            assert (this.failure != null);
            try (ThreadContext.StoredContext ignore = this.threadContextSupplier.get();){
                this.restoreResponseHeaders();
                this.getTask().onFailure(this.failure);
            }
            catch (Exception inner) {
                inner.addSuppressed(this.failure);
                logger.error("exception thrown by listener notifying of failure", (Throwable)inner);
            }
        }

        ContextPreservingAckListener getContextPreservingAckListener() {
            assert (!this.incomplete());
            if (this.clusterStateAckListener == null || this.failure != null) {
                return null;
            }
            return new ContextPreservingAckListener(this.clusterStateAckListener, this.threadContextSupplier, this::restoreResponseHeaders);
        }

        public String toString() {
            return "TaskContext[" + String.valueOf(this.task) + "]";
        }
    }

    private record ContextPreservingAckListener(ClusterStateAckListener listener, Supplier<ThreadContext.StoredContext> context, Runnable restoreResponseHeaders) {
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return this.listener.mustAck(discoveryNode);
        }

        public void onAckSuccess() {
            try (ThreadContext.StoredContext ignore = this.context.get();){
                this.restoreResponseHeaders.run();
                this.listener.onAllNodesAcked();
            }
            catch (Exception inner) {
                logger.error("exception thrown by listener while notifying on all nodes acked", (Throwable)inner);
            }
        }

        public void onAckFailure(Exception e) {
            try (ThreadContext.StoredContext ignore = this.context.get();){
                this.restoreResponseHeaders.run();
                this.listener.onAckFailure(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.error("exception thrown by listener while notifying on all nodes acked or failed", (Throwable)inner);
            }
        }

        public void onAckTimeout() {
            try (ThreadContext.StoredContext ignore = this.context.get();){
                this.restoreResponseHeaders.run();
                this.listener.onAckTimeout();
            }
            catch (Exception e) {
                logger.error("exception thrown by listener while notifying on ack timeout", (Throwable)e);
            }
        }

        public TimeValue ackTimeout() {
            return this.listener.ackTimeout();
        }
    }

    private record CompositeTaskAckListener(List<TaskAckListener> listeners) implements ClusterStatePublisher.AckListener
    {
        @Override
        public void onCommit(TimeValue commitTime) {
            for (TaskAckListener listener : this.listeners) {
                listener.onCommit(commitTime);
            }
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Exception e) {
            for (TaskAckListener listener : this.listeners) {
                listener.onNodeAck(node, e);
            }
        }
    }

    private static interface Batch {
        public void run(ActionListener<Void> var1);

        public void onRejection(FailedToCommitClusterStateException var1);

        public int getPendingCount();

        public Stream<PendingClusterTask> getPending(long var1);

        public long getCreationTimeMillis();
    }

    private static class BatchingTaskQueue<T extends ClusterStateTaskListener>
    implements MasterServiceTaskQueue<T> {
        private final ConcurrentLinkedQueue<Entry<T>> queue = new ConcurrentLinkedQueue();
        private final ConcurrentLinkedQueue<Entry<T>> executing = new ConcurrentLinkedQueue();
        private final AtomicInteger queueSize = new AtomicInteger();
        private final String name;
        private final BatchConsumer<T> batchConsumer;
        private final LongSupplier insertionIndexSupplier;
        private final PerPriorityQueue perPriorityQueue;
        private final ClusterStateTaskExecutor<T> executor;
        private final ThreadPool threadPool;
        private final Batch processor = new Processor();

        BatchingTaskQueue(String name, BatchConsumer<T> batchConsumer, LongSupplier insertionIndexSupplier, PerPriorityQueue perPriorityQueue, ClusterStateTaskExecutor<T> executor, ThreadPool threadPool) {
            this.name = name;
            this.batchConsumer = batchConsumer;
            this.insertionIndexSupplier = insertionIndexSupplier;
            this.perPriorityQueue = perPriorityQueue;
            this.executor = executor;
            this.threadPool = threadPool;
        }

        @Override
        public void submitTask(String source, T task, @Nullable TimeValue timeout) {
            Scheduler.ScheduledCancellable timeoutCancellable;
            AtomicReference<T> taskHolder = new AtomicReference<T>(task);
            if (timeout != null && timeout.millis() > 0L) {
                try {
                    timeoutCancellable = this.threadPool.schedule(new TaskTimeoutHandler<T>(timeout, source, taskHolder), timeout, this.threadPool.generic());
                }
                catch (Exception e) {
                    EsRejectedExecutionException esre;
                    assert (e instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e).isExecutorShutdown()) : e;
                    task.onFailure(new FailedToCommitClusterStateException("could not schedule timeout handler for [%s][%s] on queue [%s]", (Throwable)e, source, task, this.name));
                    return;
                }
            } else {
                timeoutCancellable = null;
            }
            this.queue.add(new Entry<T>(source, taskHolder, this.insertionIndexSupplier.getAsLong(), this.threadPool.relativeTimeInMillis(), this.threadPool.getThreadContext().newRestorableContext(true), timeoutCancellable));
            if (this.queueSize.getAndIncrement() == 0) {
                this.perPriorityQueue.execute(this.processor);
            }
        }

        public String toString() {
            return "BatchingTaskQueue[" + this.name + "]";
        }

        private class Processor
        implements Batch {
            private Processor() {
            }

            @Override
            public void onRejection(FailedToCommitClusterStateException e) {
                int items = BatchingTaskQueue.this.queueSize.getAndSet(0);
                for (int i = 0; i < items; ++i) {
                    Entry entry = BatchingTaskQueue.this.queue.poll();
                    assert (entry != null);
                    entry.onRejection(e);
                }
            }

            @Override
            public void run(ActionListener<Void> listener) {
                assert (BatchingTaskQueue.this.executing.isEmpty()) : BatchingTaskQueue.this.executing;
                int entryCount = BatchingTaskQueue.this.queueSize.getAndSet(0);
                int taskCount = 0;
                ArrayList tasks = new ArrayList(entryCount);
                for (int i = 0; i < entryCount; ++i) {
                    Entry entry = BatchingTaskQueue.this.queue.poll();
                    assert (entry != null);
                    Object task = entry.acquireForExecution();
                    if (task == null) continue;
                    ++taskCount;
                    BatchingTaskQueue.this.executing.add(entry);
                    tasks.add(new ExecutionResult(entry.source(), task, BatchingTaskQueue.this.threadPool.getThreadContext(), entry.storedContextSupplier()));
                }
                if (taskCount == 0) {
                    listener.onResponse(null);
                    return;
                }
                int finalTaskCount = taskCount;
                ActionListener.run(ActionListener.runBefore(listener, () -> {
                    assert (BatchingTaskQueue.this.executing.size() == finalTaskCount);
                    BatchingTaskQueue.this.executing.clear();
                }), l -> BatchingTaskQueue.this.batchConsumer.runBatch(BatchingTaskQueue.this.executor, tasks, new BatchSummary(() -> this.buildTasksDescription(tasks)), (ActionListener<Void>)l));
            }

            private String buildTasksDescription(List<ExecutionResult<T>> tasks) {
                HashMap<String, List> tasksBySource = new HashMap<String, List>();
                for (ExecutionResult entry : tasks) {
                    tasksBySource.computeIfAbsent(entry.getSource(), ignored -> new ArrayList()).add(entry.getTask());
                }
                StringBuilder output = new StringBuilder();
                org.elasticsearch.common.Strings.collectionToDelimitedStringWithLimit(() -> tasksBySource.entrySet().stream().map(entry -> {
                    String tasksDescription = BatchingTaskQueue.this.executor.describeTasks((List)entry.getValue());
                    return tasksDescription.isEmpty() ? (String)entry.getKey() : (String)entry.getKey() + "[" + tasksDescription + "]";
                }).filter(s -> !s.isEmpty()).iterator(), ", ", 8192, output);
                if (output.length() > 8192) {
                    output.append(" (").append(tasks.size()).append(" tasks in total)");
                }
                return output.toString();
            }

            @Override
            public Stream<PendingClusterTask> getPending(long currentTimeMillis) {
                return Stream.concat(BatchingTaskQueue.this.executing.stream().map(entry -> this.makePendingTask((Entry)entry, currentTimeMillis, true)), BatchingTaskQueue.this.queue.stream().filter(Entry::isPending).map(entry -> this.makePendingTask((Entry)entry, currentTimeMillis, false)));
            }

            private PendingClusterTask makePendingTask(Entry<T> entry, long currentTimeMillis, boolean executing) {
                return new PendingClusterTask(entry.insertionIndex(), BatchingTaskQueue.this.perPriorityQueue.priority(), new Text(entry.source()), Math.max(0L, currentTimeMillis - entry.insertionTimeMillis()), executing);
            }

            @Override
            public int getPendingCount() {
                int count = BatchingTaskQueue.this.executing.size();
                for (Entry entry : BatchingTaskQueue.this.queue) {
                    if (!entry.isPending()) continue;
                    ++count;
                }
                return count;
            }

            @Override
            public long getCreationTimeMillis() {
                return Stream.concat(BatchingTaskQueue.this.executing.stream(), BatchingTaskQueue.this.queue.stream().filter(Entry::isPending)).mapToLong(Entry::insertionTimeMillis).min().orElse(Long.MAX_VALUE);
            }

            public String toString() {
                return "process queue for [" + BatchingTaskQueue.this.name + "]";
            }
        }

        private record Entry<T extends ClusterStateTaskListener>(String source, AtomicReference<T> taskHolder, long insertionIndex, long insertionTimeMillis, Supplier<ThreadContext.StoredContext> storedContextSupplier, @Nullable Scheduler.Cancellable timeoutCancellable) {
            T acquireForExecution() {
                ClusterStateTaskListener task = this.taskHolder.getAndSet(null);
                if (task != null && this.timeoutCancellable != null) {
                    this.timeoutCancellable.cancel();
                }
                return (T)task;
            }

            void onRejection(FailedToCommitClusterStateException e) {
                block9: {
                    Object task = this.acquireForExecution();
                    if (task != null) {
                        try (ThreadContext.StoredContext ignored = this.storedContextSupplier.get();){
                            task.onFailure(e);
                        }
                        catch (Exception e2) {
                            e2.addSuppressed(e);
                            logger.error(() -> Strings.format((String)"exception failing task [%s] on rejection", (Object[])new Object[]{task}), (Throwable)e2);
                            if ($assertionsDisabled) break block9;
                            throw new AssertionError((Object)e2);
                        }
                    }
                }
            }

            boolean isPending() {
                return this.taskHolder().get() != null;
            }
        }
    }

    @FunctionalInterface
    private static interface BatchConsumer<T extends ClusterStateTaskListener> {
        public void runBatch(ClusterStateTaskExecutor<T> var1, List<ExecutionResult<T>> var2, BatchSummary var3, ActionListener<Void> var4);
    }

    private static class TaskAckListener {
        private final ContextPreservingAckListener contextPreservingAckListener;
        private final TimeValue ackTimeout;
        private final CountDown countDown;
        private final DiscoveryNode masterNode;
        private final ThreadPool threadPool;
        private final long clusterStateVersion;
        private volatile Scheduler.Cancellable ackTimeoutCallback;
        private Exception lastFailure;

        TaskAckListener(ContextPreservingAckListener contextPreservingAckListener, long clusterStateVersion, DiscoveryNodes nodes, ThreadPool threadPool) {
            this.contextPreservingAckListener = contextPreservingAckListener;
            this.ackTimeout = Objects.requireNonNull(contextPreservingAckListener.ackTimeout());
            this.clusterStateVersion = clusterStateVersion;
            this.threadPool = threadPool;
            this.masterNode = nodes.getMasterNode();
            int countDown = 0;
            for (DiscoveryNode node : nodes) {
                if (!node.equals(this.masterNode) && !contextPreservingAckListener.mustAck(node)) continue;
                ++countDown;
            }
            logger.trace("expecting {} acknowledgements for cluster_state update (version: {})", (Object)countDown, (Object)clusterStateVersion);
            this.countDown = new CountDown(countDown + 1);
        }

        public void onCommit(TimeValue commitTime) {
            if (this.ackTimeout.millis() < 0L) {
                if (this.countDown.countDown()) {
                    this.finish();
                }
                return;
            }
            TimeValue timeLeft = TimeValue.timeValueNanos((long)Math.max(0L, this.ackTimeout.nanos() - commitTime.nanos()));
            if (timeLeft.nanos() == 0L) {
                this.onTimeout();
            } else if (this.countDown.countDown()) {
                this.finish();
            } else {
                this.ackTimeoutCallback = this.threadPool.schedule(this::onTimeout, timeLeft, this.threadPool.generic());
                if (this.countDown.isCountedDown()) {
                    this.ackTimeoutCallback.cancel();
                }
            }
        }

        public void onNodeAck(DiscoveryNode node, @Nullable Exception e) {
            if (!node.equals(this.masterNode) && !this.contextPreservingAckListener.mustAck(node)) {
                return;
            }
            if (e == null) {
                logger.trace("ack received from node [{}], cluster_state update (version: {})", (Object)node, (Object)this.clusterStateVersion);
            } else {
                this.lastFailure = e;
                logger.debug(() -> Strings.format((String)"ack received from node [%s], cluster_state update (version: %s)", (Object[])new Object[]{node, this.clusterStateVersion}), (Throwable)e);
            }
            if (this.countDown.countDown()) {
                this.finish();
            }
        }

        private void finish() {
            Exception failure;
            logger.trace("all expected nodes acknowledged cluster_state update (version: {})", (Object)this.clusterStateVersion);
            if (this.ackTimeoutCallback != null) {
                this.ackTimeoutCallback.cancel();
            }
            if ((failure = this.lastFailure) == null) {
                this.contextPreservingAckListener.onAckSuccess();
            } else {
                this.contextPreservingAckListener.onAckFailure(failure);
            }
        }

        public void onTimeout() {
            if (this.countDown.fastForward()) {
                logger.trace("timeout waiting for acknowledgement for cluster_state update (version: {})", (Object)this.clusterStateVersion);
                this.contextPreservingAckListener.onAckTimeout();
            }
        }
    }

    private static class TaskTimeoutHandler<T extends ClusterStateTaskListener>
    extends AbstractRunnable {
        private final TimeValue timeout;
        private final String source;
        private final AtomicReference<T> taskHolder;

        private TaskTimeoutHandler(TimeValue timeout, String source, AtomicReference<T> taskHolder) {
            this.timeout = timeout;
            this.source = source;
            this.taskHolder = taskHolder;
        }

        @Override
        public void onRejection(Exception e) {
            EsRejectedExecutionException esre;
            assert (e instanceof EsRejectedExecutionException && (esre = (EsRejectedExecutionException)e).isExecutorShutdown()) : e;
            this.completeTask(e);
        }

        @Override
        public void onFailure(Exception e) {
            logger.error("unexpected failure executing task timeout handler", (Throwable)e);
            assert (false) : e;
            this.completeTask(e);
        }

        @Override
        public boolean isForceExecution() {
            return true;
        }

        @Override
        protected void doRun() {
            this.completeTask(new ProcessClusterEventTimeoutException(this.timeout, this.source));
        }

        private void completeTask(Exception e) {
            ClusterStateTaskListener task = this.taskHolder.getAndSet(null);
            if (task != null) {
                logger.trace("timing out [{}][{}] after [{}]", (Object)this.source, (Object)task, (Object)this.timeout);
                task.onFailure(e);
            }
        }

        public String toString() {
            return MasterService.getTimeoutTaskDescription(this.source, this.taskHolder.get(), this.timeout);
        }
    }
}

