/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.CheckedConsumer;

public abstract class FilterBlobContainer
implements BlobContainer {
    private final BlobContainer delegate;

    public FilterBlobContainer(BlobContainer delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected abstract BlobContainer wrapChild(BlobContainer var1);

    @Override
    public BlobPath path() {
        return this.delegate.path();
    }

    @Override
    public boolean blobExists(OperationPurpose purpose, String blobName) throws IOException {
        return this.delegate.blobExists(purpose, blobName);
    }

    @Override
    public InputStream readBlob(OperationPurpose purpose, String blobName) throws IOException {
        return this.delegate.readBlob(purpose, blobName);
    }

    @Override
    public InputStream readBlob(OperationPurpose purpose, String blobName, long position, long length) throws IOException {
        return this.delegate.readBlob(purpose, blobName, position, length);
    }

    @Override
    public long readBlobPreferredLength() {
        return this.delegate.readBlobPreferredLength();
    }

    @Override
    public void writeBlob(OperationPurpose purpose, String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.delegate.writeBlob(purpose, blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    @Override
    public void writeMetadataBlob(OperationPurpose purpose, String blobName, boolean failIfAlreadyExists, boolean atomic, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
        this.delegate.writeMetadataBlob(purpose, blobName, failIfAlreadyExists, atomic, writer);
    }

    @Override
    public void writeBlobAtomic(OperationPurpose purpose, String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.delegate.writeBlobAtomic(purpose, blobName, inputStream, blobSize, failIfAlreadyExists);
    }

    @Override
    public void writeBlobAtomic(OperationPurpose purpose, String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        this.delegate.writeBlobAtomic(purpose, blobName, bytes, failIfAlreadyExists);
    }

    @Override
    public DeleteResult delete(OperationPurpose purpose) throws IOException {
        return this.delegate.delete(purpose);
    }

    @Override
    public void deleteBlobsIgnoringIfNotExists(OperationPurpose purpose, Iterator<String> blobNames) throws IOException {
        this.delegate.deleteBlobsIgnoringIfNotExists(purpose, blobNames);
    }

    @Override
    public Map<String, BlobMetadata> listBlobs(OperationPurpose purpose) throws IOException {
        return this.delegate.listBlobs(purpose);
    }

    @Override
    public Map<String, BlobContainer> children(OperationPurpose purpose) throws IOException {
        return this.delegate.children(purpose).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.wrapChild((BlobContainer)e.getValue())));
    }

    @Override
    public Map<String, BlobMetadata> listBlobsByPrefix(OperationPurpose purpose, String blobNamePrefix) throws IOException {
        return this.delegate.listBlobsByPrefix(purpose, blobNamePrefix);
    }

    @Override
    public void compareAndExchangeRegister(OperationPurpose purpose, String key, BytesReference expected, BytesReference updated, ActionListener<OptionalBytesReference> listener) {
        this.delegate.compareAndExchangeRegister(purpose, key, expected, updated, listener);
    }

    @Override
    public void compareAndSetRegister(OperationPurpose purpose, String key, BytesReference expected, BytesReference updated, ActionListener<Boolean> listener) {
        this.delegate.compareAndSetRegister(purpose, key, expected, updated, listener);
    }

    @Override
    public void getRegister(OperationPurpose purpose, String key, ActionListener<OptionalBytesReference> listener) {
        this.delegate.getRegister(purpose, key, listener);
    }
}

