/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public abstract class BlockStoredFieldsReader
implements BlockLoader.RowStrideReader {
    @Override
    public boolean canReuse(int startingDocID) {
        return true;
    }

    private static class Id
    extends BlockStoredFieldsReader {
        private final BytesRef scratch = new BytesRef();

        private Id() {
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(BlockSourceReader.toBytesRef(this.scratch, storedFields.id()));
        }

        public String toString() {
            return "BlockStoredFieldsReader.Id";
        }
    }

    public static class IdBlockLoader
    extends StoredFieldsBlockLoader {
        public IdBlockLoader() {
            super("_id");
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
            return new Id();
        }
    }

    private static abstract class Bytes
    extends BlockStoredFieldsReader {
        private final String field;

        Bytes(String field) {
            this.field = field;
        }

        protected abstract BytesRef toBytesRef(Object var1);

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            List<Object> values = storedFields.storedFields().get(this.field);
            if (values == null) {
                builder.appendNull();
                return;
            }
            if (values.size() == 1) {
                ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(this.toBytesRef(values.get(0)));
                return;
            }
            builder.beginPositionEntry();
            for (Object v : values) {
                ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(this.toBytesRef(v));
            }
            builder.endPositionEntry();
        }

        public String toString() {
            return "BlockStoredFieldsReader.Bytes";
        }
    }

    public static class BytesFromStringsBlockLoader
    extends StoredFieldsBlockLoader {
        public BytesFromStringsBlockLoader(String field) {
            super(field);
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) {
            return new Bytes(this, this.field){
                private final BytesRef scratch = new BytesRef();

                @Override
                protected BytesRef toBytesRef(Object v) {
                    return BlockSourceReader.toBytesRef(this.scratch, (String)v);
                }
            };
        }
    }

    public static class BytesFromBytesRefsBlockLoader
    extends StoredFieldsBlockLoader {
        public BytesFromBytesRefsBlockLoader(String field) {
            super(field);
        }

        @Override
        public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
            return factory.bytesRefs(expectedCount);
        }

        @Override
        public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
            return new Bytes(this, this.field){

                @Override
                protected BytesRef toBytesRef(Object v) {
                    return (BytesRef)v;
                }
            };
        }
    }

    private static abstract class StoredFieldsBlockLoader
    implements BlockLoader {
        protected final String field;

        StoredFieldsBlockLoader(String field) {
            this.field = field;
        }

        @Override
        public final BlockLoader.ColumnAtATimeReader columnAtATimeReader(LeafReaderContext context) {
            return null;
        }

        @Override
        public final StoredFieldsSpec rowStrideStoredFieldSpec() {
            return new StoredFieldsSpec(false, false, Set.of(this.field));
        }

        @Override
        public final boolean supportsOrdinals() {
            return false;
        }

        @Override
        public final SortedSetDocValues ordinals(LeafReaderContext context) {
            throw new UnsupportedOperationException();
        }
    }
}

