/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;

class ExitableDirectoryReader
extends FilterDirectoryReader {
    ExitableDirectoryReader(DirectoryReader in, final QueryCancellation queryCancellation) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            public LeafReader wrap(LeafReader reader) {
                return new ExitableLeafReader(reader, queryCancellation);
            }
        });
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) {
        throw new UnsupportedOperationException("doWrapDirectoryReader() should never be invoked");
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    private static KnnVectorValues.DocIndexIterator createExitableIterator(final KnnVectorValues.DocIndexIterator delegate, final QueryCancellation queryCancellation) {
        return new KnnVectorValues.DocIndexIterator(){
            private int calls;

            public int index() {
                return delegate.index();
            }

            public int docID() {
                return delegate.docID();
            }

            public long cost() {
                return delegate.cost();
            }

            public int nextDoc() throws IOException {
                int nextDoc = delegate.nextDoc();
                this.checkAndThrowWithSampling();
                return nextDoc;
            }

            public int advance(int target) throws IOException {
                int advance = delegate.advance(target);
                this.checkAndThrowWithSampling();
                return advance;
            }

            private void checkAndThrowWithSampling() {
                if ((this.calls++ & 0x1FFF) == 0) {
                    queryCancellation.checkCancelled();
                }
            }
        };
    }

    static interface QueryCancellation {
        public boolean isEnabled();

        public void checkCancelled();
    }

    private static abstract class FilterFloatVectorValues
    extends FloatVectorValues {
        protected final FloatVectorValues in;

        protected FilterFloatVectorValues(FloatVectorValues in) {
            Objects.requireNonNull(in);
            this.in = in;
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.in.iterator();
        }

        public float[] vectorValue(int ord) throws IOException {
            return this.in.vectorValue(ord);
        }

        public FloatVectorValues copy() throws IOException {
            return this.in.copy();
        }

        public int dimension() {
            return this.in.dimension();
        }

        public int size() {
            return this.in.size();
        }
    }

    private static class ExitableDocSetIterator
    extends DocIdSetIterator {
        private int calls;
        private final DocIdSetIterator in;
        private final QueryCancellation queryCancellation;

        private ExitableDocSetIterator(DocIdSetIterator in, QueryCancellation queryCancellation) {
            this.in = in;
            this.queryCancellation = queryCancellation;
        }

        public int docID() {
            return this.in.docID();
        }

        public int advance(int target) throws IOException {
            int advance = this.in.advance(target);
            this.checkAndThrowWithSampling();
            return advance;
        }

        public int nextDoc() throws IOException {
            int nextDoc = this.in.nextDoc();
            this.checkAndThrowWithSampling();
            return nextDoc;
        }

        public long cost() {
            return this.in.cost();
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }
    }

    private static class ExitableFloatVectorValues
    extends FilterFloatVectorValues {
        private final QueryCancellation queryCancellation;

        ExitableFloatVectorValues(FloatVectorValues vectorValues, QueryCancellation queryCancellation) {
            super(vectorValues);
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        @Override
        public float[] vectorValue(int ord) throws IOException {
            return this.in.vectorValue(ord);
        }

        public int ordToDoc(int ord) {
            return this.in.ordToDoc(ord);
        }

        public VectorScorer scorer(float[] target) throws IOException {
            final VectorScorer scorer = this.in.scorer(target);
            if (scorer == null) {
                return null;
            }
            return new VectorScorer(){
                private final DocIdSetIterator iterator;
                {
                    this.iterator = new ExitableDocSetIterator(scorer.iterator(), queryCancellation);
                }

                public float score() throws IOException {
                    return scorer.score();
                }

                public DocIdSetIterator iterator() {
                    return this.iterator;
                }
            };
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return ExitableDirectoryReader.createExitableIterator(this.in.iterator(), this.queryCancellation);
        }

        @Override
        public FloatVectorValues copy() throws IOException {
            return this.in.copy();
        }
    }

    private static class ExitableByteVectorValues
    extends ByteVectorValues {
        private final QueryCancellation queryCancellation;
        private final ByteVectorValues in;

        private ExitableByteVectorValues(QueryCancellation queryCancellation, ByteVectorValues in) {
            this.queryCancellation = queryCancellation;
            this.in = in;
        }

        public int dimension() {
            return this.in.dimension();
        }

        public int size() {
            return this.in.size();
        }

        public byte[] vectorValue(int ord) throws IOException {
            return this.in.vectorValue(ord);
        }

        public int ordToDoc(int ord) {
            return this.in.ordToDoc(ord);
        }

        public VectorScorer scorer(byte[] bytes) throws IOException {
            final VectorScorer scorer = this.in.scorer(bytes);
            if (scorer == null) {
                return null;
            }
            return new VectorScorer(){
                private final DocIdSetIterator iterator;
                {
                    this.iterator = new ExitableDocSetIterator(scorer.iterator(), queryCancellation);
                }

                public float score() throws IOException {
                    return scorer.score();
                }

                public DocIdSetIterator iterator() {
                    return this.iterator;
                }
            };
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return ExitableDirectoryReader.createExitableIterator(this.in.iterator(), this.queryCancellation);
        }

        public ByteVectorValues copy() throws IOException {
            return this.in.copy();
        }
    }

    private static class ExitableIntersectVisitor
    implements PointValues.IntersectVisitor {
        static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 8191;
        private final QueryCancellation queryCancellation;
        private PointValues.IntersectVisitor in;
        private int calls;

        private ExitableIntersectVisitor(QueryCancellation queryCancellation) {
            this.queryCancellation = queryCancellation;
        }

        private void setIntersectVisitor(PointValues.IntersectVisitor in) {
            this.in = in;
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        public void visit(int docID) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID);
        }

        public void visit(DocIdSetIterator iterator) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(iterator);
        }

        public void visit(int docID, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID, packedValue);
        }

        public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(iterator, packedValue);
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.queryCancellation.checkCancelled();
            return this.in.compare(minPackedValue, maxPackedValue);
        }

        public void grow(int count) {
            this.queryCancellation.checkCancelled();
            this.in.grow(count);
        }
    }

    private static class ExitablePointTree
    implements PointValues.PointTree {
        private final PointValues pointValues;
        private final PointValues.PointTree in;
        private final ExitableIntersectVisitor exitableIntersectVisitor;
        private final QueryCancellation queryCancellation;
        private int calls;

        private ExitablePointTree(PointValues pointValues, PointValues.PointTree in, QueryCancellation queryCancellation) {
            this.pointValues = pointValues;
            this.in = in;
            this.queryCancellation = queryCancellation;
            this.exitableIntersectVisitor = new ExitableIntersectVisitor(queryCancellation);
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        public PointValues.PointTree clone() {
            this.queryCancellation.checkCancelled();
            return new ExitablePointTree(this.pointValues, this.in.clone(), this.queryCancellation);
        }

        public boolean moveToChild() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToChild();
        }

        public boolean moveToSibling() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToSibling();
        }

        public boolean moveToParent() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToParent();
        }

        public byte[] getMinPackedValue() {
            this.checkAndThrowWithSampling();
            return this.in.getMinPackedValue();
        }

        public byte[] getMaxPackedValue() {
            this.checkAndThrowWithSampling();
            return this.in.getMaxPackedValue();
        }

        public long size() {
            this.queryCancellation.checkCancelled();
            return this.in.size();
        }

        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.in.visitDocIDs(visitor);
        }

        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.exitableIntersectVisitor.setIntersectVisitor(visitor);
            this.in.visitDocValues((PointValues.IntersectVisitor)this.exitableIntersectVisitor);
        }
    }

    static class ExitablePointValues
    extends PointValues {
        private final PointValues in;
        private final QueryCancellation queryCancellation;

        private ExitablePointValues(PointValues in, QueryCancellation queryCancellation) {
            this.in = in;
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        public PointValues.PointTree getPointTree() throws IOException {
            this.queryCancellation.checkCancelled();
            return new ExitablePointTree(this.in, this.in.getPointTree(), this.queryCancellation);
        }

        public byte[] getMinPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMinPackedValue();
        }

        public byte[] getMaxPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMaxPackedValue();
        }

        public int getNumDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumDimensions();
        }

        public int getNumIndexDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumIndexDimensions();
        }

        public int getBytesPerDimension() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getBytesPerDimension();
        }

        public long size() {
            this.queryCancellation.checkCancelled();
            return this.in.size();
        }

        public int getDocCount() {
            this.queryCancellation.checkCancelled();
            return this.in.getDocCount();
        }
    }

    private static class ExitableTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 15;
        private int calls;
        private final QueryCancellation queryCancellation;

        private ExitableTermsEnum(TermsEnum termsEnum, QueryCancellation queryCancellation) {
            super(termsEnum);
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0xF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        public BytesRef next() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.next();
        }
    }

    static class ExitableTerms
    extends FilterLeafReader.FilterTerms {
        private final QueryCancellation queryCancellation;

        ExitableTerms(Terms terms, QueryCancellation queryCancellation) {
            super(terms);
            this.queryCancellation = queryCancellation;
        }

        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new ExitableTermsEnum(this.in.intersect(compiled, startTerm), this.queryCancellation);
        }

        public TermsEnum iterator() throws IOException {
            return new ExitableTermsEnum(this.in.iterator(), this.queryCancellation);
        }

        public BytesRef getMin() throws IOException {
            return this.in.getMin();
        }

        public BytesRef getMax() throws IOException {
            return this.in.getMax();
        }
    }

    static class ExitableLeafReader
    extends SequentialStoredFieldsLeafReader {
        private final QueryCancellation queryCancellation;

        private ExitableLeafReader(LeafReader leafReader, QueryCancellation queryCancellation) {
            super(leafReader);
            this.queryCancellation = queryCancellation;
        }

        public PointValues getPointValues(String field) throws IOException {
            PointValues pointValues = this.in.getPointValues(field);
            if (pointValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitablePointValues(pointValues, this.queryCancellation) : pointValues;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            if (terms == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() && !(terms instanceof CompletionTerms) ? new ExitableTerms(terms, this.queryCancellation) : terms;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        @Override
        protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
            return reader;
        }

        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            ByteVectorValues vectorValues = this.in.getByteVectorValues(field);
            if (vectorValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitableByteVectorValues(this.queryCancellation, vectorValues) : vectorValues;
        }

        public void searchNearestVectors(String field, byte[] target, KnnCollector collector, Bits acceptDocs) throws IOException {
            if (!this.queryCancellation.isEnabled()) {
                this.in.searchNearestVectors(field, target, collector, acceptDocs);
                return;
            }
            this.in.searchNearestVectors(field, target, collector, (Bits)new TimeOutCheckingBits(acceptDocs));
        }

        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            FloatVectorValues vectorValues = this.in.getFloatVectorValues(field);
            if (vectorValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitableFloatVectorValues(vectorValues, this.queryCancellation) : vectorValues;
        }

        public void searchNearestVectors(String field, float[] target, KnnCollector collector, Bits acceptDocs) throws IOException {
            if (!this.queryCancellation.isEnabled()) {
                this.in.searchNearestVectors(field, target, collector, acceptDocs);
                return;
            }
            this.in.searchNearestVectors(field, target, collector, (Bits)new TimeOutCheckingBits(acceptDocs));
        }

        private class TimeOutCheckingBits
        implements Bits {
            private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 10;
            private final Bits updatedAcceptDocs;
            private int calls;

            TimeOutCheckingBits(Bits acceptDocs) {
                this.updatedAcceptDocs = acceptDocs == null ? new Bits.MatchAllBits(ExitableLeafReader.this.maxDoc()) : acceptDocs;
            }

            public boolean get(int index) {
                if (this.calls++ % 10 == 0) {
                    ExitableLeafReader.this.queryCancellation.checkCancelled();
                }
                return this.updatedAcceptDocs.get(index);
            }

            public int length() {
                return this.updatedAcceptDocs.length();
            }
        }
    }
}

