/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteForecastAction;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.ml.utils.QueryBuilderHelper;

public class TransportDeleteForecastAction
extends HandledTransportAction<DeleteForecastAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteForecastAction.class);
    private final Client client;
    private final ClusterService clusterService;
    private static final int MAX_FORECAST_TO_SEARCH = 10000;
    private static final Set<String> DELETABLE_STATUSES = Stream.of(ForecastRequestStats.ForecastRequestStatus.FINISHED, ForecastRequestStats.ForecastRequestStatus.FAILED).map(ForecastRequestStats.ForecastRequestStatus::toString).collect(Collectors.toSet());

    @Inject
    public TransportDeleteForecastAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService) {
        super("cluster:admin/xpack/ml/job/forecast/delete", transportService, actionFilters, DeleteForecastAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, DeleteForecastAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String jobId = request.getJobId();
        String forecastsExpression = request.getForecastId();
        String[] forecastIds = Strings.splitStringByCommaToArray((String)forecastsExpression);
        ActionListener forecastStatsHandler = ActionListener.wrap(searchResponse -> this.deleteForecasts((SearchResponse)searchResponse, request, listener), e -> TransportDeleteForecastAction.handleFailure(e, request, listener));
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_forecast_request_stats"));
        QueryBuilderHelper.buildTokenFilterQuery(Forecast.FORECAST_ID.getPreferredName(), forecastIds).ifPresent(arg_0 -> ((BoolQueryBuilder)query).filter(arg_0));
        SearchSourceBuilder source = new SearchSourceBuilder().size(10000).fetchSource(false).docValueField(ForecastRequestStats.FORECAST_ID.getPreferredName()).docValueField(ForecastRequestStats.STATUS.getPreferredName()).query((QueryBuilder)query);
        SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId)}).source(source);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportSearchAction.TYPE, (ActionRequest)searchRequest, (ActionListener)forecastStatsHandler);
    }

    static List<String> extractForecastIds(SearchHit[] forecastsToDelete, JobState jobState, String jobId) {
        ArrayList<String> forecastIds = new ArrayList<String>(forecastsToDelete.length);
        ArrayList<String> badStatusForecastIds = new ArrayList<String>();
        for (SearchHit hit : forecastsToDelete) {
            String forecastId = (String)hit.field(ForecastRequestStats.FORECAST_ID.getPreferredName()).getValue();
            String forecastStatus = (String)hit.field(ForecastRequestStats.STATUS.getPreferredName()).getValue();
            if (DELETABLE_STATUSES.contains(forecastStatus)) {
                forecastIds.add(forecastId);
                continue;
            }
            badStatusForecastIds.add(forecastId);
        }
        if (badStatusForecastIds.size() > 0 && JobState.OPENED.equals((Object)jobState)) {
            throw org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Forecast(s) [{0}] for job [{1}] needs to be either FAILED or FINISHED to be deleted", (Object[])new Object[]{badStatusForecastIds, jobId}), (Object[])new Object[0]);
        }
        return forecastIds;
    }

    private void deleteForecasts(SearchResponse searchResponse, DeleteForecastAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        List<String> forecastIds;
        String jobId = request.getJobId();
        SearchHits forecastsToDelete = searchResponse.getHits();
        if (forecastsToDelete.getHits().length == 0) {
            if (Strings.isAllOrWildcard((String)request.getForecastId()) && request.isAllowNoForecasts()) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"No forecast(s) [{0}] exists for job [{1}]", (Object[])new Object[]{request.getForecastId(), jobId}), new Object[0])));
            }
            return;
        }
        ClusterState state = this.clusterService.state();
        PersistentTasksCustomMetadata persistentTasks = (PersistentTasksCustomMetadata)state.metadata().custom("persistent_tasks");
        JobState jobState = MlTasks.getJobState((String)jobId, (PersistentTasksCustomMetadata)persistentTasks);
        try {
            forecastIds = TransportDeleteForecastAction.extractForecastIds(forecastsToDelete.getHits(), jobState, jobId);
        }
        catch (ElasticsearchException ex) {
            listener.onFailure((Exception)((Object)ex));
            return;
        }
        DeleteByQueryRequest deleteByQueryRequest = TransportDeleteForecastAction.buildDeleteByQuery(jobId, forecastIds);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.isTimedOut()) {
                listener.onFailure((Exception)new TimeoutException("Delete request timed out. Successfully deleted " + response.getDeleted() + " forecast documents from job [" + jobId + "]"));
                return;
            }
            if (!(response.getBulkFailures().isEmpty() && response.getSearchFailures().isEmpty())) {
                Tuple<RestStatus, Throwable> statusAndReason = TransportDeleteForecastAction.getStatusAndReason(response);
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException(((Throwable)statusAndReason.v2()).getMessage(), (RestStatus)statusAndReason.v1(), (Throwable)statusAndReason.v2(), new Object[0])));
                return;
            }
            logger.info("Deleted forecast(s) [{}] from job [{}]", (Object)forecastIds, (Object)jobId);
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }, e -> TransportDeleteForecastAction.handleFailure(e, request, listener)));
    }

    private static Tuple<RestStatus, Throwable> getStatusAndReason(BulkByScrollResponse response) {
        RestStatus status = RestStatus.OK;
        Throwable reason = new Exception("Unknown error");
        for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
            if (failure.getStatus().getStatus() <= status.getStatus()) continue;
            status = failure.getStatus();
            reason = failure.getCause();
        }
        for (BulkItemResponse.Failure failure : response.getSearchFailures()) {
            RestStatus failureStatus = ExceptionsHelper.status((Throwable)failure.getReason());
            if (failureStatus.getStatus() <= status.getStatus()) continue;
            status = failureStatus;
            reason = failure.getReason();
        }
        return new Tuple((Object)status, (Object)reason);
    }

    private static DeleteByQueryRequest buildDeleteByQuery(String jobId, List<String> forecastsToDelete) {
        BoolQueryBuilder innerBoolQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)Result.RESULT_TYPE.getPreferredName(), (String[])new String[]{"model_forecast_request_stats", "model_forecast"})).must((QueryBuilder)QueryBuilders.termsQuery((String)Forecast.FORECAST_ID.getPreferredName(), forecastsToDelete));
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)innerBoolQuery);
        return (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest().setAbortOnVersionConflict(false)).setSlices(0)).indices(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId)}).setQuery((QueryBuilder)query).setRefresh(true);
    }

    private static void handleFailure(Exception e, DeleteForecastAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        if (org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
            if (request.isAllowNoForecasts() && Strings.isAllOrWildcard((String)request.getForecastId())) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                listener.onFailure((Exception)((Object)new ResourceNotFoundException(Messages.getMessage((String)"No forecast(s) [{0}] exists for job [{1}]", (Object[])new Object[]{request.getForecastId(), request.getJobId()}), new Object[0])));
            }
        } else if (e instanceof ElasticsearchException) {
            ElasticsearchException elasticsearchException = (ElasticsearchException)((Object)e);
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("An error occurred while searching forecasts to delete", elasticsearchException.status(), (Throwable)elasticsearchException, new Object[0])));
        } else {
            listener.onFailure((Exception)((Object)new ElasticsearchException("An error occurred while searching forecasts to delete", (Throwable)e, new Object[0])));
        }
    }
}

