/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelDefinitionPartAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.IndexLocation;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModelLocation;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelDefinitionDoc;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;

public class TransportPutTrainedModelDefinitionPartAction
extends HandledTransportAction<PutTrainedModelDefinitionPartAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutTrainedModelDefinitionPartAction.class);
    private final TrainedModelProvider trainedModelProvider;
    private final XPackLicenseState licenseState;
    private final OriginSettingClient client;

    @Inject
    public TransportPutTrainedModelDefinitionPartAction(TransportService transportService, XPackLicenseState licenseState, ActionFilters actionFilters, Client client, TrainedModelProvider trainedModelProvider) {
        super("cluster:admin/xpack/ml/trained_models/part/put", transportService, actionFilters, PutTrainedModelDefinitionPartAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = licenseState;
        this.trainedModelProvider = trainedModelProvider;
        this.client = new OriginSettingClient(client, "ml");
    }

    protected void doExecute(Task task, PutTrainedModelDefinitionPartAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        if (!MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        ActionListener configActionListener = ActionListener.wrap(config -> {
            TrainedModelLocation location = config.getLocation();
            if (location == null) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("cannot put definition for model [{}] as location is null", RestStatus.BAD_REQUEST, new Object[]{request.getModelId()})));
                return;
            }
            boolean isEos = request.getPart() == request.getTotalParts() - 1;
            String indexName = ((IndexLocation)location).getIndexName();
            this.trainedModelProvider.storeTrainedModelDefinitionDoc(new TrainedModelDefinitionDoc.Builder().setModelId(request.getModelId()).setDocNum(request.getPart()).setEos(isEos).setDefinitionLength(request.getDefinition().length()).setTotalDefinitionLength(request.getTotalDefinitionLength()).setCompressionVersion(1).setBinaryData(request.getDefinition()).build(), indexName, (ActionListener<Void>)ActionListener.wrap(stored -> {
                if (isEos) {
                    this.client.admin().indices().prepareRefresh(new String[]{indexName}).execute(ActionListener.wrap(refreshed -> listener.onResponse((Object)AcknowledgedResponse.TRUE), failure -> {
                        logger.warn(() -> Strings.format((String)"[%s] failed to refresh index [%s]", (Object[])new Object[]{request.getModelId(), indexName}), (Throwable)failure);
                        listener.onResponse((Object)AcknowledgedResponse.TRUE);
                    }));
                    return;
                }
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), request.isOverwritingAllowed());
        }, arg_0 -> listener.onFailure(arg_0));
        this.trainedModelProvider.getTrainedModel(request.getModelId(), GetTrainedModelsAction.Includes.empty(), null, (ActionListener<TrainedModelConfig>)configActionListener);
    }
}

