/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoPointFromStringEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToGeoPoint
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToGeoPoint", ToGeoPoint::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.GEO_POINT, (source, fieldEval) -> fieldEval), Map.entry(DataType.KEYWORD, ToGeoPointFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToGeoPointFromStringEvaluator.Factory::new), Map.entry(DataType.SEMANTIC_TEXT, ToGeoPointFromStringEvaluator.Factory::new));

    @FunctionInfo(returnType={"geo_point"}, description="Converts an input value to a `geo_point` value.\nA string will only be successfully converted if it respects the\n{wikipedia}/Well-known_text_representation_of_geometry[WKT Point] format.", examples={@Example(file="spatial", tag="to_geopoint-str")})
    public ToGeoPoint(Source source, @Param(name="field", type={"geo_point", "keyword", "text"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToGeoPoint(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToGeoPoint.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.GEO_POINT;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToGeoPoint(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToGeoPoint::new, (Object)this.field());
    }

    static BytesRef fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.stringToSpatial(in.utf8ToString());
    }
}

