/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Hash;

public final class HashConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final BreakingBytesRefBuilder scratch;
    private final Hash.HashFunction algorithm;
    private final EvalOperator.ExpressionEvaluator input;
    private final DriverContext driverContext;
    private Warnings warnings;

    public HashConstantEvaluator(Source source, BreakingBytesRefBuilder scratch, Hash.HashFunction algorithm, EvalOperator.ExpressionEvaluator input, DriverContext driverContext) {
        this.source = source;
        this.scratch = scratch;
        this.algorithm = algorithm;
        this.input = input;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock inputBlock = (BytesRefBlock)this.input.eval(page);){
            BytesRefVector inputVector = inputBlock.asVector();
            if (inputVector == null) {
                BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), inputBlock);
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), inputVector).asBlock();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock inputBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef inputScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (inputBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (inputBlock.getValueCount(p) != 1) {
                    if (inputBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBytesRef(Hash.processConstant(this.scratch, this.algorithm, inputBlock.getBytesRef(inputBlock.getFirstValueIndex(p), inputScratch)));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, BytesRefVector inputVector) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            BytesRef inputScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBytesRef(Hash.processConstant(this.scratch, this.algorithm, inputVector.getBytesRef(p, inputScratch)));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "HashConstantEvaluator[algorithm=" + String.valueOf(this.algorithm) + ", input=" + String.valueOf(this.input) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.scratch, this.input});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final Function<DriverContext, BreakingBytesRefBuilder> scratch;
        private final Function<DriverContext, Hash.HashFunction> algorithm;
        private final EvalOperator.ExpressionEvaluator.Factory input;

        public Factory(Source source, Function<DriverContext, BreakingBytesRefBuilder> scratch, Function<DriverContext, Hash.HashFunction> algorithm, EvalOperator.ExpressionEvaluator.Factory input) {
            this.source = source;
            this.scratch = scratch;
            this.algorithm = algorithm;
            this.input = input;
        }

        public HashConstantEvaluator get(DriverContext context) {
            return new HashConstantEvaluator(this.source, this.scratch.apply(context), this.algorithm.apply(context), this.input.get(context), context);
        }

        public String toString() {
            return "HashConstantEvaluator[algorithm=" + String.valueOf(this.algorithm) + ", input=" + String.valueOf(this.input) + "]";
        }
    }
}

