/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.show;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Build;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class ShowInfo
extends LeafPlan
implements TelemetryAware {
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public ShowInfo(Source source) {
        super(source);
        for (String name : List.of("version", "date", "hash")) {
            this.attributes.add((Attribute)new ReferenceAttribute(Source.EMPTY, name, DataType.KEYWORD));
        }
    }

    public void writeTo(StreamOutput out) {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    @Override
    public List<Attribute> output() {
        return this.attributes;
    }

    public List<List<Object>> values() {
        ArrayList<BytesRef> row = new ArrayList<BytesRef>(this.attributes.size());
        row.add(new BytesRef((CharSequence)Build.current().version()));
        row.add(new BytesRef((CharSequence)Build.current().date()));
        row.add(new BytesRef((CharSequence)Build.current().hash()));
        return List.of(row);
    }

    @Override
    public String telemetryLabel() {
        return "SHOW";
    }

    @Override
    public boolean expressionsResolved() {
        return true;
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass();
    }
}

