/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.countedkeyword;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.AbstractSortedSetDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractIndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.KeywordDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class CountedKeywordFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "counted_keyword";
    public static final String COUNT_FIELD_NAME_SUFFIX = "_count";
    private static final FieldType FIELD_TYPE_INDEXED;
    private static final FieldType FIELD_TYPE_NOT_INDEXED;
    public static FieldMapper.TypeParser PARSER;
    private final FieldType fieldType;
    private final BinaryFieldMapper countFieldMapper;
    private final Mapper.SourceKeepMode indexSourceKeepMode;

    private static CountedKeywordFieldMapper toType(FieldMapper in) {
        return (CountedKeywordFieldMapper)in;
    }

    protected CountedKeywordFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, BinaryFieldMapper countFieldMapper, Mapper.SourceKeepMode indexSourceKeepMode) {
        super(simpleName, mappedFieldType, builderParams);
        this.fieldType = fieldType;
        this.countFieldMapper = countFieldMapper;
        this.indexSourceKeepMode = indexSourceKeepMode;
    }

    public boolean parsesArrayValue() {
        return true;
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        TreeMap<String, Integer> values = new TreeMap<String, Integer>();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
            this.parseArray(context, values);
        } else if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            CountedKeywordFieldMapper.parseValue(parser, values);
        } else {
            throw new IllegalArgumentException("Encountered unexpected token [" + String.valueOf(parser.currentToken()) + "].");
        }
        if (values.isEmpty()) {
            return;
        }
        int i = 0;
        int[] counts = new int[values.size()];
        for (Map.Entry value : values.entrySet()) {
            context.doc().add((IndexableField)new KeywordFieldMapper.KeywordField(this.fullPath(), new BytesRef((CharSequence)value.getKey()), this.fieldType));
            counts[i++] = (Integer)value.getValue();
        }
        BytesStreamOutput streamOutput = new BytesStreamOutput();
        streamOutput.writeVIntArray(counts);
        context.doc().add((IndexableField)new BinaryDocValuesField(this.countFieldMapper.fullPath(), streamOutput.bytes().toBytesRef()));
    }

    private void parseArray(DocumentParserContext context, SortedMap<String, Integer> values) throws IOException {
        XContentParser.Token token;
        XContentParser parser = context.parser();
        int arrDepth = 1;
        while (true) {
            if ((token = parser.nextToken()) == XContentParser.Token.END_ARRAY) {
                if (--arrDepth > 0) continue;
                return;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                CountedKeywordFieldMapper.parseValue(parser, values);
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                ++arrDepth;
                continue;
            }
            if (token != XContentParser.Token.VALUE_NULL) break;
        }
        throw new IllegalArgumentException("Encountered unexpected token [" + String.valueOf(token) + "].");
    }

    private static void parseValue(XContentParser parser, SortedMap<String, Integer> values) throws IOException {
        String value = parser.text();
        if (!values.containsKey(value)) {
            values.put(value, 1);
        } else {
            values.put(value, (Integer)values.get(value) + 1);
        }
    }

    public Iterator<Mapper> iterator() {
        ArrayList<Object> mappers = new ArrayList<Object>();
        Iterator m = super.iterator();
        while (m.hasNext()) {
            mappers.add((Mapper)m.next());
        }
        mappers.add(this.countFieldMapper);
        return mappers.iterator();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexSourceKeepMode).init(this);
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        Mapper.SourceKeepMode keepMode = this.sourceKeepMode().orElse(this.indexSourceKeepMode);
        if (keepMode != Mapper.SourceKeepMode.NONE) {
            return super.syntheticSourceSupport();
        }
        return new FieldMapper.SyntheticSourceSupport.Native(() -> new CountedKeywordFieldSyntheticSourceLoader(this.fullPath(), this.countFieldMapper.fullPath(), this.leafName()));
    }

    static {
        FieldType indexed = new FieldType();
        indexed.setDocValuesType(DocValuesType.SORTED_SET);
        indexed.setTokenized(false);
        indexed.setOmitNorms(true);
        indexed.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE_INDEXED = CountedKeywordFieldMapper.freezeAndDeduplicateFieldType((FieldType)indexed);
        FieldType notIndexed = new FieldType();
        notIndexed.setDocValuesType(DocValuesType.SORTED_SET);
        notIndexed.setTokenized(false);
        notIndexed.setOmitNorms(true);
        notIndexed.setIndexOptions(IndexOptions.NONE);
        FIELD_TYPE_NOT_INDEXED = CountedKeywordFieldMapper.freezeAndDeduplicateFieldType((FieldType)notIndexed);
        PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getIndexSettings().sourceKeepMode()));
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> CountedKeywordFieldMapper.toType(m).mappedFieldType.isIndexed(), (boolean)true);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final Mapper.SourceKeepMode indexSourceKeepMode;

        protected Builder(String name, Mapper.SourceKeepMode indexSourceKeepMode) {
            super(name);
            this.indexSourceKeepMode = indexSourceKeepMode;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta, this.indexed};
        }

        public FieldMapper build(MapperBuilderContext context) {
            BinaryFieldMapper countFieldMapper = new BinaryFieldMapper.Builder(this.leafName() + CountedKeywordFieldMapper.COUNT_FIELD_NAME_SUFFIX, context.isSourceSynthetic()).docValues(true).build(context);
            boolean isIndexed = (Boolean)this.indexed.getValue();
            FieldType ft = isIndexed ? FIELD_TYPE_INDEXED : FIELD_TYPE_NOT_INDEXED;
            return new CountedKeywordFieldMapper(this.leafName(), ft, (MappedFieldType)new CountedKeywordFieldType(context.buildFullName(this.leafName()), isIndexed, false, true, new TextSearchInfo(ft, null, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER), (Map)this.meta.getValue(), countFieldMapper.fieldType()), this.builderParams((Mapper.Builder)this, context), countFieldMapper, this.indexSourceKeepMode);
        }
    }

    private static class CountedKeywordFieldSyntheticSourceLoader
    extends SourceLoader.DocValuesBasedSyntheticFieldLoader {
        private final String keywordsFieldName;
        private final String countsFieldName;
        private final String leafName;
        private SortedSetDocValues keywordsReader;
        private BinaryDocValues countsReader;
        private boolean hasValue;

        CountedKeywordFieldSyntheticSourceLoader(String keywordsFieldName, String countsFieldName, String leafName) {
            this.keywordsFieldName = keywordsFieldName;
            this.countsFieldName = countsFieldName;
            this.leafName = leafName;
        }

        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.keywordsReader = leafReader.getSortedSetDocValues(this.keywordsFieldName);
            this.countsReader = leafReader.getBinaryDocValues(this.countsFieldName);
            if (this.keywordsReader == null || this.countsReader == null) {
                return null;
            }
            return docId -> {
                this.hasValue = this.keywordsReader.advanceExact(docId);
                if (!this.hasValue) {
                    return false;
                }
                boolean countsHasValue = this.countsReader.advanceExact(docId);
                assert (countsHasValue);
                return true;
            };
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public void write(XContentBuilder b) throws IOException {
            boolean singleValue;
            if (!this.hasValue) {
                return;
            }
            int[] counts = new BytesArray(this.countsReader.binaryValue()).streamInput().readVIntArray();
            boolean bl = singleValue = counts.length == 1 && counts[0] == 1;
            if (singleValue) {
                b.field(this.leafName);
            } else {
                b.startArray(this.leafName);
            }
            for (int i = 0; i < this.keywordsReader.docValueCount(); ++i) {
                BytesRef currKeyword = this.keywordsReader.lookupOrd(this.keywordsReader.nextOrd());
                for (int j = 0; j < counts[i]; ++j) {
                    b.utf8Value(currKeyword.bytes, currKeyword.offset, currKeyword.length);
                }
            }
            if (!singleValue) {
                b.endArray();
            }
        }

        public String fieldName() {
            return this.keywordsFieldName;
        }
    }

    static class CountedKeywordSortedBinaryDocValues
    extends AbstractSortedSetDocValues {
        private final SortedSetDocValues dvValues;
        private final BinaryDocValues dvCounts;
        private int sumCount;
        private Iterator<Long> ordsForThisDoc;
        private final ByteArrayStreamInput scratch = new ByteArrayStreamInput();

        CountedKeywordSortedBinaryDocValues(SortedSetDocValues dvValues, BinaryDocValues dvCounts) {
            this.dvValues = dvValues;
            this.dvCounts = dvCounts;
        }

        public boolean advanceExact(int doc) throws IOException {
            this.sumCount = 0;
            if (this.dvValues.advanceExact(doc)) {
                boolean exactMatch = this.dvCounts.advanceExact(doc);
                assert (exactMatch);
                BytesRef encodedValue = this.dvCounts.binaryValue();
                this.scratch.reset(encodedValue.bytes, encodedValue.offset, encodedValue.length);
                int[] counts = this.scratch.readVIntArray();
                assert (counts.length == this.dvValues.docValueCount());
                ArrayList<Long> values = new ArrayList<Long>();
                for (int count : counts) {
                    this.sumCount += count;
                    long ord = this.dvValues.nextOrd();
                    for (int j = 0; j < count; ++j) {
                        values.add(ord);
                    }
                }
                this.ordsForThisDoc = values.iterator();
                return true;
            }
            this.ordsForThisDoc = null;
            return false;
        }

        public int docValueCount() {
            return this.sumCount;
        }

        public long nextOrd() {
            assert (this.ordsForThisDoc.hasNext());
            return this.ordsForThisDoc.next();
        }

        public BytesRef lookupOrd(long ord) throws IOException {
            return this.dvValues.lookupOrd(ord);
        }

        public long getValueCount() {
            return this.dvValues.getValueCount();
        }

        public TermsEnum termsEnum() throws IOException {
            return this.dvValues.termsEnum();
        }
    }

    private static class CountedKeywordFieldType
    extends StringFieldType {
        private final MappedFieldType countFieldType;

        CountedKeywordFieldType(String name, boolean isIndexed, boolean isStored, boolean hasDocValues, TextSearchInfo textSearchInfo, Map<String, String> meta, MappedFieldType countFieldType) {
            super(name, isIndexed, isStored, hasDocValues, textSearchInfo, meta);
            this.countFieldType = countFieldType;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> new AbstractIndexOrdinalsFieldData(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, cache, breakerService, (dv, n) -> new KeywordDocValuesField(FieldData.toString((SortedSetDocValues)dv), n)){

                public LeafOrdinalsFieldData load(LeafReaderContext context) {
                    BinaryDocValues dvCounts;
                    SortedSetDocValues dvValues;
                    try {
                        dvValues = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.getFieldName());
                        dvCounts = DocValues.getBinary((LeafReader)context.reader(), (String)countFieldType.name());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Unable to load counted_keyword doc values", e);
                    }
                    return new AbstractLeafOrdinalsFieldData(this, this.toScriptFieldFactory){

                        public SortedSetDocValues getOrdinalsValues() {
                            return new CountedKeywordSortedBinaryDocValues(dvValues, dvCounts);
                        }

                        public long ramBytesUsed() {
                            return 0L;
                        }
                    };
                }

                public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) {
                    return this.load(context);
                }

                public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
                    throw new UnsupportedOperationException("can't sort on the [counted_keyword] field");
                }

                public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                    throw new IllegalArgumentException("can't sort on the [counted_keyword] field");
                }
            };
        }

        public String typeName() {
            return CountedKeywordFieldMapper.CONTENT_TYPE;
        }
    }
}

