/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datatiers;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;

public class DataTiersFeatureSetUsage
extends XPackFeatureUsage {
    private final Map<String, TierSpecificStats> tierStats;

    public DataTiersFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.tierStats = in.readMap(TierSpecificStats::new);
    }

    public DataTiersFeatureSetUsage(Map<String, TierSpecificStats> tierStats) {
        super("data_tiers", true, true);
        this.tierStats = tierStats;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }

    public Map<String, TierSpecificStats> getTierStats() {
        return Collections.unmodifiableMap(this.tierStats);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.tierStats, StreamOutput::writeWriteable);
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        for (Map.Entry<String, TierSpecificStats> entry : this.tierStats.entrySet()) {
            builder.field(entry.getKey(), (ToXContent)entry.getValue());
        }
    }

    public int hashCode() {
        return Objects.hash(this.tierStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataTiersFeatureSetUsage other = (DataTiersFeatureSetUsage)obj;
        return Objects.equals(this.available, other.available) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.tierStats, other.tierStats);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static class TierSpecificStats
    implements Writeable,
    ToXContentObject {
        public final int nodeCount;
        public final int indexCount;
        public final int totalShardCount;
        public final int primaryShardCount;
        public final long docCount;
        public final long totalByteCount;
        public final long primaryByteCount;
        public final long primaryByteCountMedian;
        public final long primaryShardBytesMAD;

        public TierSpecificStats(StreamInput in) throws IOException {
            this.nodeCount = in.readVInt();
            this.indexCount = in.readVInt();
            this.totalShardCount = in.readVInt();
            this.primaryShardCount = in.readVInt();
            this.docCount = in.readVLong();
            this.totalByteCount = in.readVLong();
            this.primaryByteCount = in.readVLong();
            this.primaryByteCountMedian = in.readVLong();
            this.primaryShardBytesMAD = in.readVLong();
        }

        public TierSpecificStats(int nodeCount, int indexCount, int totalShardCount, int primaryShardCount, long docCount, long totalByteCount, long primaryByteCount, long primaryByteCountMedian, long primaryShardBytesMAD) {
            this.nodeCount = nodeCount;
            this.indexCount = indexCount;
            this.totalShardCount = totalShardCount;
            this.primaryShardCount = primaryShardCount;
            this.docCount = docCount;
            this.totalByteCount = totalByteCount;
            this.primaryByteCount = primaryByteCount;
            this.primaryByteCountMedian = primaryByteCountMedian;
            this.primaryShardBytesMAD = primaryShardBytesMAD;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.nodeCount);
            out.writeVInt(this.indexCount);
            out.writeVInt(this.totalShardCount);
            out.writeVInt(this.primaryShardCount);
            out.writeVLong(this.docCount);
            out.writeVLong(this.totalByteCount);
            out.writeVLong(this.primaryByteCount);
            out.writeVLong(this.primaryByteCountMedian);
            out.writeVLong(this.primaryShardBytesMAD);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("node_count", this.nodeCount);
            builder.field("index_count", this.indexCount);
            builder.field("total_shard_count", this.totalShardCount);
            builder.field("primary_shard_count", this.primaryShardCount);
            builder.field("doc_count", this.docCount);
            builder.humanReadableField("total_size_bytes", "total_size", (Object)ByteSizeValue.ofBytes((long)this.totalByteCount));
            builder.humanReadableField("primary_size_bytes", "primary_size", (Object)ByteSizeValue.ofBytes((long)this.primaryByteCount));
            builder.humanReadableField("primary_shard_size_avg_bytes", "primary_shard_size_avg", (Object)ByteSizeValue.ofBytes((long)(this.primaryShardCount == 0 ? 0L : this.primaryByteCount / (long)this.primaryShardCount)));
            builder.humanReadableField("primary_shard_size_median_bytes", "primary_shard_size_median", (Object)ByteSizeValue.ofBytes((long)this.primaryByteCountMedian));
            builder.humanReadableField("primary_shard_size_mad_bytes", "primary_shard_size_mad", (Object)ByteSizeValue.ofBytes((long)this.primaryShardBytesMAD));
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.nodeCount, this.indexCount, this.totalShardCount, this.primaryShardCount, this.totalByteCount, this.primaryByteCount, this.docCount, this.primaryByteCountMedian, this.primaryShardBytesMAD);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TierSpecificStats other = (TierSpecificStats)obj;
            return this.nodeCount == other.nodeCount && this.indexCount == other.indexCount && this.totalShardCount == other.totalShardCount && this.primaryShardCount == other.primaryShardCount && this.docCount == other.docCount && this.totalByteCount == other.totalByteCount && this.primaryByteCount == other.primaryByteCount && this.primaryByteCountMedian == other.primaryByteCountMedian && this.primaryShardBytesMAD == other.primaryShardBytesMAD;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

