/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.SingleMessageFieldInfo;

public class WaitForIndexColorStep
extends ClusterStateWaitStep {
    public static final String NAME = "wait-for-index-color";
    private static final Logger logger = LogManager.getLogger(WaitForIndexColorStep.class);
    private final ClusterHealthStatus color;
    private final BiFunction<String, LifecycleExecutionState, String> indexNameSupplier;

    WaitForIndexColorStep(Step.StepKey key, Step.StepKey nextStepKey, ClusterHealthStatus color) {
        this(key, nextStepKey, color, (String index, LifecycleExecutionState lifecycleState) -> index);
    }

    WaitForIndexColorStep(Step.StepKey key, Step.StepKey nextStepKey, ClusterHealthStatus color, @Nullable String indexNamePrefix) {
        this(key, nextStepKey, color, (String index, LifecycleExecutionState lifecycleState) -> indexNamePrefix + index);
    }

    WaitForIndexColorStep(Step.StepKey key, Step.StepKey nextStepKey, ClusterHealthStatus color, BiFunction<String, LifecycleExecutionState, String> indexNameSupplier) {
        super(key, nextStepKey);
        this.color = color;
        this.indexNameSupplier = indexNameSupplier;
    }

    public ClusterHealthStatus getColor() {
        return this.color;
    }

    BiFunction<String, LifecycleExecutionState, String> getIndexNameSupplier() {
        return this.indexNameSupplier;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.color, this.indexNameSupplier);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        WaitForIndexColorStep other = (WaitForIndexColorStep)obj;
        return super.equals(obj) && Objects.equals(this.color, other.color) && Objects.equals(this.indexNameSupplier, other.indexNameSupplier);
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        LifecycleExecutionState lifecycleExecutionState = clusterState.metadata().index(index.getName()).getLifecycleExecutionState();
        String indexName = this.indexNameSupplier.apply(index.getName(), lifecycleExecutionState);
        IndexMetadata indexMetadata = clusterState.metadata().index(indexName);
        if (indexMetadata == null) {
            String errorMessage = Strings.format((String)"[%s] lifecycle action for index [%s] executed but the target index [%s] does not exist", (Object[])new Object[]{this.getKey().action(), index.getName(), indexName});
            logger.debug(errorMessage);
            return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo(errorMessage));
        }
        IndexRoutingTable indexRoutingTable = clusterState.routingTable().index(indexMetadata.getIndex());
        ClusterStateWaitStep.Result result = switch (this.color) {
            default -> throw new MatchException(null, null);
            case ClusterHealthStatus.GREEN -> WaitForIndexColorStep.waitForGreen(indexRoutingTable);
            case ClusterHealthStatus.YELLOW -> WaitForIndexColorStep.waitForYellow(indexRoutingTable);
            case ClusterHealthStatus.RED -> WaitForIndexColorStep.waitForRed(indexRoutingTable);
        };
        return result;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    private static ClusterStateWaitStep.Result waitForRed(IndexRoutingTable indexRoutingTable) {
        if (indexRoutingTable == null) {
            return new ClusterStateWaitStep.Result(true, new SingleMessageFieldInfo("index is red"));
        }
        return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo("index is not red"));
    }

    private static ClusterStateWaitStep.Result waitForYellow(IndexRoutingTable indexRoutingTable) {
        if (indexRoutingTable == null) {
            return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo("index is red; no indexRoutingTable"));
        }
        boolean indexIsAtLeastYellow = indexRoutingTable.allPrimaryShardsActive();
        if (indexIsAtLeastYellow) {
            return new ClusterStateWaitStep.Result(true, null);
        }
        return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo("index is red; not all primary shards are active"));
    }

    private static ClusterStateWaitStep.Result waitForGreen(IndexRoutingTable indexRoutingTable) {
        if (indexRoutingTable == null) {
            return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo("index is red; no indexRoutingTable"));
        }
        if (indexRoutingTable.allPrimaryShardsActive()) {
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                boolean replicaIndexIsGreen = indexRoutingTable.shard(i).replicaShards().stream().allMatch(ShardRouting::active);
                if (replicaIndexIsGreen) continue;
                return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo("index is yellow; not all replica shards are active"));
            }
            return new ClusterStateWaitStep.Result(true, null);
        }
        return new ClusterStateWaitStep.Result(false, new SingleMessageFieldInfo("index is not green; not all shards are active"));
    }
}

