/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.alibabacloudsearch;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.external.request.alibabacloudsearch.AlibabaCloudSearchEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.sparse.AlibabaCloudSearchSparseTaskSettings;

public record AlibabaCloudSearchSparseRequestEntity(List<String> input, AlibabaCloudSearchSparseTaskSettings taskSettings) implements ToXContentObject
{
    private static final String TEXTS_FIELD = "input";
    public static final String INPUT_TYPE_FIELD = "input_type";
    public static final String RETURN_TOKEN_FIELD = "return_token";

    public AlibabaCloudSearchSparseRequestEntity {
        Objects.requireNonNull(input);
        Objects.requireNonNull(taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TEXTS_FIELD, this.input);
        String inputType = AlibabaCloudSearchEmbeddingsRequestEntity.convertToString(this.taskSettings.getInputType());
        if (inputType != null) {
            builder.field(INPUT_TYPE_FIELD, inputType);
        }
        if (this.taskSettings.isReturnToken() != null) {
            builder.field(RETURN_TOKEN_FIELD, this.taskSettings.isReturnToken());
        }
        builder.endObject();
        return builder;
    }
}

