/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request.cohere;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingType;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsTaskSettings;

public record CohereEmbeddingsRequestEntity(List<String> input, CohereEmbeddingsTaskSettings taskSettings, @Nullable String model, @Nullable CohereEmbeddingType embeddingType) implements ToXContentObject
{
    private static final String SEARCH_DOCUMENT = "search_document";
    private static final String SEARCH_QUERY = "search_query";
    private static final String CLUSTERING = "clustering";
    private static final String CLASSIFICATION = "classification";
    private static final String TEXTS_FIELD = "texts";
    public static final String INPUT_TYPE_FIELD = "input_type";
    static final String EMBEDDING_TYPES_FIELD = "embedding_types";

    public CohereEmbeddingsRequestEntity {
        Objects.requireNonNull(input);
        Objects.requireNonNull(taskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TEXTS_FIELD, this.input);
        if (this.model != null) {
            builder.field("model", this.model);
        }
        if (this.taskSettings.getInputType() != null) {
            builder.field(INPUT_TYPE_FIELD, CohereEmbeddingsRequestEntity.convertToString(this.taskSettings.getInputType()));
        }
        if (this.embeddingType != null) {
            builder.field(EMBEDDING_TYPES_FIELD, List.of(this.embeddingType.toRequestString()));
        }
        if (this.taskSettings.getTruncation() != null) {
            builder.field("truncate", (Enum)this.taskSettings.getTruncation());
        }
        builder.endObject();
        return builder;
    }

    static String convertToString(InputType inputType) {
        return switch (inputType) {
            case InputType.INGEST -> SEARCH_DOCUMENT;
            case InputType.SEARCH -> SEARCH_QUERY;
            case InputType.CLASSIFICATION -> CLASSIFICATION;
            case InputType.CLUSTERING -> CLUSTERING;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)CohereEmbeddingsTaskSettings.invalidInputTypeMessage(inputType));
                }
                yield null;
            }
        };
    }
}

