/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.googlevertexai.GoogleVertexAiActionVisitor;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiRateLimitServiceSettings;

public abstract class GoogleVertexAiModel
extends Model {
    private final GoogleVertexAiRateLimitServiceSettings rateLimitServiceSettings;
    protected URI uri;

    public GoogleVertexAiModel(ModelConfigurations configurations, ModelSecrets secrets, GoogleVertexAiRateLimitServiceSettings rateLimitServiceSettings) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
    }

    public GoogleVertexAiModel(GoogleVertexAiModel model, ServiceSettings serviceSettings) {
        super((Model)model, serviceSettings);
        this.uri = model.uri();
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
    }

    public GoogleVertexAiModel(GoogleVertexAiModel model, TaskSettings taskSettings) {
        super((Model)model, taskSettings);
        this.uri = model.uri();
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
    }

    public abstract ExecutableAction accept(GoogleVertexAiActionVisitor var1, Map<String, Object> var2, InputType var3);

    public GoogleVertexAiRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }

    public URI uri() {
        return this.uri;
    }
}

