/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.movingPercentiles;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.metrics.InternalHDRPercentiles;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.PercentilesMethod;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public class MovingPercentilesPipelineAggregator
extends PipelineAggregator {
    private final int window;
    private final int shift;

    MovingPercentilesPipelineAggregator(String name, String[] bucketsPaths, int window, int shift, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.window = window;
        this.shift = shift;
    }

    public InternalAggregation reduce(InternalAggregation aggregation, AggregationReduceContext reduceContext) {
        InternalMultiBucketAggregation histo = (InternalMultiBucketAggregation)aggregation;
        List buckets = histo.getBuckets();
        HistogramFactory factory = (HistogramFactory)histo;
        ArrayList<MultiBucketsAggregation.Bucket> newBuckets = new ArrayList<MultiBucketsAggregation.Bucket>(buckets.size());
        if (buckets.size() == 0) {
            return factory.createAggregation(newBuckets);
        }
        PercentileConfig config = MovingPercentilesPipelineAggregator.resolvePercentileConfig((MultiBucketsAggregation)histo, (InternalMultiBucketAggregation.InternalBucket)buckets.get(0), this.bucketsPaths()[0]);
        switch (config.method) {
            case TDIGEST: {
                this.reduceTDigest(buckets, (MultiBucketsAggregation)histo, newBuckets, factory, config);
                break;
            }
            case HDR: {
                this.reduceHDR(buckets, (MultiBucketsAggregation)histo, newBuckets, factory, config);
                break;
            }
            default: {
                throw new IllegalArgumentException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " references an unknown percentile aggregation method: [" + String.valueOf(config.method) + "]");
            }
        }
        return factory.createAggregation(newBuckets);
    }

    private void reduceTDigest(List<? extends InternalMultiBucketAggregation.InternalBucket> buckets, MultiBucketsAggregation histo, List<MultiBucketsAggregation.Bucket> newBuckets, HistogramFactory factory, PercentileConfig config) {
        List<TDigestState> values = buckets.stream().map(b -> MovingPercentilesPipelineAggregator.resolveTDigestBucketValue(histo, b, this.bucketsPaths()[0])).filter(Objects::nonNull).toList();
        int index = 0;
        Iterator<? extends InternalMultiBucketAggregation.InternalBucket> iterator = buckets.iterator();
        while (iterator.hasNext()) {
            InternalMultiBucketAggregation.InternalBucket bucket;
            InternalMultiBucketAggregation.InternalBucket newBucket = bucket = iterator.next();
            TDigestState state = null;
            int fromIndex = MovingPercentilesPipelineAggregator.clamp(index - this.window + this.shift, values.size());
            int toIndex = MovingPercentilesPipelineAggregator.clamp(index + this.shift, values.size());
            for (int i = fromIndex; i < toIndex; ++i) {
                TDigestState bucketState = values.get(i);
                if (bucketState == null) continue;
                if (state == null) {
                    state = TDigestState.createUsingParamsFrom((TDigestState)bucketState);
                }
                state.add(bucketState);
            }
            if (state != null) {
                newBucket = factory.createBucket(factory.getKey((MultiBucketsAggregation.Bucket)bucket), bucket.getDocCount(), InternalAggregations.append((InternalAggregations)bucket.getAggregations(), (InternalAggregation)new InternalTDigestPercentiles(this.name(), config.keys, state, config.keyed, config.formatter, this.metadata())));
            }
            newBuckets.add((MultiBucketsAggregation.Bucket)newBucket);
            ++index;
        }
    }

    private void reduceHDR(List<? extends InternalMultiBucketAggregation.InternalBucket> buckets, MultiBucketsAggregation histo, List<MultiBucketsAggregation.Bucket> newBuckets, HistogramFactory factory, PercentileConfig config) {
        List<DoubleHistogram> values = buckets.stream().map(b -> MovingPercentilesPipelineAggregator.resolveHDRBucketValue(histo, b, this.bucketsPaths()[0])).filter(Objects::nonNull).toList();
        int index = 0;
        for (InternalMultiBucketAggregation.InternalBucket internalBucket : buckets) {
            DoubleHistogram state = null;
            InternalMultiBucketAggregation.InternalBucket newBucket = internalBucket;
            int fromIndex = MovingPercentilesPipelineAggregator.clamp(index - this.window + this.shift, values.size());
            int toIndex = MovingPercentilesPipelineAggregator.clamp(index + this.shift, values.size());
            for (int i = fromIndex; i < toIndex; ++i) {
                DoubleHistogram bucketState = values.get(i);
                if (bucketState == null) continue;
                if (state == null) {
                    state = new DoubleHistogram(bucketState.getNumberOfSignificantValueDigits());
                }
                state.add(bucketState);
            }
            if (state != null) {
                newBucket = factory.createBucket(factory.getKey((MultiBucketsAggregation.Bucket)internalBucket), internalBucket.getDocCount(), InternalAggregations.append((InternalAggregations)internalBucket.getAggregations(), (InternalAggregation)new InternalHDRPercentiles(this.name(), config.keys, state, config.keyed, config.formatter, this.metadata())));
            }
            newBuckets.add((MultiBucketsAggregation.Bucket)newBucket);
            ++index;
        }
    }

    private static PercentileConfig resolvePercentileConfig(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, String aggPath) {
        List aggPathsList = AggregationPath.parse((String)aggPath).getPathElementsAsStringList();
        Object propertyValue = bucket.getProperty(agg.getName(), aggPathsList);
        if (propertyValue == null) {
            throw MovingPercentilesPipelineAggregator.buildResolveError(agg, aggPathsList, propertyValue, "percentiles");
        }
        if (propertyValue instanceof InternalTDigestPercentiles) {
            InternalTDigestPercentiles internalTDigestPercentiles = (InternalTDigestPercentiles)propertyValue;
            return new PercentileConfig(PercentilesMethod.TDIGEST, internalTDigestPercentiles.getKeys(), internalTDigestPercentiles.keyed(), internalTDigestPercentiles.formatter());
        }
        if (propertyValue instanceof InternalHDRPercentiles) {
            InternalHDRPercentiles internalHDRPercentiles = (InternalHDRPercentiles)propertyValue;
            return new PercentileConfig(PercentilesMethod.HDR, internalHDRPercentiles.getKeys(), internalHDRPercentiles.keyed(), internalHDRPercentiles.formatter());
        }
        throw MovingPercentilesPipelineAggregator.buildResolveError(agg, aggPathsList, propertyValue, "percentiles");
    }

    private static TDigestState resolveTDigestBucketValue(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, String aggPath) {
        List aggPathsList = AggregationPath.parse((String)aggPath).getPathElementsAsStringList();
        Object propertyValue = bucket.getProperty(agg.getName(), aggPathsList);
        if (propertyValue == null || !(propertyValue instanceof InternalTDigestPercentiles)) {
            throw MovingPercentilesPipelineAggregator.buildResolveError(agg, aggPathsList, propertyValue, "TDigest");
        }
        return ((InternalTDigestPercentiles)propertyValue).getState();
    }

    private static DoubleHistogram resolveHDRBucketValue(MultiBucketsAggregation agg, InternalMultiBucketAggregation.InternalBucket bucket, String aggPath) {
        List aggPathsList = AggregationPath.parse((String)aggPath).getPathElementsAsStringList();
        Object propertyValue = bucket.getProperty(agg.getName(), aggPathsList);
        if (propertyValue == null || !(propertyValue instanceof InternalHDRPercentiles)) {
            throw MovingPercentilesPipelineAggregator.buildResolveError(agg, aggPathsList, propertyValue, "HDR");
        }
        return ((InternalHDRPercentiles)propertyValue).getState();
    }

    private static IllegalArgumentException buildResolveError(MultiBucketsAggregation agg, List<String> aggPathsList, Object propertyValue, String method) {
        if (propertyValue == null) {
            return new IllegalArgumentException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference a " + method + " percentile aggregation");
        }
        String currentAggName = aggPathsList.isEmpty() ? agg.getName() : aggPathsList.get(0);
        return new IllegalArgumentException(AbstractPipelineAggregationBuilder.BUCKETS_PATH_FIELD.getPreferredName() + " must reference a " + method + " percentiles aggregation, got: [" + propertyValue.getClass().getSimpleName() + "] at aggregation [" + currentAggName + "]");
    }

    private static int clamp(int index, int length) {
        if (index < 0) {
            return 0;
        }
        return Math.min(index, length);
    }

    private record PercentileConfig(PercentilesMethod method, double[] keys, boolean keyed, DocValueFormat formatter) {
    }
}

