/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.script.expression.ReplaceableConstDoubleValues;

final class ReplaceableConstDoubleValueSource
extends DoubleValuesSource {
    private final Map<LeafReaderContext, ReplaceableConstDoubleValues> specialValues = new ConcurrentHashMap<LeafReaderContext, ReplaceableConstDoubleValues>();

    ReplaceableConstDoubleValueSource() {
    }

    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        ReplaceableConstDoubleValues replaceableConstDoubleValues = new ReplaceableConstDoubleValues();
        this.specialValues.put(ctx, replaceableConstDoubleValues);
        return replaceableConstDoubleValues;
    }

    public boolean needsScores() {
        return false;
    }

    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) {
        throw new UnsupportedOperationException("explain is not supported for _value and should never be called");
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public void setValue(LeafReaderContext ctx, double v) {
        ReplaceableConstDoubleValues fv = this.specialValues.get(ctx);
        assert (fv != null) : "getValues must be called before setValue for any given leaf reader context";
        fv.setValue(v);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }

    public DoubleValuesSource rewrite(IndexSearcher reader) {
        return this;
    }
}

