/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.logical;

import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.Negatable;
import org.elasticsearch.xpack.ql.expression.predicate.Predicates;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogicProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class And
extends BinaryLogic
implements Negatable<BinaryLogic> {
    public And(Source source, Expression left, Expression right) {
        super(source, left, right, BinaryLogicProcessor.BinaryLogicOperation.AND);
    }

    @Override
    protected NodeInfo<And> info() {
        return NodeInfo.create(this, And::new, this.left(), this.right());
    }

    @Override
    protected And replaceChildren(Expression newLeft, Expression newRight) {
        return new And(this.source(), newLeft, newRight);
    }

    public And swapLeftAndRight() {
        return new And(this.source(), this.right(), this.left());
    }

    @Override
    public Or negate() {
        return new Or(this.source(), Not.negate(this.left()), Not.negate(this.right()));
    }

    @Override
    protected Expression canonicalize() {
        return Predicates.combineAnd(Predicates.splitAnd(super.canonicalize()));
    }
}

