/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorSearchResult;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;

public class ListConnectorAction {
    public static final String NAME = "cluster:admin/xpack/connector/list";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/connector/list");

    private ListConnectorAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField RESULT_FIELD = new ParseField("results", new String[0]);
        final QueryPage<ConnectorSearchResult> queryPage;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.queryPage = new QueryPage(in, ConnectorSearchResult::new);
        }

        public Response(List<ConnectorSearchResult> items, Long totalResults) {
            this.queryPage = new QueryPage(items, totalResults.longValue(), RESULT_FIELD);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.queryPage.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.queryPage.toXContent(builder, params);
        }

        public QueryPage<ConnectorSearchResult> queryPage() {
            return this.queryPage;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.queryPage.equals(that.queryPage);
        }

        public int hashCode() {
            return this.queryPage.hashCode();
        }
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final PageParams pageParams;
        private final List<String> indexNames;
        private final List<String> connectorNames;
        private final List<String> connectorServiceTypes;
        private final String connectorSearchQuery;
        private final Boolean includeDeleted;
        private static final ParseField PAGE_PARAMS_FIELD = new ParseField("pageParams", new String[0]);
        private static final ParseField INDEX_NAMES_FIELD = new ParseField("index_names", new String[0]);
        private static final ParseField NAMES_FIELD = new ParseField("names", new String[0]);
        private static final ParseField SEARCH_QUERY_FIELD = new ParseField("query", new String[0]);
        private static final ParseField INCLUDE_DELETED_FIELD = new ParseField("include_deleted", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("list_connector_request", p -> new Request((PageParams)p[0], (List)p[1], (List)p[2], (List)p[3], (String)p[4], (Boolean)p[5]));

        public Request(PageParams pageParams, List<String> indexNames, List<String> connectorNames, List<String> serviceTypes, String connectorSearchQuery, Boolean includeDeleted) {
            this.pageParams = pageParams;
            this.indexNames = indexNames;
            this.connectorNames = connectorNames;
            this.connectorServiceTypes = serviceTypes;
            this.connectorSearchQuery = connectorSearchQuery;
            this.includeDeleted = includeDeleted;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public List<String> getIndexNames() {
            return this.indexNames;
        }

        public List<String> getConnectorNames() {
            return this.connectorNames;
        }

        public List<String> getConnectorServiceTypes() {
            return this.connectorServiceTypes;
        }

        public String getConnectorSearchQuery() {
            return this.connectorSearchQuery;
        }

        public Boolean getIncludeDeleted() {
            return this.includeDeleted;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indexNames != null && !this.indexNames.isEmpty()) {
                for (String indexName : this.indexNames) {
                    try {
                        MetadataCreateIndexService.validateIndexOrAliasName((String)indexName, InvalidIndexNameException::new);
                    }
                    catch (InvalidIndexNameException e) {
                        validationException = ValidateActions.addValidationError((String)e.toString(), validationException);
                    }
                }
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.pageParams, request.pageParams) && Objects.equals(this.indexNames, request.indexNames) && Objects.equals(this.connectorNames, request.connectorNames) && Objects.equals(this.connectorServiceTypes, request.connectorServiceTypes) && Objects.equals(this.connectorSearchQuery, request.connectorSearchQuery) && Objects.equals(this.includeDeleted, request.includeDeleted);
        }

        public int hashCode() {
            return Objects.hash(this.pageParams, this.indexNames, this.connectorNames, this.connectorServiceTypes, this.connectorSearchQuery);
        }

        public static Request parse(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(PAGE_PARAMS_FIELD.getPreferredName(), (ToXContent)this.pageParams);
            builder.field(INDEX_NAMES_FIELD.getPreferredName(), this.indexNames);
            builder.field(NAMES_FIELD.getPreferredName(), this.connectorNames);
            builder.field(Connector.SERVICE_TYPE_FIELD.getPreferredName(), this.connectorServiceTypes);
            builder.field(SEARCH_QUERY_FIELD.getPreferredName(), this.connectorSearchQuery);
            builder.field(INCLUDE_DELETED_FIELD.getPreferredName(), this.includeDeleted);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> PageParams.fromXContent((XContentParser)p), PAGE_PARAMS_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), INDEX_NAMES_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), NAMES_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), Connector.SERVICE_TYPE_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), SEARCH_QUERY_FIELD);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), INCLUDE_DELETED_FIELD);
        }
    }
}

